precision highp float;
#define PI 3.14159265359

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
uniform float progress;// 转场进度
const int segments=5;// = 5;
vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}
vec4 transition (vec2 uv) {

    float angle = atan(uv.y - 0.5, uv.x - 0.5) - 0.5 * PI;
    float normalized = (angle + 1.5 * PI) * (2.0 * PI);

    float radius = (cos(float(segments) * angle) + 4.0) / 4.0;
    float difference = length(uv - vec2(0.5, 0.5));

    if (difference > radius * progress)
    return getFromColor(uv);
    else
    return getToColor(uv);
}

void main(){
    gl_FragColor=transition(aCoordinate);
}
