// 类似水波纹转场效果
precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
const float SQRT_2 = 1.414213562373;
const float dots=40.0;// = 20.0;
const vec2 center= vec2(0, 0);// = vec2(0, 0);
uniform float progress;// 转场进度
vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}
vec4 transition(vec2 uv) {
    bool nextImage = distance(fract(uv * dots), vec2(0.5, 0.5)) < (progress / distance(uv, center));
    return nextImage ? getToColor(uv) : getFromColor(uv);
}
void main(){
    gl_FragColor=transition(aCoordinate);
}
