precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
uniform float progress;// 转场进度

const float smoothness=1.0; // = 1.0

const float PI = 3.141592653589;
vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}
vec2 zoom(vec2 uv, float amount) {
    return 0.5 + ((uv - 0.5) * amount);
}

vec4 transition(vec2 p) {
    vec2 rp = p*2.-1.;
    return mix(
    getToColor(p),
    getFromColor(p),
    smoothstep(0., smoothness, atan(rp.y,rp.x) - (progress-.5) * PI * 2.5)
    );
}
void main(){
    if (progress<=0.05){
        gl_FragColor= texture2D(vTexture, aCoordinate);
        return;
    }
    gl_FragColor=transition(aCoordinate);
}
