// 类似水波纹转场效果
precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;

uniform float progress;// 转场进度
float amplitude=100.0;// = 100.0
float speed=50.0;// = 50.0
vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}
vec4 transition (vec2 uv) {
    vec2 dir = uv - vec2(.5);
    float dist = length(dir);
    vec2 offset = dir * (sin(progress * dist * amplitude - progress * speed) + .5) / 30.;
    return mix(
    getFromColor(uv + offset),
    getToColor(uv),
    smoothstep(0.2, 1.0, progress)
    );
}
void main(){
    if (progress<=0.05){
        gl_FragColor= texture2D(vTexture, aCoordinate);
        return;
    }
    gl_FragColor=transition(aCoordinate);
}
