// 旋转缩放渐显
#define PI 3.14159265359
precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
uniform float progress;// 转场进度
const vec2 center= vec2(0.5, 0.5);// = vec2(0.5, 0.5);
const float rotations=1.;// = 1;
const float scale= 4.;// = 4;
const vec4 backColor= vec4(0.15, 0.15, 0.15, 1.0);// = vec4(0.15, 0.15, 0.15, 1.0);
vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 transition (vec2 uv) {

    vec2 difference = uv - center;
    vec2 dir = normalize(difference);
    float dist = length(difference);

    float angle = 2.0 * PI * rotations * progress;

    float c = cos(angle);
    float s = sin(angle);

    float currentScale = mix(scale, 1.0, 2.0 * abs(progress - 0.5));

    vec2 rotatedDir = vec2(dir.x  * c - dir.y * s, dir.x * s + dir.y * c);
    vec2 rotatedUv = center + rotatedDir * dist / currentScale;

    if (rotatedUv.x < 0.0 || rotatedUv.x > 1.0 ||
    rotatedUv.y < 0.0 || rotatedUv.y > 1.0)
    return backColor;

    return mix(getFromColor(rotatedUv), getToColor(rotatedUv), progress);
}

void main(){
    gl_FragColor=transition(aCoordinate);
}
