// 类似水波纹转场效果
precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
uniform float progress;// 转场进度
const float reflection = 0.4;// = 0.4
const float perspective= 0.2;// = 0.2
const float depth = 3.0;// = 3.0

const vec4 black = vec4(0.0, 0.0, 0.0, 1.0);
const vec2 boundMin = vec2(0.0, 0.0);
const vec2 boundMax = vec2(1.0, 1.0);
vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}

bool inBounds (vec2 p) {
    return all(lessThan(boundMin, p)) && all(lessThan(p, boundMax));
}

vec2 project (vec2 p) {
    return p * vec2(1.0, -1.2) + vec2(0.0, 2.02);
}

vec4 bgColor (vec2 p, vec2 pfr, vec2 pto) {
    vec4 c = black;
    pfr = project(pfr);
    if (inBounds(pfr)) {
        c += mix(black, getFromColor(pfr), reflection * mix(1.0, 0.0, pfr.y));
    }
    pto = project(pto);
    if (inBounds(pto)) {
        c += mix(black, getToColor(pto), reflection * mix(1.0, 0.0, pto.y));
    }
    return c;
}

vec4 transition(vec2 p) {
    vec2 pfr, pto = vec2(-1.);
    float pp=smoothstep(0.0, 1.0, progress);
    float size = mix(1.0, depth, pp);
    float persp = perspective * pp;
    pfr = (p + vec2(-0.0, -0.5)) * vec2(size/(1.0-perspective*pp), size/(1.0-size*persp*p.x)) + vec2(0.0, 0.5);

    size = mix(1.0, depth, 1.-pp);
    persp = perspective * (1.-pp);
    pto = (p + vec2(-1.0, -0.5)) * vec2(size/(1.0-perspective*(1.0-pp)), size/(1.0-size*persp*(0.5-p.x))) + vec2(1.0, 0.5);

    if (pp < 0.5) {
        if (inBounds(pfr)) {
            return getFromColor(pfr);
        }
        if (inBounds(pto)) {
            return getToColor(pto);
        }
    }
    if (inBounds(pto)) {
        return getToColor(pto);
    }
    if (inBounds(pfr)) {
        return getFromColor(pfr);
    }
    return bgColor(p, pfr, pto);
}
void main(){
    gl_FragColor=transition(aCoordinate);
}
