// 类似水波纹转场效果
precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
uniform float progress;// 转场进度
vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}
vec4 transition(vec2 UV)
{
    float Radius = 1.0;

    float T = progress;

    UV -= vec2(0.5, 0.5);

    float Dist = length(UV);

    if (Dist < Radius)
    {
        float Percent = (Radius - Dist) / Radius;
        float A = (T <= 0.5) ? mix(0.0, 1.0, T/0.5) : mix(1.0, 0.0, (T-0.5)/0.5);
        float Theta = Percent * Percent * A * 8.0 * 3.14159;
        float S = sin(Theta);
        float C = cos(Theta);
        UV = vec2(dot(UV, vec2(C, -S)), dot(UV, vec2(S, C)));
    }
    UV += vec2(0.5, 0.5);

    vec4 C0 = getFromColor(UV);
    vec4 C1 = getToColor(UV);

    return mix(C0, C1, T);
}
void main(){
    gl_FragColor=transition(aCoordinate);
}
