precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
uniform float progress;// 转场进度

const float smoothness=0.03;// = 0.03
const vec2 center= vec2(0.5);// = vec2(0.5)
const vec3 color = vec3(0.0);// = vec3(0.0)

const float M_PI = 3.141592653589793;

vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}

float quadraticInOut(float t) {
    float p = 2.0 * t * t;
    return t < 0.5 ? p : -p + (4.0 * t) - 1.0;
}

float getGradient(float r, float dist) {
    float d = r - dist;
    return mix(
    smoothstep(-smoothness, 0.0, r - dist * (1.0 + smoothness)),
    -1.0 - step(0.005, d),
    step(-0.005, d) * step(d, 0.01)
    );
}

float getWave(vec2 p){
    vec2 _p = p - center;// offset from center
    float rads = atan(_p.y, _p.x);
    float degs = degrees(rads) + 180.0;
    vec2 range = vec2(0.0, M_PI * 30.0);
    vec2 domain = vec2(0.0, 360.0);
    float ratio = (M_PI * 30.0) / 360.0;
    degs = degs * ratio;
    float x = progress;
    float magnitude = mix(0.02, 0.09, smoothstep(0.0, 1.0, x));
    float offset = mix(40.0, 30.0, smoothstep(0.0, 1.0, x));
    float ease_degs = quadraticInOut(sin(degs));
    float deg_wave_pos = (ease_degs * magnitude) * sin(x * offset);
    return x + deg_wave_pos;
}

vec4 transition(vec2 p) {
    float dist = distance(center, p);
    float m = getGradient(getWave(p), dist);
    vec4 cfrom = getFromColor(p);
    vec4 cto = getToColor(p);
    return mix(mix(cfrom, cto, m), mix(cfrom, vec4(color, 1.0), 0.75), step(m, -2.0));
}
void main(){
    if (progress<=0.01){
        gl_FragColor= texture2D(vTexture, aCoordinate);
        return;
    }
    gl_FragColor=transition(aCoordinate);
}
