// 类似水波纹转场效果
precision highp float;

varying vec2 aCoordinate;
uniform sampler2D vTexture1;
uniform sampler2D vTexture;
uniform float progress;// 转场进度
vec4 getFromColor(vec2 coordinate) {
    return texture2D(vTexture, vec2(coordinate.x, coordinate.y-1.0));
}

vec4 getToColor(vec2 coordinate) {
    return texture2D(vTexture1, vec2(coordinate.x, coordinate.y-1.0));
}
vec4 transition (vec2 uv) {
    float t = progress;

    if (mod(floor(uv.y*100.*progress),2.)==0.)
    t*=2.-.5;

    return mix(
    getFromColor(uv),
    getToColor(uv),
    mix(t, progress, smoothstep(0.8, 1.0, progress))
    );
}
void main(){
    gl_FragColor=transition(aCoordinate);
}
