// 优化后的高斯模糊
attribute vec4 vPosition;
attribute vec4 vCoordinate;
uniform mat4 vMatrix;
// 高斯算子左右偏移值，当偏移值为5时，高斯算子为 11 x 11
// 高斯算子左右偏移值，当偏移值为2时，高斯算子为5 x 5
const int SHIFT_SIZE = 9;

uniform highp float texelWidthOffset;
uniform highp float texelHeightOffset;

varying vec2 aCoordinate;
varying vec2 blurShiftCoordinates[SHIFT_SIZE];

void main() {
    gl_Position = vMatrix*vPosition;
    aCoordinate = vCoordinate.xy;
    // 偏移步距
    vec2 singleStepOffset = vec2(texelHeightOffset, texelWidthOffset);
    int multiplier = 0;
    vec2 blurStep;
    // 记录偏移坐标
    for (int i = 0; i < SHIFT_SIZE; i++) {

        multiplier = (i - ((SHIFT_SIZE - 1) / 2));

        // Blur in x (horizontal)
        blurStep = float(multiplier) * singleStepOffset;
        blurShiftCoordinates[i] = aCoordinate.xy + blurStep;
    }
}