var srcImg = 'data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWNgYGBgAAAABQABh6FO1AAAAABJRU5ErkJggg==';
var _des = '<div>△</div>';
var imageType = {
    "sm": "?x-oss-process=image/resize,m_lfit,w_160,limit_0/auto-orient,1",
    "sm11": "?x-oss-process=image/resize,m_fill,w_160,h_160,limit_0/auto-orient,1",
    "sm43": "?x-oss-process=image/resize,m_fill,w_240,h_180,limit_0/auto-orient,1",
    "sm169": "?x-oss-process=image/resize,m_fill,w_240,h_135,limit_0/auto-orient,1",
    "md": "?x-oss-process=image/resize,m_lfit,w_480,limit_0/auto-orient,1",
    "md169": "?x-oss-process=image/resize,m_fill,w_480,h_270,limit_0/auto-orient,1",
    "md43": "?x-oss-process=image/resize,m_fill,w_480,h_360,limit_0/auto-orient,1",
    "md31": "?x-oss-process=image/resize,m_fill,w_480,h_160,limit_0/auto-orient,1",
    'lg': '?x-oss-process=image/resize,m_lfit,w_720,limit_0/auto-orient,1',
    "lg169": "?x-oss-process=image/resize,m_fill,w_720,h_405,limit_0/auto-orient,1",
    "lg43": "?x-oss-process=image/resize,m_fill,w_720,h_540,limit_0/auto-orient,1",
    'lg31': '?x-oss-process=image/resize,m_fill,w_720,h_240,limit_0/auto-orient,1',
    'webp': '?x-oss-process=image/auto-orient,1/quality,q_50/format,webp',
    'q50': '?x-oss-process=image/auto-orient,1/quality,q_50',
};

try{
    var _localgUserConfig = localStorage.getItem('gUserConfig')
    _localgUserConfig = typeof gUserConfig != 'undefined' ? gUserConfig : _localgUserConfig && JSON.parse(_localgUserConfig) || '';
    _localgUserConfig.originalDrawing == 1 && imageType && (imageType.lg = '?x-oss-process=image/auto-orient,1')
}catch (e){
    console.log(e)
}
var parseSpace = function (s) {
    try{
        return (s && s.replace(/[\r\n]/g,"<br>").replace(/[\s\t\b]/g,"&nbsp;")) || s
    }catch (e){
        return s
    }
}
var getClientWidth = function () {
    let width = 0
    return (function () {
        if(!width){
            width = window.innerWidth || screen.width || document.documentElement.clientWidth || document.body.clientWidth;
        }
        return width;
    })();

};
var parseArticleHtml = function (content) {
    var trimHtmlStrings = ["width", "height", "font-family", "text-indent", "padding-right", "padding-bottom", "padding-left", "padding-top",
        "text-transform", "font-size", "FONT-SIZE", "text-align", "margin", "padding", "line-height", "font", "font-weight", "font-family"];
    var str = "";
    content.replace(/<[^>]*>/gi, function (match, capture) {
        var tempMatch = match;//原
        if (match.indexOf("<img") == 0) {
            //处理img标签中的width <img width="123" />
            tempMatch = tempMatch.replace(/[^&]width=/gi, ' custom=');
        }
        if (!/<h[1-6]/gi.test(match)) {
            for (var i = 0; i < trimHtmlStrings.length; i++) {
                var lowerTempMatch = tempMatch.toLowerCase();
                if (lowerTempMatch.indexOf(trimHtmlStrings[i]) >= 0) {
                    if (trimHtmlStrings[i] === "width" || trimHtmlStrings[i] === "height") {
                        var regs = new RegExp('[^&]' + trimHtmlStrings[i], "gi");
                        tempMatch = tempMatch.replace(regs, " custom");
                    } else {
                        var regs = new RegExp(trimHtmlStrings[i], "gi");
                        tempMatch = tempMatch.replace(regs, "custom");
                    }
                    // tempMatch = tempMatch.replace(regs, ";custom");
                }
            }
        } else {
            tempMatch = tempMatch.replace(/font-size|font-family|line-height/gi, "custom");
        }
        if (tempMatch != match) {
            content = content.replace(match, tempMatch);
        }

    });
    var c = content.split("<p");
    for (var i = 0; i < c.length; i++) {
        //应该用 replaceReverse方法，但是 ne w RegExp("/"+ src + '/g');不起作用。
        // c[i] = c[i].replace(/[ ]|[&nbsp;]|[　]/g, "");
        // u003C!--仲夏夜之夢--u003E
        // c[i] = c[i].replace(/u003C!--.*--u003E/gi, "");
        c[i] = c[i].replace(/>[　]+/g, ">");
        c[i] = c[i].replace(/>[ ]+/g, ">");
        //
        // c[i] = c[i].replace(/u003C!+/g, "");
        // c[i] = c[i].replace(/u003E+/g, "");
        c[i] = c[i].replace(/>[\u3000]+/g, ">");
        c[i] = c[i].replace(/>(&nbsp;)+/g, ">");
        c[i] = c[i].replace(/>(　| |(&nbsp;))+/g, ">");
        if (i == 0)
            str = c[i];
        else
            str += "<p class='my_p_style'" + c[i];
    }
    var reg = /(u003C)[^(u003E)]+()/g;
    str = str.replace(reg, '');
    str = str.replace(/u003E/g, '');
    return str;
}
var handleImgScaleUrl = function (item, imgScale) {
    // 处理图片的显示比例及替换为https
    // item: 图片地址 ; imgScale: 图片显示比例后缀
    item = item || "";
    item == 'undefined' ? item = '' : "" ;
    if (!item ||  item.indexOf("newaircloud.com") === -1 || /(.svg)/gi.test(item)) return item;
    imgScale = imgScale || "";
    return item.indexOf("@!") > -1 ? item.replace("http://", "https://") : item.indexOf("x-oss-process") > -1 ? item.replace("http://", "https://") : item.replace('http://', 'https://') + imgScale ;
}
var getClientHeight = function () {
    return window.innerHeight || screen.height || document.documentElement.clientHeight || document.body.clientHeight;
};
var imgWidthHeightUrl = function (width, imgUrl, size, resultWidth,resultHeight) {
    /*
     * width :容器的宽度
     * imgUrl:图片地址
     * size  :图片的后缀大小
     *
     * return: _o
     * _o.w      :图片的宽度 width: 100px;
     * _o.h      :图片的高度 height:100px;
     * _0.imgUrl :图片地址
     * */
    var _o = {
        w: '',
        h: '',
        imgW: '',
        imgH: '',
        imgUrl: '',
        nac_r:''
    };
    imgUrl = imgUrl || "";
    size = size || "";
    width = width || 0;
    resultWidth = resultWidth || 0;
    resultHeight = resultHeight || 0;
    if (imgUrl.length === 0) return _o;
    var _this = this;
    if (imgUrl.indexOf("newaircloud.com") > 0 && imgUrl.indexOf("cms.newaircloud.com") === -1 && !/(\.svg)/gi.test(imgUrl)) {
        var _getImgInfo = imgUrl.indexOf("@!") > -1 ? imgUrl.split('@!')[0] : imgUrl.indexOf('?') > -1 ? imgUrl.split("?")[0] : imgUrl;
        try {
            $.ajax({
                url: _getImgInfo.replace("http://", "https://") + "?x-oss-process=image/info",
                async: false,
                type: "GET",
                dataType: 'json',
                success: function (result, status, xhr) {
                    // if (width > result.ImageWidth.value && width > 0) {
                    //     _o.w = ' width:' + result.ImageWidth.value + 'px;';
                    //     _o.h = ' height:' + result.ImageHeight.value + 'px;';
                    // } else {
                    //     _o.h = ' height:' + (width < result.ImageWidth.value ? (width / result.ImageWidth.value * result.ImageHeight.value).toFixed(2) > 0 ? (width / result.ImageWidth.value * result.ImageHeight.value).toFixed(2) + 'px;' : 'auto;' : result.ImageHeight.value + 'px;');
                    //     _o.w = ' width:100%;'
                    // }
                  try{
                      var _r = result.ImageWidth.value/result.ImageHeight.value
                      if(/%/i.test(resultWidth)){
                          var _width = parseFloat(resultWidth)
                          _width && (_width = _width/100)
                          _o.h = ' height:' + (((_width ==1 && width || width * _width ) / (resultHeight || _r)).toFixed(2) > 0 ? ((_width ==1 && width || width * _width ) / (resultHeight || _r)).toFixed(2) + 'px;' : 'auto;' );
                          _o.w = ' ;width:'+(_width && _width < 1  && ( _width * 100 + '%') || '100%') +';';

                      }else if (width > resultWidth && resultWidth != 0) {
                          if (resultWidth > result.ImageWidth.value && resultWidth > 0) {
                              // _o.w = ' width:' + imgWidth[1] + 'px;';
                              // _o.h = ' height:' + imgHeight[1] + 'px;';
                              //

                              _o.w = ' width:' + result.ImageWidth.value + 'px;';
                              _o.h = ' height:' + result.ImageHeight.value + 'px;';
                          } else {
                              _o.h = ' height:' + (resultWidth < result.ImageWidth.value
                                  ? (resultWidth / result.ImageWidth.value * result.ImageHeight.value).toFixed(2) > 0 ? (resultWidth / result.ImageWidth.value * result.ImageHeight.value).toFixed(2) + 'px;' : 'auto;'
                                  : result.ImageHeight.value + 'px;');
                              // _o.w = resultWidth > 0 ? ' width:' + resultWidth + 'px;' : ' width:100%;'
                              _o.w = resultWidth > 0 ? ' ;width:' + resultWidth + 'px;' : result.ImageWidth.value > 0 ?  ' ;width:' + result.ImageWidth.value + 'px;' : ' ;width:100%;' ;
                          }

                      } else {
                          if (width > result.ImageWidth.value && width > 0) {
                              _o.w = ' width:' + result.ImageWidth.value + 'px;';
                              _o.h = ' height:' + result.ImageHeight.value + 'px;';
                          } else {
                              _o.h = ' height:' + (width < result.ImageWidth.value ? (width / result.ImageWidth.value * result.ImageHeight.value).toFixed(2) > 0 ? (width / result.ImageWidth.value * result.ImageHeight.value).toFixed(2) + 'px;' : 'auto;' : result.ImageHeight.value + 'px;');
                              // _o.w = ' width:100%;'
                              _o.w = width == 0 ? result.ImageWidth.value == 0? ' ;width:100%;':' ;width:' + result.ImageWidth.value + 'px;': ' ;width:' + width + 'px;'
                          }

                          // size = w >= 720 ? url_image_type.lg : 720 > w && w >= 480 ? url_image_type.md : 480 > w && w >= 160 ? url_image_type.sm : '';

                      }

                      _o.imgW = result.ImageWidth.value ? result.ImageWidth.value : "";
                      _o.imgH = result.ImageHeight.value ? result.ImageHeight.value : "";
                      // _o.nac_r= result.ImageWidth.value && result.ImageHeight.value ? ' nac_r="' + result.ImageWidth.value / result.ImageHeight.value + '" ' :'';
                      var w = +_o.imgW;
                      // size = w >= 720 ? '@!lg' : 720 > w && w >= 480 ? '@!md' : 480 > w && w >= 160 ? '@!sm' : '';
                      // size = w >= 720 ? '@!lg' : 720 > w &&  w >= 160 ? '@!md' : '@!sm';
                      size = w >= 720 ? imageType.lg : 720 > w && w >= 160 ? imageType.md : '';
                      _o.imgUrl = _this.handleImgScaleUrl(imgUrl, size)

                  }catch (e){
                      console.log(e)
                      _o.w = "";
                      _o.imgUrl = _this.handleImgScaleUrl(imgUrl, size)
                  }

                },
                error: function (xhr, status, error) {
                    console.log('error:', error);
                    _o.w = "";
                    _o.imgUrl = _this.handleImgScaleUrl(imgUrl, size)
                }
            })
        } catch (e) {
            console.log(e, 726);
            _o.imgUrl = _this.handleImgScaleUrl(imgUrl, size)
        }
    }else{
        _o.imgUrl=imgUrl;
    }
    _o.imgW = _o.imgW ? ' nac_w="' + _o.imgW +'" ': "";
    _o.imgH = _o.imgH ? ' nac_h="' + _o.imgH  +'" ': "";
    return _o
};
var imgAttrWidthAndHeight = function (source, boxWidth, imgUrl, size, resultWidth, resultHeight) {
    // source ： img 标签内容

    var _o = {
        w: '',
        h: '',
        imgW: '',
        imgH: '',
        imgUrl: '',
        nac_r:''
    };
    boxWidth = boxWidth || 0;
    resultWidth = resultWidth || 0;
    resultHeight = resultHeight || 0;
    var regW = /nac_w=['"]([^'"]+)/;//图片宽;
    var regH = /nac_h=['"]([^'"]+)/;//图片高;

    var imgWidth = source.match(regW);
    var imgHeight = source.match(regH);


    try {
        if (imgWidth != null && imgWidth[1] != null && imgWidth[1].length > 0 && imgHeight != null && imgHeight[1] != null && imgHeight[1].length > 0 && !isNaN(imgWidth[1]) && !isNaN(imgHeight[1]) && +imgHeight[1] > 0 && +imgWidth[1] > 0) {
            _o.nac_r= ' nac_r="'+ imgWidth[1]/imgHeight[1]+ '" ';
            var _r = imgWidth[1]/imgHeight[1]
            if(/%/i.test(resultWidth)){
                var _width = parseFloat(resultWidth)
                _width && (_width = _width/100)
                _o.h = ' height:' + (((_width ==1 && boxWidth || boxWidth * _width ) / (resultHeight || _r)).toFixed(2) > 0 ? ((_width ==1 && boxWidth || boxWidth * _width ) / (resultHeight || _r)).toFixed(2) + 'px;' : 'auto;' );
                _o.w = ' ;width:'+(_width < 1  && ( _width * 100 + '%') || '100%') +';';
            }else if (boxWidth > resultWidth && resultWidth != 0) {
                if (resultWidth > imgWidth[1] && resultWidth > 0) {

                    _o.w = ' width:' + imgWidth[1] + 'px;';
                    _o.h = ' height:' + imgHeight[1] + 'px;';
                } else {
                    _o.h = ' height:' + (resultWidth < imgWidth[1] ? (resultWidth / imgWidth[1] * imgHeight[1]).toFixed(2) > 0 ? (resultWidth / imgWidth[1] * imgHeight[1]).toFixed(2) + 'px;' : 'auto;' : imgHeight[1] + 'px;');
                    _o.w = resultWidth > 0 ? ' ;width:' + resultWidth + 'px;' : imgWidth[1] > 0 ?  ' ;width:' + imgWidth[1] + 'px;' : ' ;width:100%;' ;
                }

            } else {
                if(boxWidth < resultWidth && boxWidth>0 && resultWidth>0 && resultHeight> 0){
                    _o.h = ' height:' + ((boxWidth / resultWidth * resultHeight).toFixed(2) > 0 ? (boxWidth / resultWidth * resultHeight).toFixed(2) + 'px;' : 'auto;') ;
                    _o.w = ' max-width:100%;width:' + resultWidth + 'px;'
                }else{
                    if (boxWidth > imgWidth[1] && boxWidth > 0) {
                        _o.w = ' width:' + imgWidth[1] + 'px;';
                        _o.h = ' height:' + imgHeight[1] + 'px;';
                    } else {
                        _o.h = ' height:' + (boxWidth < imgWidth[1] ? (boxWidth / imgWidth[1] * imgHeight[1]).toFixed(2) > 0 ? (boxWidth / imgWidth[1] * imgHeight[1]).toFixed(2) + 'px;' : 'auto;' : imgHeight[1] + 'px;');
                        _o.w = boxWidth == 0 ? imgWidth[1] == 0? ' ;width:100%;':' ;width:' + imgWidth[1] + 'px;': ' ;width:' + boxWidth+ 'px;'
                    }
                }

            }
            _o.imgW = imgWidth[1] ? imgWidth[1] : "";
            _o.imgH = imgHeight[1] ? imgHeight[1] : "";
            var w = +_o.imgW;
            size = w >= 720 ? imageType.lg : 720 > w && w >= 160 ? imageType.md : '';
            _o.imgUrl = handleImgScaleUrl(imgUrl, size);

        } else {
            console.log('no:');
            return imgWidthHeightUrl(boxWidth, imgUrl, size, resultWidth);
        }

    } catch (e) {
        console.log(e)
        _o.imgUrl = imgUrl ? imgUrl : '';
    }
    return _o;

}
var imgDesCheck=function (str) {
    // 图片描述
    if(!str || str.length===0 ) return 0;
    return  str !== 'undefined' && !/(\.jpg)|(\.png)|(\.gif)|(\.bmp)|(\.jpeg)|(点击查看原图)/i.test(str) && str !=='图片' && str !=='null'
}
function formatArticle(article){
    var $w = getClientWidth() - 30;
    if (typeof article.layoutId != "undefined") { //文章json中带有layoutId字段则表示数字报稿件
        sourceType = 1;
    }
    var authorAndEditor = "";
    if (article.author != null && article.author.length > 0) {
        // authorAndEditor = " 作者:" + article.author;
    }
    // if (article.liability != null && article.liability.length > 0) {
    //     authorAndEditor += " 责任编辑：" + article.liability;
    // }

    // var authorAndEditor = "";
    if (article.reporter != null && article.reporter.length > 0) {
        authorAndEditor = ' 记者:' + article.reporter;
    }

    if (article.author != null && article.author.length > 0) {
        // authorAndEditor = article.author;
        authorAndEditor += " 作者:" + article.author;
    }

    if (article.editor != null && article.editor.length > 0) {
        authorAndEditor += " 编辑:" + article.editor;
    }
    if (article.liability != null && article.liability.length > 0) {
        authorAndEditor += " 责编:" + article.liability;
    }
    if(article && article.customizeFields && article.customizeFields.length > 0){
        // var _customizeFieldsHtml = ''
        // article.customizeFields.slice(0,10).map(function (item) {
        //     item && item.name && item.value && (_customizeFieldsHtml += ('<span class="customizeField">'+parseSpace( item.name) + ' ：' + parseSpace(item.value) + '</span>'))
        // })
        // _customizeFieldsHtml && $('#customizeFields').html( '( ' + _customizeFieldsHtml + ' )').show()
        article.customizeFields.map(function (item) {
            item && item.name && item.value && (authorAndEditor += (" " + item.name + ':' + item.value))
        })

    }
    if (authorAndEditor.length > 0) {
        authorAndEditor = "(" + authorAndEditor + " )";
    }
    if (authorAndEditor) {
        document.getElementById('doc_author').innerHTML = " <span>"+authorAndEditor+"</span>"
        document.getElementById('doc_author').style.display = "block";
    }


    //投票
    if (article.widgets != null && typeof (article.widgets.vote) != "undefined") {
        voteInfo.vID = article.widgets.vote.id;
    }

    //挂件附件，文件
    // if (article.widgets != null && typeof (article.widgets.file) != "undefined" && article.widgets.file.length > 0) {
    //     for (var i = 0; i < article.widgets.file.length; i++) {
    //         var item = article.widgets.file[i];
    //         item.url = "downfile:///" + item.url;
    //         articleFiles.push(item);
    //     }
    // }

    //文章投票id
    isVoteId = article.widgets && article.widgets.vote && article.widgets.vote.id || '';

    var isVote = localStorage.getItem('article_vote_' + article.fileId + isVoteId );
    if (typeof isVote == 'undefined')
        isVote = false;
    $scope.isVote = isVote;
    // article.content = article.content.replace(/>[　]+/g, ">")
    // article.content = article.content.replace(/>[ ]+/g, ">")
    article.content = unescape(article.content);
    article.content = article.content.replace(/您的浏览器不支持video预览/g, "")
    try {

        if (article.editorVersion != '2') {
            article.content = parseArticleHtml(article.content);
        } else {
            setTimeout(function () {
                var _docContentDiv =  document.getElementById("doc-content-div")
                var _rootHtml =  document.getElementsByTagName("html")[0];
                _docContentDiv && _docContentDiv.classList.remove("news_detail_content")
                _docContentDiv &&_docContentDiv.classList.add("news_detail_content_135")
                _rootHtml && _rootHtml.classList.remove("default-editor-class")
                _rootHtml && _rootHtml.classList.add("default-editor-class-135")
            })

        }
    } catch (e) {
        article.content = parseArticleHtml(article.content);
    }

   /* var articleVoice = article.音频文件;
    if (articleVoice != null && articleVoice != undefined && articleVoice.length > 3) {
        var sufifix = articleVoice.substr(articleVoice.length - 3, articleVoice.length - 1)
        if (sufifix.toLocaleLowerCase() == "mp3") {
            $scope.voiceUrl = $sce.trustAsResourceUrl(articleVoice);
        }
    }*/
    //组图
    if (article.articleType == 1) {
        if (typeof (article.images) != "undefined") {

            for (var i = 0; i < article.images.length; i++) {
                var imageUrl = article.images[i].imageUrl;
                var summary = article.images[i].summary;
                var imageTpl = '<div>';
                if (i > 2) {
                    if (imageUrl.indexOf("newair") < 0 || imageUrl.indexOf("gif") > 0) {
                        imageTpl += '<img onclick="viewImage(event, ' + i + ')" class="news_detail_img lazy" data-original="' + imageUrl + '" />';
                    } else {
                        imageTpl += '<img onclick="viewImage(event, ' + i + ')" class="news_detail_img lazy" data-original="' + imageUrl + imageType.lg + '" />';
                    }
                } else {

                    if (imageUrl.indexOf("newair") < 0 || imageUrl.indexOf("gif") > 0) {
                        imageTpl += '<img onclick="viewImage(event, ' + i + ')" class="news_detail_img" src="' + imageUrl + '" />';
                    } else {
                        imageTpl += '<img onclick="viewImage(event, ' + i + ')" class="news_detail_img" src="' + imageUrl + imageType.lg + '" />';
                    }
                }
                if (imgDesCheck(summary)) {
                    imageTpl += '<span id="triangle-up"><span  class="img_desc">' + summary + '</span></span>';
                }
                imageTpl += '</div>';
                article.content += imageTpl;
            }
        }
    }
    //视频处理
    else if (article.articleType == 2) {
        if (typeof (article.videos) != "undefined" && article.videos.length > 0) {
            for (var i = 0; i < article.videos.length; i++) {
                var imageUrl;

                var videoUrl = article.videos[i].videoUrl;
                var summary = article.videos[i].summary;
                var videoTpl =''

                // ========= 增加视频图片点位 ============
                var imgObj = imgAttrWidthAndHeight('', $w, article.videos[i].imageUrl , imageType.md169)
                imageUrl = imgObj.imgUrl ? imgObj.imgUrl : "static/img/video.png";

                var clientWidth = getClientWidth();
                var oW=clientWidth-30 >0 ? ' width:'+(clientWidth-30)+'px;' :' width:100%;';
                var oH=clientWidth-30 >0 ? ' height:'+(clientWidth-30) / 1.77777778 +'px;': ' height:100%;';

                imgObj.h= imgObj.h && (imgObj.h+'').length>0 ? imgObj.h:oH;
                imgObj.w= imgObj.w && (imgObj.w+'').length>0 ? imgObj.w:oW;

                videoTpl = '<div class="news_detail_video">';
                if((imageUrl+'').indexOf('static/img/video.png')>-1){
                    videoTpl +='<img style="position: absolute; top: 0;left: 0;right: 0;bottom: 0;margin: auto;width: 75px;height: 75px; z-index: 20;"  src="static/img/play.png" onclick="viewVideo(\'' + videoUrl + '\')"/>'
                    videoTpl +=  '<img style="'+ oH +' ' +oW+' " src="' + imageUrl + '" >'

                }else{
                    videoTpl +='<img  class="video-play-btn" style="display:none;position: absolute; top: 0;left: 0;right: 0;bottom: 0;margin: auto;width: 75px;height: 75px; z-index: 20;"  src="static/img/play.png" onclick="viewVideo(\'' + videoUrl + '\')"/>'
                    videoTpl +=  '<img  src="'+srcImg+'"  class="video-images img_loading" data-original="' + imageUrl + '"  style="'+ imgObj.h +' ' +oW+' " src="' + imageUrl + '" >'
                }

                videoTpl+='</div>';

                //====================================

                if (imgDesCheck(summary)) {
                    videoTpl += '<span style="display: block;width: 100%;margin-bottom: 10px;font-size: 15px;" class="news_detail_video_title">' + summary + '</span>';
                }
                if (article.videos.length >= 2) {
                    videoTpl += videoTpl;
                }
            }
            article.content = videoTpl + article.content;
        }
    }
    //普通文章
    else {
        if (sourceType == 0) { //普通新闻图片视频替换处理
            //解析替换正文中的图片
            var imagesCount = 0;
            try {

                if (article.editorVersion != '2') {
                    article.content.replace(/<img[^>]* src=['"]([^'"]+)[^>]*>/gi, function (match, capture) {
                        var imgUrl = capture;
                        var result = match;
                        var imgDesc = "";
                        //新闻详情图片下方显示描述
                        var reg = /\salt="([^"]+)"/i;//匹配alt
                        var reg2 = /\stitle="([^"]+)"/i;//匹配title

                        var imgObj = imgAttrWidthAndHeight(match, $w, imgUrl);

                        var titles = result.match(reg2);
                        if (titles != null && titles[1] != null && titles[1].length > 0) {
                            imgDesc = titles[1];
                        }
                        if ("" == imgDesc || imgDesc.length <= 0) {
                            var alts = result.match(reg);
                            if (alts != null && alts[1] != null && alts[1].length > 0) {
                                imgDesc = alts[1];
                            }
                        }

                        imgUrl = imgObj.imgUrl;

                        if (imgUrl.toLowerCase().indexOf("http") < 0 && imgUrl.toLowerCase().indexOf("https") < 0) {
                            var totalMatchStr = match;
                            var re = / src="([^"]*)"/g;
                            var arr = []
                            while (arr = re.exec(totalMatchStr)) {
                                imgUrl = arr[1];
                            }

                            if (imgUrl.indexOf('//') == 0) {
                                imgUrl = 'http:' + imgUrl
                            }
                            if (imgUrl.indexOf("newaircloud.com") < 0 || imgUrl.indexOf("gif") >= 0) {
                            } else {
                                imgUrl = imgUrl.indexOf('@!') > -1 || capture.indexOf("?x-oss-process=") > -1 || /(\.svg)/gi.test(imgUrl)? imgUrl : imgUrl ? imgUrl + imageType.md : "";
                            }
                        }


                        if (imgUrl.toLowerCase().indexOf("http") == 0 || imgUrl.toLowerCase().indexOf("https") == 0 || imgUrl) {
                            var flag = imgUrl.indexOf('.gif') > -1 ? 1 : 0;

                            var imgHtml = flag == 1 ?
                                '<img onclick="viewImage(event, ' + imagesCount + ')" class="news_detail_img img_loading lazy"  data-original="' + imgUrl + '" style="' + imgObj.h + imgObj.w + '" src="' + srcImg + ' ">' :
                                '<img onclick="viewImage(event, ' + imagesCount + ')" data-original="' + imgUrl + '" class="news_detail_img  lazy img_loading"  style="' + imgObj.h + imgObj.w + '" src="' + srcImg + ' ">';
                            if (imgDesCheck(imgDesc)) {
                                imgHtml += '<div id="triangle-up"> ' + _des +  '<p  class="img_desc">' + imgDesc + '</p></div>';
                            }
                            if (imagesCount > 2) {
                                imgHtml = "";
                                imgHtml = flag == 1 ?
                                    '<img onclick="viewImage(event, ' + imagesCount + ')" class="news_detail_img lazy img_loading" data-original="' + imgUrl + '"  style="' + imgObj.h + imgObj.w + '" src="' + srcImg + ' ">' :
                                    '<img  onclick="viewImage(event, ' + imagesCount + ')" class="news_detail_img lazy img_loading" data-original="' + imgUrl + '"  style="' + imgObj.h + imgObj.w + '" src="' + srcImg + ' " >';
                                if (imgDesCheck(imgDesc)) {
                                    imgHtml += '<div id="triangle-up"> ' + _des +  '<p  class="img_desc">' + imgDesc + '</p></div>';
                                }
                            }

                        } else {
                            imgHtml = "";
                        }
                        article.content = article.content.replace(match, imgHtml);
                        imagesCount++;
                    });
                    console.log(1);
                } else {
                    //135editor
                    console.log(2);
                    article.content.replace(/<img[^>]* src=['"]([^'"]+)[^>]*>/gi, function (match, capture) {
                        var imgUrl = capture;
                        var result = match;
                        var lastResult = '', imgHtml = '';

                        var imgDesc = "";
                        //新闻详情图片下方显示描述
                        var reg = /\salt="([^"]+)"/i;//匹配alt
                        var reg2 = /\stitle="([^"]+)"/i;//匹配title
                        var titles = result.match(reg2);
                        if (titles != null && titles[1] != null && titles[1].length > 0) {
                            imgDesc = titles[1];
                        }
                        if ("" == imgDesc || imgDesc.length <= 0) {
                            var alts = result.match(reg);
                            if (alts != null && alts[1] != null && alts[1].length > 0) {
                                imgDesc = alts[1];
                            }
                        }

                        var regSrc = new RegExp(/ src=['"]([^'"]*)['"]?/gi)

                        var regClass = new RegExp(/class=['"]([^'"]*)['"]?/i);//匹配class
                        var htmlClass = '';
                        var resultClass = result.match(regClass);
                        // console.log(resultClass, 1436);
                        if (resultClass != null) {
                            try {
                                htmlClass = resultClass[1];
                            } catch (e) {
                                htmlClass = '';
                                console.log(e)
                            }
                        } else {
                            htmlClass = ''
                        }

                        var regStyle = new RegExp(/style=['"]([^'"]*)['"]?/i),//匹配style
                            regHeight = new RegExp(/[^-_]height:([^;]*);?/i),//匹配height
                            regWidth = new RegExp(/[^-_]width:([^;]*);?/i),//匹配width
                            regDisplay = new RegExp(/[^-_]display:([^;]*);?/i);//匹配display:block;
                        var htmlStyle = '',
                            resultHeight = '',
                            resultWidth = '',
                            resultDisplay = '';

                        var resultStyle = result.match(regStyle);

                        try {

                            if (resultStyle != null) {
                                // imgDesc = resultStyle[1];
                                if (resultStyle[0] != null && resultStyle[0].length > 0) {
                                    try {
                                        var lineWidth = resultStyle[0].match(regWidth)
                                        // console.log(lineWidth, 4762);
                                        if (lineWidth != null && lineWidth[1] != null && lineWidth[1].length > 0) {
                                            if (/px/i.test(lineWidth[1])&&!/%/i.test(lineWidth[1])) {
                                                var _width = parseFloat(lineWidth[1])
                                                if (!isNaN(_width) && _width > 0) {
                                                    resultWidth = _width
                                                }
                                            }else if (/%/i.test(lineWidth[1])&&!/px/i.test(lineWidth[1])) {
                                                resultWidth = lineWidth[1]
                                            } else {
                                                resultWidth = '';
                                            }

                                        }
                                        var lineHeight = resultStyle[0].match(regHeight)
                                        // console.log(lineWidth, 4762);
                                        if (lineHeight != null && lineHeight[1] != null && lineHeight[1].length > 0) {
                                            if (/px/i.test(lineHeight[1])) {
                                                var _height = parseFloat(lineHeight[1])
                                                if (!isNaN(_height) && _height > 0) {
                                                    resultHeight = _height
                                                }
                                            } else {
                                                resultHeight = '';
                                            }

                                        }
                                        htmlStyle = resultStyle[1].replace(regHeight, '').replace(regWidth, '')
                                        // console.log(htmlStyle, 1468);

                                        var lineDisplay = resultStyle[0].match(regDisplay)
                                        if (lineDisplay != null && lineDisplay[1] != null && lineDisplay[1].length > 0) {

                                            if (/(block)/i.test(lineDisplay[1])) {
                                                resultDisplay = ' data-display="block" '
                                            } else{
                                                resultDisplay = '';
                                            }
                                        }else{

                                        }
                                    } catch (e) {
                                        htmlStyle = '';
                                        console.log(e)
                                    }
                                } else {
                                    htmlStyle = '';
                                }
                            } else {

                                htmlStyle = '';
                            }
                        } catch (e) {
                            htmlStyle = '';
                            console.log(e)
                        }

                        var imgObj = imgAttrWidthAndHeight(match, $w, imgUrl, imageType.md169, resultWidth, resultHeight);
                        imgUrl = imgObj.imgUrl;
                        if (imgUrl.toLowerCase().indexOf("http") < 0 && imgUrl.toLowerCase().indexOf("https") < 0) {
                            var totalMatchStr = match;
                            var re = /src="([^"]*)"/g;
                            var arr = [];
                            while (arr = re.exec(totalMatchStr)) {
                                imgUrl = arr[1];
                            }

                            if (imgUrl.indexOf('//') == 0) {
                                imgUrl = 'http:' + imgUrl
                            }
                            if (imgUrl.indexOf("newaircloud.com") < 0 || imgUrl.indexOf("gif") >= 0) {
                            } else {
                                imgUrl = imgUrl.indexOf('@!') > -1 || capture.indexOf("?x-oss-process=") > -1 || /(\.svg)/gi.test(imgUrl)? imgUrl : imgUrl ? imgUrl + imageType.md : "";
                            }
                        }

                        if (imgUrl.toLowerCase().indexOf("http") == 0 || imgUrl.toLowerCase().indexOf("https") == 0 || imgUrl) {
                            var flag = imgUrl.indexOf('.gif') > -1 ? 1 : 0;

                            imgHtml = "";
                            lastResult = "";

                            var htmlViewImgAndOriginal = '<img  onclick="viewImage(event, ' + imagesCount + ')" data-original="' + imgUrl + '" ' + resultDisplay ;
                            var originalClass = ' news_detail_img lazy img_loading "';
                            if (htmlClass || resultClass != null) {
                                htmlClass = ' class="' + htmlClass + originalClass;
                                try {
                                    lastResult = result.replace(regClass, htmlClass)

                                } catch (e) {
                                    console.log(e)
                                }

                            } else {
                                htmlClass = '<img  class="' + originalClass;
                                lastResult = result.replace('<img ', htmlClass)
                            }

                            if (htmlStyle || resultStyle != null) {
                                htmlStyle = ' style="' + htmlStyle + imgObj.w + imgObj.h + '"'
                                try {
                                    lastResult = lastResult.replace(regStyle, htmlStyle)
                                } catch (e) {
                                    console.log(e)
                                }
                            } else {
                                htmlStyle = '<img  style="' + imgObj.w + imgObj.h + '"';
                                lastResult = lastResult.replace('<img ', htmlStyle)
                            }

                            // lastResult = lastResult.replace(regSrc, '').replace('<img ', htmlViewImgAndOriginal).replace(/crossorigin="anonymous"/gi,'');//针对微信复制图片去掉crossorigin=”anonymous“ 属性;
                            lastResult = lastResult.replace('<img ', htmlViewImgAndOriginal  + imgObj.nac_r +   ' src= "' + srcImg + '" '+ imgObj.imgW + imgObj.imgH ).replace(/crossorigin="anonymous"/gi, '');//针对微信复制图片去掉crossorigin=”anonymous“ 属性;

                            if (imgDesCheck(imgDesc)) {
                                lastResult += '<div id="triangle-up"> '+ _des +'<p  class="img_desc">' + imgDesc + '</p></div>';
                            }

                        } else {
                            imgHtml = "";
                        }
                        article.content = article.content.replace(match, lastResult);
                        imagesCount++;
                    });
                }
            } catch (e) {
                console.log(e, 'c');
                article.content.replace(/<img [^>]*\bsrc=['"]([^'"]+)[^>]*>/gi, function (match, capture) {
                    var imgUrl = capture;
                    var result = match;
                    var imgDesc = "";
                    //新闻详情图片下方显示描述
                    var reg = /\salt="([^"]+)"/i;//匹配alt
                    var reg2 = /\stitle="([^"]+)"/i;//匹配title
                    var titles = result.match(reg2);
                    if (titles != null && titles[1] != null && titles[1].length > 0) {
                        imgDesc = titles[1];
                    }
                    if ("" == imgDesc || imgDesc.length <= 0) {
                        var alts = result.match(reg);
                        if (alts != null && alts[1] != null && alts[1].length > 0) {
                            imgDesc = alts[1];
                        }
                    }
                    if (capture.indexOf("newaircloud.com") < 0 || capture.indexOf("gif") >= 0) {
                    } else {
                        imgUrl = imgUrl.indexOf('@!') > -1 || capture.indexOf("?x-oss-process=") > -1 ? imgUrl : imgUrl ? imgUrl + imageType.md : "";
                    }

                    if (imgUrl.toLowerCase().indexOf("http") < 0 && imgUrl.toLowerCase().indexOf("https") < 0) {
                        var totalMatchStr = match;
                        var re = / src="([^"]*)"/g;
                        var arr = []
                        while (arr = re.exec(totalMatchStr)) {
                            imgUrl = arr[1];
                        }
                        if (imgUrl.indexOf('//') == 0) {
                            imgUrl = 'http:' + imgUrl
                        }
                        if (imgUrl.indexOf("newaircloud.com") < 0 || imgUrl.indexOf("gif") >= 0) {
                        } else {
                            imgUrl = imgUrl.indexOf('@!') > -1 || capture.indexOf("?x-oss-process=") > -1 ? imgUrl : imgUrl ? imgUrl + imageType.md : "";
                        }
                    }

                    if (imgUrl.toLowerCase().indexOf("http") == 0 || imgUrl.toLowerCase().indexOf("https") == 0) {
                        var flag = imgUrl.indexOf('.gif') > -1 ? 1 : 0;
                        var imgHtml = flag == 1 ? '<img onclick="viewImage(event, ' + imagesCount + ')" class="news_detail_img" src="' + imgUrl + '" style="width:auto;">' : '<img onclick="viewImage(event, ' + imagesCount + ')" class="news_detail_img" src="' + imgUrl + '" style="width: auto;">';
                        if (imgDesc) {
                            imgHtml += '<span id="triangle-up"><span  class="img_desc">' + imgDesc + '</span></span>';
                        }
                        if (imagesCount > 2) {
                            imgHtml = "";
                            imgHtml = flag == 1 ? '<img onclick="viewImage(event, ' + imagesCount + ')" class="news_detail_img lazy" data-original="' + imgUrl + '"  style="width: auto">' : '<img  onclick="viewImage(event, ' + imagesCount + ')" class="news_detail_img lazy" data-original="' + imgUrl + '"  style="width: auto;">';
                            if (imgDesCheck(imgDesc)) {
                                imgHtml += '<span id="triangle-up"><span  class="img_desc">' + imgDesc + '</span></span>';
                            }
                        }
                    } else {
                        imgHtml = "";
                    }
                    article.content = article.content.replace(match, imgHtml);
                    imagesCount++;
                });
            }

            //解析替换正文中的视频
            var i = 0;
            var hasVideosLen = -1;
            if (typeof (article.videos) != "undefined") {
                hasVideosLen = article.videos.length;
            }
            article.content.replace(/<video[^>]* src=['"]([^'"]+)[^>]*>/gi, function (match, capture) {
                var imageUrl = "";
                var videoUrl = capture;
                if (hasVideosLen > i) {
                    if (article.videos[i].imageUrl != null && article.videos[i].imageUrl.length > 0) {
                        imageUrl = article.videos[i].imageUrl;
                        imagesCount++
                    }
                }
                if(!imageUrl || imageUrl.toLowerCase() === 'undefined' || imageUrl.toLowerCase() === 'none'){
                    var reg = /\sposter="([^"]+)"/i;//匹配alt
                    var videoPoster = match.match(reg);
                    console.log('videoPoster:', videoPoster);
                    if (videoPoster != null && videoPoster[1] != null && videoPoster[1].length > 0 && videoPoster[1].toLowerCase() !== 'undefined' && videoPoster[1].toLowerCase() !== 'none') {
                        imageUrl = videoPoster[1];
                        imagesCount++
                    }else{
                        imageUrl =''
                    }
                }

                var imgObj = imgAttrWidthAndHeight(match, $w, imageUrl, imageType.md);

                imageUrl = imgObj.imgUrl ? imgObj.imgUrl : "static/img/video.png";
                i++;

                var clientWidth = getClientWidth();
                var oW=clientWidth-30 >0 ? ' width:'+(clientWidth-30)+'px;' :' width:100%;';
                var oH=clientWidth-30 >0 ? ' height:'+(clientWidth-30) / 1.77777778 +'px;': ' height:100%;';

                imgObj.h= imgObj.h && (imgObj.h+'').length>0 ? imgObj.h:oH;
                imgObj.w= imgObj.w && (imgObj.w+'').length>0 ? imgObj.w:oW;

                var videoTpl = '<div class="news_detail_video">';
                if((imageUrl+'').indexOf('static/img/video.png')>-1){
                    videoTpl +='<img style="position: absolute; top: 0;left: 0;right: 0;bottom: 0;margin: auto;width: 75px;height: 75px; z-index: 20;"  src="static/img/play.png" onclick="viewVideo(\'' + videoUrl + '\')"/>'
                    videoTpl +=  '<img style="'+ oH +' ' +oW+' " src="' + imageUrl + '" >'

                }else{
                    videoTpl +='<img  class="video-play-btn" style="display:none;position: absolute; top: 0;left: 0;right: 0;bottom: 0;margin: auto;width: 75px;height: 75px; z-index: 20;"  src="static/img/play.png" onclick="viewVideo(\'' + videoUrl + '\')"/>'
                    videoTpl +=  '<img  src="'+srcImg+'"  class="video-images img_loading" data-original="' + imageUrl + '"  style="'+ imgObj.h +' ' +oW+' " src="' + imageUrl + '" >'
                }

                videoTpl+='</div>';


                article.content = article.content.replace(match, videoTpl);
            });

            article.content.replace(/<iframe[^>]*><\/iframe>/gi, function (match, capture) {

                var videoTpl = '<span class="news_detail_video" style="display:block;width: 100%;margin: 0 auto;text-align: center">';
                videoTpl += match;
                videoTpl += '</span>';
                videoTpl = videoTpl.replace('http://', '//');
                article.content = article.content.replace(/http:\/\/img\.newaircloud/g, 'https://img.newaircloud');
                article.content = article.content.replace(match, videoTpl);
            });
        } else {//数字报正文中没有图片信息处理
            //解析替换正文中的图片
            var imagesCount = 0;

            article.content.replace(/<img [^>]*src=['"]([^'"]+)[^>]*>/gi, function (match, capture) {
                var imgUrl = capture;
                var result = match;
                var imgDesc = "";
                //新闻详情图片下方显示描述
                var reg = /\salt="([^"]+)"/i;//匹配alt
                var reg2 = /\stitle="([^"]+)"/i;//匹配title
                var titles = result.match(reg2);
                if (titles != null && titles[1] != null && titles[1].length > 0) {
                    imgDesc = titles[1];
                }
                if ("" == imgDesc || imgDesc.length <= 0) {
                    var alts = result.match(reg);
                    if (alts != null && alts[1] != null && alts[1].length > 0) {
                        imgDesc = alts[1];
                    }
                }


                if (capture.indexOf("newaircloud.com") < 0 || capture.indexOf("gif") >= 0) {
                } else {
                    imgUrl = handleImgScaleUrl(imgUrl, imageType.md);
                }
                var imgHtml = '<img onclick="viewImage(event, ' + imagesCount + ')" class="news_detail_img" src="' + imgUrl + '">';
                if (imgDesCheck(imgDesc)) {
                    imgHtml += '<span id="triangle-up"><span  class="img_desc">' + imgDesc + '</span></span>';
                }

                if (imagesCount > 2) {
                    imgHtml = '<img onclick="viewImage(event, ' + imagesCount + ')" class="news_detail_img lazy" data-original="' + imgUrl + '" >';
                }
                article.content = article.content.replace(match, imgHtml);
                imagesCount++;
            });
            if (imagesCount == 0) {
                if (typeof (article.images) != "undefined") {
                    var imgContent = "";
                    for (var i = 0; i < article.images.length; i++) {
                        var imageUrl = article.images[i].imageUrl;
                        var summary = article.images[i].summary;
                        var imageTpl = '<div>';
                        if (imageUrl.indexOf("newaircloud.com") < 0 || imageUrl.indexOf("gif") >= 0) {
                        } else {
                            imageUrl = handleImgScaleUrl(imageUrl, imageType.md);
                        }
                        if (i > 2)
                            imageTpl += '<img onclick="viewImage(event, ' + i + ')" class="news_detail_img lazy" data-original="' + imageUrl + '" />';
                        else
                            imageTpl += '<img onclick="viewImage(event, ' + i + ')" class="news_detail_img" src="' + imageUrl + '" />';

                        if (imgDesCheck(summary)) {
                            imageTpl += '<div id="triangle-up" style="margin-top:0;"><p  class="img_desc">' + summary + '</p></div>';
                        }
                        imageTpl += '</div>';
                        imgContent += imageTpl;
                    }
                    article.content = imgContent + article.content;
                }
            }
        }
    }


    //  处理iosAPP 音频自动加载问题
    if (/<audio[^>]*>/gi.test(article.content)) {
        article.content.replace(/<audio[^>]*>/gi, function (match, capture) {
            var m = match.replace('autoplay="autoplay"', "").replace('preload="none"', 'preload="auto"')
            article.content = article.content.replace(match, m)
        })
    }
    // 针对ios 对news_detail至少有两个参数时做的处理
    article.content.replace(/<a [^>]*href=['"]([^'"]+)[^>]*>/gi, function (match, capture) {
        var u = ''
        if (capture.indexOf("news_detail?") > -1) {
            var newsid = getParams("newsid", capture);
            var a = '', s = ''
            if (newsid) {
                var idArray = newsid.split('_');
                a = idArray[0];
                s = idArray[1];
                a = a ? a : "";
                s = s ? s : "";
                u += capture + '&sc=' + s + '&aid=' + a
                u = match.replace(capture, u)
                article.content = article.content.replace(match, u);
            }
        }else {
            if(capture.indexOf('?')===-1){
                var u = match.replace(capture, capture+'?');
                article.content = article.content.replace(match, u)
            }
        }
    });

    return article;
}
