var store = {
	siteSource:1,
	 tokenCount:0,
  version:"1.0"
  };
//var ctx = window.location.origin;
var ctx = window.baseUrl || "https://h5.newaircloud.com";
function signToRequest(params,method,url,ischeckToken,callback){
    var token = timeLocalStorage.get(params.sid+"siteToken");
    if(!token){
       getToken(params.sid,function(tokenInfo){
		    store.tokenCount=0;
            token = tokenInfo.authtoken;
            goSignRequest(url,params,method,token,ischeckToken,function(data){
                store.tokenCount=0;
                callback(data);
            })

	   })
    }else{
        goSignRequest(url,params,method,token,ischeckToken,function(data){
            if(data.success===false && store.tokenCount<1) {

                //获取签名失败，重新获取一次
              localStorage.removeItem(params.sid+"siteToken");
			  store.tokenCount = 1;
              signToRequest(params,method,url,ischeckToken,callback)

			}else{
                store.tokenCount=0;
                callback(data);
            }
        });
    }
}
//发起请求
function goSignRequest(url,params,method,token,isCheckToken,callback){


     var  version=store.version,
      source = store.siteSource;
    //获取签名参数
    var secretParam = getSecretParam(params.sid,version);

    var middleStr = Object.keys(params).filter(function(item){
		return item!='sid'
	}).map(function(item){
      return params[item];
    }).join("");

    var sign = hex_sha1(secretParam.srcKey+""+middleStr+""+secretParam.deviceID+""+source+""+(isCheckToken ? token : ""));
    var header ={
        'tenant': secretParam.tenant,
        'authtoken':token,
        'nonce':secretParam.nonce,
        'timestamp':secretParam.timestamp,
        'version':version
    };

	params.deviceID = secretParam.deviceID;
	params.source = source;
	params.sign = sign;

    requestFun(url,method,params,header,callback)
}
function requestFun(url,method,paramsReq,header,callback){
	$.ajax({
			type: method,
			url: ctx+url,
			headers:header,
			data:paramsReq,
			dataType:"json",
			success: function(result) {
				callback(result)
			}
		});
}
function getToken(sid,callback){
    var  version=store.version,
      source = store.siteSource;
    //获取签名参数
    var secretParam = getSecretParam(sid,version);
    var sign = hex_sha1(secretParam.srcKey+secretParam.deviceID+""+source);

	$.ajax({
		url:ctx+"/api/getAppToken",
		method:"post",
		data:{
			sid:sid,
			deviceID:secretParam.deviceID,
			source:source,
			sign:sign
		},
		headers:{
		 'tenant':secretParam.tenant,
		  'nonce':secretParam.nonce,
		  'timestamp':secretParam.timestamp,
		  'version':version
		},
		dataType:"json",
		success:function(tokenInfo){
			timeLocalStorage.setAge(tokenInfo.expires_in*0.8*1000).set(sid+"siteToken",tokenInfo.authtoken);
			callback(tokenInfo)
		}
	})
  }
  /**
  * 设置localstorage过期时间
   * zhangxiaojian 2019-5-8
  * */
  var timeLocalStorage={
    // 过期时间，默认30天
    age: 30*24*60*60*1000,
    /**
     * 设置过期时间
     * @param age
     * @returns {exports}
     */
    setAge: function(age){
      this.age = age;
      return this;
    },
    /**
     * 设置 localStorage
     * @param key
     * @param value
     */
    set: function(key, value){
      localStorage.removeItem(key);
      var isObject = value instanceof Object,
        _time = new Date().getTime(),
        _age = this.age;
      // 如果不是对象，新建一个对象把 value 存起来
      if(!isObject) {
        var b = value;
        value = {};
        value._value = b;
      }
      // 加入时间
      value._time = _time;
      // 过期时间
      value._age = _time + _age;
      // 是否一个对象
      value._isObject = isObject;
      localStorage.setItem(key, JSON.stringify(value));
      return this;
    },
    /**
     * 判断一个 localStorage 是否过期
     * @param key
     * @returns {boolean}
     */
    isExpire: function(key) {

      var timeIsExpire = true,
        value = localStorage.getItem(key),
        now = new Date().getTime();

      if(value) {
        value = JSON.parse(value);
        // 当前时间是否大于过期时间
        timeIsExpire = now > value._age;
      } else {
        // 没有值也是过期
      }
      return timeIsExpire;
    },
    /**
     * 获取某个 localStorage 值
     * @param key
     * @returns {*}
     */
    get: function(key) {
      var isExpire = this.isExpire(key),
        value = null;
      if(!isExpire) {
        value = localStorage.getItem(key);
        value = JSON.parse(value);
        if(!value._isObject) {
          value = value._value;
        }
      }
      return value;
    }
  };
  function hex_sha1(s) {
    var hexcase = 0;
    /* hex output format. 0 - lowercase; 1 - uppercase     */
    var b64pad = "";
    /* base-64 pad character. "=" for strict RFC compliance  */
    var chrsz = 8;
    /* bits per input character. 8 - ASCII; 16 - Unicode    */

    // function hex_sha1(s) {
    //     return binb2hex(core_sha1(str2binb(s), s.length * chrsz));
    // }
    function b64_sha1(s) {
      return binb2b64(core_sha1(str2binb(s), s.length * chrsz));
    }

    function str_sha1(s) {
      return binb2str(core_sha1(str2binb(s), s.length * chrsz));
    }

    function hex_hmac_sha1(key, data) {
      return binb2hex(core_hmac_sha1(key, data));
    }

    function b64_hmac_sha1(key, data) {
      return binb2b64(core_hmac_sha1(key, data));
    }

    function str_hmac_sha1(key, data) {
      return binb2str(core_hmac_sha1(key, data));
    }



    function core_sha1(x, len) {
      /* append padding */
      x[len >> 5] |= 0x80 << (24 - len % 32);
      x[((len + 64 >> 9) << 4) + 15] = len;
      var w = Array(80);
      var a = 1732584193;
      var b = -271733879;
      var c = -1732584194;
      var d = 271733878;
      var e = -1009589776;
      for (var i = 0; i < x.length; i += 16) {
        var olda = a;
        var oldb = b;
        var oldc = c;
        var oldd = d;
        var olde = e;
        for (var j = 0; j < 80; j++) {
          if (j < 16) w[j] = x[i + j];
          else w[j] = rol(w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16], 1);
          var t = safe_add(safe_add(rol(a, 5), sha1_ft(j, b, c, d)), safe_add(safe_add(e, w[j]), sha1_kt(j)));
          e = d;
          d = c;
          c = rol(b, 30);
          b = a;
          a = t;
        }
        a = safe_add(a, olda);
        b = safe_add(b, oldb);
        c = safe_add(c, oldc);
        d = safe_add(d, oldd);
        e = safe_add(e, olde);
      }
      return Array(a, b, c, d, e);
    }

    function sha1_ft(t, b, c, d) {
      if (t < 20) return (b & c) | ((~b) & d);
      if (t < 40) return b ^ c ^ d;
      if (t < 60) return (b & c) | (b & d) | (c & d);
      return b ^ c ^ d;
    }

    function sha1_kt(t) {
      return (t < 20) ? 1518500249 : (t < 40) ? 1859775393 : (t < 60) ? -1894007588 : -899497514;
    }

    function core_hmac_sha1(key, data) {
      var bkey = str2binb(key);
      if (bkey.length > 16) bkey = core_sha1(bkey, key.length * chrsz);
      var ipad = Array(16),
        opad = Array(16);
      for (var i = 0; i < 16; i++) {
        ipad[i] = bkey[i] ^ 0x36363636;
        opad[i] = bkey[i] ^ 0x5C5C5C5C;
      }
      var hash = core_sha1(ipad.concat(str2binb(data)), 512 + data.length * chrsz);
      return core_sha1(opad.concat(hash), 512 + 160);
    }

    function safe_add(x, y) {
      var lsw = (x & 0xFFFF) + (y & 0xFFFF);
      var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
      return (msw << 16) | (lsw & 0xFFFF);
    }

    function rol(num, cnt) {
      return (num << cnt) | (num >>> (32 - cnt));
    }

    function str2binb(str) {
      var bin = Array();
      var mask = (1 << chrsz) - 1;
      for (var i = 0; i < str.length * chrsz; i += chrsz)
        bin[i >> 5] |= (str.charCodeAt(i / chrsz) & mask) << (24 - i % 32);
      return bin;
    }

    function binb2str(bin) {
      var str = "";
      var mask = (1 << chrsz) - 1;
      for (var i = 0; i < bin.length * 32; i += chrsz)
        str += String.fromCharCode((bin[i >> 5] >>> (24 - i % 32)) & mask);
      return str;
    }

    function binb2hex(binarray) {
      var hex_tab = hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
      var str = "";
      for (var i = 0; i < binarray.length * 4; i++) {
        str += hex_tab.charAt((binarray[i >> 2] >> ((3 - i % 4) * 8 + 4)) & 0xF) + hex_tab.charAt((binarray[i >> 2] >> ((3 - i % 4) * 8)) & 0xF);
      }
      return str;
    }

    function binb2b64(binarray) {
      var tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      var str = "";
      for (var i = 0; i < binarray.length * 4; i += 3) {
        var triplet = (((binarray[i >> 2] >> 8 * (3 - i % 4)) & 0xFF) << 16) | (((binarray[i + 1 >> 2] >> 8 * (3 - (i + 1) % 4)) & 0xFF) << 8) | ((binarray[i + 2 >> 2] >> 8 * (3 - (i + 2) % 4)) & 0xFF);
        for (var j = 0; j < 4; j++) {
          if (i * 8 + j * 6 > binarray.length * 32) str += b64pad;
          else str += tab.charAt((triplet >> 6 * (3 - j)) & 0x3F);
        }
      }
      return str;
    }

    return binb2hex(core_sha1(str2binb(s), s.length * chrsz));
  }
function md5(string){
    function md5_RotateLeft(lValue, iShiftBits) {
      return (lValue << iShiftBits) | (lValue >>> (32 - iShiftBits));
    }

    function md5_AddUnsigned(lX, lY) {
      var lX4, lY4, lX8, lY8, lResult;
      lX8 = (lX & 0x80000000);
      lY8 = (lY & 0x80000000);
      lX4 = (lX & 0x40000000);
      lY4 = (lY & 0x40000000);
      lResult = (lX & 0x3FFFFFFF) + (lY & 0x3FFFFFFF);
      if (lX4 & lY4) {
        return (lResult ^ 0x80000000 ^ lX8 ^ lY8);
      }
      if (lX4 | lY4) {
        if (lResult & 0x40000000) {
          return (lResult ^ 0xC0000000 ^ lX8 ^ lY8);
        } else {
          return (lResult ^ 0x40000000 ^ lX8 ^ lY8);
        }
      } else {
        return (lResult ^ lX8 ^ lY8);
      }
    }

    function md5_F(x, y, z) {
      return (x & y) | ((~x) & z);
    }

    function md5_G(x, y, z) {
      return (x & z) | (y & (~z));
    }

    function md5_H(x, y, z) {
      return (x ^ y ^ z);
    }

    function md5_I(x, y, z) {
      return (y ^ (x | (~z)));
    }

    function md5_FF(a, b, c, d, x, s, ac) {
      a = md5_AddUnsigned(a, md5_AddUnsigned(md5_AddUnsigned(md5_F(b, c, d), x), ac));
      return md5_AddUnsigned(md5_RotateLeft(a, s), b);
    }
    function md5_GG(a, b, c, d, x, s, ac) {
      a = md5_AddUnsigned(a, md5_AddUnsigned(md5_AddUnsigned(md5_G(b, c, d), x), ac));
      return md5_AddUnsigned(md5_RotateLeft(a, s), b);
    }
    function md5_HH(a, b, c, d, x, s, ac) {
      a = md5_AddUnsigned(a, md5_AddUnsigned(md5_AddUnsigned(md5_H(b, c, d), x), ac));
      return md5_AddUnsigned(md5_RotateLeft(a, s), b);
    }
    function md5_II(a, b, c, d, x, s, ac) {
      a = md5_AddUnsigned(a, md5_AddUnsigned(md5_AddUnsigned(md5_I(b, c, d), x), ac));
      return md5_AddUnsigned(md5_RotateLeft(a, s), b);
    }
    function md5_ConvertToWordArray(string) {
      var lWordCount;
      var lMessageLength = string.length;
      var lNumberOfWords_temp1 = lMessageLength + 8;
      var lNumberOfWords_temp2 = (lNumberOfWords_temp1 - (lNumberOfWords_temp1 % 64)) / 64;
      var lNumberOfWords = (lNumberOfWords_temp2 + 1) * 16;
      var lWordArray = Array(lNumberOfWords - 1);
      var lBytePosition = 0;
      var lByteCount = 0;
      while (lByteCount < lMessageLength) {
        lWordCount = (lByteCount - (lByteCount % 4)) / 4;
        lBytePosition = (lByteCount % 4) * 8;
        lWordArray[lWordCount] = (lWordArray[lWordCount] | (string.charCodeAt(lByteCount) << lBytePosition));
        lByteCount++;
      }
      lWordCount = (lByteCount - (lByteCount % 4)) / 4;
      lBytePosition = (lByteCount % 4) * 8;
      lWordArray[lWordCount] = lWordArray[lWordCount] | (0x80 << lBytePosition);
      lWordArray[lNumberOfWords - 2] = lMessageLength << 3;
      lWordArray[lNumberOfWords - 1] = lMessageLength >>> 29;
      return lWordArray;
    }
    function md5_WordToHex(lValue) {
      var WordToHexValue = "", WordToHexValue_temp = "", lByte, lCount;
      for (lCount = 0; lCount <= 3; lCount++) {
        lByte = (lValue >>> (lCount * 8)) & 255;
        WordToHexValue_temp = "0" + lByte.toString(16);
        WordToHexValue = WordToHexValue + WordToHexValue_temp.substr(WordToHexValue_temp.length - 2, 2);
      }
      return WordToHexValue;
    }
    function md5_Utf8Encode(string) {
      string = string.replace(/\r\n/g, "\n");
      var utftext = "";
      for (var n = 0; n < string.length; n++) {
        var c = string.charCodeAt(n);
        if (c < 128) {
          utftext += String.fromCharCode(c);
        } else if ((c > 127) && (c < 2048)) {
          utftext += String.fromCharCode((c >> 6) | 192);
          utftext += String.fromCharCode((c & 63) | 128);
        } else {
          utftext += String.fromCharCode((c >> 12) | 224);
          utftext += String.fromCharCode(((c >> 6) & 63) | 128);
          utftext += String.fromCharCode((c & 63) | 128);
        }
      }
      return utftext;
    }
    var x = Array();
    var k, AA, BB, CC, DD, a, b, c, d;
    var S11 = 7, S12 = 12, S13 = 17, S14 = 22;
    var S21 = 5, S22 = 9, S23 = 14, S24 = 20;
    var S31 = 4, S32 = 11, S33 = 16, S34 = 23;
    var S41 = 6, S42 = 10, S43 = 15, S44 = 21;
    string = md5_Utf8Encode(string);
    x = md5_ConvertToWordArray(string);
    a = 0x67452301;
    b = 0xEFCDAB89;
    c = 0x98BADCFE;
    d = 0x10325476;
    for (k = 0; k < x.length; k += 16) {
      AA = a;
      BB = b;
      CC = c;
      DD = d;
      a = md5_FF(a, b, c, d, x[k + 0], S11, 0xD76AA478);
      d = md5_FF(d, a, b, c, x[k + 1], S12, 0xE8C7B756);
      c = md5_FF(c, d, a, b, x[k + 2], S13, 0x242070DB);
      b = md5_FF(b, c, d, a, x[k + 3], S14, 0xC1BDCEEE);
      a = md5_FF(a, b, c, d, x[k + 4], S11, 0xF57C0FAF);
      d = md5_FF(d, a, b, c, x[k + 5], S12, 0x4787C62A);
      c = md5_FF(c, d, a, b, x[k + 6], S13, 0xA8304613);
      b = md5_FF(b, c, d, a, x[k + 7], S14, 0xFD469501);
      a = md5_FF(a, b, c, d, x[k + 8], S11, 0x698098D8);
      d = md5_FF(d, a, b, c, x[k + 9], S12, 0x8B44F7AF);
      c = md5_FF(c, d, a, b, x[k + 10], S13, 0xFFFF5BB1);
      b = md5_FF(b, c, d, a, x[k + 11], S14, 0x895CD7BE);
      a = md5_FF(a, b, c, d, x[k + 12], S11, 0x6B901122);
      d = md5_FF(d, a, b, c, x[k + 13], S12, 0xFD987193);
      c = md5_FF(c, d, a, b, x[k + 14], S13, 0xA679438E);
      b = md5_FF(b, c, d, a, x[k + 15], S14, 0x49B40821);
      a = md5_GG(a, b, c, d, x[k + 1], S21, 0xF61E2562);
      d = md5_GG(d, a, b, c, x[k + 6], S22, 0xC040B340);
      c = md5_GG(c, d, a, b, x[k + 11], S23, 0x265E5A51);
      b = md5_GG(b, c, d, a, x[k + 0], S24, 0xE9B6C7AA);
      a = md5_GG(a, b, c, d, x[k + 5], S21, 0xD62F105D);
      d = md5_GG(d, a, b, c, x[k + 10], S22, 0x2441453);
      c = md5_GG(c, d, a, b, x[k + 15], S23, 0xD8A1E681);
      b = md5_GG(b, c, d, a, x[k + 4], S24, 0xE7D3FBC8);
      a = md5_GG(a, b, c, d, x[k + 9], S21, 0x21E1CDE6);
      d = md5_GG(d, a, b, c, x[k + 14], S22, 0xC33707D6);
      c = md5_GG(c, d, a, b, x[k + 3], S23, 0xF4D50D87);
      b = md5_GG(b, c, d, a, x[k + 8], S24, 0x455A14ED);
      a = md5_GG(a, b, c, d, x[k + 13], S21, 0xA9E3E905);
      d = md5_GG(d, a, b, c, x[k + 2], S22, 0xFCEFA3F8);
      c = md5_GG(c, d, a, b, x[k + 7], S23, 0x676F02D9);
      b = md5_GG(b, c, d, a, x[k + 12], S24, 0x8D2A4C8A);
      a = md5_HH(a, b, c, d, x[k + 5], S31, 0xFFFA3942);
      d = md5_HH(d, a, b, c, x[k + 8], S32, 0x8771F681);
      c = md5_HH(c, d, a, b, x[k + 11], S33, 0x6D9D6122);
      b = md5_HH(b, c, d, a, x[k + 14], S34, 0xFDE5380C);
      a = md5_HH(a, b, c, d, x[k + 1], S31, 0xA4BEEA44);
      d = md5_HH(d, a, b, c, x[k + 4], S32, 0x4BDECFA9);
      c = md5_HH(c, d, a, b, x[k + 7], S33, 0xF6BB4B60);
      b = md5_HH(b, c, d, a, x[k + 10], S34, 0xBEBFBC70);
      a = md5_HH(a, b, c, d, x[k + 13], S31, 0x289B7EC6);
      d = md5_HH(d, a, b, c, x[k + 0], S32, 0xEAA127FA);
      c = md5_HH(c, d, a, b, x[k + 3], S33, 0xD4EF3085);
      b = md5_HH(b, c, d, a, x[k + 6], S34, 0x4881D05);
      a = md5_HH(a, b, c, d, x[k + 9], S31, 0xD9D4D039);
      d = md5_HH(d, a, b, c, x[k + 12], S32, 0xE6DB99E5);
      c = md5_HH(c, d, a, b, x[k + 15], S33, 0x1FA27CF8);
      b = md5_HH(b, c, d, a, x[k + 2], S34, 0xC4AC5665);
      a = md5_II(a, b, c, d, x[k + 0], S41, 0xF4292244);
      d = md5_II(d, a, b, c, x[k + 7], S42, 0x432AFF97);
      c = md5_II(c, d, a, b, x[k + 14], S43, 0xAB9423A7);
      b = md5_II(b, c, d, a, x[k + 5], S44, 0xFC93A039);
      a = md5_II(a, b, c, d, x[k + 12], S41, 0x655B59C3);
      d = md5_II(d, a, b, c, x[k + 3], S42, 0x8F0CCC92);
      c = md5_II(c, d, a, b, x[k + 10], S43, 0xFFEFF47D);
      b = md5_II(b, c, d, a, x[k + 1], S44, 0x85845DD1);
      a = md5_II(a, b, c, d, x[k + 8], S41, 0x6FA87E4F);
      d = md5_II(d, a, b, c, x[k + 15], S42, 0xFE2CE6E0);
      c = md5_II(c, d, a, b, x[k + 6], S43, 0xA3014314);
      b = md5_II(b, c, d, a, x[k + 13], S44, 0x4E0811A1);
      a = md5_II(a, b, c, d, x[k + 4], S41, 0xF7537E82);
      d = md5_II(d, a, b, c, x[k + 11], S42, 0xBD3AF235);
      c = md5_II(c, d, a, b, x[k + 2], S43, 0x2AD7D2BB);
      b = md5_II(b, c, d, a, x[k + 9], S44, 0xEB86D391);
      a = md5_AddUnsigned(a, AA);
      b = md5_AddUnsigned(b, BB);
      c = md5_AddUnsigned(c, CC);
      d = md5_AddUnsigned(d, DD);
    }
    return (md5_WordToHex(a) + md5_WordToHex(b) + md5_WordToHex(c) + md5_WordToHex(d)).toLowerCase();
  }
  function getSecretParam(sid,version){
    var tenant =md5(md5(sid)),
      nonce = randomWord(false,36),
      timestamp = dateFormat(new Date(),"yyyy-MM-ddThh:mm:ssZ",true);
    var deviceID = localStorage.getItem("deviceID");
    if(!deviceID){
      deviceID = md5(new Date().getTime()+"deviceID");
      localStorage.setItem("deviceID",deviceID);
    }
    return {
      tenant:tenant,
      nonce:nonce,
      timestamp:timestamp,
      srcKey:tenant+nonce+timestamp+version,
      deviceID:deviceID
    }
     // version=store.getState().version
  }
 function randomWord(randomFlag, min, max){
    var str = "",
      range = min,
      pos='',
      arr = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];

    // 随机产生
    if(randomFlag){
      range = Math.round(Math.random() * (max-min)) + min;
    }
    for(var i=0; i<range; i++){
      pos = Math.round(Math.random() * (arr.length-1));
      str += arr[pos];
    }
    return str;
  }
  /**
   * 格式化时间
   * */
  function dateFormat(time,fmt,utc){
    Date.prototype.Format = function (fmt,utc) { //author: meizz
      fmt = fmt || 'yyyy-MM-dd hh:mm:ss'
      var o = {
        "M+": (utc?this.getUTCMonth():this.getMonth()) + 1, //月份
        "d+": utc?this.getUTCDate():this.getDate(), //日
        "h+": utc?this.getUTCHours():this.getHours(), //小时
        "m+": utc?this.getUTCMinutes():this.getMinutes(), //分
        "s+": utc?this.getUTCSeconds():this.getSeconds(), //秒
        "q+": Math.floor(((utc?this.getUTCMonth():this.getMonth()) + 3) / 3), //季度
        "S": utc?this.getUTCMilliseconds():this.getMilliseconds() //毫秒
      };
      if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, ((utc?this.getUTCFullYear():this.getFullYear()) + "").substr(4 - RegExp.$1.length));
      for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
      return fmt;
    };
    try{
      return time.Format(fmt,utc);
    }catch(e){
      return null
    }
  }

function signToRequestNew(params,method,url,ischeckToken,callback,filter,secondStr){

  var token = timeLocalStorage.get(params.sid+"siteToken");
  if(!token){
    getToken(params.sid,function(tokenInfo){
      store.tokenCount=0;
      token = tokenInfo.authtoken;
      goSignRequestNew(url,params,method,token,ischeckToken,function(data){
        store.tokenCount=0;
        callback(data);
      },filter,secondStr)

    })
  }else{
    goSignRequestNew(url,params,method,token,ischeckToken,function(data){
      if(data.success===false && store.tokenCount<1) {

        //获取签名失败，重新获取一次
        localStorage.removeItem(params.sid+"siteToken");
        store.tokenCount = 1;
        signToRequestNew(params,method,url,ischeckToken,callback,filter,secondStr)

      }else{
        store.tokenCount=0;
        callback(data);
      }
    },filter,secondStr);
  }
}
//发起请求
function goSignRequestNew(url,params,method,token,isCheckToken,callback,filter,secondStr){
  // console.log('0    =====================================');
  // console.log(params)
  filter = filter || ''
  var filterStr = 'sid,deviceID,source,sign,'+filter
  filterStr = filterStr.split(",")
  var  version=store.version,
      source = store.siteSource;
  //获取签名参数
  var secretParam = getSecretParam(params.sid,version);

  var middleStr = Object.keys(params).filter(function(item){
    // return item!='sid'
    return filterStr.indexOf(item) === -1
  }).map(function(item){
    return item == 'userName' || item == 'topic' ? encodeURIComponent(params[item]): params[item];
  }).join("");
  var _secondStr = ''
  if(secondStr){
    _secondStr = params[secondStr]
  }
  // console.log('middleStr',middleStr)
  // console.log(secretParam)
  var _str = secretParam.srcKey+""+middleStr+""+secretParam.deviceID+""+ _secondStr + '' +source+""+(isCheckToken ? token : "")
  // console.log('_str', _str)
  var sign = hex_sha1(_str);
  var header ={
    'tenant': secretParam.tenant,
    'authtoken':token,
    'nonce':secretParam.nonce,
    'timestamp':secretParam.timestamp,
    'version':version
  };

  params.deviceID = secretParam.deviceID;
  params.source = source;
  params.sign = sign;
  // console.log('sign: ', sign);
  // console.log('1    =====================================');
  requestFun(url,method,params,header,callback)
}
