precision mediump float;

uniform sampler2D u_textureBase;
uniform sampler2D u_textureGroups;
uniform sampler2D u_textureColors;
uniform sampler2D u_textureXY;
uniform sampler2D u_textureEffects;

uniform sampler2D u_texturePen;
uniform sampler2D u_textureCrayon;
uniform sampler2D u_textureOil;

uniform int u_mode;
uniform vec2 u_click;
uniform float u_radius;
uniform vec2 u_currentGroup;
uniform vec4 u_previousColor;
uniform vec2 u_previousColorEffects;
uniform sampler2D u_previousColorTextureXY;

varying vec2 v_texCoord;

const int MODE_GROUPS = 0;
const int MODE_PAINTING = 1;


void groupPainting() {
    vec2 coords = texture2D( u_textureGroups, v_texCoord ).st;
    vec4 finalColor = texture2D( u_textureColors, coords );

    gl_FragColor = finalColor;
}

void animationPaintingSimple() {
    vec2 coords = texture2D( u_textureGroups, v_texCoord ).st;
    vec4 lineColor = texture2D( u_textureColors, vec2(0.0, 0.0) );
    vec4 finalColor = texture2D( u_textureColors, coords );
    float radiustime = u_radius / 500.0;

    // Comparação de float com um delta por motivos de problema de arredondamento dentro do shader
    if( abs( coords.x - u_currentGroup.x ) < 1.0/256.0
    && abs( coords.y - u_currentGroup.y ) < 1.0/256.0)
    {
        if( distance(v_texCoord,u_click) > radiustime )
        {
            gl_FragColor = u_previousColor;
        }
        else
        {
            gl_FragColor = finalColor;
        }
    }
    else
    {
        gl_FragColor = finalColor;
    }
}

void animationPaintingMaterial() {
    vec2 coords = texture2D( u_textureGroups, v_texCoord ).st;
    vec4 lineColor = texture2D( u_textureColors, vec2(0.0, 0.0) );
    vec4 finalColor = texture2D( u_textureColors, coords );

    // Comparação de float com um delta por motivos de problema de arredondamento dentro do shader
    if( abs( coords.x - u_currentGroup.x ) < 1.0/256.0
    && abs( coords.y - u_currentGroup.y ) < 1.0/256.0)
    {
        if( (((v_texCoord.x*100.0-u_click.x*100.0)*(v_texCoord.x*100.0-u_click.x*100.0))+((v_texCoord.y*100.0-u_click.y*100.0)*(v_texCoord.y*100.0-u_click.y*100.0)))> ((u_radius*100.0)*(u_radius*100.0)))
        {
            float gradient = u_radius;
            if(gradient > 0.9) gradient = 0.9;
            vec4 gradientColor = mix(u_previousColor,finalColor,gradient);
            gl_FragColor = gradientColor;
        }
        else
        {
            gl_FragColor = finalColor;
        }
    }
    else
    {
        gl_FragColor = finalColor;
    }
}

void animationPaintingSimpleExp() {
    vec2 coords = texture2D( u_textureGroups, v_texCoord ).st;
    vec4 lineColor = texture2D( u_textureColors, vec2(0.0, 0.0) );
    vec4 finalColor = texture2D( u_textureColors, coords );
    float radiustime = u_radius / 500.0;

    // Comparação de float com um delta por motivos de problema de arredondamento dentro do shader
    if( abs( coords.x - u_currentGroup.x ) < 1.0/256.0
    && abs( coords.y - u_currentGroup.y ) < 1.0/256.0)
    {
        float radiusSpeed = radiustime;
        if( radiusSpeed < 0.0 ) radiusSpeed = 1.0;
        if( distance(v_texCoord,u_click) > radiustime + ( radiusSpeed * radiusSpeed ) )
        {
            gl_FragColor = u_previousColor;
        }
        else
        {
            gl_FragColor = finalColor;
        }
    }
    else
    {
        gl_FragColor = finalColor;
    }
}

void animationPaintingGradientInside() {
    vec2 coords = texture2D( u_textureGroups, v_texCoord ).st;
    vec4 lineColor = texture2D( u_textureColors, vec2(0.0, 0.0) );
    vec4 finalColor = texture2D( u_textureColors, coords );
    float radiustime = u_radius / 500.0;

    // Comparação de float com um delta por motivos de problema de arredondamento dentro do shader
    if( abs( coords.x - u_currentGroup.x ) < 1.0/256.0
    && abs( coords.y - u_currentGroup.y ) < 1.0/256.0)
    {
        float gradient = (u_radius + (distance(v_texCoord,u_click)*500.0))/500.0;
        if(gradient < 1.0)
        {
            vec4 gradientColor = mix(u_previousColor,finalColor,gradient);
            gl_FragColor = gradientColor;
        }
        else
        {
            gl_FragColor = finalColor;
        }

    }
    else
    {
        gl_FragColor = finalColor;
    }
}

void animationPaintingExpLayers() {
    vec2 coords = texture2D( u_textureGroups, v_texCoord ).st;
    vec4 lineColor = texture2D( u_textureColors, vec2(0.0, 0.0) );
    vec4 finalColor = texture2D( u_textureColors, coords );
    float radiustime = u_radius / 500.0;

    // Comparação de float com um delta por motivos de problema de arredondamento dentro do shader
    if( abs( coords.x - u_currentGroup.x ) < 1.0/256.0
    && abs( coords.y - u_currentGroup.y ) < 1.0/256.0)
    {
        if( distance(v_texCoord,u_click) > radiustime )
        {
            gl_FragColor = u_previousColor;
        }
        else if (distance(v_texCoord,u_click) > radiustime / 2.0 )
        {
            vec4 animbg = mix(finalColor,u_previousColor,0.7);
            gl_FragColor = animbg;
        }
        else if (distance(v_texCoord,u_click) > radiustime / 3.0 )
        {
            vec4 animbg = mix(finalColor,u_previousColor,0.4);
            gl_FragColor = animbg;
        }
        else if (distance(v_texCoord,u_click) > radiustime / 4.0 )
        {
            vec4 animbg = mix(finalColor,u_previousColor,0.2);
            gl_FragColor = animbg;
        }
        else
        {
            gl_FragColor = finalColor;
        }
    }
    else
    {
        gl_FragColor = finalColor;
    }
}

void animationPaintingLinearLayers() {
    vec2 coords = texture2D( u_textureGroups, v_texCoord ).st;
    vec4 lineColor = texture2D( u_textureColors, vec2(0.0, 0.0) );
    vec4 finalColor = texture2D( u_textureColors, coords );
    float radiustime = u_radius / 500.0;

    // Comparação de float com um delta por motivos de problema de arredondamento dentro do shader
    if( abs( coords.x - u_currentGroup.x ) < 1.0/256.0
    && abs( coords.y - u_currentGroup.y ) < 1.0/256.0)
    {
        if( distance(v_texCoord,u_click) > radiustime )
        {
            gl_FragColor = u_previousColor;
        }
        else if (distance(v_texCoord,u_click) > 3.0 * radiustime / 4.0 )
        {
            vec4 animbg = mix(finalColor,u_previousColor,0.7);
            gl_FragColor = animbg;
        }
        else if (distance(v_texCoord,u_click) > 2.0 * radiustime / 4.0 )
        {
            vec4 animbg = mix(finalColor,u_previousColor,0.4);
            gl_FragColor = animbg;
        }
        else if (distance(v_texCoord,u_click) > radiustime / 4.0 )
        {
            vec4 animbg = mix(finalColor,u_previousColor,0.2);
            gl_FragColor = animbg;
        }
        else
        {
            gl_FragColor = finalColor;
        }
    }
    else
    {
        gl_FragColor = finalColor;
    }
}

void animationPaintingGradientOutside() {
    vec2 coords = texture2D( u_textureGroups, v_texCoord ).st;
    vec4 lineColor = texture2D( u_textureColors, vec2(0.0, 0.0) );
    vec4 finalColor = texture2D( u_textureColors, coords );
    float radiustime = u_radius / 500.0;

    // Comparação de float com um delta por motivos de problema de arredondamento dentro do shader
    if( abs( coords.x - u_currentGroup.x ) < 1.0/256.0
    && abs( coords.y - u_currentGroup.y ) < 1.0/256.0)
    {
        if( distance(v_texCoord,u_click) > radiustime )
        {
            gl_FragColor = u_previousColor;
        }
        else
        {
            float gradient = (u_radius - (distance(v_texCoord,u_click)*500.0))/500.0;
            if(gradient>1.0) gradient=1.0;
            if(gradient<0.0) gradient=0.0;
            gl_FragColor = mix(u_previousColor,finalColor,gradient);
        }
    }
    else
    {
        gl_FragColor = finalColor;
    }
}


void regularTexture() {
    gl_FragColor = texture2D( u_textureBase, v_texCoord );
}


vec3 rgb2hsv(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

vec3 secondaryColorForPrimary(vec3 color)
{
    vec3 secColor = rgb2hsv(color);

    float h = secColor[0];
    float s = secColor[1];
    float b = secColor[2];

    if(b>0.6) {
        b -= 0.3;
    }
    else {
        b += 0.4;
        s += 0.3;
        s = min(s, 1.);
    }

    h -= 0.08;
    if(h<0.) h=0.;

    return hsv2rgb(vec3(h, s, b));
}

vec2 textureBrushCoordinate(vec2 point, vec2 center, float textureSize)
{
    vec2 p1 = point;
    vec2 c1 = center;
    vec2 s1 = c1 - 0.5;

    vec2 newP = vec2(0.0, 0.0);
    newP.x = c1.x + (p1.x-c1.x)*cos(c1.x * 180.0 +c1.y * 180.0 ) - (p1.y-c1.y)*sin(c1.x * 180.0 +c1.y * 180.0 );
    newP.y = c1.y + (p1.x-c1.x)*sin(c1.x * 180.0 +c1.y * 180.0 ) + (p1.y-c1.y)*cos(c1.x * 180.0 +c1.y * 180.0 );

    newP.x = newP.x + s1.x;
    newP.y = newP.y + s1.y;

    newP = newP / (textureSize / 1024.0);

    return newP;
}

vec4 mixWithTexture(vec4 color, vec4 texture)
{
    return vec4(
        texture.r + color.r - texture.r * color.r,
        texture.g + color.g - texture.g * color.g,
        texture.b + color.b - texture.b * color.b,
        color.a);
}

vec4 mixWithTexture2(sampler2D brushtexture, float texturesize, vec2 coords, vec4 color, sampler2D textureXY)
{
    vec4 finalXY = texture2D( textureXY, coords );
    vec2 finalXYn = vec2(finalXY.y, finalXY.w);
    vec2 texDistance = textureBrushCoordinate(v_texCoord, finalXYn, texturesize);
    vec4 textureColor = texture2D( brushtexture, texDistance );
    return vec4(
        textureColor.r + color.r - textureColor.r * color.r,
        textureColor.g + color.g - textureColor.g * color.g,
        textureColor.b + color.b - textureColor.b * color.b,
        color.a);
}

void colorPainting() {
    vec2 coords = texture2D( u_textureGroups, v_texCoord ).st;
    float gradientType = texture2D( u_textureEffects, coords).r;
    float brushType = texture2D( u_textureEffects, coords).g;

    vec4 gradientColor;

    if (gradientType == 0.0)
    {
        vec4 finalColor = texture2D( u_textureColors, coords );
        gradientColor = finalColor;
    }
    else if (gradientType < 0.004)
    {
        vec4 finalColor = texture2D( u_textureColors, coords );
        vec4 finalXY = texture2D( u_textureXY, coords );

        vec2 finalXYn = vec2(finalXY.y, finalXY.w);

        vec3 finalColorTri = vec3(finalColor.x, finalColor.y, finalColor.z);
        finalColorTri = secondaryColorForPrimary(finalColorTri);
        vec4 secColor = vec4(finalColorTri.x, finalColorTri.y, finalColorTri.z, finalColor.w);

        float dist = distance(v_texCoord,finalXYn) * (4.0-3.0*finalXY.x);

        if(dist>1.0) dist = 1.0;

        gradientColor = mix(finalColor, secColor, dist);
    }
    else
    {
        vec4 finalColor = texture2D( u_textureColors, coords );
        vec4 finalXY = texture2D( u_textureXY, coords );

        vec3 finalColorTri = vec3(finalColor.x, finalColor.y, finalColor.z);
        finalColorTri = secondaryColorForPrimary(finalColorTri);
        vec4 secColor = vec4(finalColorTri.x, finalColorTri.y, finalColorTri.z, finalColor.w);

        if(finalXY.w>1.0) finalXY.w = 1.0;

        float dist = distance(v_texCoord.y,finalXY.w)  * (4.0-3.0*finalXY.x);

        if(dist>1.0) dist = 1.0;

        gradientColor = mix(finalColor, secColor, dist);
    }

    if (brushType == 0.0)
    {
        gl_FragColor = gradientColor;
    }
    else if (brushType < 0.004)
    {
        vec4 finalXY = texture2D( u_textureXY, coords );
        vec2 finalXYn = vec2(finalXY.y, finalXY.w);
        vec2 texDistance = textureBrushCoordinate(v_texCoord, finalXYn, 256.0);
        vec4 textureColor = texture2D( u_texturePen, texDistance );
        gl_FragColor = mixWithTexture(gradientColor, textureColor);
    }
    else if (brushType < 0.008)
    {
        vec4 finalXY = texture2D( u_textureXY, coords );
        vec2 finalXYn = vec2(finalXY.y, finalXY.w);
        vec2 texDistance = textureBrushCoordinate(v_texCoord, finalXYn, 256.0);
        vec4 textureColor = texture2D( u_textureCrayon, texDistance );
        gl_FragColor = mixWithTexture(gradientColor, textureColor);
    }
    else if (brushType < 0.012)
    {
        vec4 finalXY = texture2D( u_textureXY, coords );
        vec2 finalXYn = vec2(finalXY.y, finalXY.w);
        vec2 texDistance = textureBrushCoordinate(v_texCoord, finalXYn, 256.0);
        vec4 textureColor = texture2D( u_textureOil, texDistance );
        gl_FragColor = mixWithTexture(gradientColor, textureColor);
    }
    else
    {
        gl_FragColor = gradientColor;
    }
}

vec4 generateFinalColor(vec4 color, float gradientType, float brushType, sampler2D textureXY) {
    vec2 coords = texture2D( u_textureGroups, v_texCoord ).st;
    vec4 fColor;
    vec4 gradientColor;

    if (gradientType == 0.0)
    {
        vec4 finalColor = color;
        gradientColor = finalColor;
    }
    else if (gradientType < 0.004)
    {
        vec4 finalColor = color;
        vec4 finalXY = texture2D( textureXY, coords );

        vec2 finalXYn = vec2(finalXY.y, finalXY.w);

        vec3 finalColorTri = vec3(finalColor.x, finalColor.y, finalColor.z);
        finalColorTri = secondaryColorForPrimary(finalColorTri);
        vec4 secColor = vec4(finalColorTri.x, finalColorTri.y, finalColorTri.z, finalColor.w);

        float dist = distance(v_texCoord,finalXYn) * (4.0-3.0*finalXY.x);

        if(dist>1.0) dist = 1.0;

        gradientColor = mix(finalColor, secColor, dist);
    }
    else
    {
        vec4 finalColor = color;
        vec4 finalXY = texture2D( textureXY, coords );

        vec3 finalColorTri = vec3(finalColor.x, finalColor.y, finalColor.z);
        finalColorTri = secondaryColorForPrimary(finalColorTri);
        vec4 secColor = vec4(finalColorTri.x, finalColorTri.y, finalColorTri.z, finalColor.w);

        if(finalXY.w>1.0) finalXY.w = 1.0;

        float dist = distance(v_texCoord.y,finalXY.w)  * (4.0-3.0*finalXY.x);

        if(dist>1.0) dist = 1.0;

        gradientColor = mix(finalColor, secColor, dist);
    }

    if (brushType == 0.0)
    {
        fColor = gradientColor;
    }
    else if (brushType > 0.003 && brushType < 0.004)
    {
        fColor = mixWithTexture2(u_texturePen, 256.0, coords, gradientColor, textureXY);
    }
    else if (brushType > 0.007 && brushType < 0.008)
    {
        fColor = mixWithTexture2(u_textureCrayon, 256.0, coords, gradientColor, textureXY);
    }
    else
    {
        fColor = mixWithTexture2(u_textureOil, 256.0, coords, gradientColor, textureXY);
    }

    return fColor;
 }


void animationPainting() {
    vec2 coords = texture2D( u_textureGroups, v_texCoord ).st;

    float radiustime = u_radius / 500.0;

    vec4 finalColor = texture2D( u_textureColors, coords );

    float finalColorGradientType = texture2D( u_textureEffects, coords).r;
    float finalColorBrushType = texture2D( u_textureEffects, coords).g;
    float previousColorGradientType = u_previousColorEffects.x;
    float previousColorBrushType = u_previousColorEffects.y;

    vec4 auxFinalColor;
    vec4 finalPreviousColor;

    auxFinalColor = generateFinalColor(finalColor, finalColorGradientType, finalColorBrushType, u_textureXY);
    finalPreviousColor = generateFinalColor(u_previousColor, previousColorGradientType, previousColorBrushType, u_previousColorTextureXY);

    // Comparação de float com um delta por motivos de problema de arredondamento dentro do shader
    if ( abs( coords.x - u_currentGroup.x ) < 1.0/256.0
        && abs( coords.y - u_currentGroup.y ) < 1.0/256.0)
    {
        vec2 posFromClick = v_texCoord - u_click;
        float dist = distance(v_texCoord,u_click);
        float waveDist = radiustime + sin(atan(posFromClick.y, posFromClick.x) * 20.0) * (radiustime / 50.0);

        // only old color
        if( dist > waveDist + 0.025)
        {
            gl_FragColor = finalPreviousColor;
        }
        // transition from old color to new color
        else if ( dist <= waveDist + 0.025 && dist > waveDist)
        {
            gl_FragColor = mix(auxFinalColor, finalPreviousColor, (dist - waveDist) / 0.025);
        }
        // only new color
        else
        {
            gl_FragColor = auxFinalColor;
         }
    }
    else
    {
        gl_FragColor = auxFinalColor;
    }
}

void main() {
    if ( u_mode == MODE_GROUPS )
    {
        groupPainting();
    }
    else if ( u_mode == MODE_PAINTING )
    {
        animationPainting();
    }
    else
    {
        regularTexture();
    }
}