(function() {
"use strict";
var root = "object" == typeof window ? window : {}, NODE_JS = !root.JS_SHA1_NO_NODE_JS && "object" == typeof process && process.versions && process.versions.node;
NODE_JS && (root = global);
var COMMON_JS = !root.JS_SHA1_NO_COMMON_JS && "object" == typeof module && module.exports, AMD = "function" == typeof define && define.amd, HEX_CHARS = "0123456789abcdef".split(""), EXTRA = [ -2147483648, 8388608, 32768, 128 ], SHIFT = [ 24, 16, 8, 0 ], OUTPUT_TYPES = [ "hex", "array", "digest", "arrayBuffer" ], blocks = [], createOutputMethod = function(t) {
return function(e) {
return new Sha1(!0).update(e)[t]();
};
}, createMethod = function() {
var t = createOutputMethod("hex");
NODE_JS && (t = nodeWrap(t));
t.create = function() {
return new Sha1();
};
t.update = function(e) {
return t.create().update(e);
};
for (var e = 0; e < OUTPUT_TYPES.length; ++e) {
var s = OUTPUT_TYPES[e];
t[s] = createOutputMethod(s);
}
return t;
}, nodeWrap = function(method) {
var crypto = eval("require('crypto')"), Buffer = eval("require('buffer').Buffer"), nodeMethod = function(t) {
if ("string" == typeof t) return crypto.createHash("sha1").update(t, "utf8").digest("hex");
if (t.constructor === ArrayBuffer) t = new Uint8Array(t); else if (void 0 === t.length) return method(t);
return crypto.createHash("sha1").update(new Buffer(t)).digest("hex");
};
return nodeMethod;
};
function Sha1(t) {
if (t) {
blocks[0] = blocks[16] = blocks[1] = blocks[2] = blocks[3] = blocks[4] = blocks[5] = blocks[6] = blocks[7] = blocks[8] = blocks[9] = blocks[10] = blocks[11] = blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
this.blocks = blocks;
} else this.blocks = [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ];
this.h0 = 1732584193;
this.h1 = 4023233417;
this.h2 = 2562383102;
this.h3 = 271733878;
this.h4 = 3285377520;
this.block = this.start = this.bytes = this.hBytes = 0;
this.finalized = this.hashed = !1;
this.first = !0;
}
Sha1.prototype.update = function(t) {
if (!this.finalized) {
var e = "string" != typeof t;
e && t.constructor === root.ArrayBuffer && (t = new Uint8Array(t));
for (var s, h, i = 0, r = t.length || 0, o = this.blocks; i < r; ) {
if (this.hashed) {
this.hashed = !1;
o[0] = this.block;
o[16] = o[1] = o[2] = o[3] = o[4] = o[5] = o[6] = o[7] = o[8] = o[9] = o[10] = o[11] = o[12] = o[13] = o[14] = o[15] = 0;
}
if (e) for (h = this.start; i < r && h < 64; ++i) o[h >> 2] |= t[i] << SHIFT[3 & h++]; else for (h = this.start; i < r && h < 64; ++i) if ((s = t.charCodeAt(i)) < 128) o[h >> 2] |= s << SHIFT[3 & h++]; else if (s < 2048) {
o[h >> 2] |= (192 | s >> 6) << SHIFT[3 & h++];
o[h >> 2] |= (128 | 63 & s) << SHIFT[3 & h++];
} else if (s < 55296 || s >= 57344) {
o[h >> 2] |= (224 | s >> 12) << SHIFT[3 & h++];
o[h >> 2] |= (128 | s >> 6 & 63) << SHIFT[3 & h++];
o[h >> 2] |= (128 | 63 & s) << SHIFT[3 & h++];
} else {
s = 65536 + ((1023 & s) << 10 | 1023 & t.charCodeAt(++i));
o[h >> 2] |= (240 | s >> 18) << SHIFT[3 & h++];
o[h >> 2] |= (128 | s >> 12 & 63) << SHIFT[3 & h++];
o[h >> 2] |= (128 | s >> 6 & 63) << SHIFT[3 & h++];
o[h >> 2] |= (128 | 63 & s) << SHIFT[3 & h++];
}
this.lastByteIndex = h;
this.bytes += h - this.start;
if (h >= 64) {
this.block = o[16];
this.start = h - 64;
this.hash();
this.hashed = !0;
} else this.start = h;
}
if (this.bytes > 4294967295) {
this.hBytes += this.bytes / 4294967296 << 0;
this.bytes = this.bytes % 4294967296;
}
return this;
}
};
Sha1.prototype.finalize = function() {
if (!this.finalized) {
this.finalized = !0;
var t = this.blocks, e = this.lastByteIndex;
t[16] = this.block;
t[e >> 2] |= EXTRA[3 & e];
this.block = t[16];
if (e >= 56) {
this.hashed || this.hash();
t[0] = this.block;
t[16] = t[1] = t[2] = t[3] = t[4] = t[5] = t[6] = t[7] = t[8] = t[9] = t[10] = t[11] = t[12] = t[13] = t[14] = t[15] = 0;
}
t[14] = this.hBytes << 3 | this.bytes >>> 29;
t[15] = this.bytes << 3;
this.hash();
}
};
Sha1.prototype.hash = function() {
var t, e, s = this.h0, h = this.h1, i = this.h2, r = this.h3, o = this.h4, H = this.blocks;
for (t = 16; t < 80; ++t) {
e = H[t - 3] ^ H[t - 8] ^ H[t - 14] ^ H[t - 16];
H[t] = e << 1 | e >>> 31;
}
for (t = 0; t < 20; t += 5) {
s = (e = (h = (e = (i = (e = (r = (e = (o = (e = s << 5 | s >>> 27) + (h & i | ~h & r) + o + 1518500249 + H[t] << 0) << 5 | o >>> 27) + (s & (h = h << 30 | h >>> 2) | ~s & i) + r + 1518500249 + H[t + 1] << 0) << 5 | r >>> 27) + (o & (s = s << 30 | s >>> 2) | ~o & h) + i + 1518500249 + H[t + 2] << 0) << 5 | i >>> 27) + (r & (o = o << 30 | o >>> 2) | ~r & s) + h + 1518500249 + H[t + 3] << 0) << 5 | h >>> 27) + (i & (r = r << 30 | r >>> 2) | ~i & o) + s + 1518500249 + H[t + 4] << 0;
i = i << 30 | i >>> 2;
}
for (;t < 40; t += 5) {
s = (e = (h = (e = (i = (e = (r = (e = (o = (e = s << 5 | s >>> 27) + (h ^ i ^ r) + o + 1859775393 + H[t] << 0) << 5 | o >>> 27) + (s ^ (h = h << 30 | h >>> 2) ^ i) + r + 1859775393 + H[t + 1] << 0) << 5 | r >>> 27) + (o ^ (s = s << 30 | s >>> 2) ^ h) + i + 1859775393 + H[t + 2] << 0) << 5 | i >>> 27) + (r ^ (o = o << 30 | o >>> 2) ^ s) + h + 1859775393 + H[t + 3] << 0) << 5 | h >>> 27) + (i ^ (r = r << 30 | r >>> 2) ^ o) + s + 1859775393 + H[t + 4] << 0;
i = i << 30 | i >>> 2;
}
for (;t < 60; t += 5) {
s = (e = (h = (e = (i = (e = (r = (e = (o = (e = s << 5 | s >>> 27) + (h & i | h & r | i & r) + o - 1894007588 + H[t] << 0) << 5 | o >>> 27) + (s & (h = h << 30 | h >>> 2) | s & i | h & i) + r - 1894007588 + H[t + 1] << 0) << 5 | r >>> 27) + (o & (s = s << 30 | s >>> 2) | o & h | s & h) + i - 1894007588 + H[t + 2] << 0) << 5 | i >>> 27) + (r & (o = o << 30 | o >>> 2) | r & s | o & s) + h - 1894007588 + H[t + 3] << 0) << 5 | h >>> 27) + (i & (r = r << 30 | r >>> 2) | i & o | r & o) + s - 1894007588 + H[t + 4] << 0;
i = i << 30 | i >>> 2;
}
for (;t < 80; t += 5) {
s = (e = (h = (e = (i = (e = (r = (e = (o = (e = s << 5 | s >>> 27) + (h ^ i ^ r) + o - 899497514 + H[t] << 0) << 5 | o >>> 27) + (s ^ (h = h << 30 | h >>> 2) ^ i) + r - 899497514 + H[t + 1] << 0) << 5 | r >>> 27) + (o ^ (s = s << 30 | s >>> 2) ^ h) + i - 899497514 + H[t + 2] << 0) << 5 | i >>> 27) + (r ^ (o = o << 30 | o >>> 2) ^ s) + h - 899497514 + H[t + 3] << 0) << 5 | h >>> 27) + (i ^ (r = r << 30 | r >>> 2) ^ o) + s - 899497514 + H[t + 4] << 0;
i = i << 30 | i >>> 2;
}
this.h0 = this.h0 + s << 0;
this.h1 = this.h1 + h << 0;
this.h2 = this.h2 + i << 0;
this.h3 = this.h3 + r << 0;
this.h4 = this.h4 + o << 0;
};
Sha1.prototype.hex = function() {
this.finalize();
var t = this.h0, e = this.h1, s = this.h2, h = this.h3, i = this.h4;
return HEX_CHARS[t >> 28 & 15] + HEX_CHARS[t >> 24 & 15] + HEX_CHARS[t >> 20 & 15] + HEX_CHARS[t >> 16 & 15] + HEX_CHARS[t >> 12 & 15] + HEX_CHARS[t >> 8 & 15] + HEX_CHARS[t >> 4 & 15] + HEX_CHARS[15 & t] + HEX_CHARS[e >> 28 & 15] + HEX_CHARS[e >> 24 & 15] + HEX_CHARS[e >> 20 & 15] + HEX_CHARS[e >> 16 & 15] + HEX_CHARS[e >> 12 & 15] + HEX_CHARS[e >> 8 & 15] + HEX_CHARS[e >> 4 & 15] + HEX_CHARS[15 & e] + HEX_CHARS[s >> 28 & 15] + HEX_CHARS[s >> 24 & 15] + HEX_CHARS[s >> 20 & 15] + HEX_CHARS[s >> 16 & 15] + HEX_CHARS[s >> 12 & 15] + HEX_CHARS[s >> 8 & 15] + HEX_CHARS[s >> 4 & 15] + HEX_CHARS[15 & s] + HEX_CHARS[h >> 28 & 15] + HEX_CHARS[h >> 24 & 15] + HEX_CHARS[h >> 20 & 15] + HEX_CHARS[h >> 16 & 15] + HEX_CHARS[h >> 12 & 15] + HEX_CHARS[h >> 8 & 15] + HEX_CHARS[h >> 4 & 15] + HEX_CHARS[15 & h] + HEX_CHARS[i >> 28 & 15] + HEX_CHARS[i >> 24 & 15] + HEX_CHARS[i >> 20 & 15] + HEX_CHARS[i >> 16 & 15] + HEX_CHARS[i >> 12 & 15] + HEX_CHARS[i >> 8 & 15] + HEX_CHARS[i >> 4 & 15] + HEX_CHARS[15 & i];
};
Sha1.prototype.toString = Sha1.prototype.hex;
Sha1.prototype.digest = function() {
this.finalize();
var t = this.h0, e = this.h1, s = this.h2, h = this.h3, i = this.h4;
return [ t >> 24 & 255, t >> 16 & 255, t >> 8 & 255, 255 & t, e >> 24 & 255, e >> 16 & 255, e >> 8 & 255, 255 & e, s >> 24 & 255, s >> 16 & 255, s >> 8 & 255, 255 & s, h >> 24 & 255, h >> 16 & 255, h >> 8 & 255, 255 & h, i >> 24 & 255, i >> 16 & 255, i >> 8 & 255, 255 & i ];
};
Sha1.prototype.array = Sha1.prototype.digest;
Sha1.prototype.arrayBuffer = function() {
this.finalize();
var t = new ArrayBuffer(20), e = new DataView(t);
e.setUint32(0, this.h0);
e.setUint32(4, this.h1);
e.setUint32(8, this.h2);
e.setUint32(12, this.h3);
e.setUint32(16, this.h4);
return t;
};
var exports = createMethod();
if (COMMON_JS) module.exports = exports; else {
root.sha1 = exports;
AMD && define(function() {
return exports;
});
}
})();