﻿/**
 * Created by GamerSky-1014 on 2015/12/15.
 */
/*------------------------------------------------
 @自身实现
 ------------------------------------------------*/
var _glDevicePixelRatio = window.devicePixeRatio;
_glDevicePixelRatio = 1.5;
var _glInstallingBackgroundCircleCanvasWidth = 0.0;
var _glInstallingBackgroundCircleCanvasHeight = 0.0;
function glSendMessageToApp(msg)
{
    var url = "app://gamerLauncher.gamersky.com?" + msg;
    location.href = url;
}
var _glAnimationFrameTimerElapse = 1000.0/100.0;
var _glAnimationFrameTimerId = null;
function glNextAnimation()
{
    glStopAnimation();
    _glAnimationFrameTimerId
        = setTimeout(
        function ()
        {
            glDidAnimationFrame();
            glNextAnimation();
        },
        _glAnimationFrameTimerElapse);
}
function glStartAnimation()
{
    glNextAnimation();
}
function glStopAnimation()
{
    if (_glAnimationFrameTimerId != null)
    {
        clearTimeout(_glAnimationFrameTimerId);
        _glAnimationFrameTimerId = null;
    }
}
var _glInstallingStateCaption = null;
function glSetInstallingStateCaption(caption)
{
    if (_glInstallingStateCaption==null)
    {
        _glInstallingStateCaption = document.getElementById("installingStateCaption");
    }
    if (_glInstallingStateCaption!=null)
    {
        _glInstallingStateCaption.innerHTML = caption;
    }
}
function glUpdateRelatedNews(relatedContentElements)
{
    if (relatedContentElements == null
        || relatedContentElements.length < 1)
    {
        return;
    }

    relatedContentElements = relatedContentElements["relatedContentElements"];
    if (relatedContentElements == null
        || relatedContentElements.length < 1)
    {
        return;
    }

    try
    {
        var relatedNewsHTML = "";
        var relatedContentElementsCount = relatedContentElements.length;
        for (var relatedContentElementIndex = 0;
             relatedContentElementIndex < relatedContentElementsCount;
             relatedContentElementIndex++)
        {
            var relatedContentElement = relatedContentElements[relatedContentElementIndex];

            relatedNewsHTML
                += "<a href=\"http://wap.gamersky.com/news/Content-" + relatedContentElement.id
                   + ".html\" target=\"_blank\"><li>" + relatedContentElement.title + "</li></a>";
        }
        if (relatedNewsHTML != null
            && relatedNewsHTML.length > 0)
        {
            $("#relatedNews").html(relatedNewsHTML);
            $("#relatedNewsContainer").show();
        }
    }
    catch (e)
    {
        document.write(e);
    }
}
function glUpdateRelatedGames(relatedContentElements)
{
    if (relatedContentElements == null
        || relatedContentElements.length < 1)
    {
        return;
    }

    relatedContentElements = relatedContentElements["relatedContentElements"];
    if (relatedContentElements == null
        || relatedContentElements.length < 1)
    {
        return;
    }

    try
    {
        var gameRowsCount = 2;
        var gameCellsCount = 4;
        if ($(window).width<=380)
        {
            gameCellsCount = 3;
        }

        var relatedContentElementsCount = relatedContentElements.length;

        var relatedGamesHTML = "";
        var gameIndex = 0;
        for (var gameRowIndex=0;
             gameRowIndex<gameRowsCount;
             gameRowIndex++)
        {
            var gameRowHTML = "";
            for (var gameCellIndex=0;
                 gameCellIndex<gameCellsCount;
                 gameCellIndex++)
            {
                if (gameIndex>=relatedContentElementsCount)
                {
                    gameRowHTML += "<td></td>";
                }
                else
                {
                    var relatedGame = relatedContentElements[gameIndex];

                    gameRowHTML
                        += "<td align=\"center\" valign=\"center\"><a href=\"http://shouyou.gamersky.com/ku/"
                        + relatedGame.id + ".shtml\" target=\"_blank\"><img src=\""
                        + relatedGame.thumbnailURL + "\">" + relatedGame.title + "</a></td>";
                }

                gameIndex ++;
            }
            if (gameRowHTML!=null
                && gameRowHTML.length>0)
            {
                relatedGamesHTML += "<tr class=\"RelatedGamesRow\">" + gameRowHTML + "</tr>";
            }
        }

        if (relatedGamesHTML != null
            && relatedGamesHTML.length > 0)
        {
            $("#relatedGames").html(relatedGamesHTML);
            $("#relatedGamesContainer").show();
        }
    }
    catch (e)
    {
    }
}
function glShareCurrentGameTo(shareTo)
{
    glHideShareView();
    glSendMessageToApp("share:{\"shareTo\":\"" + shareTo + "\"}");
}
function glShowShareView()
{
    return;

    var shareContentContainer = $("#shareContentContainer");
    if (shareContentContainer.length < 1)
    {
        return;
    }

    var shareButtonsContainer = $("#shareButtonsContainer");
    if (shareButtonsContainer.length < 1)
    {
        return;
    }

    //shareContentContainer.opacity = 0.0;
    {
        var shareButtonsContainerTop
            = ($(window).height() - 400) / 2.0;
        shareButtonsContainer.css("margin-top", shareButtonsContainerTop + "px");
    }
    shareContentContainer.show();
    /*
     shareContentContainer.opacity = 1.0;

     shareContentContainer.animate(
     {opacity: 1.0},
     "fast",
     "swing");
     */
}
function glHideShareView()
{
    var shareContentContainer = $("#shareContentContainer");
    if (shareContentContainer.length < 1)
    {
        return;
    }

    /*
     shareContentContainer.animate(
     {opacity: 0.0},
     "fast",
     "swing",
     function ()
     {
     shareContentContainer.hide();
     });*/
    shareContentContainer.hide();
}
function glPrepareInstallSteps()
{
    $(".InstallingStateOperateRow").hide();
}
function glInstallStep_GetGameInfo()
{
    glPrepareInstallSteps();
    glSetInstallingStateCaption("获取游戏");
    $("#installingStateContent_GetGameInfo").show();

    glSendMessageToApp("getGameInfo:{}");
}
var _glCurrentGameInfo = null;
function glUpdateGameInfo(gameInfo)
{
    try
    {
        if (gameInfo == null)
        {
            gameInfo = new Object();
            {
                gameInfo.name = "";
                gameInfo.alias = "";
                gameInfo.developer = "";
                gameInfo.type = "";
                gameInfo.language = "";
                gameInfo.tags = new Array();
                gameInfo.version = "";
                gameInfo.adId = "";

                // 内容相关
                gameInfo.iconURL = "";
                gameInfo.previewImageURLs = new Array();
                gameInfo.detail = "";
                gameInfo.originURL = "";
                gameInfo.videoContent = "";

                // 评分相关
                gameInfo.gsScore = 0.0;
                gameInfo.gsHotIndex = 0.0;
                gameInfo.gsHotIndexLikeCount = 0.0;
                gameInfo.gsHotIndexUnlikeCount = 0.0;

                // 安装环境相关
                gameInfo.systemRequired = "";

                // 文件操作相关
                gameInfo.bundleId = "";
                gameInfo.fileURL = "";
                gameInfo.fileSize = "";
                gameInfo.dataPackageURL = "";
            }
        }

        if (gameInfo.previewImageURLs!=null
        && gameInfo.previewImageURLs.length>0)
        {
            /*
            $("#installingStateContainerBackground")
                .css("background-image", "url(\"" + gameInfo.previewImageURLs[0] + "\")");
               */
        }
        $("#installingStateGameIcon").attr("src", gameInfo.iconURL);
        var installingStateGameName = $("#installingStateGameName");
        {
            if (gameInfo.name!=null
			&& gameInfo.name.length>8)
            {
                installingStateGameName.css("font-size","12px");
            }
        }
        installingStateGameName.text(gameInfo.name);

        $("#installingStateGameVersion").text("游戏版本:" + gameInfo.version);
        //$("#installingStateGameUpdateTime").text("更新日期: -");
        $("#installingStateGameFileSize").text("游戏大小:" + gameInfo.fileSize);

		var systemRequired = gameInfo.systemRequired;
        if (systemRequired!=null)
		{
			var systemName = "android";
			var systemNameBeginCharIndex
			= systemRequired.toLowerCase().indexOf(systemName);
			if (systemNameBeginCharIndex>-1)
			{
				systemRequired
					= systemRequired.substr(
					systemNameBeginCharIndex
					+ systemName.length).trim();
			}
		}
        $("#installingConditionSystemVersion").text("需要系统 " + systemRequired);
        $("#installingConditionDiskSpace").text("需要空间 " + gameInfo.fileSize);
        _glCurrentGameInfo = gameInfo;

        glInstallStep_CheckInstallEnvironmentWithApp();
    }
    catch (e)
    {
        document.write(e);
    }
}
function glInstallStep_CheckInstallEnvironmentWithApp()
{
    glPrepareInstallSteps();
    glSetInstallingStateCaption("检查环境");
    $("#installingStateContent_CheckInstallEnvironmentWithApp").show();

    glSendMessageToApp("checkInstallEnvironment:{}");
}
function glUpdateCheckInstallEnvironmentResult(checkResult)
{
    if (checkResult == null)
    {
        return;
    }

    // checkResult = {isValidSystem:"yes"/"no",isDiskSpaceEnough:"yes"/"no"}

    var isValidToInstall = true;
    var installingConditionSystemVersion
        = document.getElementById("installingConditionSystemVersionContainer");
    if (checkResult.isValidSystem == "yes")
    {
        installingConditionSystemVersion.className = "Valid";
    }
    else
    {
        isValidToInstall = false;
        installingConditionSystemVersion.className = "Invalid";
    }

    var installingConditionDiskSpaceContainer
        = document.getElementById("installingConditionDiskSpaceContainer");
    if (checkResult.isDiskSpaceEnough == "yes")
    {
        installingConditionDiskSpaceContainer.className = "Valid";
    }
    else if (checkResult.isDiskSpaceEnough == "warning")
    {
        installingConditionDiskSpaceContainer.className = "Warning";
    }
    else
    {
        isValidToInstall = false;
        installingConditionDiskSpaceContainer.className = "Invalid";

        var freeSpaceSizeNeeded
            = checkResult.freeSpaceSizeNeeded;
        var freeSpaceSizeExisted
            = checkResult.freeSpaceSizeExisted;
        if (typeof(freeSpaceSizeNeeded) != "undefined"
            && freeSpaceSizeNeeded!=null
            && typeof(freeSpaceSizeExisted) != "undefined"
            && freeSpaceSizeExisted!=null)
        {

            $("#installingConditionDiskSpace").text(
                "需要 "
                  + freeSpaceSizeNeeded
                  + "/"
                  + freeSpaceSizeExisted);
        }
    }

    if (isValidToInstall)
    {
        if (checkResult.isDiskSpaceEnough=="warning")
        {
            glInstallStep_FreeBytesCountWarning(
                checkResult.freeSpaceSizeNeeded,
                checkResult.freeSpaceSizeExisted);
        }
        else if (_glCurrentGameInfo != null
            && _glCurrentGameInfo.needGooglePlayToPlay == "yes")
        {
            glInstallStep_GameNeedGooglePlayToPlay();
        }
        else if (_glCurrentGameInfo != null
                 && _glCurrentGameInfo.needVPNToPlay == "yes")
        {
            glInstallStep_GameNeedVPNToPlay();
        }
        else
        {
            setTimeout(glInstallStep_InstallGame, 2000);
        }
    }
    else
    {
        glStopAnimation();
        glUpdateBackgroundCirle(0, 1.0);
    }
}
function glInstallStep_GameNeedGooglePlayToPlay()
{
    glPrepareInstallSteps();
    glSetInstallingStateCaption("<img src=\"image/icon_Exclamation_23x21@2x.png\" width=\"23px\" height=\"21px\" style=\"margin-right: 4px;\">需要GooglePlay");
    $("#installingStateContent_GameNeedGooglePlayToPlay").show();
}
function glInstallStep_GameNeedGooglePlayToPlay_SureToInstall()
{
	if (_glCurrentGameInfo!=null
	&& _glCurrentGameInfo.needVPNToPlay=="yes")
	{
		glInstallStep_GameNeedVPNToPlay();
	}
	else
	{
		glInstallStep_InstallGame();
	}
}
function glInstallStep_GameNeedVPNToPlay()
{
    glPrepareInstallSteps();
    glSetInstallingStateCaption("<img src=\"image/icon_Exclamation_23x21@2x.png\" width=\"23px\" height=\"21px\" style=\"margin-right: 4px;\">游戏需要VPN");
    $("#installingStateContent_GameNeedVPNToPlay").show();
}
function glInstallStep_GameNeedVPNToPlay_SureToInstall()
{
    glInstallStep_InstallGame();
}
function glInstallStep_FreeBytesCountWarning(
    freeSpaceSizeNeeded,
    freeSpaceSizeExisted)
{
    glPrepareInstallSteps();

    var installingStateCaption
    = "<img src=\"image/icon_Exclamation_23x21@2x.png\" width=\"23px\" height=\"21px\" style=\"margin-right: 4px; vertical-align: middle;\">"
      + "<span style=\"font-size:16px;vertical-align: middle;\">剩余空间较小，安装可能失败</span>";
    if (typeof(freeSpaceSizeNeeded) != "undefined"
        && freeSpaceSizeNeeded!=null
        && typeof(freeSpaceSizeExisted) != "undefined"
        && freeSpaceSizeExisted!=null)
    {
        installingStateCaption
            = installingStateCaption
              +
              "<div align=\"center\" valign=\"middle\" style=\"line-height:30px; font-size:16px; vertical-align:middle;\">解压后需要"
              + freeSpaceSizeNeeded
              + ",当前剩余"
              + freeSpaceSizeExisted
              + "</div>";
    }
    glSetInstallingStateCaption(installingStateCaption);
    $("#installingStateContent_FreeBytesCountWarning").show();
}
function glInstallStep_FreeBytesCountWarning_SureToInstall()
{
    if (_glCurrentGameInfo != null
        && _glCurrentGameInfo.needGooglePlayToPlay == "yes")
    {
        glInstallStep_GameNeedGooglePlayToPlay();
    }
    else if (_glCurrentGameInfo != null
             && _glCurrentGameInfo.needVPNToPlay == "yes")
    {
        glInstallStep_GameNeedVPNToPlay();
    }
    else
    {
        setTimeout(glInstallStep_InstallGame, 2000);
    }
}
function glInstallStep_InstallGame()
{
    glPrepareInstallSteps();
    glSetInstallStateButtonInNavigationBarCaption("正在安装");
    glSetInstallingStateCaption("安装文件");
    $("#installingStateContent_Installing").show();

    glUpdateBackgroundCirleForProgress(0.0);

    glSendMessageToApp("downloadGameFiles:{}");
}
function glInstallStep_PauseInstallGame()
{
    glPrepareInstallSteps();
    glSetInstallStateButtonInNavigationBarCaption("已暂停");
    glSetInstallingStateCaption("继续安装");
    $("#installingStateContent_PauseInstall").show();
}
// state 可选值为: download, install, pause, complete, failed.
function glUpdateGameInstallState(state, caption, progress, speed)
{
    try
    {
        switch (state)
        {
            case "downloading":
            case "uncompressing":
			{
				glUpdateBackgroundCirleForProgress(progress);
                if (speed!=null
                && typeof(speed) != "undefined")
                {
                    try
                    {
                        if (speed.length<=0)
                        {
                            speed = "";
                        }
                        $("#installingStateOperateSpeedCaption").text(speed);
                    }
                    catch (exception)
                    {}
                }
			}break;
            case "installing":
            {
				glInstallStep_ReInstall();
            }break;
            case "pausing":
            {
                glInstallStep_PauseInstallGame();
            }break;
            case "installCompleted":
            {
                glInstallStep_InstallCompleted();
            }
                break;
            case "installFailed":
            {
                if (caption == "下载游戏失败"
                || caption == "下载数据失败")
                {
                    caption
                    = "<span style=\"line-height: 10px;font-size: 14px;\">下载失败，服务器忙<br>安装器支持续传，请稍后再试</span>";
                }
                glInstallStep_InstallFailed(caption);
            }
                break;
        }
    }
    catch (e)
    {
        document.write(e);
    }
}
function glInstallStep_ReInstall()
{
    glPrepareInstallSteps();
	glSetInstallStateButtonInNavigationBarCaption("安装游戏");
    glSetInstallingStateCaption("安装游戏");
    $("#installingStateContent_ReInstall").show();
}
function glInstallStep_InstallFailed(caption)
{
    glPrepareInstallSteps();
	glSetInstallStateButtonInNavigationBarCaption("安装失败");
    if (caption==null
    || typeof (caption) == "undefined")
    {
        caption = "安装失败";
    }
    glSetInstallingStateCaption(caption);
    $("#installingStateContent_InstallFailed").show();
}
function glInstallStep_InstallCompleted()
{
    glPrepareInstallSteps();
	glSetInstallStateButtonInNavigationBarCaption("安装成功");
    glSetInstallingStateCaption("安装成功");
    $("#installingStateContent_InstallCompleted").show();
}
// 进度圈的画布
var _glInstallingBackgroundCircleCanvas = null;
function glGetInstallingProgressCircleCanvas()
{
    if (_glInstallingBackgroundCircleCanvas==null)
    {
        _glInstallingBackgroundCircleCanvas = document.getElementById("installingBackgroundCircle");
    }
    return _glInstallingBackgroundCircleCanvas;
}
var _glInstallStateButtonInNavigationBar = null;
function glGetInstallStateButtonInNavigationBar()
{
    if (_glInstallStateButtonInNavigationBar==null)
    {
        _glInstallStateButtonInNavigationBar = document.getElementById("installStateButtonInNavigationBar");
    }
    return _glInstallStateButtonInNavigationBar;
}
function glSetInstallStateButtonInNavigationBarCaption(caption, progress)
{
	var installStateButtonInNavigationBar
		= glGetInstallStateButtonInNavigationBar()
	if (installStateButtonInNavigationBar == null)
	{
		return;
	}

	if (progress != null
		&& typeof (progress) != "undefined")
	{
		var progressCaption = (100.0 * parseFloat(progress)).toString();
		progressCaption = progressCaption.substring(0, progressCaption.indexOf(".") + 2);
		caption += " " + progressCaption + "%";
	}

	installStateButtonInNavigationBar.innerText = caption;
}
// 进度圈相关动画
var _glInstallingBackgroundCircleLineWidth = 12.0*_glDevicePixelRatio;//17.0;
var _glInstallingBackgroundCircleShadowStyle = "outter";// "outter", "mid", "inner"
var _glInstallingBackgroundCircleShadowSize = 8.0*_glDevicePixelRatio;

function glGetBackgroundProgressCircleRadius()
{
    var radius = _glInstallingBackgroundCircleCanvasWidth;
    if (radius > _glInstallingBackgroundCircleCanvasHeight)
    {
        radius = _glInstallingBackgroundCircleCanvasHeight;
    }

    radius = radius / 2.0 - _glInstallingBackgroundCircleShadowSize - _glInstallingBackgroundCircleShadowSize;
    if (radius<0.0)
    {
        radius = 0.0;
    }

    return radius;
}
// 更新进度圈的 背景 外观
var _kGLBackgroundCircleBackground_Color = "rgba(255, 255, 255, 0.8)";
var _kGLBackgroundCircleBackground_StandardAlphaAccelerationForward = 1.0;
var _kGLBackgroundCircleBackground_StandardAlphaAccelerationBackward = -1 * _kGLBackgroundCircleBackground_StandardAlphaAccelerationForward;
var _kGLBackgroundCircleBackground_CurrentAlpha = 0.0;
var _kGLBackgroundCircleBackground_LastAlpha = 0.0;
var _kGLBackgroundCircleBackground_LastSecondsPoint = 0.0;
var _kGLBackgroundCircleBackground_Speed = 0.0;
var _kGLBackgroundCircleBackground_Acceleration = _kGLBackgroundCircleBackground_StandardAlphaAccelerationForward;
function glUpdateBackgroundCirle(beginPointProgress,endPointProgress)
{
	////////////////////////////////////////////////
	// 绘制参数
	////////////////////////////////////////////////
    //var shadowLineWidth = _glInstallingBackgroundCircleShadowLineWidth;
    var lineWidth = _glInstallingBackgroundCircleLineWidth;
    var shadowStyle = _glInstallingBackgroundCircleShadowStyle;//"outter";// "outter", "mid", "inner"
	var shadowSize = _glInstallingBackgroundCircleShadowSize;
	var progressCircleCenterX = _glInstallingBackgroundCircleCanvasWidth / 2.0;
	var progressCircleCenterY = _glInstallingBackgroundCircleCanvasHeight / 2.0;
	var progressCircleRadius = glGetBackgroundProgressCircleRadius();

	////////////////////////////////////////////////
	// 获取绘制上下文
	////////////////////////////////////////////////
	var canvas = glGetInstallingProgressCircleCanvas();
	if (canvas != null)
	{
		var graphics = canvas.getContext("2d");
		if (graphics != null)
		{
			graphics.clearRect(
				0,
				0,
				canvas.width,
				canvas.height);
			/*
			 graphics.roundedRect
			 = function (x, y, width, height, cornerRadius)
			 {
			 if (width > 0)
			 {
			 this.moveTo(x + cornerRadius, y);
			 }
			 else
			 {
			 this.moveTo(x - cornerRadius, y);
			 }
			 this.arcTo(x + width, y, x + width, y + height, cornerRadius);
			 this.arcTo(x + width, y + height, x, y + height, cornerRadius);
			 this.arcTo(x, y + height, x, y, cornerRadius);
			 if (width > 0)
			 {
			 this.arcTo(x, y, x + cornerRadius, y, cornerRadius);
			 }
			 else
			 {
			 this.arcTo(x, y, x - cornerRadius, y, cornerRadius);
			 }
			 }
			 */


            /*
			////////////////////////////////////////////////
			// 绘制背景
			////////////////////////////////////////////////

			graphics.beginPath();
			{
				graphics.arc(
					progressCircleCenterX,
					progressCircleCenterY,
					progressCircleRadius,
					0,
					2 * Math.PI);
			}
			graphics.fillStyle = _kGLBackgroundCircleBackground_Color;
			graphics.globalAlpha = _kGLBackgroundCircleBackground_CurrentAlpha;
			graphics.fill();
			graphics.globalAlpha = 1.0;
			*/

			////////////////////////////////////////////////
			// 绘制进度线
			////////////////////////////////////////////////

			graphics.lineCap = "butt";

			// 阴影线
            var shadowLineCircleRadius = progressCircleRadius;
            var shadowLineWidth = 0.0;
            switch (shadowStyle)
            {
                case "outter":
                {
                    shadowLineCircleRadius = progressCircleRadius + lineWidth/2.0 + shadowSize/2.0;
                    shadowLineWidth = shadowSize;
                }break;
                case "mid":
                {
                    shadowLineCircleRadius = progressCircleRadius;
                    shadowLineWidth = lineWidth+shadowSize*2.0;
                }break;
                case "inner":
                {

                }break;
            }

            // 绘制阴影线高光
            {
                graphics.beginPath();
                {
                    graphics.arc(
                        progressCircleCenterX,
                        progressCircleCenterY,
                        shadowLineCircleRadius + 2.0,
                        0,
                        2 * Math.PI);
                }
                graphics.closePath();
                graphics.lineWidth = shadowLineWidth;
                graphics.strokeStyle = "#FFFFFF";
                graphics.stroke();
            }

            // 绘制阴影线本体
            {
                graphics.beginPath();
                {
                    graphics.arc(
                        progressCircleCenterX,
                        progressCircleCenterY,
                        shadowLineCircleRadius,
                        0,
                        2 * Math.PI);
                }
                graphics.closePath();
                graphics.lineWidth = shadowLineWidth;
                graphics.strokeStyle = _kGLBackgroundCirle_ShadowLineColor;
                graphics.stroke();
            }

			// 背景线
			graphics.beginPath();
			{
				graphics.arc(
					progressCircleCenterX,
					progressCircleCenterY,
					progressCircleRadius,
					0,
					2 * Math.PI);
			}
			graphics.closePath();
			graphics.lineWidth = lineWidth;
			graphics.strokeStyle = _kGLBackgroundCirle_BackgroundLineColor;
			graphics.stroke();

			// 进度线
            {
                var beginAngle = 360.0 * beginPointProgress - 90.0;
                beginAngle = parseInt(beginAngle) % 360;
                if (beginAngle < 0.0)
                {
                    beginAngle += 360.0;
                }
                var endAngle = 360.0 * endPointProgress - 90.0;
                endAngle = parseInt(endAngle) % 360;
                if (endAngle < 0.0)
                {
                    endAngle += 360.0;
                }

                if (endAngle == beginAngle
                    && endAngle != 0.0)
                {
                    endAngle = beginAngle + 360.0;
                }

                var beginRadian
                    = beginAngle * Math.PI / 180.0;
                var endRadian
                    = endAngle * Math.PI / 180.0;

                graphics.beginPath();
                {
                    graphics.arc(
                        progressCircleCenterX,
                        progressCircleCenterY,
                        progressCircleRadius,
                        beginRadian,
                        endRadian);
                }
                //graphics.closePath();
                graphics.lineWidth = lineWidth;
                graphics.strokeStyle = _kGLBackgroundCirle_LineColor;
                graphics.stroke();

                // 绘制 起始 端点圆头
                var beginPointX
                    = progressCircleCenterX
                    + progressCircleRadius * Math.cos(beginRadian);
                var beginPointY
                    = progressCircleCenterY
                      + progressCircleRadius * Math.sin(beginRadian);
                graphics.beginPath();
                {
                    graphics.arc(
                        beginPointX,
                        beginPointY,
                        lineWidth /2.0,
                        0.0,
                        2*Math.PI,
                        true);

                }
                graphics.closePath();
                graphics.fillStyle = _kGLProgressCirle_LinePointColor;
                graphics.fill();

                // 绘制 结尾 端点圆头
                var endPointX
                    = progressCircleCenterX
                      + progressCircleRadius * Math.cos(endRadian);
                var endPointY
                    = progressCircleCenterY
                      + progressCircleRadius * Math.sin(endRadian);
                graphics.beginPath();
                {
                    graphics.arc(
                        endPointX,
                        endPointY,
                        lineWidth /2.0,
                        0.0,
                        2*Math.PI,
                        true);

                }
                graphics.closePath();
                graphics.fillStyle = _kGLProgressCirle_LinePointColor;
                graphics.fill();
            }
		}
	}
}

// 更新进度圈的 圈线 外观, 进度
/* @颜色, 进度线条颜色 */
var _kGLBackgroundCirle_ShadowLineColor = "#dddddd";//"#eee";;//"#fff";
var _kGLBackgroundCirle_BackgroundLineColor = "#1eaf60";//"#51c422";
var _kGLBackgroundCirle_LineColor = "#128450";//"#009944";
var _kGLProgressCirle_LinePointColor = "#00884d";//"#00884d";
var _kGLProgressCirle_StandardEndPointAccelerationForward = 0.01;
var _kGLProgressCirle_StandardEndPointAccelerationBackward = -1 * _kGLProgressCirle_StandardEndPointAccelerationForward;
var _glProgressCirle_ObjectProgress = 0.0;
var _glProgressCirle_LastProgress = 0.0;
var _glProgressCirle_LastSecondsPoint = 0.0;
var _glProgressCirle_LastEndPointSpeed = 0.0;
var _glProgressCirle_LastEndPointAcceleration = 0.0;
function glUpdateBackgroundCirleForProgress(progress)
{
	var nowTimePoint = parseFloat((new Date()).getTime()) / 1000.0;

	////////////////////////////////////////////////
	// 1, 背景属性计算
	////////////////////////////////////////////////

	var secondsAfterLastFrame = 0.0;
	if (_kGLBackgroundCircleBackground_LastSecondsPoint != 0.0)
	{
		secondsAfterLastFrame
			= nowTimePoint
			  - _kGLBackgroundCircleBackground_LastSecondsPoint;
	}
	_kGLBackgroundCircleBackground_LastSecondsPoint = nowTimePoint;

	_kGLBackgroundCircleBackground_LastAlpha
		= _kGLBackgroundCircleBackground_LastAlpha
		  + _kGLBackgroundCircleBackground_Speed * secondsAfterLastFrame
		  + _kGLBackgroundCircleBackground_Acceleration * Math.pow(secondsAfterLastFrame, 2) / 2;
	_kGLBackgroundCircleBackground_Speed
		= _kGLBackgroundCircleBackground_Speed
		  + _kGLBackgroundCircleBackground_Acceleration * secondsAfterLastFrame;

	if (_kGLBackgroundCircleBackground_LastAlpha > 1.0)
	{
		_kGLBackgroundCircleBackground_LastAlpha = 1.0;
		_kGLBackgroundCircleBackground_Speed = 0.0;
		_kGLBackgroundCircleBackground_Acceleration
			= _kGLBackgroundCircleBackground_StandardAlphaAccelerationBackward;
	}
	else if (_kGLBackgroundCircleBackground_LastAlpha < 0.0)
	{
		_kGLBackgroundCircleBackground_LastAlpha = 0.0;
		_kGLBackgroundCircleBackground_Speed = 0.0;
		_kGLBackgroundCircleBackground_Acceleration
			= _kGLBackgroundCircleBackground_StandardAlphaAccelerationForward;
	}

	var needUpdateForBackground
		= _kGLBackgroundCircleBackground_LastAlpha != _kGLBackgroundCircleBackground_CurrentAlpha
		  && (_kGLBackgroundCircleBackground_LastAlpha == 1.0
			  || _kGLBackgroundCircleBackground_LastAlpha == 0.0
			  || Math.abs(_kGLBackgroundCircleBackground_LastAlpha - _kGLBackgroundCircleBackground_CurrentAlpha)
				 >= 0.01);
	if (needUpdateForBackground)
	{
		_kGLBackgroundCircleBackground_CurrentAlpha = _kGLBackgroundCircleBackground_LastAlpha;
	}

	////////////////////////////////////////////////
	// 2, 进度圈属性计算
	////////////////////////////////////////////////
	var objectProgress = _glProgressCirle_ObjectProgress;
	if (progress != null
		&& typeof(progress) != "undefined"
        && progress>_glProgressCirle_ObjectProgress)
	{
		objectProgress = progress;

		if (progress==1.0
		|| Math.abs(objectProgress-_glProgressCirle_ObjectProgress)>=0.01)
		{
			glSetInstallStateButtonInNavigationBarCaption("安装中", objectProgress);
		}
		_glProgressCirle_ObjectProgress = objectProgress;
	}

	var nextEndPointAcceleration = 0.0;
	if (objectProgress > _glProgressCirle_LastProgress)
	{
		nextEndPointAcceleration = _kGLProgressCirle_StandardEndPointAccelerationForward;
	}
	else if (objectProgress < _glProgressCirle_LastProgress)
	{
		nextEndPointAcceleration = _kGLProgressCirle_StandardEndPointAccelerationBackward;
	}

	var lastMSecondsPoint = _glProgressCirle_LastSecondsPoint
	_glProgressCirle_LastSecondsPoint = nowTimePoint;

	var needUpdateForCircle = true;
	if (lastMSecondsPoint == 0.0)
	{
		lastMSecondsPoint = nowTimePoint;
	}
	else if (nextEndPointAcceleration == 0.0)
	{
		//_glProgressCirle_LastProgress = ;
		//_glProgressCirle_LastSecondsPoint = ;
		_glProgressCirle_LastEndPointSpeed = 0.0;
		_glProgressCirle_LastEndPointAcceleration = 0.0;

		needUpdateForCircle = false;
	}

	secondsAfterLastFrame
		= nowTimePoint
		  - lastMSecondsPoint;

	_glProgressCirle_LastProgress
		= _glProgressCirle_LastProgress
		  + _glProgressCirle_LastEndPointSpeed * secondsAfterLastFrame
		  + _glProgressCirle_LastEndPointAcceleration * Math.pow(secondsAfterLastFrame, secondsAfterLastFrame) / 2.0;
	if (nextEndPointAcceleration > 0.0)
	{
		if (_glProgressCirle_LastProgress > _glProgressCirle_ObjectProgress)
		{
			_glProgressCirle_LastProgress = _glProgressCirle_ObjectProgress;
		}
	}
	else if (nextEndPointAcceleration < 0.0)
	{
		if (_glProgressCirle_LastProgress < _glProgressCirle_ObjectProgress)
		{
			_glProgressCirle_LastProgress = _glProgressCirle_ObjectProgress;
		}
	}

	_glProgressCirle_LastEndPointSpeed
		= _glProgressCirle_LastEndPointSpeed
		  + _glProgressCirle_LastEndPointAcceleration * secondsAfterLastFrame;

	_glProgressCirle_LastEndPointAcceleration
		= nextEndPointAcceleration;

    /*
	if (needUpdateForBackground == false
		&& needUpdateForCircle == false)
	*/
    if (needUpdateForCircle == false)
	{
		//return;
	}

	// 绘制背景圈
	glUpdateBackgroundCirle(0.0, _glProgressCirle_LastProgress);

}
function glUpdateBackgroundCirleForReInstall()
{
    // 绘制背景圈
    glUpdateBackgroundCirle(0.0, 1.0);
}
function glUpdateBackgroundCirleForInstallFailed()
{
    // 绘制背景圈
    glUpdateBackgroundCirle(0.0, 1.0);
}
function glUpdateBackgroundCirleForInstallCompleted()
{
    // 绘制背景圈
    glUpdateBackgroundCirle(0.0, 1.0);
}
// 更新进度圈的 圈线 外观, 等待风格
var _glWaitCirle_LastSecondsPoint = 0.0;
var _glWaitCirle_LastEndPointProgress = 0.0;
var _glWaitCirle_LastEndPointSpeed = 0.75;
var _glWaitCirle_ProgressLength = 0.92;
function glResetBackgroundCirleForWaitAnimation()
{
    _glWaitCirle_LastSecondsPoint = 0.0;
}
function glUpdateBackgroundCirleForWait()
{
	var nowTimePoint = parseFloat((new Date()).getTime()) / 1000.0;
	if (_glWaitCirle_LastSecondsPoint == 0.0)
	{
		_glWaitCirle_LastSecondsPoint = nowTimePoint;
		return;
	}
	var secondsAfterLastFrame = nowTimePoint - _glWaitCirle_LastSecondsPoint;
	_glWaitCirle_LastSecondsPoint = nowTimePoint;

	_glWaitCirle_LastEndPointProgress
		= _glWaitCirle_LastEndPointProgress + _glWaitCirle_LastEndPointSpeed * secondsAfterLastFrame;

	var backgroundCircleBeginPointProgress
		= _glWaitCirle_LastEndPointProgress
		  - _glWaitCirle_ProgressLength;
	var backgroundCircleEndPointProgress
		= _glWaitCirle_LastEndPointProgress;

	if (backgroundCircleBeginPointProgress > 1.0)
	{
		backgroundCircleBeginPointProgress -= Math.floor(backgroundCircleBeginPointProgress);
	}
	if (backgroundCircleBeginPointProgress < 0.0)
	{
		backgroundCircleBeginPointProgress = Math.abs(Math.ceil(backgroundCircleBeginPointProgress)) + backgroundCircleBeginPointProgress;
	}
	if (backgroundCircleEndPointProgress > 1.0)
	{
		backgroundCircleEndPointProgress -= Math.floor(backgroundCircleBeginPointProgress);
	}
	if (backgroundCircleEndPointProgress < 0.0)
	{
		backgroundCircleEndPointProgress = Math.abs(Math.ceil(backgroundCircleBeginPointProgress)) + backgroundCircleBeginPointProgress;
	}

	if (backgroundCircleEndPointProgress>backgroundCircleBeginPointProgress)
	{
		var lastBackgroundCircleBeginPointProgress = backgroundCircleBeginPointProgress;
		backgroundCircleBeginPointProgress = backgroundCircleEndPointProgress;
		backgroundCircleEndPointProgress = lastBackgroundCircleBeginPointProgress;
	}

	glUpdateBackgroundCirle(backgroundCircleBeginPointProgress, backgroundCircleEndPointProgress);
}

var _kGLLastProgressCirleAnimationFrameType_Unknow = "unknown";
var _kGLLastProgressCirleAnimationFrameType_Progress = "progress";
var _kGLLastProgressCirleAnimationFrameType_Wait = "wait";
var _kGLLastProgressCirleAnimationFrameType_ReInstall = "reinstall";
var _kGLLastProgressCirleAnimationFrameType_Failed = "failed";
var _kGLLastProgressCirleAnimationFrameType_Completed = "completed";
var _glLastProgressCirleAnimationFrameType = _kGLLastProgressCirleAnimationFrameType_Unknow;
function glUpdateProgressCirleAnimationFrame(progress)
{
    var progressCirleAnimationFrameType = _glLastProgressCirleAnimationFrameType;
    if ($("#installingStateContent_GetGameInfo").is(":hidden")==false)
    {
        progressCirleAnimationFrameType = _kGLLastProgressCirleAnimationFrameType_Wait;
    }
    else if ($("#installingStateContent_CheckInstallEnvironmentWithApp").is(":hidden")==false)
	{
        progressCirleAnimationFrameType = _kGLLastProgressCirleAnimationFrameType_Wait;
	}
    else if ($("#installingStateContent_Installing").is(":hidden")==false)
    {
        progressCirleAnimationFrameType = _kGLLastProgressCirleAnimationFrameType_Progress;
    }
    else if ($("#installingStateContent_PauseInstall").is(":hidden")==false)
    {
        progressCirleAnimationFrameType = _kGLLastProgressCirleAnimationFrameType_Wait;
    }
    else if ($("#installingStateContent_ReInstall").is(":hidden")==false)
    {
        progressCirleAnimationFrameType = _kGLLastProgressCirleAnimationFrameType_ReInstall;
    }
    else if ($("#installingStateContent_InstallFailed").is(":hidden")==false)
    {
        progressCirleAnimationFrameType = _kGLLastProgressCirleAnimationFrameType_Failed;
    }
    else if ($("#installingStateContent_InstallCompleted").is(":hidden")==false)
    {
        progressCirleAnimationFrameType = _kGLLastProgressCirleAnimationFrameType_Completed;
    }

    var isNewAnimationFrameType = false;
    if (progressCirleAnimationFrameType!=_glLastProgressCirleAnimationFrameType)
    {
        _glLastProgressCirleAnimationFrameType = progressCirleAnimationFrameType;
        isNewAnimationFrameType = true;
    }

    switch (progressCirleAnimationFrameType)
    {
        case _kGLLastProgressCirleAnimationFrameType_Unknow:
        {

        }break;
        case _kGLLastProgressCirleAnimationFrameType_Progress:
        {
            glUpdateBackgroundCirleForProgress();
        }break;
        case _kGLLastProgressCirleAnimationFrameType_Wait:
        {
            glUpdateBackgroundCirleForWait();
        }break;
        case _kGLLastProgressCirleAnimationFrameType_ReInstall:
        {
            glUpdateBackgroundCirleForReInstall();
        }break;
        case _kGLLastProgressCirleAnimationFrameType_Failed:
        {
            glUpdateBackgroundCirleForInstallFailed();
        }break;
        case _kGLLastProgressCirleAnimationFrameType_Completed:
        {
            glUpdateBackgroundCirleForInstallCompleted();
        }break;
    }
}
var _glGameStateOperateIcons = null;
function getGetGameStateOperateIcons()
{
    if (_glGameStateOperateIcons==null)
    {
        _glGameStateOperateIcons
        = $(".InstallingStateOperateIcon");
    }
    return _glGameStateOperateIcons;
}
var _glInstallingStateOperateIcon_LastUpdateTimePoint = 0.0;
var _glInstallingStateOperateIcon_UpdateElapseSeconds = 0.6;
var _glInstallingStateOperateIcons_Visible = true;
function glUpdateInstallingStateOperateIconAnimationFrame()
{
    var nowTimePoint = (new Date()).getTime()/1000.0;
    if (_glInstallingStateOperateIcon_LastUpdateTimePoint==0)
    {
        _glInstallingStateOperateIcon_LastUpdateTimePoint = nowTimePoint;
    }
    else
    {
        if (nowTimePoint-_glInstallingStateOperateIcon_LastUpdateTimePoint
            >=_glInstallingStateOperateIcon_UpdateElapseSeconds)
        {
            var gameStateOperateIcons
            = getGetGameStateOperateIcons();
            if (gameStateOperateIcons!=null
            && gameStateOperateIcons.length>0)
            {
                _glInstallingStateOperateIcons_Visible = !_glInstallingStateOperateIcons_Visible;
                if (_glInstallingStateOperateIcons_Visible)
                {
                    gameStateOperateIcons.css("visibility", "visible");
                }
                else
                {
                    gameStateOperateIcons.css("visibility", "hidden");
                }
            }
            _glInstallingStateOperateIcon_LastUpdateTimePoint = nowTimePoint;
        }
    }
}
/*------------------------------------------------
 @事件节点
 ------------------------------------------------*/
function glOnWindowLoad()
{
    // layout 事件
    // 布局窗口
    glOnWindowResize();
    $(window).resize(glOnWindowResize);
    $("#contentContainer").show();
    $("#navigationBarContainer").show();
    $("#toolBarContainer").show();


    /*
    // 整体滑动事件
    $(window).scroll(glOnWindowScroll)
    document.addEventListener("touchstart", glDidDocumentTouchStart, true);
    document.addEventListener("touchmove", glDidDocumentTouchMove, true);
    document.addEventListener("touchend", glDidDocumentTouchEnd, true);
    document.addEventListener("touchcancel", glDidDocumentTouchCancel, true);
    */

    // 关联  navigationBar 相关事件
    $("#navigationBarContent").click(glOnNavigationBarContentClick);

    // 开始执行动画帧, 帧率
    glStartAnimation();

    // 开始第一步, 获取游戏信息
    glInstallStep_GetGameInfo();
}
function glOnWindowResize()
{
    var bodyHeight = $(window).height();

    var navigationBarContainer = $("#navigationBarContainer");
    var toolBarContainer = $("#toolBarContainer");
    var toolBarContainerHeight = parseFloat(toolBarContainer.height());

    // contentContainer
    var contentContainer = $("#contentContainer");
    contentContainer.css("padding-top", parseFloat(navigationBarContainer.height())+"px");
    contentContainer.css("padding-bottom", parseFloat(toolBarContainerHeight)+"px");

	// 进度圈画布调整
	{
		_glInstallingBackgroundCircleCanvasWidth = document.body.clientWidth;
		if (_glInstallingBackgroundCircleCanvasWidth>380.0)
		{
			_glInstallingBackgroundCircleCanvasWidth = 380.0;
		}
		_glInstallingBackgroundCircleCanvasHeight = _glInstallingBackgroundCircleCanvasWidth;


		var installingBackgroundCircle
			= document.getElementById("installingBackgroundCircle");
		if (installingBackgroundCircle!=null)
		{
			installingBackgroundCircle.style.width
				= _glInstallingBackgroundCircleCanvasWidth + "px";
			installingBackgroundCircle.style.height
				= _glInstallingBackgroundCircleCanvasWidth + "px";

			installingBackgroundCircle.setAttribute(
				"width",
				(_glInstallingBackgroundCircleCanvasWidth * _glDevicePixelRatio) + "px");
			installingBackgroundCircle.setAttribute(
				"height",
				(_glInstallingBackgroundCircleCanvasHeight * _glDevicePixelRatio) + "px");
		}

		_glInstallingBackgroundCircleCanvasWidth *= _glDevicePixelRatio;
		_glInstallingBackgroundCircleCanvasHeight *= _glDevicePixelRatio;
	}

    // navigationBar
    // ...

    // toolBarContainer
    var toolBarContainerTop = (parseFloat(bodyHeight) - toolBarContainerHeight)+"px";
    toolBarContainer.css("top", toolBarContainerTop);
}
function glOnWindowScroll()
{
    var installStateButtonInNavigationBar
    = glGetInstallStateButtonInNavigationBar();
    if (installStateButtonInNavigationBar!=null)
    {
        var currentScrollTop = document.body.scrollTop;
        var navigationBarContainerHeight = $("#navigationBarContainer").height();
        var installingBackgroundCircle = document.getElementById("installingBackgroundCircle");
        var installingBackgroundCircleBottom
        = installingBackgroundCircle.offsetTop
        + installingBackgroundCircle.offsetHeight;

        var viewAreaTop
            = currentScrollTop
              + navigationBarContainerHeight;

        var installStateButtonInNavigationBarOpacity = 0.0;
        if (installingBackgroundCircleBottom<viewAreaTop)
        {
            installStateButtonInNavigationBarOpacity = 1.0;
        }
        else if (installingBackgroundCircleBottom != navigationBarContainerHeight)
        {
            installStateButtonInNavigationBarOpacity
                = 1.0
                  - (installingBackgroundCircleBottom-viewAreaTop)
                  / (installingBackgroundCircleBottom - navigationBarContainerHeight);
            if (installStateButtonInNavigationBarOpacity<0.0)
            {
                installStateButtonInNavigationBarOpacity = 0.0;
            }
        }
        installStateButtonInNavigationBar.style.opacity = installStateButtonInNavigationBarOpacity;
    }
}
var _glDocumentLastTouchTimePoint = 0;
var _glDocumentLastTouchPageY = 0;
var _glDocumentTouchMoveSpeed = 0;
function glDidDocumentTouchStart(event)
{}
function glDidDocumentTouchMove(event)
{
    if (event==null
        || event.touches==null
        || event.touches.length<1)
    {
        return;
    }

    _glLastTouch = null;

    var touch = event.touches[0];
    if (touch==null)
    {
        return;
    }

    /*event.preventDefault();
    event.stopPropagation()*/;

    var touchTimePoint = (new Date).getTime();
    var touchPageY = touch.pageY;

    if (_glDocumentLastTouchTimePoint!=0
        && touchPageY!=_glDocumentLastTouchPageY
        && touchTimePoint-_glDocumentLastTouchTimePoint!=0)
    {
        _glDocumentTouchMoveSpeed
            = (touchPageY - _glDocumentLastTouchPageY)
              / (touchTimePoint - _glDocumentLastTouchTimePoint);
    }


    _glDocumentLastTouchTimePoint = touchTimePoint;
    _glDocumentLastTouchPageY = touchPageY;
}
function glDidDocumentTouchCancel(event)
{
}
function glDidDocumentTouchEnd(event)
{
    return;

    if (_glDocumentTouchMoveSpeed==0.0)
    {
        return;
    }
    var currentScrollTop = document.body.scrollTop;
    var navigationBarContainerHeight = $("#navigationBarContainer").height();
    var toolBarContainerHeight = $("#toolBarContainer").height();
    var viewAreaTop
        = currentScrollTop
        + navigationBarContainerHeight;
    var viewAreaBottom
        = viewAreaTop
        + $(window).height()
        - navigationBarContainerHeight
        - toolBarContainerHeight;

    if (_glDocumentTouchMoveSpeed>0.0)
    {
        var pageAnchors = $(".PageAnchor");

        var pageAnchorsCount = pageAnchors.length;
        for (var pageAnchorIndex=pageAnchorsCount-1;
             pageAnchorIndex>-1;
             pageAnchorIndex--)
        {
            var pageAnchor = pageAnchors[pageAnchorIndex];
            var pageAnchorTop = pageAnchor.offsetTop;
            //var pageAnchorBottom = pageAnchorTop + pageAnchor.offsetHeight;
            if (pageAnchorTop<viewAreaTop)
            {
                var newScrollTop
                    = pageAnchorTop
                    - navigationBarContainerHeight;
                var animationElapse
                    = Math.abs(newScrollTop-currentScrollTop/_glDocumentTouchMoveSpeed);

                $(document.body).animate(
                    {scrollTop: newScrollTop},
                    animationElapse,
                    "swing");
                return;
            }
        }
    }
    else// if (_glDocumentTouchMoveSpeed<0.0)
    {
        var pageAnchors = $(".PageAnchor");
        var currentScrollTop = document.body.scrollTop;
        var contentViewAreaTop
            = currentScrollTop
            + $("#navigationBarContainer").height();

        var pageAnchorsCount = pageAnchors.length;
        for (var pageAnchorIndex=0;
             pageAnchorIndex<pageAnchorsCount;
             pageAnchorIndex++)
        {
            var pageAnchor = pageAnchors[pageAnchorIndex];
            var pageAnchorTop = pageAnchor.offsetTop;
            //var pageAnchorBottom = pageAnchorTop + pageAnchor.offsetHeight;
            if (pageAnchorTop>viewAreaTop)
            {
                var newScrollTop
                    = pageAnchorTop
                      - navigationBarContainerHeight;
                var animationElapse
                    = Math.abs(newScrollTop-currentScrollTop/_glDocumentTouchMoveSpeed);

                $(document.body).animate(
                    {scrollTop: newScrollTop},
                    animationElapse,
                    "swing");
                return;
            }
        }
    }
}
function glDidAnimationFrame()
{
    glUpdateProgressCirleAnimationFrame();
    glUpdateInstallingStateOperateIconAnimationFrame();
}
function glDidInstallStateButtonInNavigationBarTouched()
{
    $(document.body).animate(
        {scrollTop: 0.0},
        "fast",
        "swing");
}

var kGLURLToJoinQQGroup_1 = "http://jq.qq.com/?_wv=1027&k=2FETlDE";
var kGLQQGroupNumber_1 = "327 693 112";
var kGLURLToJoinQQGroup_2 = "http://jq.qq.com/?_wv=1027&k=2JZxV9K";
var kGLQQGroupNumber_2 = "184 062 101";
var _glURLToJoinQQGroup = kGLURLToJoinQQGroup_1;
var _glQQGroupNumber = kGLQQGroupNumber_1;
if (Math.random()>0.10)
{
    _glURLToJoinQQGroup = kGLURLToJoinQQGroup_2;
    _glQQGroupNumber = kGLQQGroupNumber_2;
}
function glDidInstallingStateContentTouched(event)
{
    if ($("#installingStateContent_GameNeedGooglePlayToPlay").is(":hidden")==false
	|| $("#installingStateContent_GameNeedVPNToPlay").is(":hidden")==false)
    {
    }
    else if ($("#installingStateContent_Installing").is(":hidden")==false)
    {
        glSendMessageToApp("pauseInstall:{}");
    }
    else if ($("#installingStateContent_PauseInstall").is(":hidden")==false)
    {
        glInstallStep_InstallGame();
    }
    else if ($("#installingStateContent_ReInstall").is(":hidden")==false)
    {
        glSendMessageToApp("installGame:{}");
    }
    else if ($("#installingStateContent_InstallFailed").is(":hidden")==false)
    {
        window.open(_glURLToJoinQQGroup);
    }
}
function glOnNavigationBarContentClick(event)
{
    window.open("http://shouyou.gamersky.com");
}
/*------------------------------------------------
 @关联事件
 ------------------------------------------------*/
$(window).load(glOnWindowLoad);