/* Version: 0.2.22 - May 16, 2024 17:41:01 */
var ChameleonUltraJS = (function (exports, _, web) {
    'use strict';

    const BASE64_CHAR = _.transform('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split(''), (m, v, k) => {
        m.set(k, v).set(v, k);
    }, new Map()).set('-', 62).set('_', 63);
    const BASE64URL_CHAR = _.transform('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'.split(''), (m, v, k) => {
        m.set(k, v).set(v, k);
    }, new Map()).set('+', 62).set('/', 63);
    const HEX_CHAR = _.transform('0123456789abcdef'.split(''), (m, v, k) => {
        m.set(k, v).set(v, k).set(_.toUpper(v), k);
    }, new Map());
    const K_MAX_LENGTH = 0x7FFFFFFF;
    const SIGNED_MAX_VALUE = [0, 0x7F, 0x7FFF, 0x7FFFFF, 0x7FFFFFFF, 0x7FFFFFFFFF, 0x7FFFFFFFFFFF];
    const SIGNED_OFFSET = [0, 0x100, 0x10000, 0x1000000, 0x100000000, 0x10000000000, 0x1000000000000];
    function isInstance(obj, type) {
        return obj instanceof type || obj?.constructor?.name === type?.name;
    }
    function isSharedArrayBuffer(val) {
        return typeof SharedArrayBuffer !== 'undefined' && (isInstance(val, SharedArrayBuffer) || isInstance(val?.buffer, SharedArrayBuffer));
    }
    function floatU32ToU16(u32) {
        // Float32: 1 + 8 + 23, bits = 1 xxxxxxxx 11111111110000000000000
        //                  0x7FFFFF = 0 00000000 11111111111111111111111
        // Float16: 1 + 5 + 10, bits = 1    xxxxx 1111111111
        //                    0x0200 = 0    00000 1000000000
        //                    0x03FF = 0    00000 1111111111
        //                    0x7C00 = 0    11111 0000000000
        //                    0x8000 = 1    00000 0000000000
        const exp = (u32 >>> 23) & 0xFF;
        if (exp === 0xFF)
            return ((u32 >>> 16) & 0x8000) + 0x7C00 + ((u32 & 0x7FFFFF) !== 0 ? 0x200 : 0); // +-inf / NaN
        if (exp === 0)
            return ((u32 >>> 16) & 0x8000) + ((u32 >>> 13) & 0x3FF);
        return ((u32 >>> 16) & 0x8000) + (((exp - 112) << 10) & 0x7C00) + ((u32 >>> 13) & 0x3FF);
    }
    function floatU16ToU32(u16) {
        // Float32: 1 + 8 + 23, bits = 1 xxxxxxxx 11111111110000000000000
        //                0x00400000 = 0 00000000 10000000000000000000000
        //                0x007FE000 = 0 00000000 11111111110000000000000
        //                0x7F800000 = 0 11111111 00000000000000000000000
        //                0x80000000 = 1 00000000 00000000000000000000000
        // Float16: 1 + 5 + 10, bits = 1    xxxxx 1111111111
        //                    0x03FF = 0    00000 1111111111
        const exp = (u16 >>> 10) & 0x1F;
        if (exp === 0x1F)
            return ((u16 << 16) & 0x80000000) + 0x7F800000 + ((u16 & 0x3FF) !== 0 ? 0x400000 : 0); // +-inf / NaN
        if (exp === 0)
            return ((u16 << 16) & 0x80000000) + ((u16 << 13) & 0x7FE000);
        return ((u16 << 16) & 0x80000000) + (((exp + 112) << 23) & 0x7F800000) + ((u16 << 13) & 0x7FE000);
    }
    const float16Buf = new DataView(new ArrayBuffer(4));
    var Encoding;
    (function (Encoding) {
        Encoding["ucs-2"] = "ucs-2";
        Encoding["utf-16le"] = "utf-16le";
        Encoding["utf-8"] = "utf-8";
        Encoding["ascii"] = "ascii";
        Encoding["base64"] = "base64";
        Encoding["base64url"] = "base64url";
        Encoding["binary"] = "binary";
        Encoding["hex"] = "hex";
        Encoding["latin1"] = "latin1";
        Encoding["ucs2"] = "ucs2";
        Encoding["utf16le"] = "utf16le";
        Encoding["utf8"] = "utf8";
    })(Encoding || (Encoding = {}));
    function createIsEnum$1(e) {
        const ev = new Set(_.chain(e).toPairs().filter(([k, v]) => !_.isNumber(e[v])).map(1).value());
        return (val) => ev.has(val);
    }
    const isNativeLittleEndian = new Uint8Array(new Uint16Array([0x1234]).buffer)[0] === 0x12;
    /**
     * @see [Format Characters](https://docs.python.org/3/library/struct.html#format-characters)
     */
    const packFromFns = new Map([
        ['x', packFromPad],
        ['c', packFromChar],
        ['b', packFromInt8],
        ['B', packFromInt8],
        ['?', packFromBool],
        ['h', packFromInt16],
        ['H', packFromInt16],
        ['i', packFromInt32],
        ['I', packFromInt32],
        ['l', packFromInt32],
        ['L', packFromInt32],
        ['q', packFromBigInt64],
        ['Q', packFromBigInt64],
        ['e', packFromFloat16],
        ['f', packFromFloat],
        ['d', packFromDouble],
        ['s', packFromString],
        ['p', packFromPascal],
    ]);
    /**
     * @see [Format Characters](https://docs.python.org/3/library/struct.html#format-characters)
     */
    const unpackToFns = new Map([
        ['x', unpackToPad],
        ['c', unpackToChar],
        ['b', unpackToInt8],
        ['B', unpackToInt8],
        ['?', unpackToBool],
        ['h', unpackToInt16],
        ['H', unpackToInt16],
        ['i', unpackToInt32],
        ['I', unpackToInt32],
        ['l', unpackToInt32],
        ['L', unpackToInt32],
        ['q', unpackToBigInt64],
        ['Q', unpackToBigInt64],
        ['e', unpackToFloat16],
        ['f', unpackToFloat],
        ['d', unpackToDouble],
        ['s', unpackToString],
        ['p', unpackToPascal],
    ]);
    class Buffer extends Uint8Array {
        dv;
        constructor(val, offset, length) {
            if (_.isNil(val))
                super();
            else if (_.isNil(offset))
                super(val);
            else if (_.isNil(length))
                super(val, offset);
            else
                super(val, offset, length);
            this.dv = new DataView(this.buffer, this.byteOffset, this.byteLength);
        }
        static isEncoding = createIsEnum$1(Encoding);
        static alloc(size, fill, encoding = 'utf8') {
            if (!_.isSafeInteger(size) || size >= K_MAX_LENGTH)
                throw new RangeError(`Invalid size: ${size}`);
            const buf = new Buffer(size);
            if (_.isNil(fill))
                return buf;
            return _.isNil(encoding) ? buf.fill(fill) : buf.fill(fill, encoding);
        }
        static allocUnsafe(size) {
            return new Buffer(size);
        }
        static allocUnsafeSlow(size) {
            return new Buffer(size);
        }
        static byteLength(string, encoding = 'utf8') {
            if (Buffer.isBuffer(string) || isInstance(string, ArrayBuffer) || isSharedArrayBuffer(string) || ArrayBuffer.isView(string))
                return string.byteLength;
            if (!_.isString(string))
                throw new TypeError(`Invalid type of string: ${typeof string}`);
            if (_.includes(['ascii', 'latin1', 'binary'], encoding))
                return string.length;
            if (_.includes(['ucs2', 'ucs-2', 'utf16le', 'utf-16le'], encoding))
                return string.length * 2;
            if (encoding === 'hex')
                return string.length >>> 1;
            if (_.includes(['base64', 'base64url'], encoding))
                return (string.replace(/[^A-Za-z0-9/_+-]/g, '').length * 3) >>> 2;
            return new TextEncoder().encode(string).length; // default utf8
        }
        static compare(buf1, buf2) {
            if (!Buffer.isBuffer(buf1)) {
                if (!ArrayBuffer.isView(buf1))
                    throw new TypeError('Invalid type');
                buf1 = Buffer.fromView(buf1);
            }
            return buf1.compare(buf2);
        }
        static equals(buf1, buf2) {
            return Buffer.isBuffer(buf1) && buf1.equals(buf2);
        }
        static concat(list, totalLength) {
            if (_.isNil(totalLength))
                totalLength = _.sumBy(list, 'length');
            if (totalLength < 0)
                totalLength = 0;
            const buf = new Buffer(totalLength);
            let start = 0;
            for (let i = 0; i < list.length; i++) {
                if (start + list[i].length > totalLength)
                    list[i] = list[i].subarray(0, totalLength - start);
                buf.set(list[i], start);
                start += list[i].length;
            }
            return buf;
        }
        static fromView(view, offset = 0, length) {
            if (!ArrayBuffer.isView(view))
                throw new TypeError('invalid view');
            const bytesPerElement = view?.BYTES_PER_ELEMENT ?? 1;
            const viewLength = view.byteLength / bytesPerElement;
            if (_.isNil(length))
                length = viewLength - offset;
            return new Buffer(view.buffer, view.byteOffset + offset * bytesPerElement, length * bytesPerElement);
        }
        static copyBytesFrom(view, offset = 0, length) {
            return new Buffer(Buffer.fromView(view, offset, length));
        }
        static from(val, encodingOrOffset, length) {
            const valueOfObj = val?.[Symbol.toPrimitive]?.('string') ?? val?.valueOf?.();
            if (!_.isNil(valueOfObj) && valueOfObj !== val)
                val = valueOfObj;
            if (Buffer.isBuffer(val))
                return new Buffer(val);
            if (ArrayBuffer.isView(val))
                return Buffer.fromView(val);
            if (isInstance(val, ArrayBuffer) || isSharedArrayBuffer(val))
                return new Buffer(val, encodingOrOffset, length);
            if (_.isString(val))
                return Buffer.fromString(val, encodingOrOffset);
            if (_.isArray(val))
                return Buffer.fromArray(val);
            if (typeof val[Symbol.iterator] === 'function')
                return Buffer.fromArray([...val]);
            throw new TypeError(`Invalid type of value: ${typeof val}`);
        }
        static fromString(str, encoding = 'utf8') {
            encoding = _.toLower(encoding);
            if (!Buffer.isEncoding(encoding))
                throw new TypeError(`Unknown encoding: ${encoding}`);
            const fromStringFns = {
                'ucs-2': Buffer.fromUcs2String,
                'utf-16le': Buffer.fromUcs2String,
                'utf-8': Buffer.fromUtf8String,
                ascii: Buffer.fromAsciiString,
                base64: Buffer.fromBase64String,
                base64url: Buffer.fromBase64urlString,
                binary: Buffer.fromAsciiString,
                hex: Buffer.fromHexString,
                latin1: Buffer.fromAsciiString,
                ucs2: Buffer.fromUcs2String,
                utf16le: Buffer.fromUcs2String,
                utf8: Buffer.fromUtf8String,
            };
            return fromStringFns[encoding](str);
        }
        static fromUcs2String(ucs2) {
            const buf = new Buffer(ucs2.length * 2);
            for (let i = 0; i < ucs2.length; i++)
                buf.writeUInt16LE(ucs2.charCodeAt(i), i * 2);
            return buf;
        }
        static fromUtf8String(utf8) {
            return Buffer.fromView(new TextEncoder().encode(utf8));
        }
        static fromAsciiString(ascii) {
            const buf = new Buffer(ascii.length);
            for (let i = 0; i < ascii.length; i++)
                buf[i] = ascii.charCodeAt(i) & 0xFF;
            return buf;
        }
        static fromBase64String(base64) {
            base64 = base64.replace(/[^A-Za-z0-9/_+-]/g, '');
            const tmp1 = base64.length;
            const tmp2 = base64.length + 3;
            base64 = `${base64}AAA`.slice(0, tmp2 - tmp2 % 4);
            const buf = new Buffer(base64.length * 3 >>> 2);
            let parsedLen = 0;
            for (let i = 0; i < base64.length; i += 4) {
                const u24 = (BASE64_CHAR.get(base64[i]) << 18) +
                    (BASE64_CHAR.get(base64[i + 1]) << 12) +
                    (BASE64_CHAR.get(base64[i + 2]) << 6) +
                    BASE64_CHAR.get(base64[i + 3]);
                buf[parsedLen++] = (u24 >>> 16) & 0xFF;
                buf[parsedLen++] = (u24 >>> 8) & 0xFF;
                buf[parsedLen++] = (u24 >>> 0) & 0xFF;
            }
            return tmp1 < base64.length ? buf.subarray(0, tmp1 - base64.length) : buf;
        }
        static fromBase64urlString(base64) {
            base64 = base64.replace(/[^A-Za-z0-9/_+-]/g, '');
            const tmp1 = base64.length;
            const tmp2 = base64.length + 3;
            base64 = `${base64}AAA`.slice(0, tmp2 - tmp2 % 4);
            const buf = new Buffer(base64.length * 3 >>> 2);
            let parsedLen = 0;
            for (let i = 0; i < base64.length; i += 4) {
                const u24 = (BASE64URL_CHAR.get(base64[i]) << 18) +
                    (BASE64URL_CHAR.get(base64[i + 1]) << 12) +
                    (BASE64URL_CHAR.get(base64[i + 2]) << 6) +
                    BASE64URL_CHAR.get(base64[i + 3]);
                buf[parsedLen++] = (u24 >>> 16) & 0xFF;
                buf[parsedLen++] = (u24 >>> 8) & 0xFF;
                buf[parsedLen++] = (u24 >>> 0) & 0xFF;
            }
            return tmp1 < base64.length ? buf.subarray(0, tmp1 - base64.length) : buf;
        }
        static fromHexString(hex) {
            hex = hex.replace(/[^0-9A-Fa-f]/g, '');
            const buf = new Buffer(hex.length >>> 1);
            for (let i = 0; i < buf.length; i++)
                buf[i] = HEX_CHAR.get(hex[i * 2]) << 4 | HEX_CHAR.get(hex[i * 2 + 1]);
            return buf;
        }
        static fromArray(arr) {
            if (!_.isArray(arr))
                throw new TypeError('arr must be an array');
            const buf = new Buffer(arr.length);
            for (let i = 0; i < buf.length; i++)
                buf[i] = _.toSafeInteger(arr[i]) & 0xFF;
            return buf;
        }
        static isBuffer(obj) {
            return isInstance(obj, Buffer);
        }
        static packParseFormat(format) {
            if (!_.isString(format))
                throw new TypeError('Invalid type of format');
            const matched = /^([@=<>!]?)((?:\d*[xcbB?hHiIlLqQefdsp])+)$/.exec(format);
            if (_.isNil(matched))
                throw new TypeError(`Invalid format: ${format}`);
            const littleEndian = _.includes(['', '@', '='], matched[1]) ? isNativeLittleEndian : (matched[1] === '<');
            return {
                littleEndian,
                items: _.map([...matched[2].matchAll(/\d*[xcbB?hHiIlLqQefdsp]/g)], ([s]) => {
                    const type = s[s.length - 1];
                    const repeat = s.length > 1 ? _.parseInt(s.slice(0, -1)) : 1;
                    return [(type === 'p' && repeat > 255) ? 255 : repeat, type];
                }),
            };
        }
        static packCalcSize(formatOrItems) {
            if (_.isString(formatOrItems))
                formatOrItems = Buffer.packParseFormat(formatOrItems)?.items;
            return _.sumBy(formatOrItems, item => {
                const [repeat, type] = item;
                if ('hHe'.includes(type))
                    return repeat * 2;
                if ('iIlLf'.includes(type))
                    return repeat * 4;
                if ('qQd'.includes(type))
                    return repeat * 8;
                return repeat; // xcbB?sp
            });
        }
        static pack(buf, format, ...vals) {
            if (_.isString(buf)) { // shift arguments
                vals.unshift(format);
                [buf, format] = [undefined, buf];
            }
            const { littleEndian, items } = Buffer.packParseFormat(format);
            const lenRequired = Buffer.packCalcSize(items);
            if (_.isNil(buf))
                buf = new Buffer(lenRequired);
            if (!Buffer.isBuffer(buf))
                throw new TypeError('Invalid type of buf');
            if (buf.length < lenRequired)
                throw new RangeError(`buf.length = ${buf.length}, lenRequired = ${lenRequired}`);
            const ctx = { buf, littleEndian, offset: 0, vals };
            for (const [repeat, type] of items) {
                const packFromFn = packFromFns.get(type);
                if (_.isNil(packFromFn))
                    throw new Error(`Unknown format: ${repeat}${type}`);
                packFromFn(_.merge(ctx, { repeat, type }));
            }
            return buf;
        }
        static unpack(buf, format) {
            const { littleEndian, items } = Buffer.packParseFormat(format);
            const lenRequired = Buffer.packCalcSize(items);
            if (!Buffer.isBuffer(buf))
                throw new TypeError('Invalid type of buf');
            if (buf.length < lenRequired)
                throw new RangeError(`buf.length = ${buf.length}, lenRequired = ${lenRequired}`);
            const ctx = { buf, littleEndian, offset: 0, vals: [] };
            for (const [repeat, type] of items) {
                const unpackToFn = unpackToFns.get(type);
                if (_.isNil(unpackToFn))
                    throw new Error(`Unknown format: ${repeat}${type}`);
                unpackToFn(_.merge(ctx, { repeat, type }));
            }
            return ctx.vals;
        }
        compare(target, targetStart = 0, targetEnd = target.length, sourceStart = 0, sourceEnd = this.length) {
            if (!Buffer.isBuffer(target)) {
                if (!ArrayBuffer.isView(target))
                    throw new TypeError('Invalid type');
                target = Buffer.fromView(target);
            }
            const me = this.subarray(sourceStart, sourceEnd);
            target = target.subarray(targetStart, targetEnd);
            const len = Math.max(me.length, target.length);
            for (let i = 0; i < len; i++) {
                if (i >= me.length)
                    return -1;
                if (i >= target.length)
                    return 1;
                if (me[i] !== target[i])
                    return me[i] < target[i] ? -1 : 1;
            }
            return 0;
        }
        copy(target, targetStart = 0, sourceStart = 0, sourceEnd = this.length) {
            let buf = this.subarray(sourceStart, sourceEnd);
            if (buf.length > target.length - targetStart)
                buf = buf.subarray(0, target.length - targetStart);
            target.set(buf, targetStart);
            return buf.length;
        }
        equals(other) {
            if (!Buffer.isBuffer(other) || this.length !== other.length)
                return false;
            for (let i = 0; i < this.length; i++)
                if (this[i] !== other[i])
                    return false;
            return true;
        }
        fill(val, offset = 0, end = this.length, encoding = 'utf8') {
            if (Buffer.isEncoding(offset))
                [offset, encoding] = [0, offset];
            if (Buffer.isEncoding(end))
                [end, encoding] = [this.length, end];
            if (!_.isSafeInteger(offset) || !_.isSafeInteger(end))
                throw new RangeError('Invalid type of offset or end');
            if (_.isString(val))
                val = Buffer.fromString(val, encoding);
            else if (isInstance(val, Uint8Array))
                val = Buffer.fromView(val);
            if (Buffer.isBuffer(val) && val.length < 2)
                val = val.length > 0 ? val[0] : 0; // try to convert Buffer to number
            if (_.isNumber(val)) {
                val = _.toSafeInteger(val) & 0xFF;
                for (let i = offset; i < end; i++)
                    this[i] = val;
                return this;
            }
            let tmp = 0;
            for (let i = offset; i < end; i++) {
                this[i] = val[tmp++];
                if (tmp >= val.length)
                    tmp = 0;
            }
            return this;
        }
        includes(val, offset = 0, encoding = 'utf8') {
            if (Buffer.isEncoding(offset))
                [offset, encoding] = [0, offset];
            offset = _.toSafeInteger(offset);
            if (offset < 0)
                offset = this.length + offset;
            if (_.isString(val))
                val = Buffer.fromString(val, encoding);
            else if (isInstance(val, Uint8Array))
                val = Buffer.fromView(val);
            if (Buffer.isBuffer(val)) { // try to convert Buffer to number
                if (val.length === 0)
                    return false;
                else if (val.length === 1)
                    val = val[0];
            }
            if (_.isNumber(val)) {
                val = _.toSafeInteger(val) & 0xFF;
                for (let i = offset; i < this.length; i++)
                    if (this[i] === val)
                        return true;
                return false;
            }
            const equalsAtOffset = (i) => {
                for (let j = 0; j < val.length; j++)
                    if (this[i + j] !== val[j])
                        return false;
                return true;
            };
            const len = this.length - val.length + 1;
            for (let i = offset; i < len; i++)
                if (equalsAtOffset(i))
                    return true;
            return false;
        }
        indexOf(val, offset = 0, encoding = 'utf8') {
            if (Buffer.isEncoding(offset))
                [offset, encoding] = [0, offset];
            offset = _.toSafeInteger(offset);
            if (offset < 0)
                offset = this.length + offset;
            if (_.isString(val))
                val = Buffer.fromString(val, encoding);
            else if (isInstance(val, Uint8Array))
                val = Buffer.fromView(val);
            if (Buffer.isBuffer(val)) { // try to convert Buffer which length < 2 to number
                if (val.length === 0)
                    return -1;
                else if (val.length === 1)
                    val = val[0];
            }
            if (_.isNumber(val)) {
                val = _.toSafeInteger(val) & 0xFF;
                for (let i = offset; i < this.length; i++)
                    if (this[i] === val)
                        return i;
                return -1;
            }
            const equalsAtOffset = (i) => {
                for (let j = 0; j < val.length; j++)
                    if (this[i + j] !== val[j])
                        return false;
                return true;
            };
            const len = this.length - val.length + 1;
            for (let i = offset; i < len; i++)
                if (equalsAtOffset(i))
                    return i;
            return -1;
        }
        lastIndexOf(val, offset = this.length - 1, encoding = 'utf8') {
            if (Buffer.isEncoding(offset))
                [offset, encoding] = [this.length - 1, offset];
            offset = _.toSafeInteger(offset);
            if (offset < 0)
                offset = this.length + offset;
            if (_.isString(val))
                val = Buffer.fromString(val, encoding);
            else if (isInstance(val, Uint8Array))
                val = Buffer.fromView(val);
            if (Buffer.isBuffer(val)) { // try to convert Buffer to number
                if (val.length === 0)
                    return -1;
                else if (val.length === 1)
                    val = val[0];
            }
            if (_.isNumber(val)) {
                val = _.toSafeInteger(val) & 0xFF;
                for (let i = Math.min(offset, this.length - 1); i >= 0; i--)
                    if (this[i] === val)
                        return i;
                return -1;
            }
            const equalsAtOffset = (i) => {
                for (let j = 0; j < val.length; j++)
                    if (this[i + j] !== val[j])
                        return false;
                return true;
            };
            for (let i = Math.min(offset, this.length - val.length); i >= 0; i--)
                if (equalsAtOffset(i))
                    return i;
            return -1;
        }
        readBigInt64BE(offset = 0) {
            return this.dv.getBigInt64(offset);
        }
        readBigInt64LE(offset = 0) {
            return this.dv.getBigInt64(offset, true);
        }
        readBigUInt64BE(offset = 0) {
            return this.dv.getBigUint64(offset);
        }
        readBigUInt64LE(offset = 0) {
            return this.dv.getBigUint64(offset, true);
        }
        readDoubleBE(offset = 0) {
            return this.dv.getFloat64(offset);
        }
        readDoubleLE(offset = 0) {
            return this.dv.getFloat64(offset, true);
        }
        readFloatBE(offset = 0) {
            return this.dv.getFloat32(offset);
        }
        readFloatLE(offset = 0) {
            return this.dv.getFloat32(offset, true);
        }
        readFloat16BE(offset = 0) {
            const u32 = floatU16ToU32(this.readUInt16BE(offset));
            float16Buf.setUint32(0, u32);
            return float16Buf.getFloat32(0);
        }
        readFloat16LE(offset = 0) {
            const u32 = floatU16ToU32(this.readUInt16LE(offset));
            float16Buf.setUint32(0, u32);
            return float16Buf.getFloat32(0);
        }
        readInt8(offset = 0) {
            return this.dv.getInt8(offset);
        }
        readInt16BE(offset = 0) {
            return this.dv.getInt16(offset);
        }
        readInt16LE(offset = 0) {
            return this.dv.getInt16(offset, true);
        }
        readInt32BE(offset = 0) {
            return this.dv.getInt32(offset);
        }
        readInt32LE(offset = 0) {
            return this.dv.getInt32(offset, true);
        }
        readIntBE(offset = 0, byteLength = 6) {
            const tmp = this.readUIntBE(offset, byteLength);
            return tmp > SIGNED_MAX_VALUE[byteLength] ? tmp - SIGNED_OFFSET[byteLength] : tmp;
        }
        readIntLE(offset = 0, byteLength = 6) {
            const tmp = this.readUIntLE(offset, byteLength);
            return tmp > SIGNED_MAX_VALUE[byteLength] ? tmp - SIGNED_OFFSET[byteLength] : tmp;
        }
        readUInt8(offset = 0) {
            return this.dv.getUint8(offset);
        }
        readUInt16BE(offset = 0) {
            return this.dv.getUint16(offset);
        }
        readUInt16LE(offset = 0) {
            return this.dv.getUint16(offset, true);
        }
        readUInt32BE(offset = 0) {
            return this.dv.getUint32(offset);
        }
        readUInt32LE(offset = 0) {
            return this.dv.getUint32(offset, true);
        }
        readUIntBE(offset = 0, byteLength = 6) {
            if (byteLength < 1 || byteLength > 6)
                throw new RangeError(`Invalid byteLength: ${byteLength}`);
            if (offset + byteLength > this.length)
                throw new RangeError(`Invalid offset: ${offset}`);
            let tmp = 0;
            for (let i = 0; i < byteLength; i++)
                tmp = tmp * 0x100 + this[offset + i];
            return tmp;
        }
        readUIntLE(offset = 0, byteLength = 6) {
            if (byteLength < 1 || byteLength > 6)
                throw new RangeError(`Invalid byteLength: ${byteLength}`);
            if (offset + byteLength > this.length)
                throw new RangeError(`Invalid offset: ${offset}`);
            let tmp = 0;
            for (let i = byteLength - 1; i >= 0; i--)
                tmp = tmp * 0x100 + this[offset + i];
            return tmp;
        }
        readBitMSB(bitOffset) {
            const tmp = [bitOffset >>> 3, (bitOffset & 7) ^ 7];
            return (this[tmp[0]] >>> tmp[1]) & 1;
        }
        readBitLSB(bitOffset) {
            const tmp = [this.length - (bitOffset >>> 3) - 1, bitOffset & 7];
            return (this[tmp[0]] >>> tmp[1]) & 1;
        }
        subarray(start = 0, end = this.length) {
            const buf = super.subarray(start, end);
            return new Buffer(buf.buffer, buf.byteOffset, buf.byteLength);
        }
        slice(start = 0, end = this.length) {
            return new Buffer(super.slice(start, end).buffer);
        }
        reverse() {
            const buf = new Buffer(this.length);
            for (let i = buf.length - 1; i >= 0; i--)
                buf[i] = this[this.length - i - 1];
            return buf;
        }
        swap16() {
            if ((this.length & 0x1) > 0)
                throw new RangeError('Buffer size must be a multiple of 16-bits');
            for (let i = 0; i < this.length; i += 2)
                this.writeUInt16LE(this.readUInt16BE(i), i);
            return this;
        }
        swap32() {
            if ((this.length & 0x3) > 0)
                throw new RangeError('Buffer size must be a multiple of 32-bits');
            for (let i = 0; i < this.length; i += 4)
                this.writeUInt32LE(this.readUInt32BE(i), i);
            return this;
        }
        swap64() {
            if ((this.length & 0x7) > 0)
                throw new RangeError('Buffer size must be a multiple of 64-bits');
            for (let i = 0; i < this.length; i += 8)
                this.writeBigUInt64LE(this.readBigUInt64BE(i), i);
            return this;
        }
        toJSON() {
            return { type: 'Buffer', data: [...this] };
        }
        toString(encoding = 'utf8', start = 0, end = this.length) {
            encoding = _.toLower(encoding);
            if (!Buffer.isEncoding(encoding))
                throw new TypeError(`Unknown encoding: ${encoding}`);
            const toStringFns = {
                'ucs-2': Buffer.toUcs2String,
                'utf-16le': Buffer.toUcs2String,
                'utf-8': Buffer.toUtf8String,
                ascii: Buffer.toAsciiString,
                base64: Buffer.toBase64String,
                base64url: Buffer.toBase64urlString,
                binary: Buffer.toAsciiString,
                hex: Buffer.toHexString,
                latin1: Buffer.toAsciiString,
                ucs2: Buffer.toUcs2String,
                utf16le: Buffer.toUcs2String,
                utf8: Buffer.toUtf8String,
            };
            return toStringFns[encoding](this.subarray(start, end));
        }
        static toUcs2String(buf) {
            const arr = [];
            for (let i = 0; i < buf.length; i += 2)
                arr.push(String.fromCharCode(buf.readUInt16LE(i)));
            return arr.join('');
        }
        static toUtf8String(buf) {
            return new TextDecoder().decode(buf);
        }
        static toAsciiString(buf) {
            const arr = [];
            for (let i = 0; i < buf.length; i++)
                arr.push(String.fromCharCode(buf[i]));
            return arr.join('');
        }
        static toBase64String(buf) {
            const arr = [];
            for (let i = 0; i < buf.length; i += 3) {
                const u24 = (buf[i] << 16) +
                    ((i + 1 < buf.length ? buf[i + 1] : 0) << 8) +
                    (i + 2 < buf.length ? buf[i + 2] : 0);
                arr.push(...[
                    BASE64_CHAR.get(u24 >>> 18 & 0x3F),
                    BASE64_CHAR.get(u24 >>> 12 & 0x3F),
                    BASE64_CHAR.get(u24 >>> 6 & 0x3F),
                    BASE64_CHAR.get(u24 >>> 0 & 0x3F),
                ]);
            }
            const tmp = arr.length + (buf.length + 2) % 3 - 2;
            for (let i = tmp; i < arr.length; i++)
                arr[i] = '=';
            return arr.join('');
        }
        static toBase64urlString(buf) {
            const arr = [];
            for (let i = 0; i < buf.length; i += 3) {
                const u24 = (buf[i] << 16) +
                    ((i + 1 < buf.length ? buf[i + 1] : 0) << 8) +
                    (i + 2 < buf.length ? buf[i + 2] : 0);
                arr.push(...[
                    BASE64URL_CHAR.get(u24 >>> 18 & 0x3F),
                    BASE64URL_CHAR.get(u24 >>> 12 & 0x3F),
                    BASE64URL_CHAR.get(u24 >>> 6 & 0x3F),
                    BASE64URL_CHAR.get(u24 >>> 0 & 0x3F),
                ]);
            }
            const tmp = (buf.length + 2) % 3 - 2;
            return (tmp !== 0 ? arr.slice(0, tmp) : arr).join('');
        }
        static toHexString(buf) {
            const arr = [];
            for (let i = 0; i < buf.length; i++)
                arr.push(HEX_CHAR.get(buf[i] >>> 4), HEX_CHAR.get(buf[i] & 0xF));
            return arr.join('');
        }
        write(val, offset = 0, length = this.length - offset, encoding = 'utf8') {
            if (_.isString(offset))
                [offset, length, encoding] = [0, this.length, offset];
            else if (_.isString(length))
                [length, encoding] = [this.length - offset, length];
            if (!_.isString(val))
                throw new TypeError('Invalid type of val');
            if (!_.isSafeInteger(offset))
                throw new TypeError('Invalid type of offset');
            if (!_.isSafeInteger(length))
                throw new TypeError('Invalid type of length');
            if (!Buffer.isEncoding(encoding))
                throw new TypeError(`Unknown encoding: ${encoding}`);
            const buf = Buffer.fromString(val, encoding);
            length = Math.min(buf.length, length, this.length - offset);
            this.set(buf.subarray(0, length), offset);
            return length;
        }
        writeBigInt64BE(val, offset = 0) {
            this.dv.setBigInt64(offset, val);
            return this;
        }
        writeBigInt64LE(val, offset = 0) {
            this.dv.setBigInt64(offset, val, true);
            return this;
        }
        writeBigUInt64BE(val, offset = 0) {
            this.dv.setBigUint64(offset, val);
            return this;
        }
        writeBigUInt64LE(val, offset = 0) {
            this.dv.setBigUint64(offset, val, true);
            return this;
        }
        writeDoubleBE(val, offset = 0) {
            this.dv.setFloat64(offset, val);
            return this;
        }
        writeDoubleLE(val, offset = 0) {
            this.dv.setFloat64(offset, val, true);
            return this;
        }
        writeFloatBE(val, offset = 0) {
            this.dv.setFloat32(offset, val);
            return this;
        }
        writeFloatLE(val, offset = 0) {
            this.dv.setFloat32(offset, val, true);
            return this;
        }
        writeFloat16BE(val, offset = 0) {
            float16Buf.setFloat32(0, val);
            const u32 = float16Buf.getUint32(0);
            return this.writeUInt16BE(floatU32ToU16(u32), offset);
        }
        writeFloat16LE(val, offset = 0) {
            float16Buf.setFloat32(0, val);
            const u32 = float16Buf.getUint32(0);
            return this.writeUInt16LE(floatU32ToU16(u32), offset);
        }
        writeInt8(val, offset = 0) {
            this.dv.setInt8(offset, val);
            return this;
        }
        writeInt16BE(val, offset = 0) {
            this.dv.setInt16(offset, val);
            return this;
        }
        writeInt16LE(val, offset = 0) {
            this.dv.setInt16(offset, val, true);
            return this;
        }
        writeInt32BE(val, offset = 0) {
            this.dv.setInt32(offset, val);
            return this;
        }
        writeInt32LE(val, offset = 0) {
            this.dv.setInt32(offset, val, true);
            return this;
        }
        writeIntBE(val, offset = 0, byteLength = 6) {
            if (byteLength < 1 || byteLength > 6)
                throw new RangeError(`Invalid byteLength: ${byteLength}`);
            if (val < 0)
                val += SIGNED_OFFSET[byteLength];
            this.writeUIntBE(val, offset, byteLength);
            return this;
        }
        writeIntLE(val, offset = 0, byteLength = 6) {
            if (byteLength < 1 || byteLength > 6)
                throw new RangeError(`Invalid byteLength: ${byteLength}`);
            if (val < 0)
                val += SIGNED_OFFSET[byteLength];
            this.writeUIntLE(val, offset, byteLength);
            return this;
        }
        writeUInt8(val, offset = 0) {
            this.dv.setUint8(offset, val);
            return this;
        }
        writeUInt16BE(val, offset = 0) {
            this.dv.setUint16(offset, val);
            return this;
        }
        writeUInt16LE(val, offset = 0) {
            this.dv.setUint16(offset, val, true);
            return this;
        }
        writeUInt32BE(val, offset = 0) {
            this.dv.setUint32(offset, val);
            return this;
        }
        writeUInt32LE(val, offset = 0) {
            this.dv.setUint32(offset, val, true);
            return this;
        }
        writeUIntBE(val, offset = 0, byteLength = 6) {
            if (byteLength < 1 || byteLength > 6)
                throw new RangeError(`Invalid byteLength: ${byteLength}`);
            if (offset + byteLength > this.length)
                throw new RangeError(`Invalid offset: ${offset}`);
            for (let i = byteLength - 1; i >= 0; i--) {
                this[offset + i] = val & 0xFF;
                val /= 0x100;
            }
            return this;
        }
        writeUIntLE(val, offset = 0, byteLength = 6) {
            if (byteLength < 1 || byteLength > 6)
                throw new RangeError(`Invalid byteLength: ${byteLength}`);
            if (offset + byteLength > this.length)
                throw new RangeError(`Invalid offset: ${offset}`);
            for (let i = 0; i < byteLength; i++) {
                this[offset + i] = val & 0xFF;
                val /= 0x100;
            }
            return this;
        }
        writeBitMSB(val, bitOffset) {
            const tmp = [bitOffset >>> 3, (bitOffset & 7) ^ 7];
            if (Boolean(val))
                this[tmp[0]] |= 1 << tmp[1];
            else
                this[tmp[0]] &= ~(1 << tmp[1]);
            return this;
        }
        writeBitLSB(val, bitOffset) {
            const tmp = [this.length - (bitOffset >>> 3) - 1, bitOffset & 7];
            if (Boolean(val))
                this[tmp[0]] |= 1 << tmp[1];
            else
                this[tmp[0]] &= ~(1 << tmp[1]);
            return this;
        }
        chunk(bytesPerChunk) {
            if (bytesPerChunk < 1)
                throw new TypeError('invalid bytesPerChunk');
            const chunks = [];
            for (let i = 0; i < this.length; i += bytesPerChunk)
                chunks.push(this.subarray(i, i + bytesPerChunk));
            return chunks;
        }
        xor() {
            return _.reduce(this, (xor, v) => xor ^ v, 0);
        }
        pack(format, ...vals) {
            Buffer.pack(this, format, ...vals);
            return this;
        }
        unpack(format) {
            return Buffer.unpack(this, format);
        }
    }
    function packFromPad(ctx) {
        const { buf, repeat } = ctx;
        for (let i = 0; i < repeat; i++)
            buf[ctx.offset] = 0;
        ctx.offset += repeat;
    }
    function unpackToPad(ctx) {
        const { repeat } = ctx;
        ctx.offset += repeat;
    }
    function packFromChar(ctx) {
        const { buf, repeat, vals } = ctx;
        for (let i = 0; i < repeat; i++) {
            if (vals.length === 0)
                throw new TypeError('Not enough vals');
            buf[ctx.offset] = Buffer.from(vals.shift())?.[0] ?? 0;
            ctx.offset += 1;
        }
    }
    function unpackToChar(ctx) {
        const { buf, repeat, vals } = ctx;
        for (let i = 0; i < repeat; i++) {
            vals.push(buf.subarray(ctx.offset, ctx.offset + 1));
            ctx.offset += 1;
        }
    }
    function packFromInt8(ctx) {
        const { buf, repeat, type, vals } = ctx;
        const fnName = type === 'b' ? 'writeInt8' : 'writeUInt8';
        for (let i = 0; i < repeat; i++) {
            if (vals.length === 0)
                throw new TypeError('Not enough vals');
            buf[fnName](_.toSafeInteger(vals.shift()), ctx.offset);
            ctx.offset += 1;
        }
    }
    function unpackToInt8(ctx) {
        const { buf, repeat, type, vals } = ctx;
        const fnName = type === 'b' ? 'readInt8' : 'readUInt8';
        for (let i = 0; i < repeat; i++) {
            vals.push(buf[fnName](ctx.offset));
            ctx.offset += 1;
        }
    }
    function packFromBool(ctx) {
        const { buf, repeat, vals } = ctx;
        for (let i = 0; i < repeat; i++) {
            if (vals.length === 0)
                throw new TypeError('Not enough vals');
            buf.writeUInt8(Boolean(vals.shift()) ? 1 : 0, ctx.offset);
            ctx.offset += 1;
        }
    }
    function unpackToBool(ctx) {
        const { buf, repeat, vals } = ctx;
        for (let i = 0; i < repeat; i++) {
            vals.push(buf.readUInt8(ctx.offset) !== 0);
            ctx.offset += 1;
        }
    }
    function packFromInt16(ctx) {
        const { buf, littleEndian, repeat, type, vals } = ctx;
        const fnName = ['writeUInt16BE', 'writeUInt16LE', 'writeInt16BE', 'writeInt16LE'][(type === 'h' ? 2 : 0) + (littleEndian ? 1 : 0)];
        for (let i = 0; i < repeat; i++) {
            if (vals.length === 0)
                throw new TypeError('Not enough vals');
            buf[fnName](_.toSafeInteger(vals.shift()), ctx.offset);
            ctx.offset += 2;
        }
    }
    function unpackToInt16(ctx) {
        const { buf, littleEndian, repeat, type, vals } = ctx;
        const fnName = ['readUInt16BE', 'readUInt16LE', 'readInt16BE', 'readInt16LE'][(type === 'h' ? 2 : 0) + (littleEndian ? 1 : 0)];
        for (let i = 0; i < repeat; i++) {
            vals.push(buf[fnName](ctx.offset));
            ctx.offset += 2;
        }
    }
    function packFromInt32(ctx) {
        const { buf, littleEndian, repeat, type, vals } = ctx;
        const fnName = ['writeUInt32BE', 'writeUInt32LE', 'writeInt32BE', 'writeInt32LE'][('il'.includes(type) ? 2 : 0) + (littleEndian ? 1 : 0)];
        for (let i = 0; i < repeat; i++) {
            if (vals.length === 0)
                throw new TypeError('Not enough vals');
            buf[fnName](_.toSafeInteger(vals.shift()), ctx.offset);
            ctx.offset += 4;
        }
    }
    function unpackToInt32(ctx) {
        const { buf, littleEndian, repeat, type, vals } = ctx;
        const fnName = ['readUInt32BE', 'readUInt32LE', 'readInt32BE', 'readInt32LE'][('il'.includes(type) ? 2 : 0) + (littleEndian ? 1 : 0)];
        for (let i = 0; i < repeat; i++) {
            vals.push(buf[fnName](ctx.offset));
            ctx.offset += 4;
        }
    }
    function packFromBigInt64(ctx) {
        const { buf, littleEndian, repeat, type, vals } = ctx;
        const fnName = ['writeBigUInt64BE', 'writeBigUInt64LE', 'writeBigInt64BE', 'writeBigInt64LE'][(type === 'q' ? 2 : 0) + (littleEndian ? 1 : 0)];
        for (let i = 0; i < repeat; i++) {
            if (vals.length === 0)
                throw new TypeError('Not enough vals');
            buf[fnName](BigInt(vals.shift()), ctx.offset);
            ctx.offset += 8;
        }
    }
    function unpackToBigInt64(ctx) {
        const { buf, littleEndian, repeat, type, vals } = ctx;
        const fnName = ['readBigUInt64BE', 'readBigUInt64LE', 'readBigInt64BE', 'readBigInt64LE'][(type === 'q' ? 2 : 0) + (littleEndian ? 1 : 0)];
        for (let i = 0; i < repeat; i++) {
            vals.push(buf[fnName](ctx.offset));
            ctx.offset += 8;
        }
    }
    function packFromFloat16(ctx) {
        const { buf, littleEndian, repeat, vals } = ctx;
        const fnName = littleEndian ? 'writeFloat16LE' : 'writeFloat16BE';
        for (let i = 0; i < repeat; i++) {
            if (vals.length === 0)
                throw new TypeError('Not enough vals');
            buf[fnName](vals.shift(), ctx.offset);
            ctx.offset += 2;
        }
    }
    function unpackToFloat16(ctx) {
        const { buf, littleEndian, repeat, vals } = ctx;
        const fnName = littleEndian ? 'readFloat16LE' : 'readFloat16BE';
        for (let i = 0; i < repeat; i++) {
            vals.push(buf[fnName](ctx.offset));
            ctx.offset += 2;
        }
    }
    function packFromFloat(ctx) {
        const { buf, littleEndian, repeat, vals } = ctx;
        const fnName = littleEndian ? 'writeFloatLE' : 'writeFloatBE';
        for (let i = 0; i < repeat; i++) {
            if (vals.length === 0)
                throw new TypeError('Not enough vals');
            buf[fnName](vals.shift(), ctx.offset);
            ctx.offset += 4;
        }
    }
    function unpackToFloat(ctx) {
        const { buf, littleEndian, repeat, vals } = ctx;
        const fnName = littleEndian ? 'readFloatLE' : 'readFloatBE';
        for (let i = 0; i < repeat; i++) {
            vals.push(buf[fnName](ctx.offset));
            ctx.offset += 4;
        }
    }
    function packFromDouble(ctx) {
        const { buf, littleEndian, repeat, vals } = ctx;
        const fnName = littleEndian ? 'writeDoubleLE' : 'writeDoubleBE';
        for (let i = 0; i < repeat; i++) {
            if (vals.length === 0)
                throw new TypeError('Not enough vals');
            buf[fnName](vals.shift(), ctx.offset);
            ctx.offset += 8;
        }
    }
    function unpackToDouble(ctx) {
        const { buf, littleEndian, repeat, vals } = ctx;
        const fnName = littleEndian ? 'readDoubleLE' : 'readDoubleBE';
        for (let i = 0; i < repeat; i++) {
            vals.push(buf[fnName](ctx.offset));
            ctx.offset += 8;
        }
    }
    function packFromString(ctx) {
        const { buf, repeat, vals } = ctx;
        if (vals.length === 0)
            throw new TypeError('Not enough vals');
        const val = vals.shift();
        const buf1 = new Buffer(repeat);
        Buffer.from(val).copy(buf1, 0, 0, repeat); // padded with null bytes
        buf1.copy(buf, ctx.offset);
        ctx.offset += buf1.length;
    }
    function unpackToString(ctx) {
        const { buf, repeat, vals } = ctx;
        vals.push(buf.subarray(ctx.offset, ctx.offset + repeat));
        ctx.offset += repeat;
    }
    function packFromPascal(ctx) {
        const { buf, repeat, vals } = ctx;
        if (vals.length === 0)
            throw new TypeError('Not enough vals');
        const val = vals.shift();
        const buf1 = new Buffer(repeat);
        buf1[0] = Buffer.from(val).copy(buf1, 1, 0, repeat - 1); // padded with null bytes
        buf1.copy(buf, ctx.offset);
        ctx.offset += buf1.length;
    }
    function unpackToPascal(ctx) {
        const { buf, repeat, vals } = ctx;
        const len = Math.min(buf[ctx.offset], repeat - 1);
        vals.push(buf.subarray(ctx.offset + 1, ctx.offset + 1 + len));
        ctx.offset += repeat;
    }

    var browser = {exports: {}};

    /**
     * Helpers.
     */

    var ms;
    var hasRequiredMs;

    function requireMs () {
    	if (hasRequiredMs) return ms;
    	hasRequiredMs = 1;
    	var s = 1000;
    	var m = s * 60;
    	var h = m * 60;
    	var d = h * 24;
    	var w = d * 7;
    	var y = d * 365.25;

    	/**
    	 * Parse or format the given `val`.
    	 *
    	 * Options:
    	 *
    	 *  - `long` verbose formatting [false]
    	 *
    	 * @param {String|Number} val
    	 * @param {Object} [options]
    	 * @throws {Error} throw an error if val is not a non-empty string or a number
    	 * @return {String|Number}
    	 * @api public
    	 */

    	ms = function(val, options) {
    	  options = options || {};
    	  var type = typeof val;
    	  if (type === 'string' && val.length > 0) {
    	    return parse(val);
    	  } else if (type === 'number' && isFinite(val)) {
    	    return options.long ? fmtLong(val) : fmtShort(val);
    	  }
    	  throw new Error(
    	    'val is not a non-empty string or a valid number. val=' +
    	      JSON.stringify(val)
    	  );
    	};

    	/**
    	 * Parse the given `str` and return milliseconds.
    	 *
    	 * @param {String} str
    	 * @return {Number}
    	 * @api private
    	 */

    	function parse(str) {
    	  str = String(str);
    	  if (str.length > 100) {
    	    return;
    	  }
    	  var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
    	    str
    	  );
    	  if (!match) {
    	    return;
    	  }
    	  var n = parseFloat(match[1]);
    	  var type = (match[2] || 'ms').toLowerCase();
    	  switch (type) {
    	    case 'years':
    	    case 'year':
    	    case 'yrs':
    	    case 'yr':
    	    case 'y':
    	      return n * y;
    	    case 'weeks':
    	    case 'week':
    	    case 'w':
    	      return n * w;
    	    case 'days':
    	    case 'day':
    	    case 'd':
    	      return n * d;
    	    case 'hours':
    	    case 'hour':
    	    case 'hrs':
    	    case 'hr':
    	    case 'h':
    	      return n * h;
    	    case 'minutes':
    	    case 'minute':
    	    case 'mins':
    	    case 'min':
    	    case 'm':
    	      return n * m;
    	    case 'seconds':
    	    case 'second':
    	    case 'secs':
    	    case 'sec':
    	    case 's':
    	      return n * s;
    	    case 'milliseconds':
    	    case 'millisecond':
    	    case 'msecs':
    	    case 'msec':
    	    case 'ms':
    	      return n;
    	    default:
    	      return undefined;
    	  }
    	}

    	/**
    	 * Short format for `ms`.
    	 *
    	 * @param {Number} ms
    	 * @return {String}
    	 * @api private
    	 */

    	function fmtShort(ms) {
    	  var msAbs = Math.abs(ms);
    	  if (msAbs >= d) {
    	    return Math.round(ms / d) + 'd';
    	  }
    	  if (msAbs >= h) {
    	    return Math.round(ms / h) + 'h';
    	  }
    	  if (msAbs >= m) {
    	    return Math.round(ms / m) + 'm';
    	  }
    	  if (msAbs >= s) {
    	    return Math.round(ms / s) + 's';
    	  }
    	  return ms + 'ms';
    	}

    	/**
    	 * Long format for `ms`.
    	 *
    	 * @param {Number} ms
    	 * @return {String}
    	 * @api private
    	 */

    	function fmtLong(ms) {
    	  var msAbs = Math.abs(ms);
    	  if (msAbs >= d) {
    	    return plural(ms, msAbs, d, 'day');
    	  }
    	  if (msAbs >= h) {
    	    return plural(ms, msAbs, h, 'hour');
    	  }
    	  if (msAbs >= m) {
    	    return plural(ms, msAbs, m, 'minute');
    	  }
    	  if (msAbs >= s) {
    	    return plural(ms, msAbs, s, 'second');
    	  }
    	  return ms + ' ms';
    	}

    	/**
    	 * Pluralization helper.
    	 */

    	function plural(ms, msAbs, n, name) {
    	  var isPlural = msAbs >= n * 1.5;
    	  return Math.round(ms / n) + ' ' + name + (isPlural ? 's' : '');
    	}
    	return ms;
    }

    /**
     * This is the common logic for both the Node.js and web browser
     * implementations of `debug()`.
     */

    function setup(env) {
    	createDebug.debug = createDebug;
    	createDebug.default = createDebug;
    	createDebug.coerce = coerce;
    	createDebug.disable = disable;
    	createDebug.enable = enable;
    	createDebug.enabled = enabled;
    	createDebug.humanize = requireMs();
    	createDebug.destroy = destroy;

    	Object.keys(env).forEach(key => {
    		createDebug[key] = env[key];
    	});

    	/**
    	* The currently active debug mode names, and names to skip.
    	*/

    	createDebug.names = [];
    	createDebug.skips = [];

    	/**
    	* Map of special "%n" handling functions, for the debug "format" argument.
    	*
    	* Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
    	*/
    	createDebug.formatters = {};

    	/**
    	* Selects a color for a debug namespace
    	* @param {String} namespace The namespace string for the debug instance to be colored
    	* @return {Number|String} An ANSI color code for the given namespace
    	* @api private
    	*/
    	function selectColor(namespace) {
    		let hash = 0;

    		for (let i = 0; i < namespace.length; i++) {
    			hash = ((hash << 5) - hash) + namespace.charCodeAt(i);
    			hash |= 0; // Convert to 32bit integer
    		}

    		return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
    	}
    	createDebug.selectColor = selectColor;

    	/**
    	* Create a debugger with the given `namespace`.
    	*
    	* @param {String} namespace
    	* @return {Function}
    	* @api public
    	*/
    	function createDebug(namespace) {
    		let prevTime;
    		let enableOverride = null;
    		let namespacesCache;
    		let enabledCache;

    		function debug(...args) {
    			// Disabled?
    			if (!debug.enabled) {
    				return;
    			}

    			const self = debug;

    			// Set `diff` timestamp
    			const curr = Number(new Date());
    			const ms = curr - (prevTime || curr);
    			self.diff = ms;
    			self.prev = prevTime;
    			self.curr = curr;
    			prevTime = curr;

    			args[0] = createDebug.coerce(args[0]);

    			if (typeof args[0] !== 'string') {
    				// Anything else let's inspect with %O
    				args.unshift('%O');
    			}

    			// Apply any `formatters` transformations
    			let index = 0;
    			args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
    				// If we encounter an escaped % then don't increase the array index
    				if (match === '%%') {
    					return '%';
    				}
    				index++;
    				const formatter = createDebug.formatters[format];
    				if (typeof formatter === 'function') {
    					const val = args[index];
    					match = formatter.call(self, val);

    					// Now we need to remove `args[index]` since it's inlined in the `format`
    					args.splice(index, 1);
    					index--;
    				}
    				return match;
    			});

    			// Apply env-specific formatting (colors, etc.)
    			createDebug.formatArgs.call(self, args);

    			const logFn = self.log || createDebug.log;
    			logFn.apply(self, args);
    		}

    		debug.namespace = namespace;
    		debug.useColors = createDebug.useColors();
    		debug.color = createDebug.selectColor(namespace);
    		debug.extend = extend;
    		debug.destroy = createDebug.destroy; // XXX Temporary. Will be removed in the next major release.

    		Object.defineProperty(debug, 'enabled', {
    			enumerable: true,
    			configurable: false,
    			get: () => {
    				if (enableOverride !== null) {
    					return enableOverride;
    				}
    				if (namespacesCache !== createDebug.namespaces) {
    					namespacesCache = createDebug.namespaces;
    					enabledCache = createDebug.enabled(namespace);
    				}

    				return enabledCache;
    			},
    			set: v => {
    				enableOverride = v;
    			}
    		});

    		// Env-specific initialization logic for debug instances
    		if (typeof createDebug.init === 'function') {
    			createDebug.init(debug);
    		}

    		return debug;
    	}

    	function extend(namespace, delimiter) {
    		const newDebug = createDebug(this.namespace + (typeof delimiter === 'undefined' ? ':' : delimiter) + namespace);
    		newDebug.log = this.log;
    		return newDebug;
    	}

    	/**
    	* Enables a debug mode by namespaces. This can include modes
    	* separated by a colon and wildcards.
    	*
    	* @param {String} namespaces
    	* @api public
    	*/
    	function enable(namespaces) {
    		createDebug.save(namespaces);
    		createDebug.namespaces = namespaces;

    		createDebug.names = [];
    		createDebug.skips = [];

    		let i;
    		const split = (typeof namespaces === 'string' ? namespaces : '').split(/[\s,]+/);
    		const len = split.length;

    		for (i = 0; i < len; i++) {
    			if (!split[i]) {
    				// ignore empty strings
    				continue;
    			}

    			namespaces = split[i].replace(/\*/g, '.*?');

    			if (namespaces[0] === '-') {
    				createDebug.skips.push(new RegExp('^' + namespaces.slice(1) + '$'));
    			} else {
    				createDebug.names.push(new RegExp('^' + namespaces + '$'));
    			}
    		}
    	}

    	/**
    	* Disable debug output.
    	*
    	* @return {String} namespaces
    	* @api public
    	*/
    	function disable() {
    		const namespaces = [
    			...createDebug.names.map(toNamespace),
    			...createDebug.skips.map(toNamespace).map(namespace => '-' + namespace)
    		].join(',');
    		createDebug.enable('');
    		return namespaces;
    	}

    	/**
    	* Returns true if the given mode name is enabled, false otherwise.
    	*
    	* @param {String} name
    	* @return {Boolean}
    	* @api public
    	*/
    	function enabled(name) {
    		if (name[name.length - 1] === '*') {
    			return true;
    		}

    		let i;
    		let len;

    		for (i = 0, len = createDebug.skips.length; i < len; i++) {
    			if (createDebug.skips[i].test(name)) {
    				return false;
    			}
    		}

    		for (i = 0, len = createDebug.names.length; i < len; i++) {
    			if (createDebug.names[i].test(name)) {
    				return true;
    			}
    		}

    		return false;
    	}

    	/**
    	* Convert regexp to namespace
    	*
    	* @param {RegExp} regxep
    	* @return {String} namespace
    	* @api private
    	*/
    	function toNamespace(regexp) {
    		return regexp.toString()
    			.substring(2, regexp.toString().length - 2)
    			.replace(/\.\*\?$/, '*');
    	}

    	/**
    	* Coerce `val`.
    	*
    	* @param {Mixed} val
    	* @return {Mixed}
    	* @api private
    	*/
    	function coerce(val) {
    		if (val instanceof Error) {
    			return val.stack || val.message;
    		}
    		return val;
    	}

    	/**
    	* XXX DO NOT USE. This is a temporary stub function.
    	* XXX It WILL be removed in the next major release.
    	*/
    	function destroy() {
    		console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
    	}

    	createDebug.enable(createDebug.load());

    	return createDebug;
    }

    var common = setup;

    /* eslint-env browser */

    (function (module, exports) {
    	/**
    	 * This is the web browser implementation of `debug()`.
    	 */

    	exports.formatArgs = formatArgs;
    	exports.save = save;
    	exports.load = load;
    	exports.useColors = useColors;
    	exports.storage = localstorage();
    	exports.destroy = (() => {
    		let warned = false;

    		return () => {
    			if (!warned) {
    				warned = true;
    				console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
    			}
    		};
    	})();

    	/**
    	 * Colors.
    	 */

    	exports.colors = [
    		'#0000CC',
    		'#0000FF',
    		'#0033CC',
    		'#0033FF',
    		'#0066CC',
    		'#0066FF',
    		'#0099CC',
    		'#0099FF',
    		'#00CC00',
    		'#00CC33',
    		'#00CC66',
    		'#00CC99',
    		'#00CCCC',
    		'#00CCFF',
    		'#3300CC',
    		'#3300FF',
    		'#3333CC',
    		'#3333FF',
    		'#3366CC',
    		'#3366FF',
    		'#3399CC',
    		'#3399FF',
    		'#33CC00',
    		'#33CC33',
    		'#33CC66',
    		'#33CC99',
    		'#33CCCC',
    		'#33CCFF',
    		'#6600CC',
    		'#6600FF',
    		'#6633CC',
    		'#6633FF',
    		'#66CC00',
    		'#66CC33',
    		'#9900CC',
    		'#9900FF',
    		'#9933CC',
    		'#9933FF',
    		'#99CC00',
    		'#99CC33',
    		'#CC0000',
    		'#CC0033',
    		'#CC0066',
    		'#CC0099',
    		'#CC00CC',
    		'#CC00FF',
    		'#CC3300',
    		'#CC3333',
    		'#CC3366',
    		'#CC3399',
    		'#CC33CC',
    		'#CC33FF',
    		'#CC6600',
    		'#CC6633',
    		'#CC9900',
    		'#CC9933',
    		'#CCCC00',
    		'#CCCC33',
    		'#FF0000',
    		'#FF0033',
    		'#FF0066',
    		'#FF0099',
    		'#FF00CC',
    		'#FF00FF',
    		'#FF3300',
    		'#FF3333',
    		'#FF3366',
    		'#FF3399',
    		'#FF33CC',
    		'#FF33FF',
    		'#FF6600',
    		'#FF6633',
    		'#FF9900',
    		'#FF9933',
    		'#FFCC00',
    		'#FFCC33'
    	];

    	/**
    	 * Currently only WebKit-based Web Inspectors, Firefox >= v31,
    	 * and the Firebug extension (any Firefox version) are known
    	 * to support "%c" CSS customizations.
    	 *
    	 * TODO: add a `localStorage` variable to explicitly enable/disable colors
    	 */

    	// eslint-disable-next-line complexity
    	function useColors() {
    		// NB: In an Electron preload script, document will be defined but not fully
    		// initialized. Since we know we're in Chrome, we'll just detect this case
    		// explicitly
    		if (typeof window !== 'undefined' && window.process && (window.process.type === 'renderer' || window.process.__nwjs)) {
    			return true;
    		}

    		// Internet Explorer and Edge do not support colors.
    		if (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
    			return false;
    		}

    		// Is webkit? http://stackoverflow.com/a/16459606/376773
    		// document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
    		return (typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance) ||
    			// Is firebug? http://stackoverflow.com/a/398120/376773
    			(typeof window !== 'undefined' && window.console && (window.console.firebug || (window.console.exception && window.console.table))) ||
    			// Is firefox >= v31?
    			// https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
    			(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31) ||
    			// Double check webkit in userAgent just in case we are in a worker
    			(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
    	}

    	/**
    	 * Colorize log arguments if enabled.
    	 *
    	 * @api public
    	 */

    	function formatArgs(args) {
    		args[0] = (this.useColors ? '%c' : '') +
    			this.namespace +
    			(this.useColors ? ' %c' : ' ') +
    			args[0] +
    			(this.useColors ? '%c ' : ' ') +
    			'+' + module.exports.humanize(this.diff);

    		if (!this.useColors) {
    			return;
    		}

    		const c = 'color: ' + this.color;
    		args.splice(1, 0, c, 'color: inherit');

    		// The final "%c" is somewhat tricky, because there could be other
    		// arguments passed either before or after the %c, so we need to
    		// figure out the correct index to insert the CSS into
    		let index = 0;
    		let lastC = 0;
    		args[0].replace(/%[a-zA-Z%]/g, match => {
    			if (match === '%%') {
    				return;
    			}
    			index++;
    			if (match === '%c') {
    				// We only are interested in the *last* %c
    				// (the user may have provided their own)
    				lastC = index;
    			}
    		});

    		args.splice(lastC, 0, c);
    	}

    	/**
    	 * Invokes `console.debug()` when available.
    	 * No-op when `console.debug` is not a "function".
    	 * If `console.debug` is not available, falls back
    	 * to `console.log`.
    	 *
    	 * @api public
    	 */
    	exports.log = console.debug || console.log || (() => {});

    	/**
    	 * Save `namespaces`.
    	 *
    	 * @param {String} namespaces
    	 * @api private
    	 */
    	function save(namespaces) {
    		try {
    			if (namespaces) {
    				exports.storage.setItem('debug', namespaces);
    			} else {
    				exports.storage.removeItem('debug');
    			}
    		} catch (error) {
    			// Swallow
    			// XXX (@Qix-) should we be logging these?
    		}
    	}

    	/**
    	 * Load `namespaces`.
    	 *
    	 * @return {String} returns the previously persisted debug modes
    	 * @api private
    	 */
    	function load() {
    		let r;
    		try {
    			r = exports.storage.getItem('debug');
    		} catch (error) {
    			// Swallow
    			// XXX (@Qix-) should we be logging these?
    		}

    		// If debug isn't set in LS, and we're in Electron, try to load $DEBUG
    		if (!r && typeof process !== 'undefined' && 'env' in process) {
    			r = process.env.DEBUG;
    		}

    		return r;
    	}

    	/**
    	 * Localstorage attempts to return the localstorage.
    	 *
    	 * This is necessary because safari throws
    	 * when a user disables cookies/localstorage
    	 * and you attempt to access it.
    	 *
    	 * @return {LocalStorage}
    	 * @api private
    	 */

    	function localstorage() {
    		try {
    			// TVMLKit (Apple TV JS Runtime) does not have a window object, just localStorage in the global context
    			// The Browser also has localStorage in the global context.
    			return localStorage;
    		} catch (error) {
    			// Swallow
    			// XXX (@Qix-) should we be logging these?
    		}
    	}

    	module.exports = common(exports);

    	const {formatters} = module.exports;

    	/**
    	 * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
    	 */

    	formatters.j = function (v) {
    		try {
    			return JSON.stringify(v);
    		} catch (error) {
    			return '[UnexpectedJSONParseError]: ' + error.message;
    		}
    	}; 
    } (browser, browser.exports));

    var browserExports = browser.exports;

    var MiddlewareStatus;
    (function (MiddlewareStatus) {
        MiddlewareStatus[MiddlewareStatus["PENDING"] = 0] = "PENDING";
        MiddlewareStatus[MiddlewareStatus["STARTED"] = 1] = "STARTED";
        MiddlewareStatus[MiddlewareStatus["FINISHED"] = 2] = "FINISHED";
        MiddlewareStatus[MiddlewareStatus["ERROR"] = 3] = "ERROR";
    })(MiddlewareStatus || (MiddlewareStatus = {}));
    function middlewareCompose(middlewares) {
        // 型態檢查
        if (!_.isArray(middlewares))
            throw new TypeError('Middleware stack must be an array!');
        if (_.some(middlewares, fn => !_.isFunction(fn)))
            throw new TypeError('Middleware must be composed of functions!');
        return async (context = {}, next) => {
            const cloned = [...middlewares, ...(_.isFunction(next) ? [next] : [])];
            if (cloned.length === 0)
                return;
            const executed = _.times(cloned.length + 1, () => MiddlewareStatus.PENDING);
            const dispatch = async (cur) => {
                if (executed[cur] !== MiddlewareStatus.PENDING)
                    throw new Error(`middleware[${cur}] called multiple times`);
                if (cur >= cloned.length) {
                    executed[cur] = MiddlewareStatus.FINISHED;
                    return;
                }
                try {
                    executed[cur] = MiddlewareStatus.STARTED;
                    const result = await cloned[cur](context, async () => await dispatch(cur + 1));
                    if (executed[cur + 1] === MiddlewareStatus.STARTED)
                        throw new Error(`next() in middleware[${cur}] should be awaited`);
                    executed[cur] = MiddlewareStatus.FINISHED;
                    return result;
                }
                catch (err) {
                    executed[cur] = MiddlewareStatus.ERROR;
                    if (_.isString(err.stack))
                        err.stack = err.stack.replace(/at async dispatch[^\n]+\n[^\n]+\n\s*/g, '');
                    throw err;
                }
            };
            return await dispatch(0);
        };
    }
    async function sleep(ms) {
        return new Promise(resolve => setTimeout(resolve, ms));
    }
    const ERROR_KEYS = [
        'address',
        'args',
        'code',
        'data',
        'dest',
        'errno',
        'info',
        'message',
        'name',
        'path',
        'port',
        'positions',
        'reason',
        'response.data',
        'response.headers',
        'response.status',
        'source',
        'stack',
        'status',
        'statusCode',
        'statusMessage',
        'syscall',
    ];
    function errToJson(err) {
        const tmp = {
            ..._.pick(err, ERROR_KEYS),
            ...(_.isNil(err.originalError) ? {} : { originalError: errToJson(err.originalError) }),
        };
        return tmp;
    }
    function versionCompare(str1, str2) {
        const tmp = _.map([str1, str2], (str, idx) => {
            const matched = _.trim(str).match(/^(?:(\d+)[.]?)?(?:(\d+)[.]?)?(?:(\d+)[.]?)?/);
            if (_.isNil(matched))
                throw new Error(`invalid version: str${idx + 1} = ${str}`);
            return _.map(matched.slice(1), v => _.isNil(v) ? 0 : _.toSafeInteger(v));
        });
        for (let i = 0; i < 3; i++) {
            if (tmp[0][i] > tmp[1][i])
                return 1;
            if (tmp[0][i] < tmp[1][i])
                return -1;
        }
        return 0;
    }

    function bufUnpackToClass(buf, format, Type) {
        return new Type(...buf.unpack(format));
    }
    class SlotInfo {
        hfTagType;
        lfTagType;
        constructor(hf, lf) {
            this.hfTagType = hf;
            this.lfTagType = lf;
        }
        static fromCmd1019(buf) {
            if (!Buffer.isBuffer(buf) || buf.length !== 32)
                throw new TypeError('buf should be a Buffer with length 32');
            return _.times(8, i => bufUnpackToClass(buf.subarray(i * 4), '!HH', SlotInfo));
        }
    }
    class SlotFreqIsEnable {
        hf;
        lf;
        constructor(hf, lf) {
            [this.hf, this.lf] = _.map([hf, lf], Boolean);
        }
        static fromCmd1023(buf) {
            if (!Buffer.isBuffer(buf) || buf.length !== 16)
                throw new TypeError('buf should be a Buffer with length 16');
            return _.times(8, i => bufUnpackToClass(buf.subarray(i * 2), '!??', SlotFreqIsEnable));
        }
    }
    class BatteryInfo {
        voltage;
        level;
        constructor(voltage, level) {
            [this.voltage, this.level] = [voltage, level];
        }
        static fromCmd1025(buf) {
            if (!Buffer.isBuffer(buf) || buf.length !== 3)
                throw new TypeError('buf should be a Buffer with length 3');
            return bufUnpackToClass(buf, '!HB', BatteryInfo);
        }
    }
    class DeviceSettings {
        version; // version of setting
        animation;
        buttonPressAction;
        buttonLongPressAction;
        blePairingMode;
        blePairingKey;
        constructor(version, animation, btnPressA, btnPressB, btnLongPressA, btnLongPressB, blePairingMode, blePairingKey) {
            this.version = version;
            this.animation = animation;
            this.buttonPressAction = [btnPressA, btnPressB];
            this.buttonLongPressAction = [btnLongPressA, btnLongPressB];
            this.blePairingMode = Boolean(blePairingMode);
            this.blePairingKey = blePairingKey;
        }
        static fromCmd1034(buf) {
            if (!Buffer.isBuffer(buf) || buf.length !== 13)
                throw new TypeError('buf should be a Buffer with length 13');
            return bufUnpackToClass(buf, '!6B?6s', DeviceSettings);
        }
    }
    /**
     * Class for Hf14aAntiColl Decoding.
     */
    class Hf14aAntiColl {
        uid;
        atqa;
        sak;
        ats;
        constructor(uid, atqa, sak, ats) {
            [this.uid, this.atqa, this.sak, this.ats] = [uid, atqa, sak, ats];
        }
        static fromBuffer(buf) {
            // uidlen[1]|uid[uidlen]|atqa[2]|sak[1]|atslen[1]|ats[atslen]
            const uidLen = buf[0];
            if (buf.length < uidLen + 4)
                throw new Error('invalid length of uid');
            const atsLen = buf[uidLen + 4];
            if (buf.length < uidLen + atsLen + 5)
                throw new Error('invalid invalid length of ats');
            return bufUnpackToClass(buf, `!${uidLen + 1}p2ss${atsLen + 1}p`, Hf14aAntiColl);
        }
        static fromCmd2000(buf) {
            if (!Buffer.isBuffer(buf))
                throw new TypeError('buf should be a Buffer');
            const tags = [];
            while (buf.length > 0) {
                const tag = Hf14aAntiColl.fromBuffer(buf);
                buf = buf.subarray(tag.uid.length + tag.ats.length + 5);
                tags.push(tag);
            }
            return tags;
        }
    }
    class Mf1AcquireStaticNestedRes {
        uid;
        atks;
        constructor(uid, atks) {
            [this.uid, this.atks] = [uid, atks];
        }
        static fromCmd2003(buf) {
            if (!Buffer.isBuffer(buf))
                throw new TypeError('buf should be a Buffer');
            return new Mf1AcquireStaticNestedRes(buf.subarray(0, 4), // uid
            _.map(buf.subarray(4).chunk(8), chunk => ({
                nt1: chunk.subarray(0, 4),
                nt2: chunk.subarray(4, 8),
            })));
        }
    }
    class Mf1DarksideRes {
        status;
        uid;
        nt;
        par;
        ks;
        nr;
        ar;
        constructor(status, uid, nt, par, ks, nr, ar) {
            this.status = status;
            this.uid = uid;
            this.nt = nt;
            this.par = par;
            this.ks = ks;
            this.nr = nr;
            this.ar = ar;
        }
        static fromCmd2004(buf) {
            if (!Buffer.isBuffer(buf) || !_.includes([1, 33], buf.length))
                throw new TypeError('buf should be a Buffer with length 1 or 33');
            return bufUnpackToClass(buf, buf.length === 1 ? '!B' : '!B4s4s8s8s4s4s', Mf1DarksideRes);
        }
    }
    class Mf1NtDistanceRes {
        uid;
        dist;
        constructor(uid, dist) {
            [this.uid, this.dist] = [uid, dist];
        }
        static fromCmd2005(buf) {
            if (!Buffer.isBuffer(buf) || buf.length !== 8)
                throw new TypeError('buf should be a Buffer with length 8');
            return bufUnpackToClass(buf, '!4s4s', Mf1NtDistanceRes);
        }
    }
    /** Answer the random number parameters required for Nested attack */
    class Mf1NestedRes {
        nt1; // Unblocked explicitly random number
        nt2; // Random number of nested verification encryption
        par; // The puppet test of the communication process of nested verification encryption, only the 'low 3 digits', that is, the right 3
        constructor(nt1, nt2, par) {
            [this.nt1, this.nt2, this.par] = [nt1, nt2, par];
        }
        static fromCmd2006(buf) {
            if (!Buffer.isBuffer(buf))
                throw new TypeError('buf should be a Buffer');
            return _.map(buf.chunk(9), chunk => bufUnpackToClass(chunk, '!4s4sB', Mf1NestedRes));
        }
    }
    class Mf1CheckKeysOfSectorsRes {
        found;
        sectorKeys;
        constructor(found, sectorKeys) {
            this.found = found;
            this.sectorKeys = _.times(80, i => found.readBitMSB(i) === 1 ? sectorKeys[i] : null);
        }
        static fromCmd2012(buf) {
            if (!Buffer.isBuffer(buf) || buf.length !== 490)
                throw new TypeError('buf should be a Buffer with length 490');
            return new Mf1CheckKeysOfSectorsRes(buf.subarray(0, 10), // found
            buf.subarray(10).chunk(6));
        }
    }
    class Mf1DetectionLog {
        block;
        isKeyB;
        isNested;
        uid;
        nt;
        nr;
        ar;
        constructor(block, flags, uid, nt, nr, ar) {
            this.block = block;
            this.isKeyB = flags.readBitLSB(0) === 1;
            this.isNested = flags.readBitLSB(1) === 1;
            this.uid = uid;
            this.nt = nt;
            this.nr = nr;
            this.ar = ar;
        }
        static fromBuffer(buf) {
            if (!Buffer.isBuffer(buf) || buf.length !== 18)
                throw new TypeError('buf should be a Buffer with length 18');
            return bufUnpackToClass(buf, '!Bs4s4s4s4s', Mf1DetectionLog);
        }
        static fromCmd4006(buf) {
            if (!Buffer.isBuffer(buf))
                throw new TypeError('buf should be a Buffer');
            return _.map(buf.chunk(18), Mf1DetectionLog.fromBuffer);
        }
    }
    class Mf1EmuSettings {
        detection;
        gen1a;
        gen2;
        antiColl;
        write;
        constructor(detection, gen1a, gen2, antiColl, write) {
            this.detection = detection;
            this.gen1a = gen1a;
            this.gen2 = gen2;
            this.antiColl = antiColl;
            this.write = write;
        }
        static fromCmd4009(buf) {
            if (!Buffer.isBuffer(buf) || buf.length !== 5)
                throw new TypeError('buf should be a Buffer with length 5');
            return bufUnpackToClass(buf, '!4?B', Mf1EmuSettings);
        }
    }

    function createIsEnum(e) {
        const ev = new Set(_.chain(e).toPairs().filter(([k, v]) => !_.isNumber(e[v])).map(1).value());
        return (val) => ev.has(val);
    }
    exports.AnimationMode = void 0;
    (function (AnimationMode) {
        AnimationMode[AnimationMode["FULL"] = 0] = "FULL";
        AnimationMode[AnimationMode["SHORT"] = 1] = "SHORT";
        AnimationMode[AnimationMode["NONE"] = 2] = "NONE";
    })(exports.AnimationMode || (exports.AnimationMode = {}));
    exports.ButtonAction = void 0;
    (function (ButtonAction) {
        /** No Function */
        ButtonAction[ButtonAction["DISABLE"] = 0] = "DISABLE";
        /** Select next slot */
        ButtonAction[ButtonAction["CYCLE_SLOT_INC"] = 1] = "CYCLE_SLOT_INC";
        /** Select previous slot */
        ButtonAction[ButtonAction["CYCLE_SLOT_DEC"] = 2] = "CYCLE_SLOT_DEC";
        /** Read then simulate the ID/UID card number */
        ButtonAction[ButtonAction["CLONE_IC_UID"] = 3] = "CLONE_IC_UID";
        /** Show Battery Level */
        ButtonAction[ButtonAction["BATTERY"] = 4] = "BATTERY";
    })(exports.ButtonAction || (exports.ButtonAction = {}));
    exports.ButtonType = void 0;
    (function (ButtonType) {
        ButtonType[ButtonType["BUTTON_A"] = 65] = "BUTTON_A";
        ButtonType[ButtonType["BUTTON_B"] = 66] = "BUTTON_B";
    })(exports.ButtonType || (exports.ButtonType = {}));
    exports.Cmd = void 0;
    (function (Cmd) {
        Cmd[Cmd["GET_APP_VERSION"] = 1000] = "GET_APP_VERSION";
        Cmd[Cmd["CHANGE_DEVICE_MODE"] = 1001] = "CHANGE_DEVICE_MODE";
        Cmd[Cmd["GET_DEVICE_MODE"] = 1002] = "GET_DEVICE_MODE";
        Cmd[Cmd["SET_ACTIVE_SLOT"] = 1003] = "SET_ACTIVE_SLOT";
        Cmd[Cmd["SET_SLOT_TAG_TYPE"] = 1004] = "SET_SLOT_TAG_TYPE";
        Cmd[Cmd["SET_SLOT_DATA_DEFAULT"] = 1005] = "SET_SLOT_DATA_DEFAULT";
        Cmd[Cmd["SET_SLOT_ENABLE"] = 1006] = "SET_SLOT_ENABLE";
        Cmd[Cmd["SET_SLOT_TAG_NICK"] = 1007] = "SET_SLOT_TAG_NICK";
        Cmd[Cmd["GET_SLOT_TAG_NICK"] = 1008] = "GET_SLOT_TAG_NICK";
        Cmd[Cmd["SLOT_DATA_CONFIG_SAVE"] = 1009] = "SLOT_DATA_CONFIG_SAVE";
        Cmd[Cmd["ENTER_BOOTLOADER"] = 1010] = "ENTER_BOOTLOADER";
        Cmd[Cmd["GET_DEVICE_CHIP_ID"] = 1011] = "GET_DEVICE_CHIP_ID";
        Cmd[Cmd["GET_DEVICE_ADDRESS"] = 1012] = "GET_DEVICE_ADDRESS";
        Cmd[Cmd["SAVE_SETTINGS"] = 1013] = "SAVE_SETTINGS";
        Cmd[Cmd["RESET_SETTINGS"] = 1014] = "RESET_SETTINGS";
        Cmd[Cmd["SET_ANIMATION_MODE"] = 1015] = "SET_ANIMATION_MODE";
        Cmd[Cmd["GET_ANIMATION_MODE"] = 1016] = "GET_ANIMATION_MODE";
        Cmd[Cmd["GET_GIT_VERSION"] = 1017] = "GET_GIT_VERSION";
        Cmd[Cmd["GET_ACTIVE_SLOT"] = 1018] = "GET_ACTIVE_SLOT";
        Cmd[Cmd["GET_SLOT_INFO"] = 1019] = "GET_SLOT_INFO";
        Cmd[Cmd["WIPE_FDS"] = 1020] = "WIPE_FDS";
        Cmd[Cmd["DELETE_SLOT_TAG_NICK"] = 1021] = "DELETE_SLOT_TAG_NICK";
        Cmd[Cmd["GET_ENABLED_SLOTS"] = 1023] = "GET_ENABLED_SLOTS";
        Cmd[Cmd["DELETE_SLOT_SENSE_TYPE"] = 1024] = "DELETE_SLOT_SENSE_TYPE";
        Cmd[Cmd["GET_BATTERY_INFO"] = 1025] = "GET_BATTERY_INFO";
        Cmd[Cmd["GET_BUTTON_PRESS_CONFIG"] = 1026] = "GET_BUTTON_PRESS_CONFIG";
        Cmd[Cmd["SET_BUTTON_PRESS_CONFIG"] = 1027] = "SET_BUTTON_PRESS_CONFIG";
        Cmd[Cmd["GET_LONG_BUTTON_PRESS_CONFIG"] = 1028] = "GET_LONG_BUTTON_PRESS_CONFIG";
        Cmd[Cmd["SET_LONG_BUTTON_PRESS_CONFIG"] = 1029] = "SET_LONG_BUTTON_PRESS_CONFIG";
        Cmd[Cmd["SET_BLE_PAIRING_KEY"] = 1030] = "SET_BLE_PAIRING_KEY";
        Cmd[Cmd["GET_BLE_PAIRING_KEY"] = 1031] = "GET_BLE_PAIRING_KEY";
        Cmd[Cmd["DELETE_ALL_BLE_BONDS"] = 1032] = "DELETE_ALL_BLE_BONDS";
        Cmd[Cmd["GET_DEVICE_MODEL"] = 1033] = "GET_DEVICE_MODEL";
        Cmd[Cmd["GET_DEVICE_SETTINGS"] = 1034] = "GET_DEVICE_SETTINGS";
        Cmd[Cmd["GET_DEVICE_CAPABILITIES"] = 1035] = "GET_DEVICE_CAPABILITIES";
        Cmd[Cmd["GET_BLE_PAIRING_ENABLE"] = 1036] = "GET_BLE_PAIRING_ENABLE";
        Cmd[Cmd["SET_BLE_PAIRING_ENABLE"] = 1037] = "SET_BLE_PAIRING_ENABLE";
        Cmd[Cmd["HF14A_SCAN"] = 2000] = "HF14A_SCAN";
        Cmd[Cmd["MF1_DETECT_SUPPORT"] = 2001] = "MF1_DETECT_SUPPORT";
        Cmd[Cmd["MF1_DETECT_NT_LEVEL"] = 2002] = "MF1_DETECT_NT_LEVEL";
        Cmd[Cmd["MF1_STATIC_NESTED_ACQUIRE"] = 2003] = "MF1_STATIC_NESTED_ACQUIRE";
        Cmd[Cmd["MF1_DARKSIDE_ACQUIRE"] = 2004] = "MF1_DARKSIDE_ACQUIRE";
        Cmd[Cmd["MF1_DETECT_NT_DIST"] = 2005] = "MF1_DETECT_NT_DIST";
        Cmd[Cmd["MF1_NESTED_ACQUIRE"] = 2006] = "MF1_NESTED_ACQUIRE";
        Cmd[Cmd["MF1_AUTH_ONE_KEY_BLOCK"] = 2007] = "MF1_AUTH_ONE_KEY_BLOCK";
        Cmd[Cmd["MF1_READ_ONE_BLOCK"] = 2008] = "MF1_READ_ONE_BLOCK";
        Cmd[Cmd["MF1_WRITE_ONE_BLOCK"] = 2009] = "MF1_WRITE_ONE_BLOCK";
        Cmd[Cmd["HF14A_RAW"] = 2010] = "HF14A_RAW";
        Cmd[Cmd["MF1_MANIPULATE_VALUE_BLOCK"] = 2011] = "MF1_MANIPULATE_VALUE_BLOCK";
        Cmd[Cmd["MF1_CHECK_KEYS_OF_SECTORS"] = 2012] = "MF1_CHECK_KEYS_OF_SECTORS";
        Cmd[Cmd["EM410X_SCAN"] = 3000] = "EM410X_SCAN";
        Cmd[Cmd["EM410X_WRITE_TO_T55XX"] = 3001] = "EM410X_WRITE_TO_T55XX";
        Cmd[Cmd["MF1_WRITE_EMU_BLOCK_DATA"] = 4000] = "MF1_WRITE_EMU_BLOCK_DATA";
        Cmd[Cmd["HF14A_SET_ANTI_COLL_DATA"] = 4001] = "HF14A_SET_ANTI_COLL_DATA";
        Cmd[Cmd["MF1_SET_ANTI_COLLISION_INFO"] = 4002] = "MF1_SET_ANTI_COLLISION_INFO";
        Cmd[Cmd["MF1_SET_ATS_RESOURCE"] = 4003] = "MF1_SET_ATS_RESOURCE";
        Cmd[Cmd["MF1_SET_DETECTION_ENABLE"] = 4004] = "MF1_SET_DETECTION_ENABLE";
        Cmd[Cmd["MF1_GET_DETECTION_COUNT"] = 4005] = "MF1_GET_DETECTION_COUNT";
        Cmd[Cmd["MF1_GET_DETECTION_LOG"] = 4006] = "MF1_GET_DETECTION_LOG";
        Cmd[Cmd["MF1_GET_DETECTION_ENABLE"] = 4007] = "MF1_GET_DETECTION_ENABLE";
        Cmd[Cmd["MF1_READ_EMU_BLOCK_DATA"] = 4008] = "MF1_READ_EMU_BLOCK_DATA";
        Cmd[Cmd["MF1_GET_EMULATOR_CONFIG"] = 4009] = "MF1_GET_EMULATOR_CONFIG";
        Cmd[Cmd["MF1_GET_GEN1A_MODE"] = 4010] = "MF1_GET_GEN1A_MODE";
        Cmd[Cmd["MF1_SET_GEN1A_MODE"] = 4011] = "MF1_SET_GEN1A_MODE";
        Cmd[Cmd["MF1_GET_GEN2_MODE"] = 4012] = "MF1_GET_GEN2_MODE";
        Cmd[Cmd["MF1_SET_GEN2_MODE"] = 4013] = "MF1_SET_GEN2_MODE";
        Cmd[Cmd["HF14A_GET_BLOCK_ANTI_COLL_MODE"] = 4014] = "HF14A_GET_BLOCK_ANTI_COLL_MODE";
        Cmd[Cmd["HF14A_SET_BLOCK_ANTI_COLL_MODE"] = 4015] = "HF14A_SET_BLOCK_ANTI_COLL_MODE";
        Cmd[Cmd["MF1_GET_WRITE_MODE"] = 4016] = "MF1_GET_WRITE_MODE";
        Cmd[Cmd["MF1_SET_WRITE_MODE"] = 4017] = "MF1_SET_WRITE_MODE";
        Cmd[Cmd["HF14A_GET_ANTI_COLL_DATA"] = 4018] = "HF14A_GET_ANTI_COLL_DATA";
        Cmd[Cmd["EM410X_SET_EMU_ID"] = 5000] = "EM410X_SET_EMU_ID";
        Cmd[Cmd["EM410X_GET_EMU_ID"] = 5001] = "EM410X_GET_EMU_ID";
    })(exports.Cmd || (exports.Cmd = {}));
    exports.DarksideStatus = void 0;
    (function (DarksideStatus) {
        /** normal process */
        DarksideStatus[DarksideStatus["OK"] = 0] = "OK";
        /** the random number cannot be fixed, this situation may appear on some UID card */
        DarksideStatus[DarksideStatus["CANT_FIX_NT"] = 1] = "CANT_FIX_NT";
        /** the direct authentification is successful, maybe the key is just the default one */
        DarksideStatus[DarksideStatus["LUCKY_AUTH_OK"] = 2] = "LUCKY_AUTH_OK";
        /** the card does not respond to NACK, it may be a card that fixes Nack logic vulnerabilities */
        DarksideStatus[DarksideStatus["NO_NAK_SENT"] = 3] = "NO_NAK_SENT";
        /** card change while running DARKSIDE */
        DarksideStatus[DarksideStatus["TAG_CHANGED"] = 4] = "TAG_CHANGED";
    })(exports.DarksideStatus || (exports.DarksideStatus = {}));
    exports.DeviceMode = void 0;
    (function (DeviceMode) {
        DeviceMode[DeviceMode["TAG"] = 0] = "TAG";
        DeviceMode[DeviceMode["READER"] = 1] = "READER";
    })(exports.DeviceMode || (exports.DeviceMode = {}));
    exports.DeviceModel = void 0;
    (function (DeviceModel) {
        DeviceModel[DeviceModel["ULTRA"] = 0] = "ULTRA";
        DeviceModel[DeviceModel["LITE"] = 1] = "LITE";
    })(exports.DeviceModel || (exports.DeviceModel = {}));
    exports.FreqType = void 0;
    (function (FreqType) {
        /** No Freq */
        FreqType[FreqType["NONE"] = 0] = "NONE";
        /** Low Freq: 125 kHz */
        FreqType[FreqType["LF"] = 1] = "LF";
        /** High Freq: 13.56 MHz */
        FreqType[FreqType["HF"] = 2] = "HF";
    })(exports.FreqType || (exports.FreqType = {}));
    exports.Mf1EmuWriteMode = void 0;
    (function (Mf1EmuWriteMode) {
        /** Normal write as standard mifare */
        Mf1EmuWriteMode[Mf1EmuWriteMode["NORMAL"] = 0] = "NORMAL";
        /** Send NACK to write attempts */
        Mf1EmuWriteMode[Mf1EmuWriteMode["DENIED"] = 1] = "DENIED";
        /** Acknowledge writes, but don't remember contents */
        Mf1EmuWriteMode[Mf1EmuWriteMode["DECEIVE"] = 2] = "DECEIVE";
        /** Store data to RAM, but not save to persistent storage */
        Mf1EmuWriteMode[Mf1EmuWriteMode["SHADOW"] = 3] = "SHADOW";
        /** Shadow requested, will be changed to SHADOW and stored to ROM */
        Mf1EmuWriteMode[Mf1EmuWriteMode["SHADOW_REQ"] = 4] = "SHADOW_REQ";
    })(exports.Mf1EmuWriteMode || (exports.Mf1EmuWriteMode = {}));
    exports.Mf1KeyType = void 0;
    (function (Mf1KeyType) {
        Mf1KeyType[Mf1KeyType["KEY_A"] = 96] = "KEY_A";
        Mf1KeyType[Mf1KeyType["KEY_B"] = 97] = "KEY_B";
    })(exports.Mf1KeyType || (exports.Mf1KeyType = {}));
    exports.Mf1PrngType = void 0;
    (function (Mf1PrngType) {
        /** StaticNested: the random number of the card response is fixed */
        Mf1PrngType[Mf1PrngType["STATIC"] = 0] = "STATIC";
        /** Nested: the random number of the card response is weak */
        Mf1PrngType[Mf1PrngType["WEAK"] = 1] = "WEAK";
        /** HardNested: the random number of the card response is unpredictable */
        Mf1PrngType[Mf1PrngType["HARD"] = 2] = "HARD";
    })(exports.Mf1PrngType || (exports.Mf1PrngType = {}));
    /**
     * Operators of mifare classic value block manipulation.
     */
    exports.Mf1VblockOperator = void 0;
    (function (Mf1VblockOperator) {
        /** decrement value by X (0 ~ 2147483647) from src to dst */
        Mf1VblockOperator[Mf1VblockOperator["DECREMENT"] = 192] = "DECREMENT";
        /** increment value by X (0 ~ 2147483647) from src to dst */
        Mf1VblockOperator[Mf1VblockOperator["INCREMENT"] = 193] = "INCREMENT";
        /** copy value from src to dst (Restore and Transfer) */
        Mf1VblockOperator[Mf1VblockOperator["RESTORE"] = 194] = "RESTORE";
    })(exports.Mf1VblockOperator || (exports.Mf1VblockOperator = {}));
    var RespStatus;
    (function (RespStatus) {
        /** IC card operation is successful */
        RespStatus[RespStatus["HF_TAG_OK"] = 0] = "HF_TAG_OK";
        /** IC card not found */
        RespStatus[RespStatus["HF_TAG_NOT_FOUND"] = 1] = "HF_TAG_NOT_FOUND";
        /** Abnormal IC card status */
        RespStatus[RespStatus["HF_ERR_STAT"] = 2] = "HF_ERR_STAT";
        /** IC card communication verification abnormal */
        RespStatus[RespStatus["HF_ERR_CRC"] = 3] = "HF_ERR_CRC";
        /** IC card conflict */
        RespStatus[RespStatus["HF_COLLISION"] = 4] = "HF_COLLISION";
        /** IC card BCC error */
        RespStatus[RespStatus["HF_ERR_BCC"] = 5] = "HF_ERR_BCC";
        /** MF card verification failed */
        RespStatus[RespStatus["MF_ERR_AUTH"] = 6] = "MF_ERR_AUTH";
        /** IC card parity error */
        RespStatus[RespStatus["HF_ERR_PARITY"] = 7] = "HF_ERR_PARITY";
        /** ATS should be present but card NAKed, or ATS too large */
        RespStatus[RespStatus["HF_ERR_ATS"] = 8] = "HF_ERR_ATS";
        /** LF tag operation is successful */
        RespStatus[RespStatus["LF_TAG_OK"] = 64] = "LF_TAG_OK";
        /** EM410X tag not found error */
        RespStatus[RespStatus["EM410X_TAG_NOT_FOUND"] = 65] = "EM410X_TAG_NOT_FOUND";
        /** Invalid param error */
        RespStatus[RespStatus["PAR_ERR"] = 96] = "PAR_ERR";
        /** Wrong device mode error */
        RespStatus[RespStatus["DEVICE_MODE_ERROR"] = 102] = "DEVICE_MODE_ERROR";
        /** invalid cmd error */
        RespStatus[RespStatus["INVALID_CMD"] = 103] = "INVALID_CMD";
        /** Device operation succeeded */
        RespStatus[RespStatus["DEVICE_SUCCESS"] = 104] = "DEVICE_SUCCESS";
        /** Not implemented error */
        RespStatus[RespStatus["NOT_IMPLEMENTED"] = 105] = "NOT_IMPLEMENTED";
        /** Flash write failed */
        RespStatus[RespStatus["FLASH_WRITE_FAIL"] = 112] = "FLASH_WRITE_FAIL";
        /** Flash read failed */
        RespStatus[RespStatus["FLASH_READ_FAIL"] = 113] = "FLASH_READ_FAIL";
    })(RespStatus || (RespStatus = {}));
    exports.Slot = void 0;
    (function (Slot) {
        Slot[Slot["SLOT_1"] = 0] = "SLOT_1";
        Slot[Slot["SLOT_2"] = 1] = "SLOT_2";
        Slot[Slot["SLOT_3"] = 2] = "SLOT_3";
        Slot[Slot["SLOT_4"] = 3] = "SLOT_4";
        Slot[Slot["SLOT_5"] = 4] = "SLOT_5";
        Slot[Slot["SLOT_6"] = 5] = "SLOT_6";
        Slot[Slot["SLOT_7"] = 6] = "SLOT_7";
        Slot[Slot["SLOT_8"] = 7] = "SLOT_8";
    })(exports.Slot || (exports.Slot = {}));
    exports.TagType = void 0;
    (function (TagType) {
        // 特定的且必須存在的標誌不存在的類型
        TagType[TagType["UNDEFINED"] = 0] = "UNDEFINED";
        // 1xx: ASK Tag-Talk-First
        TagType[TagType["EM410X"] = 100] = "EM410X";
        // 2xx: FSK Tag-Talk-First
        // 3xx: PSK Tag-Talk-First
        // 4xx: Reader-Talk-First
        TagType[TagType["LF_END"] = 999] = "LF_END";
        // 10xx: MIFARE Classic series
        TagType[TagType["MIFARE_Mini"] = 1000] = "MIFARE_Mini";
        TagType[TagType["MIFARE_1024"] = 1001] = "MIFARE_1024";
        TagType[TagType["MIFARE_2048"] = 1002] = "MIFARE_2048";
        TagType[TagType["MIFARE_4096"] = 1003] = "MIFARE_4096";
        // 11xx: MFUL / NTAG series
        TagType[TagType["NTAG_213"] = 1100] = "NTAG_213";
        TagType[TagType["NTAG_215"] = 1101] = "NTAG_215";
        TagType[TagType["NTAG_216"] = 1102] = "NTAG_216";
        // 12xx: MIFARE Plus series
        // 13xx: DESFire series
        // 14xx: ST25TA series
        // 15xx: HF14A-4 series
    })(exports.TagType || (exports.TagType = {}));
    const isAnimationMode = createIsEnum(exports.AnimationMode);
    const isButtonAction = createIsEnum(exports.ButtonAction);
    const isButtonType = createIsEnum(exports.ButtonType);
    createIsEnum(exports.Cmd);
    createIsEnum(exports.DarksideStatus);
    const isDeviceMode = createIsEnum(exports.DeviceMode);
    createIsEnum(exports.DeviceModel);
    createIsEnum(exports.FreqType);
    const isMf1EmuWriteMode = createIsEnum(exports.Mf1EmuWriteMode);
    const isMf1KeyType = createIsEnum(exports.Mf1KeyType);
    createIsEnum(exports.Mf1PrngType);
    const isMf1VblockOperator = createIsEnum(exports.Mf1VblockOperator);
    createIsEnum(RespStatus);
    const isSlot = createIsEnum(exports.Slot);
    const isTagType = createIsEnum(exports.TagType);
    const isValidFreqType = createIsEnum(_.pick(exports.FreqType, ['HF', 'LF']));

    const READ_DEFAULT_TIMEOUT = 5e3;
    const START_OF_FRAME = new Buffer(2).writeUInt16BE(0x11EF);
    const VERSION_SUPPORTED = { gte: '2.0', lt: '3.0' };
    function isMf1BlockNo(block) {
        return _.isInteger(block) && block >= 0 && block <= 0xFF;
    }
    function validateMf1BlockKey(block, keyType, key, prefix = '') {
        if (!isMf1BlockNo(block))
            throw new TypeError(`${prefix}block should be a integer`);
        if (!isMf1KeyType(keyType))
            throw new TypeError(`${prefix}keyType should be a Mf1KeyType`);
        if (!Buffer.isBuffer(key) || key.length !== 6)
            throw new TypeError(`${prefix}key should be a Buffer(6)`);
    }
    /**
     * The core library of "chameleon-ultra.js". The instance of this class must use exactly one adapter plugin to communication to ChameleonUltra.
     */
    class ChameleonUltra {
        /**
         * @internal
         * @group Internal
         */
        debug;
        /**
         * @internal
         * @group Internal
         */
        hooks;
        /**
         * @internal
         * @group Internal
         */
        isConnecting = false;
        /**
         * @internal
         * @group Internal
         */
        isDisconnecting = false;
        /**
         * @internal
         * @group Internal
         */
        logger = {};
        /**
         * @internal
         * @group Internal
         */
        plugins;
        /**
         * @internal
         * @group Internal
         */
        port;
        /**
         * @internal
         * @group Internal
         */
        rxSink;
        /**
         * @internal
         * @group Internal
         */
        supportedCmds = new Set();
        /**
         * @internal
         * @group Internal
         */
        deviceMode = null;
        /**
         * The supported version of SDK.
         * @group Device Related
         */
        static VERSION_SUPPORTED = VERSION_SUPPORTED;
        /**
         * Create a new instance of ChameleonUltra.
         * @param debug - Enable debug mode.
         * @example
         * Example usage in Browser (place at the end of body):
         *
         * ```html
         * <script src="https://cdn.jsdelivr.net/npm/chameleon-ultra.js@0/dist/iife/index.min.js"></script>
         * <script src="https://cdn.jsdelivr.net/npm/chameleon-ultra.js@0/dist/iife/plugin/WebbleAdapter.min.js"></script>
         * <script src="https://cdn.jsdelivr.net/npm/chameleon-ultra.js@0/dist/iife/plugin/WebserialAdapter.min.js"></script>
         * <script>
         *   const { ChameleonUltra, WebbleAdapter, WebserialAdapter } = ChameleonUltraJS
         *
         *   const ultraUsb = new ChameleonUltra()
         *   ultraUsb.use(new WebserialAdapter())
         *
         *   const ultraBle = new ChameleonUltra()
         *   ultraBle.use(new WebbleAdapter())
         * </script>
         * ```
         *
         * Example usage in CommonJS:
         *
         * ```js
         * const { ChameleonUltra } = require('chameleon-ultra.js')
         * const WebbleAdapter = require('chameleon-ultra.js/plugin/WebbleAdapter')
         * const WebserialAdapter = require('chameleon-ultra.js/plugin/WebserialAdapter')
         * const SerialPortAdapter = require('chameleon-ultra.js/plugin/SerialPortAdapter')
         *
         * const ultraUsb = new ChameleonUltra()
         * ultraUsb.use(new WebserialAdapter())
         *
         * const ultraBle = new ChameleonUltra()
         * ultraBle.use(new WebbleAdapter())
         *
         * const ultraNode = new ChameleonUltra()
         * ultraNode.use(new SerialPortAdapter())
         * ```
         *
         * Example usage in ESM:
         *
         * ```js
         * import { ChameleonUltra } from 'chameleon-ultra.js'
         * import WebbleAdapter from 'chameleon-ultra.js/plugin/WebbleAdapter'
         * import WebserialAdapter from 'chameleon-ultra.js/plugin/WebserialAdapter'
         * import SerialPortAdapter from 'chameleon-ultra.js/plugin/SerialPortAdapter'
         *
         * const ultraUsb = new ChameleonUltra()
         * ultraUsb.use(new WebserialAdapter())
         *
         * const ultraBle = new ChameleonUltra()
         * ultraBle.use(new WebbleAdapter())
         *
         * const ultraNode = new ChameleonUltra()
         * ultraNode.use(new SerialPortAdapter())
         * ```
         */
        constructor(debug = false) {
            this.hooks = {};
            this.plugins = new Map();
            this.debug = debug;
            _.extend(this.logger, {
                core: this.createDebugger('core'),
                resp: this.createDebugger('resp'),
                respError: this.createDebugger('respError'),
                send: this.createDebugger('send'),
            });
        }
        /**
         * @internal
         * @group Plugin Related
         */
        createDebugger(name) {
            if (!this.debug)
                return (...args) => { };
            return browserExports.debug(`ultra:${name}`);
        }
        /**
         * Register a plugin.
         * @param plugin - The plugin to register.
         * @param option - The option to pass to plugin.install().
         * @group Plugin Related
         */
        async use(plugin, option) {
            const pluginId = `$${plugin.name}`;
            const installResp = await plugin.install({ Buffer, ultra: this }, option);
            if (!_.isNil(installResp))
                this[pluginId] = installResp;
            return this;
        }
        /**
         * Register a hook.
         * @param hook - The hook name.
         * @param fn - The function to register.
         * @group Plugin Related
         */
        addHook(hook, fn) {
            if (!_.isArray(this.hooks[hook]))
                this.hooks[hook] = [];
            this.hooks[hook].push(fn);
            return this;
        }
        /**
         * Invoke a hook with context.
         * @param hook - The hook name.
         * @param ctx - The context will be passed to every middleware.
         * @param next - The next middleware function.
         * @returns The return value depent on the middlewares
         * @group Plugin Related
         */
        async invokeHook(hook, ctx = {}, next) {
            ctx.me = this;
            return await middlewareCompose(this.hooks[hook] ?? [])(ctx, next);
        }
        /**
         * Connect to ChameleonUltra. This method will be called automatically when you call any command.
         * @group Connection Related
         */
        async connect() {
			if (this.isConnecting){				
				throw new Error('device is connecting');
			}
			
			this.isConnecting = true; // 避免重複執行
            await this.invokeHook('connect', {}, async (ctx, next) => {
                try {
					
				
                    if (_.isNil(this.port))
                        throw new Error('this.port is undefined. Did you remember to use adapter plugin?');
                    // serial.readable pipeTo this.rxSink
                    this.rxSink = new ChameleonRxSink();
                    void this.port.readable.pipeTo(new web.WritableStream(this.rxSink), {
                        signal: this.rxSink.signal,
                    }).catch(async (err) => {
                        if (err.message === 'disconnect()')
                            return; // disconnected by invoke disconnect()
                        await this.disconnect(_.merge(new Error(`Failed to read resp: ${err.message}`), { originalError: err }));
                    });
                    this.logger.core('chameleon connected');
                }
                catch (err) {
                    this.logger.core(`Failed to connect: ${err.message}`);
                    if (this.isConnected())
                        await this.disconnect(err);
                    throw _.merge(new Error(err.message ?? 'Failed to connect'), { originalError: err });
                }
            finally {
                this.isConnecting = false;
            }
            });
        }
        /**
         * Disconnect ChameleonUltra.
         * @group Connection Related
         */
        async disconnect(err = new Error('disconnect()')) {
            try {
                if (this.isDisconnecting)
                    return;
                this.logger.core('%s %O', err.message, errToJson(err));
                this.isDisconnecting = true; // 避免重複執行
                await this.invokeHook('disconnect', { err }, async (ctx, next) => {
                    try {
                        // clean up
                        this.deviceMode = null;
                        this.supportedCmds.clear();
                        // close port
                        this.rxSink?.controller.abort(err);
                        while (this.port?.readable?.locked === true)
                            await sleep(10);
                        await this.port?.readable?.cancel(err);
                        await this.port?.writable?.close();
                        delete this.port;
                    }
                    catch (err) {
                        throw _.merge(new Error(err.message ?? 'Failed to disconnect'), { originalError: err });
                    }
                });
            }
            finally {
                this.isDisconnecting = false;
                this.isConnecting = false;
            }
        }
        /**
         * Return true if ChameleonUltra is connected.
         * @group Connection Related
         */
        isConnected() {
            return this?.port?.isOpen?.() ?? false;
        }
        /**
         * Calculate the LRC byte of a buffer.
         * @internal
         * @group Internal
         */
        _calcLrc(buf) {
            return 0x100 - _.sum(buf) & 0xFF;
        }
        /**
         * Send a buffer to device.
         * @param buf - The buffer to be sent to device.
         * @internal
         * @group Internal
         */
        async _writeBuffer(buf) {
            await this.invokeHook('_writeBuffer', { buf }, async (ctx, next) => {
			
                try {
                    if (!Buffer.isBuffer(ctx.buf))
                        throw new TypeError('buf should be a Buffer');
                    if (!this.isConnected())
                        await this.connect();
                    this.logger.send(ChameleonUltraFrame.inspect(ctx.buf));
                    const writer = this.port?.writable?.getWriter();
                    if (_.isNil(writer))
                        throw new Error('Failed to getWriter(). Did you remember to use adapter plugin?');
                    await writer.write(ctx.buf);
                    writer.releaseLock();
                }
                catch (err) {
                    throw _.merge(new Error(err.message ?? 'Failed to connect'), { originalError: err });
                }
            });
        }
        /**
         * Send a command to device.
         * @param opts.cmd - The command to be sent to device.
         * @param opts.status - The status is always `0x0000`.
         * @param opts.data - `<= 512 bytes`, the data to be sent. This payload depends on the exact command being used. See [Packet payloads](https://github.com/RfidResearchGroup/ChameleonUltra/blob/main/docs/protocol.md#packet-payloads) for more infomation.
         * @internal
         * @group Internal
         */
        async _writeCmd(opts) {
            const { cmd, status = 0, data = Buffer.allocUnsafe(0) } = opts;
            const buf = Buffer.allocUnsafe(data.length + 10);
            START_OF_FRAME.copy(buf, 0); // SOF + SOF LRC Byte
            // head info
            buf.writeUInt16BE(cmd, 2);
            buf.writeUInt16BE(status, 4);
            buf.writeUInt16BE(data.length, 6);
            buf[8] = this._calcLrc(buf.subarray(2, 8)); // head lrc byte
            // data
            if (data.length > 0)
                data.copy(buf, 9);
            // lrc byte of buf
            buf[buf.length - 1] = this._calcLrc(buf.subarray(9, -1));
            await this._writeBuffer(buf);
        }
        /**
         * Return the buffers in rxSink and clear rxSink.
         * @returns The buffers in rxSink.
         * @internal
         * @group Internal
         */
        _clearRxBufs() {
            return this.rxSink?.bufs.splice(0, this.rxSink.bufs.length) ?? [];
        }
        /**
         * Read a response from device.
         * @param timeout - The timeout in milliseconds.
         * @internal
         * @group Internal
         */
        async _readRespTimeout({ cmd, timeout } = {}) {
            return await this.invokeHook('_readRespTimeout', { timeout }, async (ctx, next) => {
                if (!this.isConnected())
                    await this.connect();
                if (_.isNil(this.rxSink))
                    throw new Error('rxSink is undefined');
                ctx.timeout = ctx.timeout ?? READ_DEFAULT_TIMEOUT;
                ctx.startedAt = Date.now();
                while (true) {
                    if (!this.isConnected())
                        throw new Error('device disconnected');
                    ctx.nowts = Date.now();
                    if (ctx.nowts > ctx.startedAt + ctx.timeout)
                        throw new Error(`readRespTimeout ${ctx.timeout}ms`);
                    let buf = Buffer.concat(this._clearRxBufs());
                    try {
                        const sofIdx = buf.indexOf(START_OF_FRAME);
                        if (sofIdx < 0)
                            throw new Error('SOF not found');
                        else if (sofIdx > 0)
                            throw _.merge(new Error('ignore bytes before SOF'), { skip: sofIdx });
                        // sof + sof lrc + cmd (2) + status (2) + data len (2) + head lrc + data + data lrc
                        if (buf.length < 10)
                            throw new Error('buf.length < 10');
                        if (this._calcLrc(buf.subarray(2, 8)) !== buf[8])
                            throw _.merge(new Error('head lrc mismatch'), { skip: 1 });
                        const lenFrame = buf.readUInt16BE(6) + 10;
                        if (buf.length < lenFrame)
                            throw new Error('waiting for more data');
                        if (this._calcLrc(buf.subarray(9, -1)) !== buf[buf.length - 1])
                            throw _.merge(new Error('data lrc mismatch'), { skip: 1 });
                        ctx.resp = new ChameleonUltraFrame(buf.subarray(0, lenFrame));
                        if (!_.isNil(cmd) && ctx.resp.cmd !== cmd)
                            throw _.merge(new Error(`expect cmd=${cmd} but receive cmd=${ctx.resp.cmd}`), { skip: lenFrame });
                        // resp is valid
                        if (buf.length > lenFrame)
                            this.rxSink.bufs.unshift(buf.subarray(lenFrame));
                        break;
                    }
                    catch (err) {
                        const skip = err.skip ?? 0;
                        if (skip > 0) {
                            this.logger.respError(`readRespTimeout skip ${skip} byte(s), reason = ${err.message}`);
                            buf = buf.subarray(skip);
                        }
                        this.rxSink.bufs.unshift(buf);
                    }
                    await sleep(10);
                }
                if (RespStatusFail.has(ctx.resp.status)) {
                    const status = ctx.resp.status;
                    this.logger.respError(ctx.resp.inspect);
                    throw _.merge(new Error(RespStatusMsg.get(status)), { status, data: { resp: ctx.resp } });
                }
                this.logger.resp(ctx.resp.inspect);
                return ctx.resp;
            });
        }
        /**
         * Get current firmware version of device.
         * @returns Current firmware version of device.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdGetAppVersion()) // '1.0'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdGetAppVersion() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_APP_VERSION; // cmd = 1000
            await this._writeCmd({ cmd });
            const { status, data } = await this._readRespTimeout({ cmd });
            if (status === RespStatus.HF_TAG_OK && data.readUInt16BE(0) === 0x0001)
                throw new Error('Unsupported protocol. Firmware update is required.');
            return `${data[0]}.${data[1]}`;
        }
        /**
         * Change device mode to tag reader or tag emulator.
         * @param mode - The mode to be changed.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { DeviceMode } = window.ChameleonUltraJS
         *   await ultra.cmdChangeDeviceMode(DeviceMode.TAG)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdChangeDeviceMode(mode) {
            if (!isDeviceMode(mode))
                throw new TypeError('Invalid device mode');
            this._clearRxBufs();
            const cmd = exports.Cmd.CHANGE_DEVICE_MODE; // cmd = 1001
            await this._writeCmd({ cmd, data: Buffer.pack('!B', mode) });
            await this._readRespTimeout({ cmd });
            this.deviceMode = mode;
        }
        /**
         * Get current mode of device.
         * @returns Current mode of device.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { DeviceMode } = window.ChameleonUltraJS
         *   const deviceMode = await ultra.cmdGetDeviceMode()
         *   console.log(DeviceMode[deviceMode]) // 'TAG'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdGetDeviceMode() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_DEVICE_MODE; // cmd = 1002
            await this._writeCmd({ cmd });
            const data = (await this._readRespTimeout({ cmd }))?.data;
            this.deviceMode = data[0];
            return this.deviceMode;
        }
        /**
         * Automatically change the device mode to `mode` if the current device mode is not equal to `mode`.
         * @group Device Related
         */
        async assureDeviceMode(mode) {
            if (this.deviceMode === mode)
                return;
            await this.cmdChangeDeviceMode(mode);
        }
        /**
         * Change the active emulation tag slot of device.
         * @param slot - The slot to be active.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Slot } = window.ChameleonUltraJS
         *   await ultra.cmdSlotSetActive(Slot.SLOT_1)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotSetActive(slot) {
            if (!isSlot(slot))
                throw new TypeError('Invalid slot');
            this._clearRxBufs();
            const cmd = exports.Cmd.SET_ACTIVE_SLOT; // cmd = 1003
            await this._writeCmd({ cmd, data: Buffer.pack('!B', slot) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Change the emulation tag type of specified slot.
         * @param slot - The slot to be set.
         * @param tagType - The tag type to be set.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Slot, TagType } = window.ChameleonUltraJS
         *   await ultra.cmdSlotChangeTagType(Slot.SLOT_1, TagType.MIFARE_1024)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotChangeTagType(slot, tagType) {
            if (!isSlot(slot))
                throw new TypeError('Invalid slot');
            if (!isTagType(tagType))
                throw new TypeError('Invalid tagType');
            this._clearRxBufs();
            const cmd = exports.Cmd.SET_SLOT_TAG_TYPE; // cmd = 1004
            await this._writeCmd({ cmd, data: Buffer.pack('!BH', slot, tagType) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Reset the emulation tag data of specified tag type in specified slot to default values.
         * @param slot - The slot to be reset.
         * @param tagType - The tag type to be reset.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Slot, TagType } = window.ChameleonUltraJS
         *   await ultra.cmdSlotResetTagType(Slot.SLOT_1, TagType.MIFARE_1024)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotResetTagType(slot, tagType) {
            if (!isSlot(slot))
                throw new TypeError('Invalid slot');
            if (!isTagType(tagType))
                throw new TypeError('Invalid tagType');
            this._clearRxBufs();
            const cmd = exports.Cmd.SET_SLOT_DATA_DEFAULT; // cmd = 1005
            await this._writeCmd({ cmd, data: Buffer.pack('!BH', slot, tagType) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Enable or disable the specified slot.
         * @param slot - The slot to be enable/disable.
         * @param enable - `true` to enable the slot, `false` to disable the slot.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { FreqType, Slot } = window.ChameleonUltraJS
         *   await ultra.cmdSlotSetEnable(Slot.SLOT_1, FreqType.HF, true)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotSetEnable(slot, freq, enable) {
            if (!isSlot(slot))
                throw new TypeError('Invalid slot');
            if (!isValidFreqType(freq))
                throw new TypeError('Invalid freq');
            if (_.isNil(enable))
                throw new TypeError('enable is required');
            this._clearRxBufs();
            const cmd = exports.Cmd.SET_SLOT_ENABLE; // cmd = 1006
            await this._writeCmd({ cmd, data: Buffer.pack('!BB?', slot, freq, enable) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Set the nickname of specified freq type in specified slot.
         * @param slot - The slot to be set.
         * @param freq - The freq type to be set.
         * @param name - The name to be set. The `byteLength` of name should between `1` and `32`.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Slot, FreqType } = window.ChameleonUltraJS
         *   await ultra.cmdSlotSetFreqName(Slot.SLOT_1, FreqType.HF, 'My Tag')
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotSetFreqName(slot, freq, name) {
            if (!isSlot(slot))
                throw new TypeError('Invalid slot');
            if (!isValidFreqType(freq))
                throw new TypeError('Invalid freq');
            if (!_.isString(name))
                throw new TypeError('name should be a string');
            const buf1 = Buffer.from(name);
            if (!_.inRange(buf1.length, 1, 33))
                throw new TypeError('byteLength of name should between 1 and 32');
            this._clearRxBufs();
            const cmd = exports.Cmd.SET_SLOT_TAG_NICK; // cmd = 1007
            await this._writeCmd({ cmd, data: Buffer.pack(`!BB${buf1.length}s`, slot, freq, buf1) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get the nickname of specified freq type in specified slot.
         * @param slot - The slot to be get.
         * @param freq - The freq type to be get.
         * @returns The nickname of specified freq type in specified slot.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Slot, FreqType } = window.ChameleonUltraJS
         *   const name = await ultra.cmdSlotGetFreqName(Slot.SLOT_1, FreqType.HF)
         *   console.log(name) // 'My Tag'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotGetFreqName(slot, freq) {
            try {
                if (!isSlot(slot))
                    throw new TypeError('Invalid slot');
                if (!isValidFreqType(freq))
                    throw new TypeError('Invalid freq');
                this._clearRxBufs();
                const cmd = exports.Cmd.GET_SLOT_TAG_NICK; // cmd = 1008
                await this._writeCmd({ cmd, data: Buffer.pack('!BB', slot, freq) });
                return (await this._readRespTimeout({ cmd }))?.data.toString('utf8');
            }
            catch (err) {
                if (err.status === RespStatus.FLASH_READ_FAIL)
                    return; // slot name is empty
                throw err;
            }
        }
        /**
         * The SlotSettings, hf tag data and lf tag data will be written to persistent storage. But the slot nickname is not affected by this command.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer } = window.ChameleonUltraJS
         *   await ultra.cmdMf1EmuWriteBlock(1, Buffer.alloc(16))
         *   await ultra.cmdSlotSaveSettings()
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotSaveSettings() {
            this._clearRxBufs();
            const cmd = exports.Cmd.SLOT_DATA_CONFIG_SAVE; // cmd = 1009
            await this._writeCmd({ cmd });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Enter bootloader mode.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.cmdEnterBootloader()
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdEnterBootloader() {
            this._clearRxBufs();
            const cmd = exports.Cmd.ENTER_BOOTLOADER; // cmd = 1010
            await this._writeCmd({ cmd });
        }
        /**
         * Get chipset id of device in hex format.
         * @returns Chipset id of device in hex format.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdGetDeviceChipId()) // 'db1c624228d9634c'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdGetDeviceChipId() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_DEVICE_CHIP_ID; // cmd = 1011
            await this._writeCmd({ cmd });
            const data = (await this._readRespTimeout({ cmd }))?.data;
            return data.toString('hex');
        }
        /**
         * Get the ble address of device.
         * @returns The ble address of device.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdBleGetAddress()) // 'E8:B6:3D:04:B6:FE'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdBleGetAddress() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_DEVICE_ADDRESS; // cmd = 1012
            await this._writeCmd({ cmd });
            const data = (await this._readRespTimeout({ cmd }))?.data;
            const arr = [];
            for (let i = 0; i < data.length; i++)
                arr.push(data.subarray(i, i + 1).toString('hex'));
            return _.toUpper(arr.join(':'));
        }
        /**
         * Save the settings of device to persistent storage.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.cmdSaveSettings()
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSaveSettings() {
            this._clearRxBufs();
            const cmd = exports.Cmd.SAVE_SETTINGS; // cmd = 1013
            await this._writeCmd({ cmd });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Reset the settings of device to default values.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.cmdResetSettings()
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdResetSettings() {
            this._clearRxBufs();
            const cmd = exports.Cmd.RESET_SETTINGS; // cmd = 1014
            await this._writeCmd({ cmd });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Set the animation mode of device while wake-up and sleep.
         * @param mode - The animation mode to be set.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { AnimationMode } = window.ChameleonUltraJS
         *   await ultra.cmdSetAnimationMode(AnimationMode.SHORT)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSetAnimationMode(mode) {
            if (!isAnimationMode(mode))
                throw new TypeError('Invalid mode');
            this._clearRxBufs();
            const cmd = exports.Cmd.SET_ANIMATION_MODE; // cmd = 1015
            await this._writeCmd({ cmd, data: Buffer.pack('!B', mode) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get the animation mode of device while wake-up and sleep.
         * @returns The animation mode of device.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { AnimationMode } = window.ChameleonUltraJS
         *   const mode = await ultra.cmdGetAnimationMode()
         *   console.log(AnimationMode[mode]) // 'FULL'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdGetAnimationMode() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_ANIMATION_MODE; // cmd = 1016
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data[0];
        }
        /**
         * Get the git version of firmware.
         * @returns The git version of firmware.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdGetGitVersion()) // '98605be'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdGetGitVersion() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_GIT_VERSION; // cmd = 1017
            await this._writeCmd({ cmd });
            const data = (await this._readRespTimeout({ cmd }))?.data;
            return data.toString('utf8');
        }
        /**
         * Get the active emulation tag slot of device.
         * @returns The active slot of device.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Slot } = window.ChameleonUltraJS
         *   const slot = await ultra.cmdSlotGetActive()
         *   console.log(Slot[slot]) // 'SLOT_1'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotGetActive() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_ACTIVE_SLOT; // cmd = 1018
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data[0];
        }
        /**
         * Get the slot info of all slots.
         * @returns The slot info of all slots.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const slots = await ultra.cmdSlotGetInfo()
         *   console.log(JSON.stringify(slots))
         *   /**
         *    * [
         *    *   { "hfTagType": 1001, "lfTagType": 100 },
         *    *   { "hfTagType": 1001, "lfTagType": 0 },
         *    *   { "hfTagType": 0, "lfTagType": 100 },
         *    *   { "hfTagType": 0, "lfTagType": 0 },
         *    *   { "hfTagType": 0, "lfTagType": 0 },
         *    *   { "hfTagType": 0, "lfTagType": 0 },
         *    *   { "hfTagType": 0, "lfTagType": 0 },
         *    *   { "hfTagType": 0, "lfTagType": 0 }
         *    * ]
         *    *\/
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotGetInfo() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_SLOT_INFO; // cmd = 1019
            await this._writeCmd({ cmd });
            return SlotInfo.fromCmd1019((await this._readRespTimeout({ cmd }))?.data);
        }
        /**
         * Permanently wipes Chameleon to factory settings. This will delete all your slot data and custom settings. There's no going back.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.cmdWipeFds()
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdWipeFds() {
            this._clearRxBufs();
            const cmd = exports.Cmd.WIPE_FDS; // cmd = 1020
            await this._writeCmd({ cmd });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Delete the nick name of the slot
         * @param slot - Slot number
         * @param freq - Frequency type
         * @returns `true` if success, `false` if slot name is empty.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Slot, FreqType } = window.ChameleonUltraJS
         *   console.log(await ultra.cmdSlotDeleteFreqName(Slot.SLOT_1, FreqType.HF)) // true
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotDeleteFreqName(slot, freq) {
            try {
                if (!isSlot(slot))
                    throw new TypeError('Invalid slot');
                if (!isValidFreqType(freq))
                    throw new TypeError('Invalid freq');
                this._clearRxBufs();
                const cmd = exports.Cmd.DELETE_SLOT_TAG_NICK; // cmd = 1021
                await this._writeCmd({ cmd, data: Buffer.pack('!BB', slot, freq) });
                await this._readRespTimeout({ cmd });
                return true;
            }
            catch (err) {
                if (err.status === RespStatus.FLASH_WRITE_FAIL)
                    return false; // slot name is empty
                throw err;
            }
        }
        /**
         * Get enabled slots.
         * @returns Enabled slots.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const enabledSlots = await ultra.cmdSlotGetIsEnable()
         *   console.log(JSON.stringify(enabledSlots))
         *   // [
         *   //   { "hf": true, "lf": true },
         *   //   { "hf": true, "lf": false },
         *   //   { "hf": false, "lf": true },
         *   //   { "hf": false, "lf": false },
         *   //   { "hf": false, "lf": false },
         *   //   { "hf": false, "lf": false },
         *   //   { "hf": false, "lf": false },
         *   //   { "hf": true, "lf": false }
         *   // ]
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotGetIsEnable() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_ENABLED_SLOTS; // cmd = 1023
            await this._writeCmd({ cmd });
            return SlotFreqIsEnable.fromCmd1023((await this._readRespTimeout({ cmd }))?.data);
        }
        /**
         * Delete the emulation tag data of specified freq type in specified slot.
         * @param slot - The slot to be deleted.
         * @param freq - The freq type of slot.
         * @group Slot Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Slot, FreqType } = window.ChameleonUltraJS
         *   await ultra.cmdSlotDeleteFreqType(Slot.SLOT_1, FreqType.HF)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSlotDeleteFreqType(slot, freq) {
            if (!isSlot(slot))
                throw new TypeError('Invalid slot');
            if (!isValidFreqType(freq))
                throw new TypeError('Invalid freq');
            this._clearRxBufs();
            const cmd = exports.Cmd.DELETE_SLOT_SENSE_TYPE; // cmd = 1024
            await this._writeCmd({ cmd, data: Buffer.pack('!BB', slot, freq) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get the battery info of device.
         * @returns The battery info of device.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const battery = await ultra.cmdGetBatteryInfo()
         *   console.log(JSON.stringify(battery)) // { "voltage": 4192, "level": 99 }
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdGetBatteryInfo() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_BATTERY_INFO; // cmd = 1025
            await this._writeCmd({ cmd });
            return BatteryInfo.fromCmd1025((await this._readRespTimeout({ cmd }))?.data);
        }
        /**
         * Get the button press action of specified button.
         * @param btn - The button to be get.
         * @returns The button press action of specified button.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { ButtonAction, ButtonType } = window.ChameleonUltraJS
         *   const btnAction = await ultra.cmdGetButtonPressAction(ButtonType.BUTTON_A)
         *   console.log(ButtonAction[btnAction]) // 'CYCLE_SLOT_INC'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdGetButtonPressAction(btn) {
            if (!isButtonType(btn))
                throw new TypeError('Invalid btn');
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_BUTTON_PRESS_CONFIG; // cmd = 1026
            await this._writeCmd({ cmd, data: Buffer.pack('!B', btn) });
            return (await this._readRespTimeout({ cmd }))?.data[0];
        }
        /**
         * Set the button press action of specified button.
         * @param btn - The button to be set.
         * @param action - The button press action to be set.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { ButtonAction, ButtonType } = window.ChameleonUltraJS
         *   await ultra.cmdSetButtonPressAction(ButtonType.BUTTON_A, ButtonAction.CYCLE_SLOT_INC)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSetButtonPressAction(btn, action) {
            if (!isButtonType(btn))
                throw new TypeError('Invalid btn');
            if (!isButtonAction(action))
                throw new TypeError('Invalid action');
            this._clearRxBufs();
            const cmd = exports.Cmd.SET_BUTTON_PRESS_CONFIG; // cmd = 1027
            await this._writeCmd({ cmd, data: Buffer.pack('!BB', btn, action) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get the button long press action of specified button.
         * @param btn - The button to be get.
         * @returns The button long press action of specified button.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { ButtonAction, ButtonType } = window.ChameleonUltraJS
         *   const btnAction = await ultra.cmdGetButtonLongPressAction(ButtonType.BUTTON_A)
         *   console.log(ButtonAction[btnAction]) // 'CLONE_IC_UID'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdGetButtonLongPressAction(btn) {
            if (!isButtonType(btn))
                throw new TypeError('Invalid btn');
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_LONG_BUTTON_PRESS_CONFIG; // cmd = 1028
            await this._writeCmd({ cmd, data: Buffer.pack('!B', btn) });
            return (await this._readRespTimeout({ cmd }))?.data[0];
        }
        /**
         * Set the button long press action of specified button.
         * @param btn - The button to be set.
         * @param action - The button long press action to be set.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { ButtonAction, ButtonType } = window.ChameleonUltraJS
         *   await ultra.cmdSetButtonLongPressAction(ButtonType.BUTTON_A, ButtonAction.CYCLE_SLOT_INC)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdSetButtonLongPressAction(btn, action) {
            if (!isButtonType(btn))
                throw new TypeError('Invalid btn');
            if (!isButtonAction(action))
                throw new TypeError('Invalid action');
            this._clearRxBufs();
            const cmd = exports.Cmd.SET_LONG_BUTTON_PRESS_CONFIG; // cmd = 1029
            await this._writeCmd({ cmd, data: Buffer.pack('!BB', btn, action) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Set the ble pairing key of device.
         * @param key - The new ble pairing key.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.cmdBleSetPairingKey('123456')
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdBleSetPairingKey(key) {
            if (!_.isString(key) || !/^\d{6}$/.test(key))
                throw new TypeError('Invalid key, must be 6 digits');
            this._clearRxBufs();
            const cmd = exports.Cmd.SET_BLE_PAIRING_KEY; // cmd = 1030
            await this._writeCmd({ cmd, data: Buffer.from(key) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get current ble pairing key of device.
         * @returns The ble pairing key.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdBleGetPairingKey()) // '123456'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdBleGetPairingKey() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_BLE_PAIRING_KEY; // cmd = 1031
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data.toString('utf8');
        }
        /**
         * Delete all ble bindings.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.cmdBleDeleteAllBonds()
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdBleDeleteAllBonds() {
            this._clearRxBufs();
            const cmd = exports.Cmd.DELETE_ALL_BLE_BONDS; // cmd = 1032
            await this._writeCmd({ cmd });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get the device is ChameleonUltra or ChameleonLite.
         * @returns `true` if device is ChameleonUltra, `false` if device is ChameleonLite.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { DeviceModel } = window.ChameleonUltraJS
         *   const model = await ultra.cmdGetDeviceModel()
         *   console.log(DeviceModel[model]) // 'ULTRA'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdGetDeviceModel() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_DEVICE_MODEL; // cmd = 1033
            await this._writeCmd({ cmd });
            const data = (await this._readRespTimeout({ cmd }))?.data;
            return data[0];
        }
        /**
         * Get the settings of device.
         * @returns The settings of device.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const settings = await ultra.cmdGetDeviceSettings()
         *   console.log(JSON.stringify(settings)
         *   /**
         *    * {
         *    *   "version": 5,
         *    *   "animation": 0,
         *    *   "buttonPressAction": [1, 2],
         *    *   "buttonLongPressAction": [3, 3],
         *    *   "blePairingMode": false,
         *    *   "blePairingKey": "123456"
         *    * }
         *    *\/
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdGetDeviceSettings() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_DEVICE_SETTINGS; // cmd = 1034
            await this._writeCmd({ cmd });
            return DeviceSettings.fromCmd1034((await this._readRespTimeout({ cmd }))?.data);
        }
        /**
         * Get the cmds supported by device.
         * @returns The cmds supported by device.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const cmds = await ultra.cmdGetSupportedCmds()
         *   console.log(cmds.size) // 67
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdGetSupportedCmds() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_DEVICE_CAPABILITIES; // cmd = 1035
            await this._writeCmd({ cmd });
            const data = (await this._readRespTimeout({ cmd }))?.data;
            const cmds = new Set();
            for (let i = 0; i < data.length; i += 2)
                cmds.add(data.readUInt16BE(i));
            return cmds;
        }
        /**
         * To check if the specified cmd is supported by device.
         * @returns `true` if the specified cmd is supported by device, otherwise return `false`.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.isCmdSupported(Cmd.GET_APP_VERSION)) // true
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async isCmdSupported(cmd) {
            if (this.supportedCmds.size === 0)
                this.supportedCmds = await this.cmdGetSupportedCmds();
            return this.supportedCmds.has(cmd);
        }
        /**
         * Get the ble pairing mode of device.
         * @returns `true` if pairing is required to connect to device, otherwise return `false`.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdBleGetPairingMode()) // false
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdBleGetPairingMode() {
            this._clearRxBufs();
            const cmd = exports.Cmd.GET_BLE_PAIRING_ENABLE; // cmd = 1036
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data[0] === 1;
        }
        /**
         * Set if the ble pairing is required when connecting to device.
         * @param enable - `true` to enable pairing mode, `false` to disable pairing mode.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.cmdBleSetPairingMode(false)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdBleSetPairingMode(enable) {
            if (_.isNil(enable))
                throw new TypeError('enable is required');
            this._clearRxBufs();
            const cmd = exports.Cmd.SET_BLE_PAIRING_ENABLE; // cmd = 1037
            await this._writeCmd({ cmd, data: Buffer.pack('!?', enable) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Scan 14a tag, and return basic information. The device mode must be set to READER before using this command.
         * @returns The basic infomation of scanned tag.
         * @throws This command will throw an error if tag not scanned or any error occured.
         * @group Reader Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const antiColl = _.first(await ultra.cmdHf14aScan())
         *   console.log(_.mapValues(antiColl, val => val.toString('hex')))
         *   // { uid: '040dc4420d2981', atqa: '4400', sak: '00', ats: ''}
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdHf14aScan() {
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.HF14A_SCAN; // cmd = 2000
            await this._writeCmd({ cmd });
            return Hf14aAntiColl.fromCmd2000((await this._readRespTimeout({ cmd }))?.data);
        }
        /**
         * Test whether it is mifare classic tag.
         * @returns `true` if tag is mifare classic tag, otherwise return `false`.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdMf1IsSupport()) // true
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1IsSupport() {
            try {
                await this.assureDeviceMode(exports.DeviceMode.READER);
                this._clearRxBufs();
                const cmd = exports.Cmd.MF1_DETECT_SUPPORT; // cmd = 2001
                await this._writeCmd({ cmd });
                await this._readRespTimeout({ cmd });
                return true;
            }
            catch (err) {
                if (err.status === RespStatus.HF_ERR_STAT)
                    return false;
                throw err;
            }
        }
        /**
         * Check the nt level of mifare protocol.
         * @returns The nt level of mifare protocol.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Mf1PrngType } = window.ChameleonUltraJS
         *   console.log(Mf1PrngType[await ultra.cmdMf1TestPrngType()]) // 'WEAK'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1TestPrngType() {
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_DETECT_NT_LEVEL; // cmd = 2002
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data[0];
        }
        /**
         * Use a known key to do the mifare static nested attack.
         * @param known - The info of known key.
         * @param known.block - The block of known key.
         * @param known.key - The known key.
         * @param known.keyType - The key type of known key.
         * @param target - The info of target key to be attack.
         * @param target.block - The block of target key.
         * @param target.keyType - The key type of target key.
         * @returns The result of mifare static nested attack.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer, Mf1KeyType } = window.ChameleonUltraJS
         *   const key = Buffer.from('FFFFFFFFFFFF', 'hex')
         *   const res1 = await ultra.cmdMf1AcquireStaticNested({
         *     block: 0,
         *     keyType: Mf1KeyType.KEY_A,
         *     key
         *   }, {
         *     block: 4,
         *     keyType: Mf1KeyType.KEY_A
         *   })
         *   const res = {
         *     uid: res1.uid.toString('hex'),
         *     atks: _.map(res1.atks, item => ({ nt1: item.nt1.toString('hex'), nt2: item.nt2.toString('hex') })),
         *   }
         *   console.log(res)
         *   // {
         *   //   uid: 'b908a16d',
         *   //   atks: [
         *   //     { nt1: '01200145', nt2: '81901975' },
         *   //     { nt1: '01200145', nt2: 'cdd400f3' },
         *   //   ],
         *   // }
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1AcquireStaticNested(known, target) {
            validateMf1BlockKey(known.block, known.keyType, known.key, 'known.');
            if (!isMf1BlockNo(target.block))
                throw new TypeError('Invalid target.block');
            if (!isMf1KeyType(target.keyType))
                throw new TypeError('Invalid target.keyType');
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_STATIC_NESTED_ACQUIRE; // cmd = 2003
            await this._writeCmd({ cmd, data: Buffer.pack('!BB6sBB', known.keyType, known.block, known.key, target.keyType, target.block) });
            return Mf1AcquireStaticNestedRes.fromCmd2003((await this._readRespTimeout({ cmd }))?.data);
        }
        /**
         * Acquire the data from mifare darkside attack.
         * @param block - The target block.
         * @param keyType - The target key type.
         * @param isFirst - `true` if this is the first attack.
         * @param syncMax - The max sync count of darkside attack.
         * @returns The data from mifare darkside attack.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Mf1KeyType, DarksideStatus } = window.ChameleonUltraJS
         *   const res1 = await ultra.cmdMf1AcquireDarkside(0, Mf1KeyType.KEY_A, true)
         *   console.log(res1)
         *   const res2 = {
         *     status: `${DarksideStatus[res1.status]} (${res1.status})`,
         *     ...(res1.status !== DarksideStatus.OK ? {} : {
         *       ar: res1.ar.toString('hex'),
         *       ks: res1.ks.toString('hex'),
         *       nr: res1.nr.toString('hex'),
         *       nt: res1.nt.toString('hex'),
         *       par: res1.par.toString('hex'),
         *       uid: res1.uid.toString('hex'),
         *     }),
         *   }
         *   console.log(res2)
         *   // {
         *   //   "ar": "00000000",
         *   //   "ks": "0c0508080f04050a",
         *   //   "nr": "00000000",
         *   //   "nt": "b346fc3d",
         *   //   "par": "0000000000000000",
         *   //   "status": "OK (0)",
         *   //   "uid": "d3efed0c"
         *   // }
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         *
         * If you want to use darkside attack to recover the key, you can use the following example code:
         *
         * ```js
         * async function run (ultra) {
         *   const { Buffer, DarksideStatus, Mf1KeyType } = window.ChameleonUltraJS
         *   const block = 0
         *   const keyType = Mf1KeyType.KEY_A
         *   const key = await Crypto1.darkside(
         *     async attempt => {
         *       const accquired = await ultra.cmdMf1AcquireDarkside(block, keyType, attempt === 0)
         *       console.log(_.mapValues(accquired, buf => Buffer.isBuffer(buf) ? buf.toString('hex') : buf))
         *       if (acquired.status === DarksideStatus.LUCKY_AUTH_OK) throw new Error('LUCKY_AUTH_OK')
         *       if (acquired.status !== DarksideStatus.OK) throw new Error('card is not vulnerable to Darkside attack')
         *       return accquired
         *     },
         *     async key => {
         *       return await ultra.cmdMf1CheckBlockKey({ block, keyType, key })
         *     },
         *   )
         *   console.log(`key founded: ${key.toString('hex')}`)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1AcquireDarkside(block, keyType, isFirst, syncMax = 30) {
            if (!_.isSafeInteger(block))
                throw new TypeError('Invalid block');
            if (!isMf1KeyType(keyType))
                throw new TypeError('Invalid keyType');
            if (_.isNil(isFirst))
                throw new TypeError('Invalid isFirst');
            if (!_.isSafeInteger(syncMax))
                throw new TypeError('Invalid syncMax');
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_DARKSIDE_ACQUIRE; // cmd = 2004
            await this._writeCmd({ cmd, data: Buffer.pack('!BB?B', keyType, block, isFirst, syncMax) });
            return Mf1DarksideRes.fromCmd2004((await this._readRespTimeout({ cmd, timeout: syncMax * 1e4 }))?.data);
        }
        /**
         * Dectect the nt distance of mifare protocol.
         * @param known - The info of known key.
         * @param known.block - The block of known key.
         * @param known.key - The known key.
         * @param known.keyType - The key type of known key.
         * @returns The nt distance of mifare protocol.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer, Mf1KeyType } = window.ChameleonUltraJS
         *   const key = Buffer.from('FFFFFFFFFFFF', 'hex')
         *   const res1 = await ultra.cmdMf1TestNtDistance({ block: 0, keyType: Mf1KeyType.KEY_A, key })
         *   const res2 = await ultra.cmdMf1AcquireNested(
         *     { block: 0, keyType: Mf1KeyType.KEY_A, key },
         *     { block: 4, keyType: Mf1KeyType.KEY_A },
         *   )
         *   const res = {
         *     uid: res1.uid.toString('hex'),
         *     dist: res1.dist.toString('hex'),
         *     atks: _.map(res2, item => ({
         *       nt1: item.nt1.toString('hex'),
         *       nt2: item.nt2.toString('hex'),
         *       par: item.par,
         *     }))
         *   }
         *   console.log(res)
         *   // {
         *   //   uid: '877209e1',
         *   //   dist: '00000080',
         *   //   atks: [
         *   //     { nt1: '35141fcb', nt2: '40430522', par: 7 },
         *   //     { nt1: 'cff2b3ef', nt2: '825ba8ea', par: 5 },
         *   //   ]
         *   // }
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1TestNtDistance(known) {
            validateMf1BlockKey(known.block, known.keyType, known.key, 'known.');
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_DETECT_NT_DIST; // cmd = 2005
            await this._writeCmd({ cmd, data: Buffer.pack('!BB6s', known.keyType, known.block, known.key) });
            return Mf1NtDistanceRes.fromCmd2005((await this._readRespTimeout({ cmd }))?.data);
        }
        /**
         * Use a known key to do the mifare nested attack.
         * @param known - The info of known key.
         * @param known.block - The block of known key.
         * @param known.key - The known key.
         * @param known.keyType - The key type of known key.
         * @param target - The info of target key to be attack.
         * @param target.block - The block of target key.
         * @param target.keyType - The key type of target key.
         * @returns The result of mifare nested attack.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer, Mf1KeyType } = window.ChameleonUltraJS
         *   const key = Buffer.from('FFFFFFFFFFFF', 'hex')
         *   const res1 = await ultra.cmdMf1TestNtDistance({ block: 0, keyType: Mf1KeyType.KEY_A, key })
         *   const res2 = await ultra.cmdMf1AcquireNested(
         *     { block: 0, keyType: Mf1KeyType.KEY_A, key },
         *     { block: 4, keyType: Mf1KeyType.KEY_A },
         *   )
         *   const res = {
         *     uid: res1.uid.toString('hex'),
         *     dist: res1.dist.toString('hex'),
         *     atks: _.map(res2, item => ({
         *       nt1: item.nt1.toString('hex'),
         *       nt2: item.nt2.toString('hex'),
         *       par: item.par,
         *     }))
         *   }
         *   console.log(res)
         *   // {
         *   //   uid: '877209e1',
         *   //   dist: '00000080',
         *   //   atks: [
         *   //     { nt1: '35141fcb', nt2: '40430522', par: 7 },
         *   //     { nt1: 'cff2b3ef', nt2: '825ba8ea', par: 5 },
         *   //   ]
         *   // }
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1AcquireNested(known, target) {
            // validateMf1BlockKey(known.block, known.keyType, known.key, 'known.');
            // if (!_.isSafeInteger(target.block))
            //     throw new TypeError('Invalid target.block');
            // if (!isMf1KeyType(target.keyType))
            //     throw new TypeError('Invalid target.keyType');
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_NESTED_ACQUIRE; // cmd = 2006
            await this._writeCmd({ cmd, data: Buffer.pack('!BB6sBB', known.keyType, known.block, known.key, target.keyType, target.block) });
            return Mf1NestedRes.fromCmd2006((await this._readRespTimeout({ cmd }))?.data);
        }
        /**
         * Check if the key is valid for specified block and key type.
         * @param opts - The info of key to be checked.
         * @param opts.block - The block of key to be checked.
         * @param opts.keyType - The type of key to be checked.
         * @param opts.key - The key to be checked.
         * @returns `true` if the key is valid for specified block and key type.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer, Mf1KeyType } = window.ChameleonUltraJS
         *   const key = Buffer.from('FFFFFFFFFFFF', 'hex')
         *   console.log(await ultra.cmdMf1CheckBlockKey({
         *     block: 0,
         *     keyType: Mf1KeyType.KEY_A,
         *     key,
         *   })) // true
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1CheckBlockKey(opts) {
            const { block, keyType, key } = opts;
            try {
                validateMf1BlockKey(block, keyType, key);
                await this.assureDeviceMode(exports.DeviceMode.READER);
                this._clearRxBufs();
                const cmd = exports.Cmd.MF1_AUTH_ONE_KEY_BLOCK; // cmd = 2007
                await this._writeCmd({ cmd, data: Buffer.pack('!BB6s', keyType, block, key) });
                await this._readRespTimeout({ cmd });
                return true;
            }
            catch (err) {
                if (err.status === RespStatus.MF_ERR_AUTH)
                    return false;
                throw err;
            }
        }
        /**
         * Read block data from a mifare tag.
         * @param opts - The block to be read and the key info of the block.
         * @param opts.block - The block to be read.
         * @param opts.keyType - The key type of the block.
         * @param opts.key - The key of the block.
         * @returns The block data read from a mifare tag.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer, Mf1KeyType } = window.ChameleonUltraJS
         *   const key = Buffer.from('FFFFFFFFFFFF', 'hex')
         *   const block1 = await ultra.cmdMf1ReadBlock({
         *     block: 1,
         *     keyType: Mf1KeyType.KEY_A,
         *     key,
         *   })
         *   console.log(block1.toString('hex')) // '00000000000000000000000000000000'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1ReadBlock(opts) {
            const { block, keyType, key } = opts;
            validateMf1BlockKey(block, keyType, key);
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_READ_ONE_BLOCK; // cmd = 2008
            await this._writeCmd({ cmd, data: Buffer.pack('!BB6s', keyType, block, key) });
            return (await this._readRespTimeout({ cmd }))?.data;
        }
        /**
         * Write data to a mifare tag.
         * @param opts - The block to be written and the key info of the block.
         * @param opts.block - The block to be written.
         * @param opts.keyType - The key type of the block.
         * @param opts.key - The key of the block.
         * @param opts.data - The block data to be written.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer, Mf1KeyType } = window.ChameleonUltraJS
         *   const key = Buffer.from('FFFFFFFFFFFF', 'hex')
         *   const block1 = Buffer.from('00000000000000000000000000000000', 'hex')
         *   await ultra.cmdMf1WriteBlock({
         *     block: 1,
         *     keyType: Mf1KeyType.KEY_A,
         *     key,
         *     data: block1,
         *   })
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1WriteBlock(opts) {
            const { block, keyType, key, data } = opts;
            validateMf1BlockKey(block, keyType, key);
            if (!Buffer.isBuffer(data) || data.length !== 16)
                throw new TypeError('data should be a Buffer with length 16');
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_WRITE_ONE_BLOCK; // cmd = 2009
            await this._writeCmd({ cmd, data: Buffer.pack('!BB6s16s', keyType, block, key, data) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get the info composed of `cmdHf14aScan()` and `cmdMf1TestNtLevel()`.
         * @returns The info about 14a tag and mifare protocol.
         * @group Reader Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Mf1PrngType } = window.ChameleonUltraJS
         *   const tag = _.first(await ultra.hf14aInfo())
         *   console.log(tag.nxpTypeBySak) // 'MIFARE Classic 1K | Plus SE 1K | Plug S 2K | Plus X 2K'
         *   console.log(Mf1PrngType[tag.prngType]) // 'WEAK'
         *   console.log(_.mapValues(tag.antiColl, val => val.toString('hex')))
         *   // { uid: 'dbe3d63d', atqa: '0400', sak: '08', ats: '' }
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async hf14aInfo() {
            const items = [];
            const antiColls = await this.cmdHf14aScan();
            for (const antiColl of antiColls) {
                const item = { antiColl, nxpTypeBySak: NxpTypeBySak.get(antiColl.sak[0]) };
                items.push(item);
            }
            if (antiColls.length === 1 && await this.cmdMf1IsSupport()) {
                items[0].prngType = await this.cmdMf1TestPrngType();
            }
            return items;
        }
        /**
         * Send raw NfcA data to a tag and receive the response.
         * @param opts.activateRfField - Set `true` to activate RF field. If `data` is not empty or `autoSelect` is true, `activateRfField` will be set to `true`.
         * @param opts.appendCrc - Set `true` to add CRC before sending data.
         * @param opts.autoSelect - Set `true` to automatically select card before sending data.
         * @param opts.checkResponseCrc - Set `true` to verify CRC of response and remove. If CRC of response is valid, CRC will be removed from response, otherwise will throw HF_ERR_CRC error.
         * @param opts.data - The data to be send. If `appendCrc` is `true`, the maximum length of data is `62`, otherwise is `64`.
         * @param opts.dataBitLength - Number of bits to send. Useful for send partial byte. `dataBitLength` is incompatible with `appendCrc`.
         * @param opts.keepRfField - Set `true` to keep the RF field active after sending.
         * @param opts.waitResponse - Default value is `true`. Set `false` to skip reading tag response.
         * @param opts.timeout - Default value is `1000 ms`. Maximum timeout for reading tag response in ms while `waitResponse` is `true`.
         * @returns The response from tag.
         * @group Reader Related
         */
        async cmdHf14aRaw(opts) {
            let { activateRfField = false, waitResponse = true, appendCrc = false, autoSelect = false, keepRfField = false, checkResponseCrc = false, dataBitLength = 0, timeout = 1000, data = new Buffer(), } = opts;
            if (!Buffer.isBuffer(data))
                throw new TypeError('data should be a Buffer');
            if (!_.isSafeInteger(timeout))
                throw new TypeError('Invalid timeout');
            if (!_.isSafeInteger(dataBitLength))
                throw new TypeError('Invalid dataBitLength');
            // [8, 1, 2, 3, 4, 5, 6, 7]
            dataBitLength = (data.length - 1) * 8 + (dataBitLength + 7) % 8 + 1;
            const buf1 = Buffer.pack(`!xHH${data.length}s`, timeout, dataBitLength, data);
            // options
            for (const [bitOffset, val] of [
                [0, activateRfField],
                [1, waitResponse],
                [2, appendCrc],
                [3, autoSelect],
                [4, keepRfField],
                [5, checkResponseCrc],
            ])
                buf1.writeBitMSB(val, bitOffset);
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.HF14A_RAW; // cmd = 2010
            await this._writeCmd({ cmd, data: buf1 });
            return (await this._readRespTimeout({ cmd, timeout: READ_DEFAULT_TIMEOUT + timeout }))?.data;
        }
        /**
         * MIFARE Classic manipulate value block
         *
         * - Decrement: decrement value by `X` (`0` ~ `2147483647`) from src to dst
         * - Increment: increment value by `X` (`0` ~ `2147483647`) from src to dst
         * - Restore: copy value from src to dst (Restore and Transfer)
         *
         * @param src - The key info of src block.
         * @param src.key - The key of src block.
         * @param src.keyType - The key type of src block.
         * @param src.block - The block of src block.
         * @param operator - The operator of value block.
         * @param operand - The operand of value block.
         * @param dst - The key info of dst block.
         * @param dst.key - The key of dst block.
         * @param dst.keyType - The key type of dst block.
         * @param dst.block - The block of dst block.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer, Mf1KeyType, Mf1VblockOperator } = window.ChameleonUltraJS
         *   const key = Buffer.from('FFFFFFFFFFFF', 'hex')
         *   const src = { block: 4, keyType: Mf1KeyType.KEY_A, key }
         *   await ultra.mf1VblockSetValue(src, { value: 2 })
         *   console.log(await ultra.mf1VblockGetValue(src))
         *   await ultra.cmdMf1VblockManipulate(
         *     { block: 4, keyType: Mf1KeyType.KEY_A, key },
         *     Mf1VblockOperator.DECREMENT, 1,
         *     { block: 4, keyType: Mf1KeyType.KEY_A, key },
         *   )
         *   console.log(await ultra.mf1VblockGetValue(src))
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1VblockManipulate(src, operator, operand, dst) {
            validateMf1BlockKey(src.block, src.keyType, src.key, 'src.');
            validateMf1BlockKey(dst.block, dst.keyType, dst.key, 'dst.');
            if (!isMf1VblockOperator(operator))
                throw new TypeError('Invalid operator');
            if (!_.isSafeInteger(operand))
                throw new TypeError('Invalid operand');
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_MANIPULATE_VALUE_BLOCK; // cmd = 2011
            const data = Buffer.pack('!BB6sBiBB6s', src.keyType, src.block, src.key, operator, operand, dst.keyType, dst.block, dst.key);
            await this._writeCmd({ cmd, data });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get value from `opts` block (MIFARE Classic value block)
         * @param opts - The key info of `opts` block.
         * @param opts.block - The block of `opts` block.
         * @param opts.keyType - The key type of `opts` block.
         * @param opts.key - The key of `opts` block.
         * @returns The value and address of `opts` block.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer, Mf1KeyType, Mf1VblockOperator } = window.ChameleonUltraJS
         *   const key = Buffer.from('FFFFFFFFFFFF', 'hex')
         *   const src = { block: 4, keyType: Mf1KeyType.KEY_A, key }
         *   await ultra.mf1VblockSetValue(src, { value: 2 })
         *   console.log(await ultra.mf1VblockGetValue(src))
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async mf1VblockGetValue(opts) {
            const blkDt = await this.cmdMf1ReadBlock(opts);
            const [val1, val2, val3] = _.times(3, i => blkDt.readInt32LE(i * 4));
            if (val1 !== val3 || val1 + val2 !== -1)
                throw new Error(`Invalid value of value block: ${blkDt.toString('hex')}`);
            const [adr1, adr2, adr3, adr4] = blkDt.subarray(12, 16);
            if (adr1 !== adr3 || adr2 !== adr4 || adr1 + adr2 !== 0xFF)
                throw new Error(`Invalid address of value block: ${blkDt.toString('hex')}`);
            return { adr: adr1, value: val1 };
        }
        /**
         * Set value X (-2147483647 ~ 2147483647) to `dst` block (MIFARE Classic value block)
         * @param dst - The key info of `dst` block.
         * @param dst.block - The block of `dst` block.
         * @param dst.keyType - The key type of `dst` block.
         * @param dst.key - The key of `dst` block.
         * @param val - The value and address to be set.
         * @param val.value - The value to be set. Default is `0`.
         * @param val.adr - The address to be set. Default is `dst.block`.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer, Mf1KeyType, Mf1VblockOperator } = window.ChameleonUltraJS
         *   const key = Buffer.from('FFFFFFFFFFFF', 'hex')
         *   const src = { block: 4, keyType: Mf1KeyType.KEY_A, key }
         *   await ultra.mf1VblockSetValue(src, { value: 2 })
         *   console.log(await ultra.mf1VblockGetValue(src))
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async mf1VblockSetValue(dst, val) {
            const blkDt = new Buffer(16);
            const { value: val1 = 0, adr: adr1 = dst.block } = val;
            if (!_.isSafeInteger(val1))
                throw new TypeError('Invalid val.value');
            const [val2, adr2] = [-val1 - 1, 0xFF - adr1];
            blkDt.writeInt32LE(val1, 0).writeInt32LE(val2, 4).writeInt32LE(val1, 8);
            blkDt[12] = blkDt[14] = adr1;
            blkDt[13] = blkDt[15] = adr2;
            await this.cmdMf1WriteBlock({ ...dst, data: blkDt });
        }
        /**
         * Given a list of keys, check which is the correct key A and key B of the sectors. If you want to check more than 83 keys, you can use `mf1CheckKeysOfSectors()`.
         * @param opts.keys - The keys to be checked. Maximum length is `83`.
         * @param opts.mask - The mask of sectors. 80 bits, 2 bits/sector, the first bit is key A, the second bit is key B, `0b1` represent to skip checking the key.
         * @returns
         * - `found`: 80 bits, 2 bits/sector, the first bit is key A, the second bit is key B, `0b1` represent key is found.
         * - `sectorKeys`: 80 keys, 2 keys/sector, the first key is key A, the second key is key B. `null` represent key is not found.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer } = window.ChameleonUltraJS
         *   const mask = Buffer.from('00000000FFFFFFFFFFFF', 'hex')
         *   const keys = Buffer.from('FFFFFFFFFFFF\n000000000000\nA0A1A2A3A4A5\nD3F7D3F7D3F7', 'hex').chunk(6)
         *   const tsStart = Date.now()
         *   const result = await ultra.cmdMf1CheckKeysOfSectors({ keys, mask })
         *   console.log(`Time: ${Date.now() - tsStart}ms`)
         *   const replacer = function (k, v) { return Buffer.isBuffer(this[k]) ? this[k].toString('hex') : v }
         *   console.log(JSON.stringify(result, replacer, 2))
         * }
         * // {
         * //   "found": "ffffffff000000000000",
         * //   "sectorKeys": [
         * //     "ffffffffffff", "ffffffffffff", "ffffffffffff", "ffffffffffff",
         * //     "ffffffffffff", "ffffffffffff", "ffffffffffff", "ffffffffffff",
         * //     "ffffffffffff", "ffffffffffff", "ffffffffffff", "ffffffffffff",
         * //     "ffffffffffff", "ffffffffffff", "ffffffffffff", "ffffffffffff",
         * //     "ffffffffffff", "ffffffffffff", "ffffffffffff", "ffffffffffff",
         * //     "ffffffffffff", "ffffffffffff", "ffffffffffff", "ffffffffffff",
         * //     "ffffffffffff", "ffffffffffff", "ffffffffffff", "ffffffffffff",
         * //     "ffffffffffff", "ffffffffffff", "ffffffffffff", "ffffffffffff",
         * //     null, null, null, null,
         * //     null, null, null, null,
         * //     null, null, null, null,
         * //     null, null, null, null,
         * //     null, null, null, null,
         * //     null, null, null, null,
         * //     null, null, null, null,
         * //     null, null, null, null,
         * //     null, null, null, null,
         * //     null, null, null, null,
         * //     null, null, null, null,
         * //     null, null, null, null,
         * //   ]
         * // }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1CheckKeysOfSectors(opts) {
            const { keys, mask } = opts;
            if (!Buffer.isBuffer(mask) || mask.length !== 10)
                throw new TypeError('mask should be a Buffer with length 10');
            if (keys.length < 1 || keys.length > 83)
                throw new TypeError('Invalid keys.length');
            for (let i = 0; i < keys.length; i++) {
                const key = keys[i];
                if (!Buffer.isBuffer(key) || key.length !== 6)
                    throw new TypeError(`keys[${i}] should be a Buffer with length 6`);
            }
            let bitsCnt = 80;
            for (let b of mask)
                while (b > 0)
                    [bitsCnt, b] = [bitsCnt - (b & 0b1), b >>> 1];
            if (bitsCnt < 1)
                return null;
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_CHECK_KEYS_OF_SECTORS; // cmd = 2012
            const data = Buffer.concat([mask, ...keys]);
            const timeout = READ_DEFAULT_TIMEOUT + bitsCnt * (keys.length + 1) * 100;
            await this._writeCmd({ cmd, data });
            return Mf1CheckKeysOfSectorsRes.fromCmd2012((await this._readRespTimeout({ cmd, timeout }))?.data);
        }
        /**
         * Scan em410x tag and print id
         * @returns The id of em410x tag.
         * @group Reader Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const id = await ultra.cmdEm410xScan()
         *   console.log(id.toString('hex')) // 'deadbeef88'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdEm410xScan() {
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.EM410X_SCAN; // cmd = 3000
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data;
        }
        /**
         * Write id of em410x tag to t55xx tag.
         * @param id - The id of em410x tag.
         * @group Reader Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer } = window.ChameleonUltraJS
         *   await ultra.cmdEm410xWriteToT55xx(Buffer.from('deadbeef88', 'hex'))
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdEm410xWriteToT55xx(id,oldKeys) {
            if (!Buffer.isBuffer(id) || id.length !== 5)
                throw new TypeError('id should be a Buffer with length 5');
            await this.assureDeviceMode(exports.DeviceMode.READER);
            this._clearRxBufs();
            const cmd = exports.Cmd.EM410X_WRITE_TO_T55XX; // cmd = 3001
        
           // const data = Buffer.pack(`!5sI${oldKeys.length}I`, id, 0x20206666, ...oldKeys);
			
			const data = Buffer.concat([id,...oldKeys])
            await this._writeCmd({ cmd, data });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Set the mifare block data of actived slot.
         * @param offset - The start block of actived slot.
         * @param data - The data to be set. the length of data should be multiples of 16.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer } = window.ChameleonUltraJS
         *   await ultra.cmdMf1EmuWriteBlock(1, Buffer.alloc(16))
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1EmuWriteBlock(offset, data) {
            if (!_.isSafeInteger(offset))
                throw new TypeError('Invalid offset');
            if (!Buffer.isBuffer(data) || data.length % 16 !== 0)
                throw new TypeError('data should be a Buffer with length be multiples of 16');
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_WRITE_EMU_BLOCK_DATA; // cmd = 4000
            await this._writeCmd({ cmd, data: Buffer.pack(`!B${data.length}s`, offset, data) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Set the mifare anti-collision data of actived slot.
         * @param opts.uid - The new uid to be set.
         * @param opts.atqa - `2 bytes`, the new atqa to be set.
         * @param opts.sak - `1 byte`, the new sak to be set.
         * @param opts.ats - The new ats to be set.
         * @group Emulator Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer } = window.ChameleonUltraJS
         *   await ultra.cmdHf14aSetAntiCollData({
         *     atqa: Buffer.from('0400', 'hex'),
         *     sak: Buffer.from('08', 'hex'),
         *     uid: Buffer.from('01020304', 'hex')
         *   })
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdHf14aSetAntiCollData(opts) {
            const { uid, atqa, sak, ats = new Buffer() } = opts;
            if (!Buffer.isBuffer(uid) || !_.includes([4, 7, 10], uid.length))
                throw new TypeError('uid should be a Buffer with length 4, 7 or 10');
            if (!Buffer.isBuffer(atqa) || atqa.length !== 2)
                throw new TypeError('atqa should be a Buffer with length 2');
            if (!Buffer.isBuffer(sak) || sak.length !== 1)
                throw new TypeError('sak should be a Buffer with length 1');
            if (!Buffer.isBuffer(ats))
                throw new TypeError('ats should be a Buffer');
            this._clearRxBufs();
            const cmd = exports.Cmd.HF14A_SET_ANTI_COLL_DATA; // cmd = 4001
            await this._writeCmd({ cmd, data: Buffer.pack(`!${uid.length + 1}p2ss${ats.length + 1}p`, uid, atqa, sak, ats) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Enable or disable the mifare MFKey32 detection and clear the data of detections.
         * @param enable - `true` to enable the detection, `false` to disable the detection.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.cmdMf1SetDetectionEnable(true)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1SetDetectionEnable(enable) {
            if (_.isNil(enable))
                throw new TypeError('enable is required');
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_SET_DETECTION_ENABLE; // cmd = 4004
            await this._writeCmd({ cmd, data: Buffer.pack('!?', enable) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get the count of mifare MFKey32 detections.
         * @returns The count of mifare MFKey32 detections.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdMf1GetDetectionCount()) // 0
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1GetDetectionCount() {
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_GET_DETECTION_COUNT; // cmd = 4005
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data.readUInt32BE();
        }
        /**
         * Get the data of mifare MFKey32 detections.
         * @param offset - The start log of detections to be get.
         * @returns The mifare MFKey32 detections.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const logs = await ultra.cmdMf1GetDetectionLogs(0)
         *   console.log(logs)
         *   /**
         *    * {
         *    *   "block": 2,
         *    *   "isKeyB": 1,
         *    *   "isNested": 0,
         *    *   "uid": Buffer.from('65535d33', 'hex'),
         *    *   "nt": Buffer.from('cb7b9ed9', 'hex'),
         *    *   "nr": Buffer.from('5a8ffec6', 'hex'),
         *    *   "ar": Buffer.from('5c7c6f89', 'hex'),
         *    * }
         *    *\/
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1GetDetectionLogs(offset = 0) {
            if (!_.isSafeInteger(offset))
                throw new TypeError('Invalid offset');
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_GET_DETECTION_LOG; // cmd = 4006
            await this._writeCmd({ cmd, data: Buffer.pack('!I', offset) });
            return Mf1DetectionLog.fromCmd4006((await this._readRespTimeout({ cmd }))?.data);
        }
        /**
         * Get the feature of mifare MFKey32 detections is enabled or not.
         * @returns `true` if the feature of mifare MFKey32 detections is enabled, otherwise return `false`.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdMf1GetDetectionEnable()) // false
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1GetDetectionEnable() {
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_GET_DETECTION_ENABLE; // cmd = 4007
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data[0] === 1;
        }
        /**
         * Get the mifare block data of actived slot.
         * @param offset - The start block of actived slot.
         * @param length - The count of blocks to be get.
         * @returns The mifare block data of actived slot.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const data = await ultra.cmdMf1EmuReadBlock(1)
         *   console.log(data.toString('hex')) // '00000000000000000000000000000000'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1EmuReadBlock(offset = 0, length = 1) {
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_READ_EMU_BLOCK_DATA; // cmd = 4008
            await this._writeCmd({ cmd, data: Buffer.pack('!BB', offset, length) });
            return (await this._readRespTimeout({ cmd }))?.data;
        }
        /**
         * Get the mifare settings of actived slot.
         * @returns The mifare settings of actived slot.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const mf1Settings = await ultra.cmdMf1GetEmuSettings()
         *   console.log(JSON.stringify(mf1Settings))
         *   /**
         *    * {
         *    *   "detection": false,
         *    *   "gen1a": false,
         *    *   "gen2": false,
         *    *   "antiColl": false,
         *    *   "write": 0
         *    *  }
         *    *\/
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1GetEmuSettings() {
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_GET_EMULATOR_CONFIG; // cmd = 4009
            await this._writeCmd({ cmd });
            return Mf1EmuSettings.fromCmd4009((await this._readRespTimeout({ cmd }))?.data);
        }
        /**
         * Set the mifare gen1a mode of actived slot.
         * @returns The mifare gen1a mode of actived slot.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdMf1GetGen1aMode()) // false
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1GetGen1aMode() {
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_GET_GEN1A_MODE; // cmd = 4010
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data[0] === 1;
        }
        /**
         * Set the mifare gen1a mode of actived slot.
         * @param enable - `true` to enable the gen1a mode, `false` to disable the gen1a mode.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.cmdMf1SetGen1aMode(false)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1SetGen1aMode(enable) {
            if (_.isNil(enable))
                throw new TypeError('enable is required');
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_SET_GEN1A_MODE; // cmd = 4011
            await this._writeCmd({ cmd, data: Buffer.pack('!?', enable) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get the mifare gen2 mode of actived slot.
         * @returns The mifare gen2 mode of actived slot.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdMf1GetGen2Mode()) // false
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1GetGen2Mode() {
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_GET_GEN2_MODE; // cmd = 4012
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data[0] === 1;
        }
        /**
         * Set the mifare gen2 mode of actived slot.
         * @param enable - `true` to enable the gen2 mode, `false` to disable the gen2 mode.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.cmdMf1SetGen2Mode(false)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1SetGen2Mode(enable) {
            if (_.isNil(enable))
                throw new TypeError('enable is required');
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_SET_GEN2_MODE; // cmd = 4013
            await this._writeCmd({ cmd, data: Buffer.pack('!?', enable) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get the mode of actived slot that using anti-collision data from block 0 for 4 byte UID tags or not.
         * @returns The mode of actived slot that using anti-collision data from block 0 for 4 byte UID tags or not.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdMf1GetAntiCollMode()) // false
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1GetAntiCollMode() {
            this._clearRxBufs();
            const cmd = exports.Cmd.HF14A_GET_BLOCK_ANTI_COLL_MODE; // cmd = 4014
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data[0] === 1;
        }
        /**
         * Set the mode of actived slot that using anti-collision data from block 0 for 4 byte UID tags or not.
         * @param enable - `true` to enable the mode, `false` to disable the mode.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.cmdMf1SetAntiCollMode(false)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1SetAntiCollMode(enable) {
            if (_.isNil(enable))
                throw new TypeError('enable is required');
            this._clearRxBufs();
            const cmd = exports.Cmd.HF14A_SET_BLOCK_ANTI_COLL_MODE; // cmd = 4015
            await this._writeCmd({ cmd, data: Buffer.pack('!?', enable) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get the mifare write mode of actived slot.
         * @returns The mifare write mode of actived slot.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   console.log(await ultra.cmdMf1GetWriteMode()) // 0
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1GetWriteMode() {
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_GET_WRITE_MODE; // cmd = 4016
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data[0];
        }
        /**
         * Set the mifare write mode of actived slot.
         * @param mode - The mifare write mode of actived slot.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Mf1EmuWriteMode } = window.ChameleonUltraJS
         *   await ultra.cmdMf1SetWriteMode(Mf1EmuWriteMode.NORMAL)
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdMf1SetWriteMode(mode) {
            if (!isMf1EmuWriteMode(mode))
                throw new TypeError('Invalid mode');
            this._clearRxBufs();
            const cmd = exports.Cmd.MF1_SET_WRITE_MODE; // cmd = 4017
            await this._writeCmd({ cmd, data: Buffer.pack('!B', mode) });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get anti-collision data from actived slot.
         * @returns The anti-collision data from actived slot.
         * @group Emulator Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const res = await ultra.cmdHf14aGetAntiCollData()
         *   console.log(JSON.stringify(res))
         *   // {
         *   //   "uid": { "type": "Buffer", "data": [222, 173, 190, 239] },
         *   //   "atqa": { "type": "Buffer", "data": [4, 0] },
         *   //   "sak": { "type": "Buffer", "data": [8] },
         *   //   "ats": { "type": "Buffer", "data": [] }
         *   // }
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdHf14aGetAntiCollData() {
            this._clearRxBufs();
            const cmd = exports.Cmd.HF14A_GET_ANTI_COLL_DATA; // cmd = 4018
            await this._writeCmd({ cmd });
            const data = (await this._readRespTimeout({ cmd }))?.data;
            return data.length > 0 ? Hf14aAntiColl.fromBuffer(data) : null;
        }
        /**
         * Set the em410x id of actived slot.
         * @param id - The em410x id of actived slot.
         * @group Emulator Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer } = window.ChameleonUltraJS
         *   await ultra.cmdEm410xSetEmuId(Buffer.from('deadbeef88', 'hex'))
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdEm410xSetEmuId(id) {
            if (!Buffer.isBuffer(id) || id.length !== 5)
                throw new TypeError('id should be a Buffer with length 5');
            this._clearRxBufs();
            const cmd = exports.Cmd.EM410X_SET_EMU_ID; // cmd = 5000
            await this._writeCmd({ cmd, data: id });
            await this._readRespTimeout({ cmd });
        }
        /**
         * Get the em410x id of actived slot.
         * @returns The em410x id of actived slot.
         * @group Emulator Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const id = await ultra.cmdEm410xGetEmuId()
         *   console.log(id.toString('hex')) // 'deadbeef88'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async cmdEm410xGetEmuId() {
            this._clearRxBufs();
            const cmd = exports.Cmd.EM410X_GET_EMU_ID; // cmd = 5001
            await this._writeCmd({ cmd });
            return (await this._readRespTimeout({ cmd }))?.data;
        }
        /**
         * Check if the firmware version is supported by SDK.
         * @returns `true` if the firmware version is supported, `false` otherwise.
         * @group Device Related
         * @example
         * ```js
         * async function run (ultra) {
         *   if (await ultra.isSupportedAppVersion()) throw new Error('Firmware version is not supported. Please update the firmware.')
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async isSupportedAppVersion() {
            const version = await this.cmdGetAppVersion();
            return versionCompare(version, VERSION_SUPPORTED.gte) >= 0 && versionCompare(version, VERSION_SUPPORTED.lt) < 0;
        }
        /**
         * Read 4 pages (16 bytes) from Mifare Ultralight
         * @param opts.pageOffset - page number to read
         * @returns 4 pages (16 bytes)
         * @group Mifare Ultralight Related
         * @see [MF0ICU1 MIFARE Ultralight contactless single-ticket IC](https://www.nxp.com/docs/en/data-sheet/MF0ICU1.pdf#page=16)
         * @example
         * ```js
         * async function run (ultra) {
         *   const data = await ultra.mfuReadPages({ pageOffset: 0 })
         *   console.log(data.toString('hex')) // '040dc445420d2981e7480000e1100600'
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async mfuReadPages(opts) {
            const { pageOffset } = opts;
            if (!_.isSafeInteger(pageOffset))
                throw new TypeError('Invalid pageOffset');
            return await this.cmdHf14aRaw({
                appendCrc: true,
                autoSelect: true,
                checkResponseCrc: true,
                data: Buffer.pack('!BB', 0x30, pageOffset),
            });
        }
        /**
         * Write 1 page (4 bytes) to Mifare Ultralight
         * @param opts.pageOffset - page number to read
         * @param opts.data - `4 bytes`, the page data to be written.
         * @group Mifare Ultralight Related
         * @see [MF0ICU1 MIFARE Ultralight contactless single-ticket IC](https://www.nxp.com/docs/en/data-sheet/MF0ICU1.pdf#page=17)
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer } = window.ChameleonUltraJS
         *   const data = await ultra.mfuWritePage({ pageOffset: 9, data: Buffer.from('00000000', 'hex') })
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async mfuWritePage(opts) {
            const { pageOffset, data } = opts;
            if (!_.isSafeInteger(pageOffset))
                throw new TypeError('Invalid pageOffset');
            if (!Buffer.isBuffer(data) || data.length !== 4)
                throw new TypeError('data should be a Buffer with length 4');
            await this.cmdHf14aRaw({
                appendCrc: true,
                autoSelect: true,
                checkResponseCrc: true,
                data: Buffer.pack('!BB4s', 0xA2, pageOffset, data),
            });
        }
        /**
         * Send Mifare Classic HALT command and close RF field.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   await ultra.mf1Halt()
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async mf1Halt() {
            await this.cmdHf14aRaw({ appendCrc: true, data: Buffer.pack('!H', 0x5000), waitResponse: false }); // HALT + close RF field
        }
        /**
         * Magic auth helper function for mifare gen1a tag.
         * @param cb - The callback function to be executed after auth.
         * @returns The result of callback function.
         * @group Mifare Classic Related
         */
        async _mf1Gen1aAuth(cb) {
            try {
                if (_.isNil(cb))
                    throw new TypeError('cb is required');
                await this.mf1Halt();
                const resp1 = await this.cmdHf14aRaw({ data: Buffer.pack('!B', 0x40), dataBitLength: 7, keepRfField: true }) // 0x40 (7)
                    .catch(err => { throw _.merge(new Error(`Gen1a auth failed 1: ${err.message}`), { originalError: err }); });
                if (resp1[0] !== 0x0A)
                    throw new Error('Gen1a auth failed 1');
                const resp2 = await this.cmdHf14aRaw({ data: Buffer.pack('!B', 0x43), keepRfField: true }) // 0x43
                    .catch(err => { throw _.merge(new Error(`Gen1a auth failed 2: ${err.message}`), { originalError: err }); });
                if (resp2[0] !== 0x0A)
                    throw new Error('Gen1a auth failed 2');
                return await cb();
            }
            finally {
                if (this.isConnected())
                    await this.mf1Halt();
            }
        }
        /**
         * Read blocks from Mifare Classic Gen1a.
         * @param offset - The start block of Mifare Classic Gen1a.
         * @param length - The amount of blocks to read.
         * @returns The blocks data.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const card = await ultra.mf1Gen1aReadBlocks(0, 64)
         *   console.log(_.map(card.chunk(16), chunk => chunk.toString('hex')).join('\n'))
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async mf1Gen1aReadBlocks(offset, length = 1) {
            if (!_.isSafeInteger(offset))
                throw new TypeError('Invalid offset');
            if (!_.isSafeInteger(length))
                throw new TypeError('Invalid length');
            return await this._mf1Gen1aAuth(async () => {
                const buf = new Buffer(length * 16);
                for (let i = 0; i < length; i++) {
                    buf.set(await this.cmdHf14aRaw({
                        appendCrc: true,
                        checkResponseCrc: true,
                        data: Buffer.pack('!BB', 0x30, offset + i),
                        keepRfField: true,
                    }), i * 16);
                }
                return buf;
            });
        }
        /**
         * Write blocks to Mifare Classic Gen1a.
         * @param offset - The start block of Mifare Classic Gen1a.
         * @param data - The blocks data to write.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer } = window.ChameleonUltraJS
         *   await ultra.mf1Gen1aWriteBlocks(1, new Buffer(16))
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async mf1Gen1aWriteBlocks(offset, data) {
            if (!_.isSafeInteger(offset))
                throw new TypeError('Invalid offset');
            if (!Buffer.isBuffer(data) || data.length % 16 !== 0)
                throw new TypeError('data should be a Buffer with length be multiples of 16');
            await this._mf1Gen1aAuth(async () => {
                const blocks = data.chunk(16);
                for (let i = 0; i < blocks.length; i++) {
                    const resp1 = await this.cmdHf14aRaw({ appendCrc: true, data: Buffer.pack('!BB', 0xA0, offset + i), keepRfField: true });
                    if (resp1[0] !== 0x0A)
                        throw new Error('Gen1a write failed 1');
                    const resp2 = await this.cmdHf14aRaw({ appendCrc: true, data: blocks[i], keepRfField: true });
                    if (resp2[0] !== 0x0A)
                        throw new Error('Gen1a write failed 2');
                }
            });
        }
        /**
         * Get the blockNo of sector trailer.
         * @param sector - The sector number.
         * @returns The blockNo of sector trailer.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run () {
         *   const { ChameleonUltra } = window.ChameleonUltraJS
         *   console.log(ChameleonUltra.mf1TrailerBlockNoOfSector(0))
         *   // 3
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        static mf1TrailerBlockNoOfSector(sector) {
            return sector < 32 ? sector * 4 + 3 : sector * 16 - 369;
        }
        /**
         * Given a list of keys, check which is the correct key A and key B of the sector.
         * @param sector - The sector number to be checked.
         * @param keys - The keys dictionary.
         * @returns The Key A and Key B of the sector.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer } = window.ChameleonUltraJS
         *   const keys = Buffer.from('FFFFFFFFFFFF\n000000000000\nA0A1A2A3A4A5\nD3F7D3F7D3F7', 'hex').chunk(6)
         *   const sectorKey = await ultra.mf1CheckSectorKeys(0, keys)
         *   console.log(_.mapValues(sectorKey, key => key.toString('hex')))
         *   // { "96": "ffffffffffff", "97": "ffffffffffff" }
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async mf1CheckSectorKeys(sector, keys) {
            if (!_.isSafeInteger(sector))
                throw new TypeError('Invalid sector');
            const mask = Buffer.alloc(10, 0xFF);
            mask[sector >>> 2] ^= 3 << (6 - sector % 4 * 2);
            const [ka, kb] = (await this.mf1CheckKeysOfSectors({ keys, mask })).slice(sector * 2, sector * 2 + 2);
            return {
                ...(_.isNil(ka) ? {} : { [exports.Mf1KeyType.KEY_A]: ka }),
                ...(_.isNil(kb) ? {} : { [exports.Mf1KeyType.KEY_B]: kb }),
            };
        }
        /**
         * Mifare Classic check keys of sectors.
         * @param opts.chunkSize - `keys` will be chunked by this size.
         * @param opts.keys - The keys to be checked.
         * @param opts.mask - The mask of sectors. 80 bits, 2 bits/sector, the first bit is key A, the second bit is key B, 0b1 represent to skip checking the key.
         * @param opts.maxSectors - The max sectors to be check.
         * @param opts.onChunkKeys - The callback function to be invoked before checking every chunk of keys.
         * @group Mifare Classic Related
         * @returns
         */
        async mf1CheckKeysOfSectors(opts) {
            let { chunkSize = 20, keys, mask = new Buffer(10), maxSectors = 40, onChunkKeys } = opts;

            if (keys.length === 0)
                throw new TypeError('Invalid keys');
            if (!Buffer.isBuffer(mask))
                mask = new Buffer(10);
            else if (mask.length !== 10) {
                const buf = new Buffer(10);
                buf.copy(mask, 0, 0, 10);
                mask = buf;
            }
            // console.log({ chunkSize, keys, mask, maxSectors })
            for (let i = maxSectors ?? 40; i < 40; i++)
                mask[i >>> 2] |= 3 << (6 - i % 4 * 2);
            const foundKeys = new Array(maxSectors * 2).fill(null);
            for (const chunkKeys of _.chunk(keys, chunkSize)) {
                await onChunkKeys?.({ keys: chunkKeys, mask });
                const tmp = await this.cmdMf1CheckKeysOfSectors({ keys: chunkKeys, mask });
                if (_.isNil(tmp))
                    break; // all founded
                for (let i = 0; i < 10; i++)
                    mask[i] |= tmp.found[i];
                for (let i = 0; i < maxSectors * 2; i++) {
                    if (_.isNil(tmp.sectorKeys[i]))
                        continue;
                    foundKeys[i] = tmp.sectorKeys[i];
                }
            }
            return foundKeys;
        }
        /**
         * Read the sector data of Mifare Classic by given keys.
         * @param sector - The sector number to be read.
         * @param keys - The keys dictionary.
         * @returns The sector data and the read status of each block.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer, Mf1KeyType } = window.ChameleonUltraJS
         *   const keys = Buffer.from('FFFFFFFFFFFF\n000000000000\nA0A1A2A3A4A5\nD3F7D3F7D3F7', 'hex').chunk(6)
         *   const { data, success } = await ultra.mf1ReadSectorByKeys(0, keys)
         *   console.log({ data: data.toString('hex'), success })
         *   // { "data": "...", "success": [true, true, true, true] }
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async mf1ReadSectorByKeys(sector, keys) {
            const sectorKey = await this.mf1CheckSectorKeys(sector, keys);
            if (_.isEmpty(sectorKey))
                throw new Error('No valid key');
            const data = new Buffer(64);
            const success = _.times(4, () => false);
            for (let i = 0; i < 4; i++) {
                for (const keyType of [exports.Mf1KeyType.KEY_B, exports.Mf1KeyType.KEY_A]) {
                    const key = sectorKey[keyType];
                    if (_.isNil(key))
                        continue;
                    try {
                        data.set(await this.cmdMf1ReadBlock({ block: sector * 4 + i, keyType, key }), i * 16);
                        success[i] = true;
                        break;
                    }
                    catch (err) {
                        if (!this.isConnected())
                            throw err;
                        this.logger.core(`Failed to read block ${sector * 4 + i} with ${exports.Mf1KeyType[keyType]} = ${key.toString('hex')}`);
                    }
                }
            }
            if (!_.isNil(sectorKey[exports.Mf1KeyType.KEY_A]))
                data.set(sectorKey[exports.Mf1KeyType.KEY_A], 48);
            if (!_.isNil(sectorKey[exports.Mf1KeyType.KEY_B]))
                data.set(sectorKey[exports.Mf1KeyType.KEY_B], 58);
            return { data, success };
        }
        /**
         * Write the sector data of Mifare Classic by given keys.
         * @param sector - The sector number to be written.
         * @param keys - The key dictionary.
         * @param data - Sector data
         * @returns the write status of each block.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer } = window.ChameleonUltraJS
         *   const keys = Buffer.from('FFFFFFFFFFFF\n000000000000\nA0A1A2A3A4A5\nD3F7D3F7D3F7', 'hex').chunk(6)
         *   const data = Buffer.concat([
         *     Buffer.from('00000000000000000000000000000000', 'hex'),
         *     Buffer.from('00000000000000000000000000000000', 'hex'),
         *     Buffer.from('00000000000000000000000000000000', 'hex'),
         *     Buffer.from('ffffffffffffff078069ffffffffffff', 'hex'),
         *   ])
         *   const { success } = await ultra.mf1WriteSectorByKeys(1, keys, data)
         *   console.log(success)
         *   // [true, true, true, true]
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        async mf1WriteSectorByKeys(sector, keys, data) {
            if (!Buffer.isBuffer(data) || data.length !== 64)
                throw new TypeError('data should be a Buffer with length 64');
            if (!this.mf1IsValidAcl(data))
                throw new TypeError('Invalid ACL bytes of data');
            const sectorKey = await this.mf1CheckSectorKeys(sector, keys);
            if (_.isEmpty(sectorKey))
                throw new Error('No valid key');
            const success = _.times(4, () => false);
            for (let i = 0; i < 4; i++) {
                for (const keyType of [exports.Mf1KeyType.KEY_B, exports.Mf1KeyType.KEY_A]) {
                    const key = sectorKey[keyType];
                    if (_.isNil(key))
                        continue;
                    try {
                        await this.cmdMf1WriteBlock({ block: sector * 4 + i, keyType, key, data: data.slice(i * 16, i * 16 + 16) });
                        success[i] = true;
                        break;
                    }
                    catch (err) {
                        if (!this.isConnected())
                            throw err;
                        this.logger.core(`Failed to write block ${sector * 4 + i} with ${exports.Mf1KeyType[keyType]} = ${key.toString('hex')}`);
                    }
                }
            }
            return { success };
        }
        /**
         * Check acl bytes of ACL, block or sector.
         * @param data - Data of ACL, block or sector.
         * @returns `true` if the acl bytes is valid, `false` otherwise.
         * @group Mifare Classic Related
         * @example
         * ```js
         * async function run (ultra) {
         *   const { Buffer } = window.ChameleonUltraJS
         *   console.log(ultra.mf1IsValidAcl(Buffer.from('ff078069', 'hex'))) // true
         * }
         *
         * await run(vm.ultra) // you can run in DevTools of https://taichunmin.idv.tw/chameleon-ultra.js/test.html
         * ```
         */
        mf1IsValidAcl(data) {
            if (!Buffer.isBuffer(data) || !_.includes([3, 4, 16, 64], data.length))
                throw new TypeError('data should be a Buffer with length 3, 4, 16 or 64');
            if (data.length === 16)
                data = data.subarray(6);
            else if (data.length === 64)
                data = data.subarray(54);
            const acl = [];
            for (let i = 0; i < 3; i++)
                acl.push((data[i] & 0xF0) >>> 4, data[i] & 0x0F);
            return _.every([[1, 2], [0, 5], [3, 4]], ([a, b]) => (acl[a] ^ acl[b]) === 0xF);
        }
    }
    const RespStatusMsg = new Map([
        [RespStatus.HF_TAG_OK, 'HF tag operation succeeded'],
        [RespStatus.HF_TAG_NOT_FOUND, 'HF tag not found error'],
        [RespStatus.HF_ERR_STAT, 'HF tag status error'],
        [RespStatus.HF_ERR_CRC, 'HF tag data crc error'],
        [RespStatus.HF_COLLISION, 'HF tag collision'],
        [RespStatus.HF_ERR_BCC, 'HF tag uid bcc error'],
        [RespStatus.MF_ERR_AUTH, 'HF tag auth failed'],
        [RespStatus.HF_ERR_PARITY, 'HF tag data parity error'],
        [RespStatus.HF_ERR_ATS, 'HF tag was supposed to send ATS but didn\'t'],
        [RespStatus.LF_TAG_OK, 'LF tag operation succeeded'],
        [RespStatus.EM410X_TAG_NOT_FOUND, 'EM410x tag not found error'],
        [RespStatus.PAR_ERR, 'invalid param error'],
        [RespStatus.DEVICE_MODE_ERROR, 'wrong device mode error'],
        [RespStatus.INVALID_CMD, 'invalid cmd error'],
        [RespStatus.DEVICE_SUCCESS, 'Device operation succeeded'],
        [RespStatus.NOT_IMPLEMENTED, 'Not implemented error'],
        [RespStatus.FLASH_WRITE_FAIL, 'Flash write failed'],
        [RespStatus.FLASH_READ_FAIL, 'Flash read failed'],
    ]);
    const RespStatusFail = new Set([
        RespStatus.HF_TAG_NOT_FOUND,
        RespStatus.HF_ERR_STAT,
        RespStatus.HF_ERR_CRC,
        RespStatus.HF_COLLISION,
        RespStatus.HF_ERR_BCC,
        RespStatus.MF_ERR_AUTH,
        RespStatus.HF_ERR_PARITY,
        RespStatus.HF_ERR_ATS,
        RespStatus.EM410X_TAG_NOT_FOUND,
        RespStatus.PAR_ERR,
        RespStatus.DEVICE_MODE_ERROR,
        RespStatus.INVALID_CMD,
        RespStatus.NOT_IMPLEMENTED,
        RespStatus.FLASH_WRITE_FAIL,
        RespStatus.FLASH_READ_FAIL,
    ]);
    class ChameleonRxSink {
        bufs = [];
        controller;
        constructor() {
            this.controller = new AbortController();
        }
        get signal() { return this.controller.signal; }
        write(chunk) {
            this.bufs.push(Buffer.from(chunk));
        }
    }
    class ChameleonUltraFrame {
        buf;
        constructor(buf) {
            this.buf = buf;
        }
        static inspect(buf) {
            if (!Buffer.isBuffer(buf))
                return 'Invalid frame';
            // sof + sof lrc + cmd (2) + status (2) + data len (2) + head lrc + data + data lrc
            return [
                buf.slice(0, 2).toString('hex'), // sof + sof lrc
                buf.slice(2, 4).toString('hex'), // cmd
                buf.slice(4, 6).toString('hex'), // status
                buf.slice(6, 8).toString('hex'), // data len
                buf.slice(8, 9).toString('hex'), // head lrc
                buf.readUInt16BE(6) > 0 ? buf.slice(9, -1).toString('hex') : '(no data)', // data
                buf.slice(-1).toString('hex'), // data lrc
            ].join(' ');
        }
        get cmd() { return this.buf.readUInt16BE(2); }
        get data() { return this.buf.subarray(9, -1); }
        get inspect() { return ChameleonUltraFrame.inspect(this.buf); }
        get status() { return this.buf.readUInt16BE(4); }
    }
    /**
     * @see [MIFARE type identification procedure](https://www.nxp.com/docs/en/application-note/AN10833.pdf)
     */
    const NxpTypeBySak = new Map([
        [0x00, 'MIFARE Ultralight Classic/C/EV1/Nano | NTAG 2xx'],
        [0x08, 'MIFARE Classic 1K | Plus SE 1K | Plug S 2K | Plus X 2K'],
        [0x09, 'MIFARE Mini 0.3k'],
        [0x10, 'MIFARE Plus 2K'],
        [0x11, 'MIFARE Plus 4K'],
        [0x18, 'MIFARE Classic 4K | Plus S 4K | Plus X 4K'],
        [0x19, 'MIFARE Classic 2K'],
        [0x20, 'MIFARE Plus EV1/EV2 | DESFire EV1/EV2/EV3 | DESFire Light | NTAG 4xx | MIFARE Plus S 2/4K | MIFARE Plus X 2/4K | MIFARE Plus SE 1K'],
        [0x28, 'SmartMX with MIFARE Classic 1K'],
        [0x38, 'SmartMX with MIFARE Classic 4K'],
    ]);

    /** The version of `chameleon-ultra.js`. */
    const version = '0.2.22';

    exports.Buffer = Buffer;
    exports.ChameleonUltra = ChameleonUltra;
    exports.version = version;

    return exports;

})({}, _, window);
