this.ChameleonUltraJS = this.ChameleonUltraJS || {};
this.ChameleonUltraJS.WebbleAdapter = (function(_, webbluetooth, web) {
	'use strict';
	const BASE64_CHAR = _.transform('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split(''), (m, v, k) => {
		m.set(k, v).set(v, k)
	}, new Map()).set('-', 62).set('_', 63);
	const BASE64URL_CHAR = _.transform('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'.split(''), (m, v, k) => {
		m.set(k, v).set(v, k)
	}, new Map()).set('+', 62).set('/', 63);
	const HEX_CHAR = _.transform('0123456789abcdef'.split(''), (m, v, k) => {
		m.set(k, v).set(v, k).set(_.toUpper(v), k)
	}, new Map());
	const K_MAX_LENGTH = 0x7FFFFFFF;
	const SIGNED_MAX_VALUE = [0, 0x7F, 0x7FFF, 0x7FFFFF, 0x7FFFFFFF, 0x7FFFFFFFFF, 0x7FFFFFFFFFFF];
	const SIGNED_OFFSET = [0, 0x100, 0x10000, 0x1000000, 0x100000000, 0x10000000000, 0x1000000000000];

	function isInstance(obj, type) {
		return obj instanceof type || obj?.constructor?.name === type?.name
	}

	function isSharedArrayBuffer(val) {
		return typeof SharedArrayBuffer !== 'undefined' && (isInstance(val, SharedArrayBuffer) || isInstance(val?.buffer, SharedArrayBuffer))
	}

	function floatU32ToU16(u32) {
		const exp = (u32 >>> 23) & 0xFF;
		if (exp === 0xFF) return ((u32 >>> 16) & 0x8000) + 0x7C00 + ((u32 & 0x7FFFFF) !== 0 ? 0x200 : 0);
		if (exp === 0) return ((u32 >>> 16) & 0x8000) + ((u32 >>> 13) & 0x3FF);
		return ((u32 >>> 16) & 0x8000) + (((exp - 112) << 10) & 0x7C00) + ((u32 >>> 13) & 0x3FF)
	}

	function floatU16ToU32(u16) {
		const exp = (u16 >>> 10) & 0x1F;
		if (exp === 0x1F) return ((u16 << 16) & 0x80000000) + 0x7F800000 + ((u16 & 0x3FF) !== 0 ? 0x400000 : 0);
		if (exp === 0) return ((u16 << 16) & 0x80000000) + ((u16 << 13) & 0x7FE000);
		return ((u16 << 16) & 0x80000000) + (((exp + 112) << 23) & 0x7F800000) + ((u16 << 13) & 0x7FE000)
	}
	const float16Buf = new DataView(new ArrayBuffer(4));
	var Encoding;
	(function(Encoding) {
		Encoding["ucs-2"] = "ucs-2";
		Encoding["utf-16le"] = "utf-16le";
		Encoding["utf-8"] = "utf-8";
		Encoding["ascii"] = "ascii";
		Encoding["base64"] = "base64";
		Encoding["base64url"] = "base64url";
		Encoding["binary"] = "binary";
		Encoding["hex"] = "hex";
		Encoding["latin1"] = "latin1";
		Encoding["ucs2"] = "ucs2";
		Encoding["utf16le"] = "utf16le";
		Encoding["utf8"] = "utf8"
	})(Encoding || (Encoding = {}));

	function createIsEnum(e) {
		const ev = new Set(_.chain(e).toPairs().filter(([k, v]) => !_.isNumber(e[v])).map(1).value());
		return (val) => ev.has(val)
	}
	const isNativeLittleEndian = new Uint8Array(new Uint16Array([0x1234]).buffer)[0] === 0x12;
	const packFromFns = new Map([
		['x', packFromPad],
		['c', packFromChar],
		['b', packFromInt8],
		['B', packFromInt8],
		['?', packFromBool],
		['h', packFromInt16],
		['H', packFromInt16],
		['i', packFromInt32],
		['I', packFromInt32],
		['l', packFromInt32],
		['L', packFromInt32],
		['q', packFromBigInt64],
		['Q', packFromBigInt64],
		['e', packFromFloat16],
		['f', packFromFloat],
		['d', packFromDouble],
		['s', packFromString],
		['p', packFromPascal],
	]);
	const unpackToFns = new Map([
		['x', unpackToPad],
		['c', unpackToChar],
		['b', unpackToInt8],
		['B', unpackToInt8],
		['?', unpackToBool],
		['h', unpackToInt16],
		['H', unpackToInt16],
		['i', unpackToInt32],
		['I', unpackToInt32],
		['l', unpackToInt32],
		['L', unpackToInt32],
		['q', unpackToBigInt64],
		['Q', unpackToBigInt64],
		['e', unpackToFloat16],
		['f', unpackToFloat],
		['d', unpackToDouble],
		['s', unpackToString],
		['p', unpackToPascal],
	]);
	class Buffer extends Uint8Array {
		dv;
		constructor(val, offset, length) {
			if (_.isNil(val)) super();
			else if (_.isNil(offset)) super(val);
			else if (_.isNil(length)) super(val, offset);
			else super(val, offset, length);
			this.dv = new DataView(this.buffer, this.byteOffset, this.byteLength)
		}
		static isEncoding = createIsEnum(Encoding);
		static alloc(size, fill, encoding = 'utf8') {
			if (!_.isSafeInteger(size) || size >= K_MAX_LENGTH) throw new RangeError(`Invalid size:${size}`);
			const buf = new Buffer(size);
			if (_.isNil(fill)) return buf;
			return _.isNil(encoding) ? buf.fill(fill) : buf.fill(fill, encoding)
		}
		static allocUnsafe(size) {
			return new Buffer(size)
		}
		static allocUnsafeSlow(size) {
			return new Buffer(size)
		}
		static byteLength(string, encoding = 'utf8') {
			if (Buffer.isBuffer(string) || isInstance(string, ArrayBuffer) || isSharedArrayBuffer(string) || ArrayBuffer.isView(string)) return string.byteLength;
			if (!_.isString(string)) throw new TypeError(`Invalid type of string:${typeof string}`);
			if (_.includes(['ascii', 'latin1', 'binary'], encoding)) return string.length;
			if (_.includes(['ucs2', 'ucs-2', 'utf16le', 'utf-16le'], encoding)) return string.length * 2;
			if (encoding === 'hex') return string.length >>> 1;
			if (_.includes(['base64', 'base64url'], encoding)) return (string.replace(/[^A-Za-z0-9/_+-]/g, '').length * 3) >>> 2;
			return new TextEncoder().encode(string).length
		}
		static compare(buf1, buf2) {
			if (!Buffer.isBuffer(buf1)) {
				if (!ArrayBuffer.isView(buf1)) throw new TypeError('Invalid type');
				buf1 = Buffer.fromView(buf1)
			}
			return buf1.compare(buf2)
		}
		static equals(buf1, buf2) {
			return Buffer.isBuffer(buf1) && buf1.equals(buf2)
		}
		static concat(list, totalLength) {
			if (_.isNil(totalLength)) totalLength = _.sumBy(list, 'length');
			if (totalLength < 0) totalLength = 0;
			const buf = new Buffer(totalLength);
			let start = 0;
			for (let i = 0; i < list.length; i++) {
				if (start + list[i].length > totalLength) list[i] = list[i].subarray(0, totalLength - start);
				buf.set(list[i], start);
				start += list[i].length
			}
			return buf
		}
		static fromView(view, offset = 0, length) {
			if (!ArrayBuffer.isView(view)) throw new TypeError('invalid view');
			const bytesPerElement = view?.BYTES_PER_ELEMENT ?? 1;
			const viewLength = view.byteLength / bytesPerElement;
			if (_.isNil(length)) length = viewLength - offset;
			return new Buffer(view.buffer, view.byteOffset + offset * bytesPerElement, length * bytesPerElement)
		}
		static copyBytesFrom(view, offset = 0, length) {
			return new Buffer(Buffer.fromView(view, offset, length))
		}
		static from(val, encodingOrOffset, length) {
			const valueOfObj = val?.[Symbol.toPrimitive]?.('string') ?? val?.valueOf?.();
			if (!_.isNil(valueOfObj) && valueOfObj !== val) val = valueOfObj;
			if (Buffer.isBuffer(val)) return new Buffer(val);
			if (ArrayBuffer.isView(val)) return Buffer.fromView(val);
			if (isInstance(val, ArrayBuffer) || isSharedArrayBuffer(val)) return new Buffer(val, encodingOrOffset, length);
			if (_.isString(val)) return Buffer.fromString(val, encodingOrOffset);
			if (_.isArray(val)) return Buffer.fromArray(val);
			if (typeof val[Symbol.iterator] === 'function') return Buffer.fromArray([...val]);
			throw new TypeError(`Invalid type of value:${typeof val}`)
		}
		static fromString(str, encoding = 'utf8') {
			encoding = _.toLower(encoding);
			if (!Buffer.isEncoding(encoding)) throw new TypeError(`Unknown encoding:${encoding}`);
			const fromStringFns = {
				'ucs-2': Buffer.fromUcs2String,
				'utf-16le': Buffer.fromUcs2String,
				'utf-8': Buffer.fromUtf8String,
				ascii: Buffer.fromAsciiString,
				base64: Buffer.fromBase64String,
				base64url: Buffer.fromBase64urlString,
				binary: Buffer.fromAsciiString,
				hex: Buffer.fromHexString,
				latin1: Buffer.fromAsciiString,
				ucs2: Buffer.fromUcs2String,
				utf16le: Buffer.fromUcs2String,
				utf8: Buffer.fromUtf8String,
			};
			return fromStringFns[encoding](str)
		}
		static fromUcs2String(ucs2) {
			const buf = new Buffer(ucs2.length * 2);
			for (let i = 0; i < ucs2.length; i++) buf.writeUInt16LE(ucs2.charCodeAt(i), i * 2);
			return buf
		}
		static fromUtf8String(utf8) {
			return Buffer.fromView(new TextEncoder().encode(utf8))
		}
		static fromAsciiString(ascii) {
			const buf = new Buffer(ascii.length);
			for (let i = 0; i < ascii.length; i++) buf[i] = ascii.charCodeAt(i) & 0xFF;
			return buf
		}
		static fromBase64String(base64) {
			base64 = base64.replace(/[^A-Za-z0-9/_+-]/g, '');
			const tmp1 = base64.length;
			const tmp2 = base64.length + 3;
			base64 = `${base64}AAA`.slice(0, tmp2 - tmp2 % 4);
			const buf = new Buffer(base64.length * 3 >>> 2);
			let parsedLen = 0;
			for (let i = 0; i < base64.length; i += 4) {
				const u24 = (BASE64_CHAR.get(base64[i]) << 18) + (BASE64_CHAR.get(base64[i + 1]) << 12) + (BASE64_CHAR.get(base64[i + 2]) << 6) + BASE64_CHAR.get(base64[i + 3]);
				buf[parsedLen++] = (u24 >>> 16) & 0xFF;
				buf[parsedLen++] = (u24 >>> 8) & 0xFF;
				buf[parsedLen++] = (u24 >>> 0) & 0xFF
			}
			return tmp1 < base64.length ? buf.subarray(0, tmp1 - base64.length) : buf
		}
		static fromBase64urlString(base64) {
			base64 = base64.replace(/[^A-Za-z0-9/_+-]/g, '');
			const tmp1 = base64.length;
			const tmp2 = base64.length + 3;
			base64 = `${base64}AAA`.slice(0, tmp2 - tmp2 % 4);
			const buf = new Buffer(base64.length * 3 >>> 2);
			let parsedLen = 0;
			for (let i = 0; i < base64.length; i += 4) {
				const u24 = (BASE64URL_CHAR.get(base64[i]) << 18) + (BASE64URL_CHAR.get(base64[i + 1]) << 12) + (BASE64URL_CHAR.get(base64[i + 2]) << 6) + BASE64URL_CHAR.get(base64[i + 3]);
				buf[parsedLen++] = (u24 >>> 16) & 0xFF;
				buf[parsedLen++] = (u24 >>> 8) & 0xFF;
				buf[parsedLen++] = (u24 >>> 0) & 0xFF
			}
			return tmp1 < base64.length ? buf.subarray(0, tmp1 - base64.length) : buf
		}
		static fromHexString(hex) {
			hex = hex.replace(/[^0-9A-Fa-f]/g, '');
			const buf = new Buffer(hex.length >>> 1);
			for (let i = 0; i < buf.length; i++) buf[i] = HEX_CHAR.get(hex[i * 2]) << 4 | HEX_CHAR.get(hex[i * 2 + 1]);
			return buf
		}
		static fromArray(arr) {
			if (!_.isArray(arr)) throw new TypeError('arr must be an array');
			const buf = new Buffer(arr.length);
			for (let i = 0; i < buf.length; i++) buf[i] = _.toSafeInteger(arr[i]) & 0xFF;
			return buf
		}
		static isBuffer(obj) {
			return isInstance(obj, Buffer)
		}
		static packParseFormat(format) {
			if (!_.isString(format)) throw new TypeError('Invalid type of format');
			const matched = /^([@=<>!]?)((?:\d*[xcbB?hHiIlLqQefdsp])+)$/.exec(format);
			if (_.isNil(matched)) throw new TypeError(`Invalid format:${format}`);
			const littleEndian = _.includes(['', '@', '='], matched[1]) ? isNativeLittleEndian : (matched[1] === '<');
			return {
				littleEndian,
				items: _.map([...matched[2].matchAll(/\d*[xcbB?hHiIlLqQefdsp]/g)], ([s]) => {
					const type = s[s.length - 1];
					const repeat = s.length > 1 ? _.parseInt(s.slice(0, -1)) : 1;
					return [(type === 'p' && repeat > 255) ? 255 : repeat, type]
				}),
			}
		}
		static packCalcSize(formatOrItems) {
			if (_.isString(formatOrItems)) formatOrItems = Buffer.packParseFormat(formatOrItems)?.items;
			return _.sumBy(formatOrItems, item => {
				const [repeat, type] = item;
				if ('hHe'.includes(type)) return repeat * 2;
				if ('iIlLf'.includes(type)) return repeat * 4;
				if ('qQd'.includes(type)) return repeat * 8;
				return repeat
			})
		}
		static pack(buf, format, ...vals) {
			if (_.isString(buf)) {
				vals.unshift(format);
				[buf, format] = [undefined, buf]
			}
			const {
				littleEndian,
				items
			} = Buffer.packParseFormat(format);
			const lenRequired = Buffer.packCalcSize(items);
			if (_.isNil(buf)) buf = new Buffer(lenRequired);
			if (!Buffer.isBuffer(buf)) throw new TypeError('Invalid type of buf');
			if (buf.length < lenRequired) throw new RangeError(`buf.length=${buf.length},lenRequired=${lenRequired}`);
			const ctx = {
				buf,
				littleEndian,
				offset: 0,
				vals
			};
			for (const [repeat, type] of items) {
				const packFromFn = packFromFns.get(type);
				if (_.isNil(packFromFn)) throw new Error(`Unknown format:${repeat}${type}`);
				packFromFn(_.merge(ctx, {
					repeat,
					type
				}))
			}
			return buf
		}
		static unpack(buf, format) {
			const {
				littleEndian,
				items
			} = Buffer.packParseFormat(format);
			const lenRequired = Buffer.packCalcSize(items);
			if (!Buffer.isBuffer(buf)) throw new TypeError('Invalid type of buf');
			if (buf.length < lenRequired) throw new RangeError(`buf.length=${buf.length},lenRequired=${lenRequired}`);
			const ctx = {
				buf,
				littleEndian,
				offset: 0,
				vals: []
			};
			for (const [repeat, type] of items) {
				const unpackToFn = unpackToFns.get(type);
				if (_.isNil(unpackToFn)) throw new Error(`Unknown format:${repeat}${type}`);
				unpackToFn(_.merge(ctx, {
					repeat,
					type
				}))
			}
			return ctx.vals
		}
		compare(target, targetStart = 0, targetEnd = target.length, sourceStart = 0, sourceEnd = this.length) {
			if (!Buffer.isBuffer(target)) {
				if (!ArrayBuffer.isView(target)) throw new TypeError('Invalid type');
				target = Buffer.fromView(target)
			}
			const me = this.subarray(sourceStart, sourceEnd);
			target = target.subarray(targetStart, targetEnd);
			const len = Math.max(me.length, target.length);
			for (let i = 0; i < len; i++) {
				if (i >= me.length) return -1;
				if (i >= target.length) return 1;
				if (me[i] !== target[i]) return me[i] < target[i] ? -1 : 1
			}
			return 0
		}
		copy(target, targetStart = 0, sourceStart = 0, sourceEnd = this.length) {
			let buf = this.subarray(sourceStart, sourceEnd);
			if (buf.length > target.length - targetStart) buf = buf.subarray(0, target.length - targetStart);
			target.set(buf, targetStart);
			return buf.length
		}
		equals(other) {
			if (!Buffer.isBuffer(other) || this.length !== other.length) return false;
			for (let i = 0; i < this.length; i++)
				if (this[i] !== other[i]) return false;
			return true
		}
		fill(val, offset = 0, end = this.length, encoding = 'utf8') {
			if (Buffer.isEncoding(offset))[offset, encoding] = [0, offset];
			if (Buffer.isEncoding(end))[end, encoding] = [this.length, end];
			if (!_.isSafeInteger(offset) || !_.isSafeInteger(end)) throw new RangeError('Invalid type of offset or end');
			if (_.isString(val)) val = Buffer.fromString(val, encoding);
			else if (isInstance(val, Uint8Array)) val = Buffer.fromView(val);
			if (Buffer.isBuffer(val) && val.length < 2) val = val.length > 0 ? val[0] : 0;
			if (_.isNumber(val)) {
				val = _.toSafeInteger(val) & 0xFF;
				for (let i = offset; i < end; i++) this[i] = val;
				return this
			}
			let tmp = 0;
			for (let i = offset; i < end; i++) {
				this[i] = val[tmp++];
				if (tmp >= val.length) tmp = 0
			}
			return this
		}
		includes(val, offset = 0, encoding = 'utf8') {
			if (Buffer.isEncoding(offset))[offset, encoding] = [0, offset];
			offset = _.toSafeInteger(offset);
			if (offset < 0) offset = this.length + offset;
			if (_.isString(val)) val = Buffer.fromString(val, encoding);
			else if (isInstance(val, Uint8Array)) val = Buffer.fromView(val);
			if (Buffer.isBuffer(val)) {
				if (val.length === 0) return false;
				else if (val.length === 1) val = val[0]
			}
			if (_.isNumber(val)) {
				val = _.toSafeInteger(val) & 0xFF;
				for (let i = offset; i < this.length; i++)
					if (this[i] === val) return true;
				return false
			}
			const equalsAtOffset = (i) => {
				for (let j = 0; j < val.length; j++)
					if (this[i + j] !== val[j]) return false;
				return true
			};
			const len = this.length - val.length + 1;
			for (let i = offset; i < len; i++)
				if (equalsAtOffset(i)) return true;
			return false
		}
		indexOf(val, offset = 0, encoding = 'utf8') {
			if (Buffer.isEncoding(offset))[offset, encoding] = [0, offset];
			offset = _.toSafeInteger(offset);
			if (offset < 0) offset = this.length + offset;
			if (_.isString(val)) val = Buffer.fromString(val, encoding);
			else if (isInstance(val, Uint8Array)) val = Buffer.fromView(val);
			if (Buffer.isBuffer(val)) {
				if (val.length === 0) return -1;
				else if (val.length === 1) val = val[0]
			}
			if (_.isNumber(val)) {
				val = _.toSafeInteger(val) & 0xFF;
				for (let i = offset; i < this.length; i++)
					if (this[i] === val) return i;
				return -1
			}
			const equalsAtOffset = (i) => {
				for (let j = 0; j < val.length; j++)
					if (this[i + j] !== val[j]) return false;
				return true
			};
			const len = this.length - val.length + 1;
			for (let i = offset; i < len; i++)
				if (equalsAtOffset(i)) return i;
			return -1
		}
		lastIndexOf(val, offset = this.length - 1, encoding = 'utf8') {
			if (Buffer.isEncoding(offset))[offset, encoding] = [this.length - 1, offset];
			offset = _.toSafeInteger(offset);
			if (offset < 0) offset = this.length + offset;
			if (_.isString(val)) val = Buffer.fromString(val, encoding);
			else if (isInstance(val, Uint8Array)) val = Buffer.fromView(val);
			if (Buffer.isBuffer(val)) {
				if (val.length === 0) return -1;
				else if (val.length === 1) val = val[0]
			}
			if (_.isNumber(val)) {
				val = _.toSafeInteger(val) & 0xFF;
				for (let i = Math.min(offset, this.length - 1); i >= 0; i--)
					if (this[i] === val) return i;
				return -1
			}
			const equalsAtOffset = (i) => {
				for (let j = 0; j < val.length; j++)
					if (this[i + j] !== val[j]) return false;
				return true
			};
			for (let i = Math.min(offset, this.length - val.length); i >= 0; i--)
				if (equalsAtOffset(i)) return i;
			return -1
		}
		readBigInt64BE(offset = 0) {
			return this.dv.getBigInt64(offset)
		}
		readBigInt64LE(offset = 0) {
			return this.dv.getBigInt64(offset, true)
		}
		readBigUInt64BE(offset = 0) {
			return this.dv.getBigUint64(offset)
		}
		readBigUInt64LE(offset = 0) {
			return this.dv.getBigUint64(offset, true)
		}
		readDoubleBE(offset = 0) {
			return this.dv.getFloat64(offset)
		}
		readDoubleLE(offset = 0) {
			return this.dv.getFloat64(offset, true)
		}
		readFloatBE(offset = 0) {
			return this.dv.getFloat32(offset)
		}
		readFloatLE(offset = 0) {
			return this.dv.getFloat32(offset, true)
		}
		readFloat16BE(offset = 0) {
			const u32 = floatU16ToU32(this.readUInt16BE(offset));
			float16Buf.setUint32(0, u32);
			return float16Buf.getFloat32(0)
		}
		readFloat16LE(offset = 0) {
			const u32 = floatU16ToU32(this.readUInt16LE(offset));
			float16Buf.setUint32(0, u32);
			return float16Buf.getFloat32(0)
		}
		readInt8(offset = 0) {
			return this.dv.getInt8(offset)
		}
		readInt16BE(offset = 0) {
			return this.dv.getInt16(offset)
		}
		readInt16LE(offset = 0) {
			return this.dv.getInt16(offset, true)
		}
		readInt32BE(offset = 0) {
			return this.dv.getInt32(offset)
		}
		readInt32LE(offset = 0) {
			return this.dv.getInt32(offset, true)
		}
		readIntBE(offset = 0, byteLength = 6) {
			const tmp = this.readUIntBE(offset, byteLength);
			return tmp > SIGNED_MAX_VALUE[byteLength] ? tmp - SIGNED_OFFSET[byteLength] : tmp
		}
		readIntLE(offset = 0, byteLength = 6) {
			const tmp = this.readUIntLE(offset, byteLength);
			return tmp > SIGNED_MAX_VALUE[byteLength] ? tmp - SIGNED_OFFSET[byteLength] : tmp
		}
		readUInt8(offset = 0) {
			return this.dv.getUint8(offset)
		}
		readUInt16BE(offset = 0) {
			return this.dv.getUint16(offset)
		}
		readUInt16LE(offset = 0) {
			return this.dv.getUint16(offset, true)
		}
		readUInt32BE(offset = 0) {
			return this.dv.getUint32(offset)
		}
		readUInt32LE(offset = 0) {
			return this.dv.getUint32(offset, true)
		}
		readUIntBE(offset = 0, byteLength = 6) {
			if (byteLength < 1 || byteLength > 6) throw new RangeError(`Invalid byteLength:${byteLength}`);
			if (offset + byteLength > this.length) throw new RangeError(`Invalid offset:${offset}`);
			let tmp = 0;
			for (let i = 0; i < byteLength; i++) tmp = tmp * 0x100 + this[offset + i];
			return tmp
		}
		readUIntLE(offset = 0, byteLength = 6) {
			if (byteLength < 1 || byteLength > 6) throw new RangeError(`Invalid byteLength:${byteLength}`);
			if (offset + byteLength > this.length) throw new RangeError(`Invalid offset:${offset}`);
			let tmp = 0;
			for (let i = byteLength - 1; i >= 0; i--) tmp = tmp * 0x100 + this[offset + i];
			return tmp
		}
		readBitMSB(bitOffset) {
			const tmp = [bitOffset >>> 3, (bitOffset & 7) ^ 7];
			return (this[tmp[0]] >>> tmp[1]) & 1
		}
		readBitLSB(bitOffset) {
			const tmp = [this.length - (bitOffset >>> 3) - 1, bitOffset & 7];
			return (this[tmp[0]] >>> tmp[1]) & 1
		}
		subarray(start = 0, end = this.length) {
			const buf = super.subarray(start, end);
			return new Buffer(buf.buffer, buf.byteOffset, buf.byteLength)
		}
		slice(start = 0, end = this.length) {
			return new Buffer(super.slice(start, end).buffer)
		}
		reverse() {
			const buf = new Buffer(this.length);
			for (let i = buf.length - 1; i >= 0; i--) buf[i] = this[this.length - i - 1];
			return buf
		}
		swap16() {
			if ((this.length & 0x1) > 0) throw new RangeError('Buffer size must be a multiple of 16-bits');
			for (let i = 0; i < this.length; i += 2) this.writeUInt16LE(this.readUInt16BE(i), i);
			return this
		}
		swap32() {
			if ((this.length & 0x3) > 0) throw new RangeError('Buffer size must be a multiple of 32-bits');
			for (let i = 0; i < this.length; i += 4) this.writeUInt32LE(this.readUInt32BE(i), i);
			return this
		}
		swap64() {
			if ((this.length & 0x7) > 0) throw new RangeError('Buffer size must be a multiple of 64-bits');
			for (let i = 0; i < this.length; i += 8) this.writeBigUInt64LE(this.readBigUInt64BE(i), i);
			return this
		}
		toJSON() {
			return {
				type: 'Buffer',
				data: [...this]
			}
		}
		toString(encoding = 'utf8', start = 0, end = this.length) {
			encoding = _.toLower(encoding);
			if (!Buffer.isEncoding(encoding)) throw new TypeError(`Unknown encoding:${encoding}`);
			const toStringFns = {
				'ucs-2': Buffer.toUcs2String,
				'utf-16le': Buffer.toUcs2String,
				'utf-8': Buffer.toUtf8String,
				ascii: Buffer.toAsciiString,
				base64: Buffer.toBase64String,
				base64url: Buffer.toBase64urlString,
				binary: Buffer.toAsciiString,
				hex: Buffer.toHexString,
				latin1: Buffer.toAsciiString,
				ucs2: Buffer.toUcs2String,
				utf16le: Buffer.toUcs2String,
				utf8: Buffer.toUtf8String,
			};
			return toStringFns[encoding](this.subarray(start, end))
		}
		static toUcs2String(buf) {
			const arr = [];
			for (let i = 0; i < buf.length; i += 2) arr.push(String.fromCharCode(buf.readUInt16LE(i)));
			return arr.join('')
		}
		static toUtf8String(buf) {
			return new TextDecoder().decode(buf)
		}
		static toAsciiString(buf) {
			const arr = [];
			for (let i = 0; i < buf.length; i++) arr.push(String.fromCharCode(buf[i]));
			return arr.join('')
		}
		static toBase64String(buf) {
			const arr = [];
			for (let i = 0; i < buf.length; i += 3) {
				const u24 = (buf[i] << 16) + ((i + 1 < buf.length ? buf[i + 1] : 0) << 8) + (i + 2 < buf.length ? buf[i + 2] : 0);
				arr.push(...[BASE64_CHAR.get(u24 >>> 18 & 0x3F), BASE64_CHAR.get(u24 >>> 12 & 0x3F), BASE64_CHAR.get(u24 >>> 6 & 0x3F), BASE64_CHAR.get(u24 >>> 0 & 0x3F), ])
			}
			const tmp = arr.length + (buf.length + 2) % 3 - 2;
			for (let i = tmp; i < arr.length; i++) arr[i] = '=';
			return arr.join('')
		}
		static toBase64urlString(buf) {
			const arr = [];
			for (let i = 0; i < buf.length; i += 3) {
				const u24 = (buf[i] << 16) + ((i + 1 < buf.length ? buf[i + 1] : 0) << 8) + (i + 2 < buf.length ? buf[i + 2] : 0);
				arr.push(...[BASE64URL_CHAR.get(u24 >>> 18 & 0x3F), BASE64URL_CHAR.get(u24 >>> 12 & 0x3F), BASE64URL_CHAR.get(u24 >>> 6 & 0x3F), BASE64URL_CHAR.get(u24 >>> 0 & 0x3F), ])
			}
			const tmp = (buf.length + 2) % 3 - 2;
			return (tmp !== 0 ? arr.slice(0, tmp) : arr).join('')
		}
		static toHexString(buf) {
			const arr = [];
			for (let i = 0; i < buf.length; i++) arr.push(HEX_CHAR.get(buf[i] >>> 4), HEX_CHAR.get(buf[i] & 0xF));
			return arr.join('')
		}
		write(val, offset = 0, length = this.length - offset, encoding = 'utf8') {
			if (_.isString(offset))[offset, length, encoding] = [0, this.length, offset];
			else if (_.isString(length))[length, encoding] = [this.length - offset, length];
			if (!_.isString(val)) throw new TypeError('Invalid type of val');
			if (!_.isSafeInteger(offset)) throw new TypeError('Invalid type of offset');
			if (!_.isSafeInteger(length)) throw new TypeError('Invalid type of length');
			if (!Buffer.isEncoding(encoding)) throw new TypeError(`Unknown encoding:${encoding}`);
			const buf = Buffer.fromString(val, encoding);
			length = Math.min(buf.length, length, this.length - offset);
			this.set(buf.subarray(0, length), offset);
			return length
		}
		writeBigInt64BE(val, offset = 0) {
			this.dv.setBigInt64(offset, val);
			return this
		}
		writeBigInt64LE(val, offset = 0) {
			this.dv.setBigInt64(offset, val, true);
			return this
		}
		writeBigUInt64BE(val, offset = 0) {
			this.dv.setBigUint64(offset, val);
			return this
		}
		writeBigUInt64LE(val, offset = 0) {
			this.dv.setBigUint64(offset, val, true);
			return this
		}
		writeDoubleBE(val, offset = 0) {
			this.dv.setFloat64(offset, val);
			return this
		}
		writeDoubleLE(val, offset = 0) {
			this.dv.setFloat64(offset, val, true);
			return this
		}
		writeFloatBE(val, offset = 0) {
			this.dv.setFloat32(offset, val);
			return this
		}
		writeFloatLE(val, offset = 0) {
			this.dv.setFloat32(offset, val, true);
			return this
		}
		writeFloat16BE(val, offset = 0) {
			float16Buf.setFloat32(0, val);
			const u32 = float16Buf.getUint32(0);
			return this.writeUInt16BE(floatU32ToU16(u32), offset)
		}
		writeFloat16LE(val, offset = 0) {
			float16Buf.setFloat32(0, val);
			const u32 = float16Buf.getUint32(0);
			return this.writeUInt16LE(floatU32ToU16(u32), offset)
		}
		writeInt8(val, offset = 0) {
			this.dv.setInt8(offset, val);
			return this
		}
		writeInt16BE(val, offset = 0) {
			this.dv.setInt16(offset, val);
			return this
		}
		writeInt16LE(val, offset = 0) {
			this.dv.setInt16(offset, val, true);
			return this
		}
		writeInt32BE(val, offset = 0) {
			this.dv.setInt32(offset, val);
			return this
		}
		writeInt32LE(val, offset = 0) {
			this.dv.setInt32(offset, val, true);
			return this
		}
		writeIntBE(val, offset = 0, byteLength = 6) {
			if (byteLength < 1 || byteLength > 6) throw new RangeError(`Invalid byteLength:${byteLength}`);
			if (val < 0) val += SIGNED_OFFSET[byteLength];
			this.writeUIntBE(val, offset, byteLength);
			return this
		}
		writeIntLE(val, offset = 0, byteLength = 6) {
			if (byteLength < 1 || byteLength > 6) throw new RangeError(`Invalid byteLength:${byteLength}`);
			if (val < 0) val += SIGNED_OFFSET[byteLength];
			this.writeUIntLE(val, offset, byteLength);
			return this
		}
		writeUInt8(val, offset = 0) {
			this.dv.setUint8(offset, val);
			return this
		}
		writeUInt16BE(val, offset = 0) {
			this.dv.setUint16(offset, val);
			return this
		}
		writeUInt16LE(val, offset = 0) {
			this.dv.setUint16(offset, val, true);
			return this
		}
		writeUInt32BE(val, offset = 0) {
			this.dv.setUint32(offset, val);
			return this
		}
		writeUInt32LE(val, offset = 0) {
			this.dv.setUint32(offset, val, true);
			return this
		}
		writeUIntBE(val, offset = 0, byteLength = 6) {
			if (byteLength < 1 || byteLength > 6) throw new RangeError(`Invalid byteLength:${byteLength}`);
			if (offset + byteLength > this.length) throw new RangeError(`Invalid offset:${offset}`);
			for (let i = byteLength - 1; i >= 0; i--) {
				this[offset + i] = val & 0xFF;
				val /= 0x100
			}
			return this
		}
		writeUIntLE(val, offset = 0, byteLength = 6) {
			if (byteLength < 1 || byteLength > 6) throw new RangeError(`Invalid byteLength:${byteLength}`);
			if (offset + byteLength > this.length) throw new RangeError(`Invalid offset:${offset}`);
			for (let i = 0; i < byteLength; i++) {
				this[offset + i] = val & 0xFF;
				val /= 0x100
			}
			return this
		}
		writeBitMSB(val, bitOffset) {
			const tmp = [bitOffset >>> 3, (bitOffset & 7) ^ 7];
			if (Boolean(val)) this[tmp[0]] |= 1 << tmp[1];
			else this[tmp[0]] &= ~(1 << tmp[1]);
			return this
		}
		writeBitLSB(val, bitOffset) {
			const tmp = [this.length - (bitOffset >>> 3) - 1, bitOffset & 7];
			if (Boolean(val)) this[tmp[0]] |= 1 << tmp[1];
			else this[tmp[0]] &= ~(1 << tmp[1]);
			return this
		}
		chunk(bytesPerChunk) {
			if (bytesPerChunk < 1) throw new TypeError('invalid bytesPerChunk');
			const chunks = [];
			for (let i = 0; i < this.length; i += bytesPerChunk) chunks.push(this.subarray(i, i + bytesPerChunk));
			return chunks
		}
		xor() {
			return _.reduce(this, (xor, v) => xor ^ v, 0)
		}
		pack(format, ...vals) {
			Buffer.pack(this, format, ...vals);
			return this
		}
		unpack(format) {
			return Buffer.unpack(this, format)
		}
	}

	function packFromPad(ctx) {
		const {
			buf,
			repeat
		} = ctx;
		for (let i = 0; i < repeat; i++) buf[ctx.offset] = 0;
		ctx.offset += repeat
	}

	function unpackToPad(ctx) {
		const {
			repeat
		} = ctx;
		ctx.offset += repeat
	}

	function packFromChar(ctx) {
		const {
			buf,
			repeat,
			vals
		} = ctx;
		for (let i = 0; i < repeat; i++) {
			if (vals.length === 0) throw new TypeError('Not enough vals');
			buf[ctx.offset] = Buffer.from(vals.shift())?.[0] ?? 0;
			ctx.offset += 1
		}
	}

	function unpackToChar(ctx) {
		const {
			buf,
			repeat,
			vals
		} = ctx;
		for (let i = 0; i < repeat; i++) {
			vals.push(buf.subarray(ctx.offset, ctx.offset + 1));
			ctx.offset += 1
		}
	}

	function packFromInt8(ctx) {
		const {
			buf,
			repeat,
			type,
			vals
		} = ctx;
		const fnName = type === 'b' ? 'writeInt8' : 'writeUInt8';
		for (let i = 0; i < repeat; i++) {
			if (vals.length === 0) throw new TypeError('Not enough vals');
			buf[fnName](_.toSafeInteger(vals.shift()), ctx.offset);
			ctx.offset += 1
		}
	}

	function unpackToInt8(ctx) {
		const {
			buf,
			repeat,
			type,
			vals
		} = ctx;
		const fnName = type === 'b' ? 'readInt8' : 'readUInt8';
		for (let i = 0; i < repeat; i++) {
			vals.push(buf[fnName](ctx.offset));
			ctx.offset += 1
		}
	}

	function packFromBool(ctx) {
		const {
			buf,
			repeat,
			vals
		} = ctx;
		for (let i = 0; i < repeat; i++) {
			if (vals.length === 0) throw new TypeError('Not enough vals');
			buf.writeUInt8(Boolean(vals.shift()) ? 1 : 0, ctx.offset);
			ctx.offset += 1
		}
	}

	function unpackToBool(ctx) {
		const {
			buf,
			repeat,
			vals
		} = ctx;
		for (let i = 0; i < repeat; i++) {
			vals.push(buf.readUInt8(ctx.offset) !== 0);
			ctx.offset += 1
		}
	}

	function packFromInt16(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			type,
			vals
		} = ctx;
		const fnName = ['writeUInt16BE', 'writeUInt16LE', 'writeInt16BE', 'writeInt16LE'][(type === 'h' ? 2 : 0) + (littleEndian ? 1 : 0)];
		for (let i = 0; i < repeat; i++) {
			if (vals.length === 0) throw new TypeError('Not enough vals');
			buf[fnName](_.toSafeInteger(vals.shift()), ctx.offset);
			ctx.offset += 2
		}
	}

	function unpackToInt16(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			type,
			vals
		} = ctx;
		const fnName = ['readUInt16BE', 'readUInt16LE', 'readInt16BE', 'readInt16LE'][(type === 'h' ? 2 : 0) + (littleEndian ? 1 : 0)];
		for (let i = 0; i < repeat; i++) {
			vals.push(buf[fnName](ctx.offset));
			ctx.offset += 2
		}
	}

	function packFromInt32(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			type,
			vals
		} = ctx;
		const fnName = ['writeUInt32BE', 'writeUInt32LE', 'writeInt32BE', 'writeInt32LE'][('il'.includes(type) ? 2 : 0) + (littleEndian ? 1 : 0)];
		for (let i = 0; i < repeat; i++) {
			if (vals.length === 0) throw new TypeError('Not enough vals');
			buf[fnName](_.toSafeInteger(vals.shift()), ctx.offset);
			ctx.offset += 4
		}
	}

	function unpackToInt32(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			type,
			vals
		} = ctx;
		const fnName = ['readUInt32BE', 'readUInt32LE', 'readInt32BE', 'readInt32LE'][('il'.includes(type) ? 2 : 0) + (littleEndian ? 1 : 0)];
		for (let i = 0; i < repeat; i++) {
			vals.push(buf[fnName](ctx.offset));
			ctx.offset += 4
		}
	}

	function packFromBigInt64(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			type,
			vals
		} = ctx;
		const fnName = ['writeBigUInt64BE', 'writeBigUInt64LE', 'writeBigInt64BE', 'writeBigInt64LE'][(type === 'q' ? 2 : 0) + (littleEndian ? 1 : 0)];
		for (let i = 0; i < repeat; i++) {
			if (vals.length === 0) throw new TypeError('Not enough vals');
			buf[fnName](BigInt(vals.shift()), ctx.offset);
			ctx.offset += 8
		}
	}

	function unpackToBigInt64(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			type,
			vals
		} = ctx;
		const fnName = ['readBigUInt64BE', 'readBigUInt64LE', 'readBigInt64BE', 'readBigInt64LE'][(type === 'q' ? 2 : 0) + (littleEndian ? 1 : 0)];
		for (let i = 0; i < repeat; i++) {
			vals.push(buf[fnName](ctx.offset));
			ctx.offset += 8
		}
	}

	function packFromFloat16(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			vals
		} = ctx;
		const fnName = littleEndian ? 'writeFloat16LE' : 'writeFloat16BE';
		for (let i = 0; i < repeat; i++) {
			if (vals.length === 0) throw new TypeError('Not enough vals');
			buf[fnName](vals.shift(), ctx.offset);
			ctx.offset += 2
		}
	}

	function unpackToFloat16(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			vals
		} = ctx;
		const fnName = littleEndian ? 'readFloat16LE' : 'readFloat16BE';
		for (let i = 0; i < repeat; i++) {
			vals.push(buf[fnName](ctx.offset));
			ctx.offset += 2
		}
	}

	function packFromFloat(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			vals
		} = ctx;
		const fnName = littleEndian ? 'writeFloatLE' : 'writeFloatBE';
		for (let i = 0; i < repeat; i++) {
			if (vals.length === 0) throw new TypeError('Not enough vals');
			buf[fnName](vals.shift(), ctx.offset);
			ctx.offset += 4
		}
	}

	function unpackToFloat(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			vals
		} = ctx;
		const fnName = littleEndian ? 'readFloatLE' : 'readFloatBE';
		for (let i = 0; i < repeat; i++) {
			vals.push(buf[fnName](ctx.offset));
			ctx.offset += 4
		}
	}

	function packFromDouble(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			vals
		} = ctx;
		const fnName = littleEndian ? 'writeDoubleLE' : 'writeDoubleBE';
		for (let i = 0; i < repeat; i++) {
			if (vals.length === 0) throw new TypeError('Not enough vals');
			buf[fnName](vals.shift(), ctx.offset);
			ctx.offset += 8
		}
	}

	function unpackToDouble(ctx) {
		const {
			buf,
			littleEndian,
			repeat,
			vals
		} = ctx;
		const fnName = littleEndian ? 'readDoubleLE' : 'readDoubleBE';
		for (let i = 0; i < repeat; i++) {
			vals.push(buf[fnName](ctx.offset));
			ctx.offset += 8
		}
	}

	function packFromString(ctx) {
		const {
			buf,
			repeat,
			vals
		} = ctx;
		if (vals.length === 0) throw new TypeError('Not enough vals');
		const val = vals.shift();
		const buf1 = new Buffer(repeat);
		Buffer.from(val).copy(buf1, 0, 0, repeat);
		buf1.copy(buf, ctx.offset);
		ctx.offset += buf1.length
	}

	function unpackToString(ctx) {
		const {
			buf,
			repeat,
			vals
		} = ctx;
		vals.push(buf.subarray(ctx.offset, ctx.offset + repeat));
		ctx.offset += repeat
	}

	function packFromPascal(ctx) {
		const {
			buf,
			repeat,
			vals
		} = ctx;
		if (vals.length === 0) throw new TypeError('Not enough vals');
		const val = vals.shift();
		const buf1 = new Buffer(repeat);
		buf1[0] = Buffer.from(val).copy(buf1, 1, 0, repeat - 1);
		buf1.copy(buf, ctx.offset);
		ctx.offset += buf1.length
	}

	function unpackToPascal(ctx) {
		const {
			buf,
			repeat,
			vals
		} = ctx;
		const len = Math.min(buf[ctx.offset], repeat - 1);
		vals.push(buf.subarray(ctx.offset + 1, ctx.offset + 1 + len));
		ctx.offset += repeat
	}

	function startDiscovery() {
		console.log('开始搜索蓝牙设备：');
		plus.bluetooth.startBluetoothDevicesDiscovery({
			success: function(e) {
				console.log('开始搜索成功!')
			},
			fail: function(e) {
				console.log('开始搜索失败! ' + JSON.stringify(e))
			}
		})
	}
	var MiddlewareStatus;
	(function(MiddlewareStatus) {
		MiddlewareStatus[MiddlewareStatus["PENDING"] = 0] = "PENDING";
		MiddlewareStatus[MiddlewareStatus["STARTED"] = 1] = "STARTED";
		MiddlewareStatus[MiddlewareStatus["FINISHED"] = 2] = "FINISHED";
		MiddlewareStatus[MiddlewareStatus["ERROR"] = 3] = "ERROR"
	})(MiddlewareStatus || (MiddlewareStatus = {}));
	async function sleep(ms) {
		return new Promise(resolve => setTimeout(resolve, ms))
	}
	const BLESERIAL_FILTERS = [{
		name: 'ChameleonUltra'
	}, ];
	const BLESERIAL_UUID = [{
		serv: '6e400001-b5a3-f393-e0a9-e50e24dcca9e',
		send: '6e400002-b5a3-f393-e0a9-e50e24dcca9e',
		recv: '6e400003-b5a3-f393-e0a9-e50e24dcca9e',
	}, ];
	class WebbleAdapter {
		Buffer;
		device;
		isOpen = false;
		logger = {};
		name = 'adapter';
		recv;
		rxSource;
		send;
		serv;
		txSink;
		async install(context, pluginOption) {
			const {
				ultra,
				Buffer
			} = context;
			this.Buffer = Buffer;
			this.logger.webble = ultra.createDebugger('webble');
			const that = this;

			if (!_.isNil(ultra.$adapter)) await ultra.disconnect(new Error('adapter replaced'));
			const adapter = {};
			await plus.bluetooth.closeBluetoothAdapter({
				success: function(e) {
					console.log('close success: ' + JSON.stringify(e));
				},
				fail: function(e) {
					console.log('close failed: ' + JSON.stringify(e));
				},

				complete: function(e) {
					console.log('close complete: ' + JSON.stringify(e));
					plus.bluetooth.openBluetoothAdapter({
						success: function(e) {
							console.log('打开成功!' + JSON.stringify(e));
							const _isSupported = true;
							adapter.isSupported = () => _isSupported
						},
						fail: function(e) {
							console.log('打开失败! ' + JSON.stringify(e));
							const _isSupported = false;
							adapter.isSupported = () => _isSupported
						}
					});


				}
			});


			ultra.addHook('connect', async (ctx, next) => {
				if (ultra.$adapter !== adapter) return await next();
				try {
					if (adapter.isSupported() !== true) throw new Error('Bluetooth not ready');

					this.rxSource = new ChameleonWebbleAdapterRxSource(this);
					this.txSink = new ChameleonWebbleAdapterTxSink(this);



					plus.bluetooth.startBluetoothDevicesDiscovery({
						services: [BLESERIAL_UUID[0].serv],
						success: function(e) {
							console.log('start discovery success: ' + JSON.stringify(e))
						},
						fail: function(e) {
							console.log('start discovery failed: ' + JSON.stringify(e))
						}
					});

					let foundDevice = false;
					let err

					while (this.isOpen == false) {
						await sleep(1000);
						if (foundDevice == false) {
							plus.bluetooth.getBluetoothDevices({
								success: async function(e) {
									var devices = e.devices;
									console.log('get devices success: ' + e.length);
									for (var i in devices) {
										console.log(i + ': ' + JSON.stringify(devices[i]));
										if (devices[i].name == "ChameleonUltra") {
											foundDevice = true;
											let device = devices[i];
											that.device = device;
											console.log("发现设备，停止搜索");
											await plus.bluetooth.stopBluetoothDevicesDiscovery({
												success: function(e) {
													console.log('stop discovery success: ' + JSON.stringify(e))
												},
												fail: function(e) {
													err = e
													console.log('stop discovery failed: ' + JSON.stringify(e))
												}
											});
											console.log("发现设备，准备连接");
											plus.bluetooth.createBLEConnection({
												deviceId: device.deviceId,
												success: async function(e) {
													console.log('create connection success: ' + JSON.stringify(e) + BLESERIAL_UUID[0].serv.toUpperCase());
													for (let i = 0; i < 10; i++) {
														await sleep(1000);
														if (foundDevice == false)break;
														if (that.isOpen == true) break;
														plus.bluetooth.getBLEDeviceServices({
															deviceId: device.deviceId,
															success: function(e) {
																var services = e.services;
																console.log('获取服务成功: ' + services.length);
																if (services.length > 0) {
																	for (var i in services) {
																		console.log(JSON.stringify(services[i]));
																		if (services[i].uuid == BLESERIAL_UUID[0].serv.toUpperCase()) {
																			plus.bluetooth.onBLECharacteristicValueChange(function(e) {
																				console.log('onBLECharacteristicValueChange: ' + JSON.stringify(e));
																				if (BLESERIAL_UUID[0].recv.toUpperCase() == e.characteristicId) {
																					console.log('特征值变化: ' + JSON.stringify(e));
																					that.rxSource?.onNotify(e)
																				}
																			});
																			console.log("开始监听notify");
																			plus.bluetooth.notifyBLECharacteristicValueChange({
																				deviceId: device.deviceId,
																				serviceId: BLESERIAL_UUID[0].serv,
																				characteristicId: BLESERIAL_UUID[0].recv,
																				state: true,
																				success: function(e) {
																					that.isOpen = true;
																					var characteristics = e.characteristics;
																					console.log('get characteristics success: ');
																					for (var i in characteristics) {
																						console.log(i + ': ' + JSON.stringify(characteristics[i]))
																					}
																				},
																				fail: function(e) {
																					if (e.message.includes('no connection')) foundDevice = false;
																					err = e
																					console.log('get characteristics failed: ' + JSON.stringify(e))
																				}
																			})
																		}
																	}
																} else {
																	console.log('获取服务列表为空?')
																}
															},
															fail: async function(e) {
																if (e.message.includes('no connection')) foundDevice = false;
																err = e
																console.log('获取服务失败! ' + JSON.stringify(e))


															}
														})
													}
												},
												fail: function(e) {

													foundDevice = false;
													err = e
													console.log('create connection failed: ' + JSON.stringify(e))

												}
											})

										}

									}
								},
								fail: function(e) {

									err = e
									console.log('get devices failed: ' + JSON.stringify(e));
								}
							});
						}


					}





					ultra.port = {
						isOpen: () => {
							return that.isOpen
						},
						readable: new web.ReadableStream(that.rxSource),
						writable: new web.WritableStream(that.txSink),
					};
					if (!this.isOpen) throw new Error('Failed to connect');
					console.log(`success to connect`);
					return await next()
				} catch (err) {
					this.logger.webble(`Failed to connect:${err.message}`);

					//throw err;
				}
			});
			ultra.addHook('disconnect', async (ctx, next) => {
				if (ultra.$adapter !== adapter || _.isNil(this.device)) return await next();

				this.isOpen = false;
				await next();

				if (!_.isNil(this.recv)) {
					if (gattIsConnected()) await this.recv.stopNotifications();
					delete this.recv;
					delete this.rxSource
				}
				if (!_.isNil(this.send)) {
					delete this.send;
					delete this.txSink
				}
				if (!_.isNil(this.serv)) delete this.serv;


				delete this.device
			});
			return adapter
		}
	}
	class ChameleonWebbleAdapterRxSource {
		adapter;
		bufs = [];
		controller;
		constructor(adapter) {
			this.adapter = adapter
		}
		start(controller) {
			this.controller = controller
		}
		onNotify(e) {
			const buf = this.adapter.Buffer?.from(e.value);
			console.log(`接收到数据：onNotify=${buf?.toString('hex')}`);
			this.controller?.enqueue(buf)
		}
	}
	class ChameleonWebbleAdapterTxSink {
		adapter;
		isFirstEsc = true;
		constructor(adapter) {
			this.adapter = adapter
		}
		async write(chunk) {
			let that = this
			let success = false
			let fail = false
			let err
			console.log('开始写数据: ' + chunk?.toString('hex'));

			plus.bluetooth.writeBLECharacteristicValue({
				deviceId: that.adapter.device.deviceId,
				serviceId: BLESERIAL_UUID[0].serv,
				characteristicId: BLESERIAL_UUID[0].send,
				value: chunk,
				success: function(e) {
					console.log('write characteristics success: ' + JSON.stringify(e))
					success = true
				},
				fail: function(e) {
					console.log('write characteristics failed: ' + JSON.stringify(e))
					fail = true
					err = e


				}
			})
			while (true) {

				await sleep(100);
				if (success == true) break;
				if (fail == true) throw new Error(err.message);
			}
		}
	}
	return WebbleAdapter
})(_, window.navigator, window);