#version 300 es

precision mediump float;

uniform sampler2D u_ObjTexture;
uniform bool u_UseTex;
uniform vec4 u_Color;

in vec2 v_TexCoord;

layout(location = 0) out vec4 o_FragColor;

void main() {
    vec2 texCoord = vec2(v_TexCoord.x, 1.0 - v_TexCoord.y);
    if (u_UseTex) {
        o_FragColor = vec4(texture(u_ObjTexture, texCoord).rgb, 1.0);
    } else {
        o_FragColor = u_Color;
    }
}