#version 300 es

precision mediump float;

// 虚拟场景颜色纹理
uniform sampler2D u_VirtualSceneColorTexture;

#if IS_USE_OCCLUSION
// 相机深度纹理
uniform sampler2D u_CameraDepthTexture;
// 虚拟场景深度纹理
uniform sampler2D u_VirtualSceneDepthTexture;
// 近裁剪平面和远裁剪平面，用于将虚拟场景深度转换回视图空间，以与相机深度纹理进行比较
uniform float u_ZNear;
uniform float u_ZFar;
// 屏幕的宽高比。这在期间用于为被遮挡的对象创建均匀模糊
uniform float u_DepthAspectRatio;
#endif

// 输入虚拟场景纹理坐标
in vec2 v_VirtualSceneTexCoord;
#if IS_USE_OCCLUSION
// 输入相机纹理坐标
in vec2 v_CameraTexCoord;
#endif

// 输出着色器颜色
layout(location = 0) out vec4 o_FragColor;

#if IS_USE_OCCLUSION
// 获取相机深度信息，单位毫米
float Depth_GetCameraDepthInMillimeters(const sampler2D dTexture, const vec2 depthUv) {
    vec3 packedDepthAndVisibility = texture(dTexture, depthUv).xyz;
    return dot(packedDepthAndVisibility.xy, vec2(255.0, 256.0 * 255.0));
}

// 获取虚拟场景深度信息，单位毫米
float Depth_GetVirtualSceneDepthMillimeters(const sampler2D dTexture, const vec2 depthUv, float zNear, float zFar) {
    const float kMetersToMillimeters = 1000.0;
    const float kBias = -80.0;
    float ndc = 2.0 * texture(dTexture, depthUv).x - 1.0;
    return 2.0 * zNear * zFar / (zFar + zNear - ndc * (zFar - zNear)) * kMetersToMillimeters + kBias;
}

// 获取遮挡深度信息，单位毫米
float Depth_GetOcclusion(const sampler2D depthTexture, const vec2 depthUv, float assetDepthMm) {
    float depthMm = Depth_GetCameraDepthInMillimeters(depthTexture, depthUv);

    const float depthTolerancePerMm = 0.01;
    return clamp(1.0 - 0.5 * (depthMm - assetDepthMm) / (depthTolerancePerMm * assetDepthMm) + 0.5, 0.0, 1.0);
}

// 计算UV周围的模糊遮挡
float Depth_GetBlurredOcclusionAroundUV(const sampler2D depthTexture, const vec2 uv, float assetDepthMm) {
    const float kernelTotalWeights = 269.0;
    float sum = 0.0;

    const float kOcclusionBlurAmount = 0.01;
    vec2 blurriness = vec2(kOcclusionBlurAmount, kOcclusionBlurAmount * u_DepthAspectRatio);

    float curDepth = 0.0;

    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(-1.0, -2.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(+1.0, -2.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(-1.0, +2.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(+1.0, +2.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(-2.0, +1.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(+2.0, +1.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(-2.0, -1.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(+2.0, -1.0) * blurriness, assetDepthMm);
    sum += curDepth * 4.0;

    curDepth = 0.0;
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(-2.0, -0.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(+2.0, +0.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(+0.0, +2.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(-0.0, -2.0) * blurriness, assetDepthMm);
    sum += curDepth * 7.0;

    curDepth = 0.0;
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(-1.0, -1.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(+1.0, -1.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(-1.0, +1.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(+1.0, +1.0) * blurriness, assetDepthMm);
    sum += curDepth * 16.0;

    curDepth = 0.0;
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(+0.0, +1.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(-0.0, -1.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(-1.0, -0.0) * blurriness, assetDepthMm);
    curDepth += Depth_GetOcclusion(
    depthTexture, uv + vec2(+1.0, +0.0) * blurriness, assetDepthMm);
    sum += curDepth * 26.0;

    sum += Depth_GetOcclusion(depthTexture, uv, assetDepthMm) * 41.0;

    return sum / kernelTotalWeights;
}
#endif

void main() {
    // 输出着色器颜色
    o_FragColor = texture(u_VirtualSceneColorTexture, v_VirtualSceneTexCoord);

#if IS_USE_OCCLUSION
    if (o_FragColor.a == 0.0) {
        return;
    }

    // 计算深度遮挡关系，输出着色器颜色
    float assetDepthMm = Depth_GetVirtualSceneDepthMillimeters(
    u_VirtualSceneDepthTexture, v_VirtualSceneTexCoord, u_ZNear, u_ZFar);
    float occlusion = Depth_GetBlurredOcclusionAroundUV(u_CameraDepthTexture, v_CameraTexCoord, assetDepthMm);
    float objectMaskEroded = pow(occlusion, 10.0);
    float occlusionTransition = clamp(occlusion * (2.0 - objectMaskEroded), 0.0, 1.0);
    float kMaxOcclusion = 1.0;
    occlusionTransition = min(occlusionTransition, kMaxOcclusion);
    o_FragColor *= 1.0 - occlusion;
#endif
}
