#version 300 es

uniform mat4 u_Model;
uniform mat4 u_ModelViewProjection;
uniform mat2 u_PlaneUvMatrix;
uniform vec3 u_Normal;

layout(location = 0) in vec3 a_XZPositionAlpha;

out vec3 v_TexCoordAlpha;
out float v_alpha;
out vec2 v_textureCoords;
void main() {
    v_alpha = a_XZPositionAlpha.z;
    vec4 local_pos = vec4(a_XZPositionAlpha.x, 0.0, a_XZPositionAlpha.y, 1.0);
    vec4 world_pos = u_Model * local_pos;

    const vec3 arbitrary = vec3(1.0, 1.0, 0.0);
    vec3 vec_u = normalize(cross(u_Normal, arbitrary));
    vec3 vec_v = normalize(cross(u_Normal, vec_u));

    vec2 uv = vec2(dot(world_pos.xyz, vec_u), dot(world_pos.xyz, vec_v));
    v_TexCoordAlpha = vec3(u_PlaneUvMatrix * uv, a_XZPositionAlpha.z);
    v_textureCoords = uv;

    gl_Position = u_ModelViewProjection * local_pos;
}