#version 320 es
layout (location = 0) in vec4 vPosition;
uniform mat4 vMatrix;
uniform vec3 centerPose;
uniform vec3 cameraPose;
uniform vec3 cameraPoseY;
in vec2 aTextureCoord;
out vec2 TexCoord;
void main() {
    vec3 look = normalize(cameraPose - centerPose);
    vec3 up =normalize(cameraPoseY);
    vec3 right = cross(up, look);

    mat4 bMatrix;
    bMatrix[0] = vec4(right, 0.0);
    bMatrix[1] = vec4(up, 0.0);
    bMatrix[2] = vec4(look, 0.0);
    bMatrix[3] = vec4(centerPose, 1.0);

    gl_Position  = vMatrix*bMatrix*vPosition;
    TexCoord = aTextureCoord;
}