#version 320 es
layout (location = 0) in vec3 vPosition;
uniform mat4 vpMatrix;
uniform vec3 centerPose;
uniform vec3 cameraPose;
in vec2 aTextureCoord;
out vec2 TexCoord;
void main() {
    vec3 l = normalize(cameraPose - centerPose);
    vec3 u =normalize(vec3(0.0, 1.0, 0.0));
    vec3 r = cross(u, l);
    mat4 bMatrix;
    bMatrix[0] = vec4(r, 0.0);
    bMatrix[1] = vec4(u, 0.0);
    bMatrix[2] = vec4(l, 0.0);
    bMatrix[3] = vec4(centerPose, 1.0);
    gl_Position = vpMatrix *bMatrix *vec4(vPosition, 1);
    TexCoord = aTextureCoord;
}