#version 320 es
layout (location = 0) in vec4 vPosition;
uniform mat4 mvMatrix;
uniform mat2 inPlanUVMatrix;
in vec2 aTextureCoord;
out vec2 TexCoord;

void main() {
    vec4 tempPosition = vec4(vPosition.x, 0.0, vPosition.y, 1.0);
    gl_Position  = mvMatrix*tempPosition;

    vec2 tempUV = inPlanUVMatrix * vPosition.xy;
    vec3 varTexCoordAlpha = vec3(tempUV.x + 0.5, tempUV.y + 0.5, vPosition.z);
    TexCoord = vec2(varTexCoordAlpha.xy);
}