package com.union.test;

import java.security.KeyPair;

import javax.crypto.spec.SecretKeySpec;

import org.junit.Test;

import com.union.crypto.asymmetric.SM2;
import com.union.crypto.asymmetric.SM2KeyGenerator;
import com.union.crypto.asymmetric.SM2PrivateKey;
import com.union.crypto.asymmetric.SM2PublicKey;
import com.union.crypto.digests.SM3Digest;
import com.union.security.base.Cipher;
import com.union.util.UnionUtils;

public class AlgorithmTest {
	
	public static void main(String[] args) throws Exception {
		String message = "qwertyuiopasdfghjklzxcvbnm呵呵1234567890:?<>!@#$%^&*()";
		byte[] data = message.getBytes();
		
		// SM2调用示例
		// 生成密钥
		SM2KeyGenerator keyGenerator = new SM2KeyGenerator();
		KeyPair keyPair = keyGenerator.generateKeyPair();
		SM2PrivateKey pvk = (SM2PrivateKey) keyPair.getPrivate();
		SM2PublicKey pbk = (SM2PublicKey) keyPair.getPublic();
		String hexPvk = pvk.getPvkHex();  // 私钥的16进制表示
		String hexPubx = pbk.getPbkxHex();  // 公钥x成份的16进制表示
		String hexPuby = pbk.getPbkyHex();  // 公钥y成份的16进制表示
		System.out.println("私   钥: " + hexPvk);
		System.out.println("公钥X: " + hexPubx);
		System.out.println("公钥Y: " + hexPuby);
		
		// 签名验签
		byte[] signData = SM2.sign(data, hexPvk);
		System.out.println("SM2签名: " + UnionUtils.bcdhex_to_aschex(signData));
		boolean vr = SM2.verify(data, signData, hexPubx, hexPuby);
		System.out.println("SM2验签: " + vr);
		// 加密解密
		byte[] encData = SM2.encrypt(pbk, data);
		System.out.println("SM2加 密: " + UnionUtils.bcdhex_to_aschex(encData));
		byte[] decData = SM2.decrypt(pvk, encData);
		System.out.println("SM2解密: " + new String(decData));
		
		// SM3调用示例
		byte[] sm3Result = new byte[32];
		SM3Digest sm3 = new SM3Digest();
		sm3.update(data, 0, data.length);
		sm3.doFinal(sm3Result, 0);
		System.out.println("SM3摘要: " + UnionUtils.bcdhex_to_aschex(sm3Result));
		
		// SM4调用示例
		String algorithm = "SM4";
		Cipher cipher = Cipher.getInstance(algorithm);
		data = "abcdef12345哈哈67890".getBytes();
		byte[] key = { 0x12, 0x34, 0x56, 0x78, (byte) 0x90, (byte) 0xab, (byte) 0xcd, (byte) 0xef,  0x12, 0x34, 0x56, 0x78, (byte) 0x90, (byte) 0xab, (byte) 0xcd, (byte) 0xef };
		cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(key, algorithm));
		byte[] sm4EncData = cipher.doFinal(data);
		cipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(key,
				algorithm));
		byte[] sm4DecData = cipher.doFinal(sm4EncData);
		System.out.println("SM4加密: " + UnionUtils.bcdhex_to_aschex(sm4EncData));
		System.out.println("SM4解密: " + new String(sm4DecData));
	}
	
	@Test
	public void hmac() {
		SM3Digest sm3 = new SM3Digest();
		final byte[] key = "1234567890123456".getBytes();
		final byte[] message = "1234567890123456".getBytes();
		final byte[] hmac = sm3.hmac(key, message);
		System.out.println("SM3 HMAC: " + UnionUtils.bcdhex_to_aschex(hmac));
	}
	

}
