package com.union.test;

import java.io.IOException;

import com.union.crypto.asymmetric.SM2;
import com.union.util.UnionUtils;

public class SignTest {
	
	public static void main(String[] args) throws IOException {
		String message = "12345678哈哈哈";
		byte[] data = message.getBytes();
//		byte[] data = UnionUtils.aschex_to_bcdhex(message);
		
		String pvkHex = "E8122E1B126DCE089ACC1BA049740279AAD2EB77F164A46F652C2717DF191469";
		String pbkxHex = "686B7629C6D425BA1F5F42A92E703BFEF263D412A3D8FA91EF294E1591B2746D";
		String pbkyHex = "BA3E9025EF94DD534EB6FE7245E078AEED06A2DD7917B286589B36EDE373AB9B";
		
		byte[] signData = SM2.sign(data, pvkHex);
		SM2.sign(data, pvkHex);
		System.out.println("签名: " + UnionUtils.bcdhex_to_aschex(signData));
		
//		signData = UnionUtils.aschex_to_bcdhex("3045022100E5346CFCA5EBB1A0C6669E1E7B90067BEF98BE324606B3195C2BA128C835AF4D02202ACF30E1B6BB50913310EB5D6341E34DBFD2169FD352C36F193FBFED8DC475EC".toUpperCase());
		
		boolean result = SM2.verify(data, signData, pbkxHex, pbkyHex);
		System.out.println("验签: " + result);
	}

}
