!(function() {
	var apiList = [
			"getSystemInfo",
			"getSystemInfoAsync",
			"getSystemInfoSync",
			"getWindowInfo",
			"getDeviceInfo",
			"getAppBaseInfo",
			"getSystemSetting",
			"getAppAuthorizeSetting",
			"openAppAuthorizeSetting",
			"openSystemBluetoothSetting",
			"switchTab",
			"reLaunch",
			"redirectTo",
			"navigateTo",
			"navigateBack",
			"showToast",
			"hideToast",
			"showLoading",
			"hideLoading",
			"showModal",
			"showActionSheet",
			"setNavigationBarTitle",
			"setNavigationBarColor",
			"showNavigationBarLoading",
			"hideNavigationBarLoading",
			"setTabBarItem",
			"setTabBarStyle",
			"hideTabBar",
			"showTabBar",
			"setTabBarBadge",
			"removeTabBarBadge",
			"showTabBarRedDot",
			"hideTabBarRedDot",
			"setBackgroundColor",
			"setBackgroundTextStyle",
			"onWindowResize",
			"offWindowResize",
			"loadFontFace",
			"request",
			"uploadFile",
			"downloadFile",
			"connectSocket",
			"createTCPSocket",
			"createUDPSocket",
			"setStorage",
			"setStorageSync",
			"getStorage",
			"getStorageSync",
			"getStorageInfo",
			"getStorageInfoSync",
			"removeStorage",
			"removeStorageSync",
			"clearStorage",
			"clearStorageSync"
		],
		syncApiList = [
			"getWindowInfo",
			"getDeviceInfo",
			"getAppBaseInfo",
			"getSystemSetting",
			"getAppAuthorizeSetting"
		];
	function invokeMethod(name, parameters) {
		var param = parameters || {};
		param.apiMethodName = name;
		api.invokeApi(param, function(ret, err) {
			!(function(param, ret, err) {
				ret && "function" == typeof param.success
					? param.success(ret)
					: err && "function" == typeof param.fail && param.fail(err);
				"function" == typeof param.complete && param.complete(ret || err);
			})(param, ret, err);
		});
	}
	function invokeMethodSync(name, parameters) {
		var param = parameters || {};
		param.apiMethodName = name;
		return api.invokeApiSync(param);
	}
	function _inheritsLoose(subClass, superClass) {
		subClass.prototype = Object.create(superClass.prototype);
		(subClass.prototype.constructor = subClass).__proto__ = superClass;
	}
	var RequestTask = (function() {
			function RequestTask(taskId) {
				this.taskId = taskId;
				this.headerCallbacks = [];
				this.progressCallbacks = [];
			}
			var _proto = RequestTask.prototype;
			_proto.abort = function() {
				invokeMethod("abortRequestTask", {
					tag: this.taskId
				});
			};
			_proto.onHeadersReceived = function(callback) {
				var _this = this;
				if (callback) {
					this.headerCallbacks.push(callback);
					1 == this.headerCallbacks.length &&
						invokeMethod("onHeadersReceived", {
							success: function(res) {
								_this.headerCallbacks.forEach(function(cb) {
									cb(res);
								});
							}
						});
				}
			};
			_proto.offHeadersReceived = function(callback) {
				if (callback) {
					var index = this.headerCallbacks.indexOf(callback);
					0 <= index && this.headerCallbacks.splice(index, 1);
				} else this.headerCallbacks = [];
			};
			_proto.onProgressUpdate = function(callback) {
				var _this2 = this;
				if (callback) {
					this.progressCallbacks.push(callback);
					1 == this.progressCallbacks.length &&
						invokeMethod("onProgressUpdate", {
							success: function(res) {
								_this2.progressCallbacks.forEach(function(cb) {
									cb(res);
								});
							}
						});
				}
			};
			_proto.offProgressUpdate = function(callback) {
				if (callback) {
					var index = this.progressCallbacks.indexOf(callback);
					0 <= index && this.progressCallbacks.splice(index, 1);
				} else this.progressCallbacks = [];
			};
			return RequestTask;
		})(),
		DownloadTask = (function(_RequestTask) {
			_inheritsLoose(DownloadTask, _RequestTask);
			function DownloadTask() {
				return _RequestTask.apply(this, arguments) || this;
			}
			return DownloadTask;
		})(RequestTask),
		UploadTask = (function(_RequestTask2) {
			_inheritsLoose(UploadTask, _RequestTask2);
			function UploadTask() {
				return _RequestTask2.apply(this, arguments) || this;
			}
			return UploadTask;
		})(RequestTask),
		requestId = 0;
	var _api = Object.freeze({
		__proto__: null,
		request: function(param) {
			void 0 === param && (param = {});
			var reqId = requestId++;
			param.tag = reqId;
			var task = new RequestTask(reqId);
			invokeMethod("request", param);
			return task;
		},
		downloadFile: function(param) {
			void 0 === param && (param = {});
			var reqId = requestId++;
			param.tag = reqId;
			var task = new DownloadTask(reqId);
			invokeMethod("downloadFile", param);
			return task;
		},
		uploadFile: function(param) {
			void 0 === param && (param = {});
			var reqId = requestId++;
			param.tag = reqId;
			var task = new UploadTask(reqId);
			invokeMethod("uploadFile", param);
			return task;
		},
		getStorageSync: function(key) {
			return invokeMethodSync("getStorageSync", {
				key: key
			});
		},
		setStorageSync: function(key, data) {
			invokeMethodSync("setStorageSync", {
				key: key,
				data: data
			});
		},
		removeStorageSync: function(key) {
			invokeMethodSync("removeStorageSync", {
				key: key
			});
		}
	});
	apiList.forEach(function(name) {
		_api[name]
			? (api[name] = _api[name])
			: !(function(name) {
					return 0 <= syncApiList.indexOf(name) || "Sync" == name.slice(-4);
			  })(name)
			? (api[name] = function(parameters) {
					invokeMethod(name, parameters);
			  })
			: (api[name] = function(parameters) {
					return invokeMethodSync(name, parameters);
			  });
	});
})();