window.onload = () => {
    const isString = (o) => Object.prototype.toString.call(o).slice(8, -1) === 'String';
    const isFunction = (o) => Object.prototype.toString.call(o).slice(8, -1) === 'Function';
    const parseResultToMd = (json) => {
        let result = [];
        const loopConcat = (someArray) => {
            someArray.forEach(ob => {
                if (isString(ob)) {
                    result.push(ob)
                    return ob;
                } else {
                    const {tag, children, attrs} = ob;
                    if (tag === 'img') {
                        const {value: src} = attrs.filter(({name}) => name === 'src')[0]
                        result.push(`![](${src})`);
                    } else if (children && children.length > 0) {
                        loopConcat(children);
                    } else {
                        return ''
                    }
                }
            })
            return result;
        }
        loopConcat(json);

        return result.join('\n');
    }

    const E = window.wangEditor
    const editor = new E('#editor');
    Object.assign(editor.customConfig, {
        // menus: ['image',],
        // uploadImgServer: 'http://test.i-patrol.cn/app/v8/File/upload',
        // uploadImgParams: {
        //     module: 'tutorial'
        // }
    })

    editor.create();

    // 安卓调用这个方法 插入图片  如果不能发送请求获取图片资源 请把base64传送过来
    function upload_image(url) {
        editor.cmd.do('insertHTML', `<p><img src="${url}" alt="巡检图片"  style="display:block;margin-bottom:0.5rem;width: 100%"><br></p>`)
    }

    // 安卓调取这个 获得结果 传入回调函数
    function getResult_string() {
        const json = editor.txt.getJSON();
        return parseResultToMd(json);
    }

    function get_result_string() {
        const resultStr =  getResult_string();
        // 我解析了之后 发送给安卓
        window.mdeditor.getResultString(resultStr);
    }

    function set_content(mdString) {
        const marker = '&';
        const contents = mdString.replace(/\)/g, marker).replace(/(\r\n)|(\n)/g, '<br>').split(marker);
        contents.forEach(string => {
            const texts = string.replace(/\!\[\]\(/g, marker).split(marker).map(item => item.trim());
            const text = texts[0], url = texts[1];

            if (text) {
                editor.cmd.do('insertHTML', `<p>${text}</p>`)
            }
            if (url) {
                upload_image(url)
            }
        })
    }

    // 单位:px
    function set_max_height(height) {
        if (height && height >= 200) {
            const maxHeight = height + 'px';
            document.querySelector('.w-e-text').style.maxHeight = maxHeight
            document.querySelector('.w-e-text-container').style.maxHeight = maxHeight
        }
    }

    function set_disabled(flag) {
        document.getElementById('modal').style.display = flag ? 'block' : 'none';
    }

    // document.getElementById('submit').onclick = function () {
    //     // console.log(getResult_string())
    //     set_content(getResult_string())
    // }
    window.uploadImage = upload_image;
    window.getResultString = getResult_string;
    window.getResultStr = get_result_string;
    window.setContent = set_content;
    window.setMaxHeight = set_max_height;
    window.setDisabled = set_disabled;

}
