attribute vec4 aPosition;
attribute vec4 aTextureCoord;

const lowp int GAUSSIAN_SAMPLES = 9;

uniform highp float texelWidthOffset;
uniform highp float texelHeightOffset;
uniform highp float blurSize;

varying highp vec2 vTextureCoord;
varying highp vec2 blurCoordinates[GAUSSIAN_SAMPLES];

void main() {
    gl_Position = aPosition;
    vTextureCoord = aTextureCoord.xy;

    // Calculate the positions for the blur
    int multiplier = 0;
    highp vec2 blurStep;
    highp vec2 singleStepOffset = vec2(texelHeightOffset, texelWidthOffset) * blurSize;

    for (lowp int i = 0; i < GAUSSIAN_SAMPLES; i++) {
        multiplier = (i - ((GAUSSIAN_SAMPLES - 1) / 2));
        // Blur in x (horizontal)
        blurStep = float(multiplier) * singleStepOffset;
        blurCoordinates[i] = vTextureCoord.xy + blurStep;
    }
}