attribute vec4 aPosition;
attribute vec4 aTextureCoord;

varying highp vec2 vTextureCoord;

/* --- START SHARPNESS --- */
uniform float imageWidthFactor;
uniform float imageHeightFactor;
uniform float sharpness;

varying highp vec2 leftTextureCoordinate;
varying highp vec2 rightTextureCoordinate;
varying highp vec2 topTextureCoordinate;
varying highp vec2 bottomTextureCoordinate;

varying float centerMultiplier;
varying float edgeMultiplier;

void computeSharpnessParams() {
    mediump vec2 widthStep = vec2(imageWidthFactor, 0.0);
    mediump vec2 heightStep = vec2(0.0, imageHeightFactor);

    leftTextureCoordinate   = clamp(vTextureCoord.xy - widthStep, 0.0, 1.0);
    rightTextureCoordinate  = clamp(vTextureCoord.xy + widthStep, 0.0, 1.0);
    topTextureCoordinate    = clamp(vTextureCoord.xy + heightStep, 0.0, 1.0);
    bottomTextureCoordinate = clamp(vTextureCoord.xy - heightStep, 0.0, 1.0);

    centerMultiplier = 1.0 + 4.0 * sharpness;
    edgeMultiplier = sharpness;
}
/* --- END SHARPNESS --- */
/* --- START GAUSSIAN BLUR --- */

const lowp int GAUSSIAN_SAMPLES = 9;

uniform highp float blurSize;
varying highp vec2 blurCoordinates[GAUSSIAN_SAMPLES];

void computeBlurGaussianParams() {
    // Calculate the positions for the blur
    int multiplier = 0;
    highp vec2 blurStep;
    highp vec2 singleStepOffset = vec2(imageHeightFactor, 0.0) * blurSize;

    for (lowp int i = 0; i < GAUSSIAN_SAMPLES; i++) {
        multiplier = (i - ((GAUSSIAN_SAMPLES - 1) / 2));
        // Blur in x (vertical)
        blurStep = float(multiplier) * singleStepOffset;
        blurCoordinates[i] = vTextureCoord.xy + blurStep;
    }
}
/* --- END GAUSSIAN BLUR --- */
void main() {
    gl_Position = aPosition;
    vTextureCoord = aTextureCoord.xy;

    computeSharpnessParams();
    computeBlurGaussianParams();
}
