/*
 * =====================================================================================
 *
 *       Filename:  asr_service.h
 *
 *    Description:  asr service
 *
 *        Version:  1.0
 *        Created:  2021/1/21
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  jack.kj@alibaba-inc.com
 *
 * =====================================================================================
 */
#ifndef GAEA_AI_GAEA_ASR_ASR_SERVICE_H_
#define GAEA_AI_GAEA_ASR_ASR_SERVICE_H_

#include "gaea/asr/asr.h"
#include "gaea/asr/speech_recognize_response_handler.h"
#include "gaea/asr/speech_short_recognize_request.h"
#include "gaea/interface/rpc/push_service.h"
#include "gaea/interface/rpc/rpc_service.h"

namespace gaea {
namespace asr {

class AsrServiceImpl;

class GAEA_AI_DECL AsrService {
 public:
  AsrService();
  ~AsrService();

  void Init();
  void set_rpc_service(
      std::shared_ptr<gaea::service::RpcServiceInterface> rpc_service);
  void set_push_service(
      std::shared_ptr<gaea::service::PushService> push_service);

  // One sentence translation, only supports less than or equal
  // to 1 minute of voice，all response will notify by handler,
  // if OnComplete or OnError, this recognize will terminated.
  // Every OnResponse will return whole context , you should cover
  // your local content everytime.
  //
  void ShortRecognize(const SpeechShortRecognizeRequest &request,
                      SpeechRecognizeResponseHandlerPtr handler);

 private:
  std::unique_ptr<AsrServiceImpl> impl_;
};

}  // namespace asr
}  // namespace gaea

#endif
