/*
 * =====================================================================================
 *
 *       Filename:  short_recognize_request.h
 *
 *    Description:  short recognize request define
 *
 *        Version:  1.0
 *        Created:  2021/1/21
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  jack.kj@alibaba-inc.com
 *
 * =====================================================================================
 */
#ifndef GAEA_AI_GAEA_ASR_SPEECH_SHORT_ASR_RECOGNIZE_H_
#define GAEA_AI_GAEA_ASR_SPEECH_SHORT_ASR_RECOGNIZE_H_

#include <string>

namespace gaea {
namespace asr {

class SpeechShortRecognizeRequest {
 public:
  explicit SpeechShortRecognizeRequest() = default;
  ~SpeechShortRecognizeRequest() = default;

  inline SpeechShortRecognizeRequest& set_media_id(const std::string& media_id) {
    media_id_ = media_id;
    return *this;
  }

  // option : if you set this , you may be get more
  inline SpeechShortRecognizeRequest& set_speaker_id(const std::string& speaker_id) {
    speaker_id_ = speaker_id;
    return *this;
  }

  inline SpeechShortRecognizeRequest& set_biz_type(const std::string& biz_type) {
    biz_type_ = biz_type;
    return *this;
  }

  inline std::string media_id() const { return media_id_; }
  inline std::string speaker_id() const { return speaker_id_; }
  inline std::string biz_type() const { return biz_type_; }

 private:
  std::string media_id_;
  std::string speaker_id_;
  std::string biz_type_;
};

} // namespace reflect
} // namespace gaea

#endif 
