//
//  ErrorResult.hpp
//  Atlas
//
//  Created by jinxi on 7/8/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_BASE_ERROR_RESULT_H_
#define GAEA_BASE_ERROR_RESULT_H_

#include <iosfwd>
#include <memory>
#include <string>


#include "gaea/base/macros.h"

namespace gaea {
namespace base {

typedef enum ErrorCode {
  kErrorSuccess,
  kErrorStandardErrno,
  kErrorOutOfMemory,
  kErrorNotImplmented,
  kErrorNullOutputArgument,
} ErrorCode;

class GAEA_BASE_DECL ErrorResult {
 public:
  ErrorResult() : status_(0), local_error_(false) {}
  ErrorResult(int status, const std::string& code, const std::string& reason)
      : status_(status), code_(code), reason_(reason), local_error_(false) {}
  virtual ~ErrorResult() {}

 public:
  const std::string& scope() const { return scope_; }
  void set_scope(const std::string& scope) { scope_ = scope; }

  int status() const { return status_; }
  void set_status(int status) { status_ = status; }

  const std::string& code() const { return code_; }
  void set_code(const std::string& code) { code_ = code; }

  const std::string& reason() const { return reason_; }
  void set_reason(const std::string& reason) { reason_ = reason; }
  
  const std::string& developer_message() const { return developer_message_; }
  void set_developer_message(const std::string& developer_message) { developer_message_ = developer_message; }
  
  const std::string& more_info() const { return more_info_; }
  void set_more_info(const std::string& more_info) { more_info_ = more_info; }

  /**
   * @brief 标识是否是本地错误
   * @return true 表示是本地错误; false 表示非本地错误。默认值: false
   */
  bool local_error() const { return local_error_; }
  void set_local_error(bool local_error) { local_error_ = local_error; }
  
  std::string ToString() const;
  std::string ToShortString() const;
  friend std::ostream& operator<<(std::ostream& os, const ErrorResult& err_result);
 private:
  std::string scope_;
  int status_;
  std::string code_;
  std::string reason_;
  std::string developer_message_;
  std::string more_info_;
  bool local_error_;
};

typedef std::shared_ptr<ErrorResult> ErrorResultPtr;

class ErrorResultHelper {
 public:
  static gaea::base::ErrorResult BuildLocalError(
      const std::string& scope,
      int status,
      const std::string& code,
      const std::string& reason,
      const std::string& developer_message);
  
  static gaea::base::ErrorResult BuildError(
      bool is_local_error,
      const std::string& scope,
      int status,
      const std::string& code,
      const std::string& reason,
      const std::string& developer_message);
};

} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_ERROR_RESULT_H_ */
