﻿//
//  Md5.hpp
//  Atlas
//
//  Created by 柯杰 on 5/17/17.
//  Copyright © 2017 www.dingtalk.com. All rights reserved.
//

#ifndef GAEA_BASE_MD5_H_
#define GAEA_BASE_MD5_H_

#include <stdint.h>
#include <string>

#include "gaea/base/macros.h"

namespace gaea {
namespace base {

class Md5 {
 public:
  Md5();
  Md5(const std::string& message);
  Md5(const char* message, size_t size);
  ~Md5();

  void Update(const std::string& chunk);
  void Update(const char* chunk, size_t size);
  std::string ToString(bool uppercase = false);

 private:
  struct HashContext {
    uint32_t total[2];
    uint32_t state[4];
    uint8_t buffer[64];
  };

  void StartContext(struct HashContext* context);
  void ProcessContext(struct HashContext* context, uint8_t data[64]);
  void UpdateContext(struct HashContext* context, uint8_t* input, size_t size);
  void FinishContext(struct HashContext* context, uint8_t digest[16]);

 private:
  unsigned int data_[4];
  struct HashContext context_;
  bool finished_;
};

std::string DoMd5(const std::string& message);

} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_MD5_H_ */
