#ifndef GAEA_BASE_NETWORK_INFORMATION_H_
#define GAEA_BASE_NETWORK_INFORMATION_H_

#include <memory>
#include <stdint.h>
#include <string>
#include <vector>

namespace gaea {
namespace base {


typedef uint64_t NetworkHandle;
#define kNetworkHandleNotSet 0

typedef enum NetworkType {
  kNetUnknown,
  kNetEthernet,
  kNetWifi,
  kNet5G,
  kNet4G,
  kNet3G,
  kNet2G,
  kNetUnknownCellular,
  kNetBluetooth,
  kNetVpn,
  kNetNone
} NetworkType;
const char * GetNetworkTypeDescript(NetworkType);

typedef struct IPAddress {
  IPAddress();
  virtual ~IPAddress();
  
  std::string address;
} IPAddress;
typedef std::shared_ptr<IPAddress> IPAddressPtr;


typedef struct NetworkInformation {
  NetworkInformation();
  virtual ~NetworkInformation();

  std::string interface_name;
  NetworkHandle handle;
  NetworkType type;
  NetworkType underlying_type_for_vpn;
  std::vector<IPAddress> ip_addresses;
} NetworkInformation;
typedef std::shared_ptr<NetworkInformation> NetworkInformationPtr;


} // end of namespace base
} // end of namespace gaea

#endif // GAEA_BASE_NETWORK_INFORMATION_H_

