//
//  Path.hpp
//  Atlas
//
//  Created by 金喜 on 4/21/16.
//  Copyright © 2016 金喜. All rights reserved.
//

#ifndef GAEA_BASE_PATH_H_
#define GAEA_BASE_PATH_H_

#include <string>

#include "gaea/base/macros.h"

namespace gaea {
namespace base {

class Path {
 public:
  static std::string GetSep();
 
  // static bool isAbsPath(const std::string& path);
  static bool IsDir(const std::string& path);
  static bool IsExist(const std::string& path);
  static bool IsFile(const std::string& path);
  // static bool isSoftLink(const std::string& path);
  static std::string GetHomePath();
  static std::string GetAbsPath(const std::string& path);
  static std::string GetBaseName(const std::string& path);
  static std::string GetDirName(const std::string& path);
  static std::string GetRealPath(const std::string& path);
  static std::string JoinPath(size_t argc, ...);
  static std::string JoinPath(const std::string& path1, const std::string& path2);

  /**
   * Remove file or directory without prompt
   */
  static bool ForceRemove(const std::string& path);
  static bool MakeDirs(const std::string& path);
  /**
   * Remove file only
   */
  static bool RemoveFile(const std::string& filePath);

  static std::string GetCurrentDir();

  static bool WildcardMatch(const std::string& pattern, const std::string& path);
};

} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_UTIL_PATH_H */
