﻿//
//  properties.h
//  Atlas
//
//  Created by jinxi on 4/21/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_BASE_PROPERTIES_H_
#define GAEA_BASE_PROPERTIES_H_

#include "gaea/base/macros.h"
#include "gaea/base/string_util.h"
#include "gaea/base/singleton.h"

namespace gaea {
namespace base {

class Properties;
class Splitter;

class Properties : public Singleton<Properties>, public std::multimap<std::string, std::string> {
 public:
  Properties();
  ~Properties();

 public:
  std::string GetString(const std::string& name, const std::string& default_value = "") const;
  Strings GetStrings(const std::string& name) const;
  int64_t GetInt64(const std::string& name, const int64_t default_value = 0) const;
  int32_t GetInt32(const std::string& name, const int32_t default_value = 0) const;
  double GetDouble(const std::string& name, const double default_value = 0.0) const;
  bool GetBool(const std::string& name, const bool default_value = false) const;
  std::string GetAbsPath(const std::string& name, const std::string& default_value = "") const;

  Strings GetNameList() const;
  /*
   * search names with glob pattern,
   * e.g. "foo.*.bar" would match "foo.abc.bar", "foo.abc.xyz.bar"
   */
  Strings SearchNameList(const std::string& pattern) const;

  StringSet GetNameSet() const;
  /*
   * search names with glob pattern,
   * e.g. "foo.*.bar" would match "foo.abc.bar", "foo.abc.xyz.bar"
   */
  StringSet SearchNameSet(const std::string& pattern) const;

  void Add(const std::string& name, const std::string& value);
  void Set(const std::string& name, const std::string& value);
  void Remove(const std::string& name);

  bool Has(const std::string& name) const;

  bool ParseFile(const std::string& config_file, std::string* error = nullptr);
  bool ParseString(const std::string& content, std::string* error = nullptr);
  std::string Dump() const;

  const std::string& config_file() const { return config_file_; }
  void set_config_file(const std::string& config_file) { config_file_ = config_file; }

 public:
  void GetMultiMapByPrefixKey(const std::string& prefix, std::multimap<std::string, std::string>* result);

 private:
  std::string config_file_;
  Splitter* line_splitter_;
  Splitter* key_value_splitter_;
};

} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_PROPERTIES_H_ */
