//
//  singleton.hpp
//  Atlas
//
//  Created by 金喜 on 4/21/16.
//  Copyright © 2016 金喜. All rights reserved.
//

#ifndef GAEA_BASE_SINGLETON_H_
#define GAEA_BASE_SINGLETON_H_

#include <stdlib.h>

#include <mutex>

#include "gaea/base/macros.h"

namespace gaea {
namespace base {

template <typename T>
class Singleton {
 public:
  static void Init() {
    static std::once_flag oc;
    std::call_once(oc, [&] () {
      instance_mutex_ = new std::mutex;
    });
    
    if (instance_) {
      return;
    }
    
    std::lock_guard<std::mutex> lock(*instance_mutex_);
    if (!instance_) {
      instance_ = new T();
    }
  }

  static void Destroy() {
    if (!instance_) {
      return;
    }
    
    std::lock_guard<std::mutex> lock(*instance_mutex_);
    if (instance_) {
      delete instance_;
      instance_ = nullptr;
    }
  }

  static T* GetInstance() {
    if (!instance_) {
      Init();
    }
    return instance_;
  }

 private:
  static std::mutex* instance_mutex_;
  static T* instance_;
};

template <typename T>
T* Singleton<T>::instance_ = nullptr;

template <typename T>
std::mutex* Singleton<T>::instance_mutex_ = nullptr;

} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_UTIL_SINGLETON_H_ */
