//
//  Uri.hpp
//  Atlas
//
//  Created by jinxi on 4/23/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_BASE_URI_H_
#define GAEA_BASE_URI_H_

#include "gaea/base/splitter.h"
#include "gaea/base/string_util.h"

namespace gaea {
namespace base {

class Uri {
 public:
  Uri();
  Uri(const std::string& uri);
  virtual ~Uri();

  static std::string Encode(const std::string& data);
  static std::string Decode(const std::string& data);

  static std::string EncodeUrl(const std::string& data);
  static std::string DecodeUrl(const std::string& data);

  static std::string GetHost(const std::string& uri);

  void Clear(void);
  bool Parse(const std::string& uri);

 public:
  const std::string& scheme() const { return scheme_; }
  void set_scheme(const std::string& scheme) { scheme_ = scheme; }

  const std::string& username() const { return username_; }
  void set_username(const std::string& username) { username_ = username; }

  const std::string& password() const { return password_; }
  void set_password(const std::string& password) { password_ = password; }

  const std::string& host() const { return host_; }
  void set_host(const std::string& host) { host_ = host; }

  int port() const { return port_; }
  void set_port(int port) { port_ = port; }

  const std::string& path() const { return path_; }
  void set_path(const std::string& path) { path_ = path; }

  const std::string& query_string() const { return query_string_; }
  // set queryString_ and parameters_
  void set_query_string(const std::string& queryString);

  const std::string& fragment() const { return fragment_; }
  void set_fragment(const std::string& fragment) { fragment_ = fragment; }

  bool HasParameter(const std::string& name) const;
  const std::string GetParameter(const std::string& name, const std::string& defauleValue = "") const;
  void SetParameter(const std::string& name, const std::string& value);
  void AddParameter(const std::string& name, const std::string& value);
  void RemoveParameter(const std::string& name);
  gaea::base::StringSet GetParameterNames() const;
  gaea::base::Strings GetParameterValues(const std::string& name) const;
  const std::multimap<std::string, std::string>& get_parameters() const { return parameters_; }
  void set_parameters(const std::multimap<std::string, std::string>& parameters) { parameters_ = parameters; }

  std::string Dumps() const;

 private:
  bool ParseUserPassHostPort(const std::string& str);
  bool ParseIPv6HostPort(const std::string& str, std::string::size_type hostPos);
  bool ParseIPv4DomainHostPort(const std::string& str, std::string::size_type hostPos);
  
  void Initial();

 private:
  gaea::base::Splitter parameter_splitter_;
  gaea::base::Splitter key_value_splitter_;
  
  std::string scheme_;

  std::string username_;
  std::string password_;

  std::string host_;
  int port_;

  std::string path_;
  std::string query_string_;

  std::multimap<std::string, std::string> parameters_;

  std::string fragment_;
};

} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_URI_H_ */
