//
//  topic_config_entry.hpp
//  GaeaConfig
//
//  Created by Herb on 2019/6/6.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_CONFIG_TOPIC_CONFIG_ENTRY_H_
#define GAEA_CONFIG_TOPIC_CONFIG_ENTRY_H_

#include <map>
#include <memory>
#include <string>

#include "gaea/base/logging.h"

namespace gaea {
namespace config {


class SubConfig {
 public:
  SubConfig() : has_matcher_(false), key_version_(0), disable_(0) {}
  virtual ~SubConfig() { }
  
  bool has_matcher() const { return has_matcher_; }
  
  const std::string matcher() const { return matcher_; }
  void set_matcher(const std::string& matcher) {
    has_matcher_ = true;
    matcher_ = matcher;
  }
  
  std::string value() const { return value_; }
  void set_value(const std::string& value) { value_ = value; }
  
  int64_t key_version() const { return key_version_; }
  void set_key_version(int64_t key_version) { key_version_ = key_version; }
  
  int64_t disable() const { return disable_; }
  void set_disable(int64_t disable) { disable_ = disable; }
  
 private:
  bool has_matcher_;
  std::string matcher_;
  std::string value_;
  //fastconfig key级别的版本号
  int64_t key_version_;
  // 为1表示回滚生效，该SubConfig不会被取到
  int64_t disable_;
};


class ModuleConfig {
 public:
  ModuleConfig(const std::string& module_name);
  
  virtual ~ModuleConfig() { }
  
  /**
   * @function FromJson
   * @brief 从 Json 配置信息加载到当前对象中
   * @param json_data Json 配置数据
   * @return true 导出成功; false 导出失败;
   */
  bool FromJson(const std::string& json_data);
  
  const std::map<std::string, SubConfig>& sub_configs() { return sub_configs_; }
  int64_t version() const { return version_; }
  const std::string name() const { return name_; }
  
 private:
  gaea::base::Logger logger_;
  int64_t version_;
  std::string name_;
  std::map<std::string, SubConfig> sub_configs_;
};
typedef std::shared_ptr<ModuleConfig> ModuleConfigPtr;

} // end of config namespace
} // end of gaea namespace

#endif /* GAEA_CONFIG_TOPIC_CONFIG_ENTRY_H_ */
