//
//  topic_config_model.hpp
//  GaeaConfig
//
//  Created by Herb on 2019/6/6.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_CONFIG_TOPIC_CONFIG_MODEL_H_
#define GAEA_CONFIG_TOPIC_CONFIG_MODEL_H_

#include <memory>
#include <string.h>

namespace gaea {
namespace config {

/**
 * 子模块配置对象
 * */
class ModuleInfo {
public:
  ModuleInfo() : version_(0) { }
  virtual ~ModuleInfo() { }
  
  const std::string name() const { return name_; }
  void set_name(const std::string& name) { name_ = name; }
  
  int64_t version() const { return version_; }
  void set_version(int64_t version) { version_ = version; }
  
  const std::string md5() const { return md5_; }
  void set_md5(const std::string& md5) { md5_ = md5; }
  
  const std::string url() const { return url_; }
  void set_url(const std::string& url) { url_ = url; }
  
  const std::string priority() const { return priority_; }
  void set_priority(const std::string& priority) { priority_ = priority; }
  
  const std::string matcher() const { return matcher_; }
  void set_matcher(const std::string& matcher) { matcher_ = matcher; }
  
private:
  std::string name_;
  int64_t version_;
  std::string md5_;
  std::string url_;
  std::string priority_;
  std::string matcher_;
};
typedef std::shared_ptr<ModuleInfo> ModuleInfoPtr;
typedef std::shared_ptr<std::vector<ModuleInfo> > ModuleInfoVectorPtr;

} // end of config namespace
} // end of gaea namespace

#endif /* GAEA_CONFIG_TOPIC_CONFIG_MODEL_H_ */
