//
//  user_info.h
//  GaeaConfig
//
//  Created by Herb on 2019/4/2.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_CONFIG_USER_INFO_MODEL_H_
#define GAEA_CONFIG_USER_INFO_MODEL_H_

#include <string>
#include <vector>

namespace gaea {
namespace config {
  
class UserInfoModel {
public:
  UserInfoModel() {}
  virtual ~UserInfoModel() {}
  
  /**
   * @brief APP version
   */
  const std::string app_version() const { return app_version_; }
  void set_app_version(const std::string& app_version) { app_version_ = app_version; }
  
  /**
   * @brief user_id
   */
  const std::string uid() const { return uid_; }
  void set_uid(const std::string& uid) { uid_ = uid; }
  
  /**
   * @brief main org id of user
   */
  const std::string main_org_id() const { return main_org_id_; }
  void set_main_org_id(const std::string& main_org_id) { main_org_id_ = main_org_id; }
  
  void set_main_org_id(int64_t main_org_id) { main_org_id_ = std::to_string(main_org_id);}
  /**
   * @brief org list of user
   */
  const std::vector<std::string> org_id_list() const { return org_id_list_; }
  void set_org_id_list(const std::vector<std::string>& org_id_list) { org_id_list_ = org_id_list; }
  
  void set_org_id_list(const std::vector<int64_t>& org_id_list) {
    std::vector<std::string> org_id_string_list;
    for (auto iter = org_id_list.begin(); iter != org_id_list.end(); ++iter) {
      org_id_string_list.push_back(std::to_string(*iter));
    }
    org_id_list_ = org_id_string_list;
  }
  /**
   * @brief os version
   */
  const std::string os_version() const { return os_version_; }
  void set_os_version(const std::string& os_version) { os_version_ = os_version; }
  
  /**
   * @brief os system type
   */
  const std::string os() const { return os_; }
  void set_os(const std::string& os) { os_ = os; }
  
private:
  std::string app_version_;
  std::string uid_;
  std::string main_org_id_;
  std::vector<std::string> org_id_list_;
  std::string os_version_;
  std::string os_;
};
  
} // namespace of config
} // namespce of gaea

#endif /* GAEA_CONFIG_USER_INFO_MODEL_H_ */
