//
//  data_listener.h
//  TbVirtualConnect
//
//  Created by Herb on 2019/4/26.
//  Copyright © 2019年 dingtalk.com. All rights reserved.
//

#ifndef ObserverListener_h
#define ObserverListener_h
#include <string>
#include <memory>
#include "gaea/lwp/gaea_define.h"

namespace paas {
  class RouteContext;
}

GAEA_LWP_NAMESPACE_BEGIN
class ObserverListener {
 public:
  virtual void DidRecvAccsBuf(const std::string& buf,
                              const paas::RouteContext& route_ctx,
                              const std::string& tag) = 0;
  virtual void OnRecvError() = 0;
  virtual void OnNetworkStatusChanged(bool is_network_valid) = 0;
};
typedef std::shared_ptr<ObserverListener> ObserverListenerPtr;
GAEA_LWP_NAMESPACE_END

#endif /* ObserverListener_h */
