//
//  tb_virtual_connection.h
//  gaeaLwp
//
//  Created by guodi.ggd on 2019/4/24.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef tbios_virtual_connection_h
#define tbios_virtual_connection_h

#include <memory>
#include <list>
#include "gaea/lwp/gaea_define.h"
#include "gaea/lwp/abstract_connection.h"
#include "gaea/lwp/virtual_socket.h"
#include "gaea/lwp/transfer_context.h"

GAEA_LWP_NAMESPACE_BEGIN
  class TbVirtualConnection : public AbstractConnection,
                              public std::enable_shared_from_this<TbVirtualConnection>,
                              public VirtualSocketDelegate {
   public:
    TbVirtualConnection(EventLoopPtr session_eventloop, EventLoopPtr net_eventloop);
    virtual ~TbVirtualConnection();
    
    void Connect() override;
    void Disconnect() override;
    void Shutdown() override;
    
    virtual int Send(const std::string& buffer, TransferContextPtr transfer_context) override;
    virtual void OnRecv(const std::string& buffer, TransferContextPtr transfer_context) override;
    virtual void OnConneted() override;
    virtual void OnError(ConnErrorType err_type) override;
    
   private:
    void ConnectCallback();
    // 这里要应该能内部区分当前连接是否连接成功，否则无法判定是connect failed回调还是disconnect回调
    void CloseWithError(int is_conn_failed = 0);
    
    void DidRecvData(const std::string &buffer, TransferContextPtr transfer_context);
    void DidSendData(int64_t len);
   private:
    VirtualSocketPtr virtual_socket_;
  };
  
  typedef std::shared_ptr<TbVirtualConnection> TbVirtualConnectionPtr;
  
GAEA_LWP_NAMESPACE_END

#endif /* tbios_virtual_connection_h */


