//
//  request_filter.hpp
//  gaea_lwp
//
//  Created by 司沐 on 2020/8/3.
//  Copyright © 2020 DingTalk. All rights reserved.
//
#ifndef GAEA_LWP_FILTER_REQUEST_FILTER_H_
#define GAEA_LWP_FILTER_REQUEST_FILTER_H_

#include <stdio.h>
#include <iostream>

#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN

class Request;
typedef std::shared_ptr<Request> RequestPtr;

class Response;
typedef std::shared_ptr<Response> ResponsePtr;

class MessageFilter {
 public:
  explicit MessageFilter(const std::string& name): name_(name) {}
  virtual ~MessageFilter() {};
    
  virtual const std::string name() const { return name_; }
  
  virtual void ProcessRequest(RequestPtr request, RequestContextPtr context) {}
  virtual bool CheckIfTakeOverRequest(RequestPtr request, RequestContextPtr context) { return false; }
  
  virtual void ProcessPush(RequestPtr request) {}
  virtual void ProcessResponse(ResponsePtr response) {}

 protected:
  std::string name_;
};
typedef std::shared_ptr<MessageFilter> MessageFilterPtr;

GAEA_LWP_NAMESPACE_END

#endif /* request_filter_hpp */
