/*
* =====================================================================================
*
*       Filename:  base_model_value.h
*
*    Description: Base classes of all model value
*
*        Version:  1.0
*        Created:  2019-04-29
*       Revision:  none
*       Compiler:  gcc
*
*         Author:  jack.kj@alibaba-inc.com
*
* =====================================================================================
*/
#ifndef GAEA_IDL_BASE_MODEL_VALUE_H_
#define GAEA_IDL_BASE_MODEL_VALUE_H_

#include <string>
#include "gaea/contrib/cmp.h"

namespace gaea {
namespace idl {

#ifndef GAEA_IDL_DISABLE_JSON
    struct JsonSerializeContext;
    struct JsonDeSerializeContext;
#endif

class BaseModelValue {
  friend class BaseModel;

public:
  BaseModelValue();
  virtual ~BaseModelValue() = default;

  inline bool IsPresent() const { return is_present_; }

  virtual void Clear() = 0;
  virtual void MergeFrom(const BaseModelValue& value) = 0;

protected:
  virtual bool Pack(cmp_ctx_t *cmp) = 0;
  virtual bool DoUnpack(cmp_ctx_t *cmp, bool *is_nil, bool *is_missing_fields) = 0;
#ifndef GAEA_IDL_DISABLE_JSON
  virtual bool DoFromJson(const JsonDeSerializeContext* context) = 0;
  virtual bool ToJson(const std::string &key, JsonSerializeContext* context) const = 0;
#endif
  inline void set_is_present(bool is_present) { is_present_ = is_present; }

public:
  // 支持MsgPack和UnMsgPack
  virtual bool Unpack(cmp_ctx_t *context, bool *is_nil, bool *is_missing_fields);

#ifndef GAEA_IDL_DISABLE_JSON
  // json的转换
  bool FromJson(const JsonDeSerializeContext* context);
#endif

private:
  bool is_present_;
};
} // namespace idl
} // namespace gaea

#endif
