//
//  kv_database_interface.hpp
//  GaeaInterface
//
//  Created by Herb on 2019/11/25.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef GAEA_SERVICE_KV_DATABASE_INTERFACE_H_
#define GAEA_SERVICE_KV_DATABASE_INTERFACE_H_

#include <memory>
#include <string>
#include "gaea/interface/database/database_wrapper.h"

namespace gaea {
namespace service {

class KvDatabaseInterface : public DatabaseWrapper {
 public:
  KvDatabaseInterface() {}
  virtual ~KvDatabaseInterface() {}
  
  virtual bool Prepare() { return false; }
  virtual bool Release() { return false; }
  
  /**
   * @function CreateRecord
   * @brief 插入数据记录
   * @return true 插入成功; false 插入失败;
   */
  virtual bool Create(
      const std::string& key,
      const std::string& value) { return false; }
  
  /**
   * @function ReadRecord
   * @brief 读取匹配的数据记录
   * @return true 插入成功; false 插入失败;
   */
  virtual bool Read(
      const std::string& key,
      std::string* value) { return false; }
  
  /**
   * @function UpdateRecord
   * @brief 更新数据记录
   * @return true 插入成功; false 插入失败;
   */
  virtual bool Update(
      const std::string& key,
      const std::string& value) { return false; }
  
  /**
   * @function DeleteRecord
   * @brief 删除数据记录
   * @return true 插入成功; false 插入失败;
   */
  virtual bool Delete(
      const std::string& key) { return false; }

};
typedef std::shared_ptr<KvDatabaseInterface> KvDatabaseInterfacePtr;

}
}

#endif /* GAEA_SERVICE_KV_DATABASE_INTERFACE_H_ */
