//
//  file_defines.h
//  gaea_interface
//
//  Created by guodi.ggd on 2020/9/14.
//

#ifndef GAEA_INTERFACE_FILE_DEFINES_H_
#define GAEA_INTERFACE_FILE_DEFINES_H_

#include <functional>
#include <memory>

namespace gaea {
namespace service {

enum AuthType {
  kAuthTypeNone     = -1,
  kNoAuth           = 0,
  kStrictAuth       = 1,
  kOnlyLoginAuth    = 2,
  kOnlyInternalAuth = 3,
  kTempAuth         = 4,
  kCdnAuth          = 6,
};

enum FileTaskType {
  kUndefine  = -1,
  kLwpUpload  = 0,
  kQuicUpload = 1,
};

class FileUploadResult;
typedef std::shared_ptr<FileUploadResult> FileUploadResultPtr;

class FileUploadTask;
typedef std::shared_ptr<FileUploadTask> FileUploadTaskPtr;

class FileProgress;
typedef std::shared_ptr<FileProgress> FileProgressPtr;

class FileUploadCallback;

class FileServiceInterface;
typedef std::shared_ptr<FileServiceInterface> FileServiceInterfacePtr;


}
}


#endif /* GAEA_INTERFACE_FILE_DEFINES_H_ */
