//
//  file_service_interface.h
//  gaea_interface
//
//  Created by guodi.ggd on 2020/8/7.
//

#ifndef GAEA_INTERFACE_FILE_FILE_SERVICE_INTERFACE_H_
#define GAEA_INTERFACE_FILE_FILE_SERVICE_INTERFACE_H_

#include "gaea/base/error_result.h"
#include "gaea/interface/file/file_defines.h"

namespace gaea {
namespace service {

class FileServiceInterface {
 public:
  FileServiceInterface() {}
  virtual ~FileServiceInterface();

  virtual void Start() = 0;

  virtual void Stop() = 0;

  virtual void Upload(
      FileUploadTaskPtr task,
      std::function<void()> onStart,
      std::function<void(const FileProgress&)> onProgress,
      std::function<void(const FileUploadResult&)> onSuccess,
      std::function<void(const gaea::base::ErrorResult&)> onFailure) = 0;

  virtual void CancelTask(const std::string& task_id) = 0;
  
  /*
   * brief  clean all task with error final_result
   */
  virtual void Clean(const gaea::base::ErrorResult& final_result) = 0;
};
typedef std::shared_ptr<FileServiceInterface> FileServiceInterfacePtr;
typedef std::weak_ptr<FileServiceInterface> FileServiceInterfaceWeakPtr;

}
}

#endif /* GAEA_INTERFACE_FILE_FILE_SERVICE_INTERFACE_H_ */
