//
//  file_upload_task.h
//  Atlas
//
//  Created by jinxi on 8/4/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_INTERFACE_FILE_FILE_UPLOAD_TASK_H_
#define GAEA_INTERFACE_FILE_FILE_UPLOAD_TASK_H_

#include <chrono>
#include <functional>
#include <memory>
#include <string>
#include <map>

#include "gaea/interface/file/file_defines.h"
#include "gaea/interface/task/url_task.h"

namespace gaea {
namespace service {

class FileUploadTask : public UrlTask {
 public:
  FileUploadTask();
  virtual ~FileUploadTask();
  
  const std::string& path() const { return path_; }
  void set_path(const std::string& path) { path_ = path; }

  const std::string& data() const { return data_; }
  void set_data(const std::string& data) { data_ = data; }

  /**
   * 配置标准 MIME: https://www.iana.org/assignments/media-types/media-types.xhtml
   * 暂时参考这里：#include "gaea/lwp/file/file_types.h"
   */
  const std::string& mime() const { return mime_; }
  void set_mime(const std::string& mime) { mime_ = mime; }
  
  const std::string& file_ext() const { return file_ext_; }
  void set_file_ext(const std::string& file_ext) { file_ext_ = file_ext; }
  
  enum MediaVersion {
    kVersionNone = -1,
    kVersionV1 = 0,
    kVersionDingPan = 1,
    kVersionV2 = 2,
  };
  MediaVersion media_ver() const { return media_ver_; }
  void set_media_ver(MediaVersion mediaVer) { media_ver_ = mediaVer; }

  bool is_streaming() const { return is_streaming_; }
  void set_is_streaming(bool isStreaming) { is_streaming_ = isStreaming; }

  bool fail_on_network_broken() const { return fail_on_network_broken_; }
  void set_fail_on_network_broken(bool failOnNetworkBroken) { fail_on_network_broken_ = failOnNetworkBroken; }

  bool is_huge_file() const { return is_huge_file_; }
  void set_is_huge_file(bool isHugeFile) { is_huge_file_ = isHugeFile; }

  const std::string& conversation_id() const { return conversation_id_; }
  void set_conversation_id(const std::string& conversationId) { conversation_id_ = conversationId; }

  const std::string& identifier() const { return identifier_; }
  void set_identifier(const std::string& identifier) { identifier_ = identifier; }

  const std::string& biz_type() const { return biz_type_; }
  void set_biz_type(const std::string& biz_type) { biz_type_ = biz_type; }

  const std::string& auth_token() const { return auth_token_; }
  void set_auth_token(const std::string& auth_token) { auth_token_ = auth_token; }

  void set_dtn_task_id(int32_t dtn_task_id) { dtn_task_id_ = dtn_task_id; }
  int32_t dtn_task_id() { return dtn_task_id_; }
  
  int64_t size() const { return size_; }
  void set_size(int64_t size) { size_ = size; }
  
  int32_t height() const { return height_; }
  void set_height(int32_t value) { height_ = value; }

  int32_t width() const { return width_; }
  void set_width(int32_t value) { width_ = value; }
  
  std::map<std::string, std::string> biz_entity() { return biz_entity_; }
  void set_biz_entity(std::map<std::string, std::string> biz_entity) { biz_entity_ = biz_entity; }
  
  AuthType auth_type() const { return auth_type_; }
  void set_auth_type(AuthType value) { auth_type_ = value; }

  // The underlying framework is used, the upper layer does not care, mainly used for timing, log burying, etc.
  void StartTiming();
  double ElapsedMills() const;

  void SetHeader(const std::string& name, const std::string& value);
  const std::map<std::string, std::string>& headers() const { return headers_; }
  void set_headers(const std::map<std::string, std::string>& headers) { headers_ = headers; }

  const std::string ToString();
  
 private:
  std::string path_;      // path must pass one
  std::string data_;      // And path must pass one
  std::string mime_;      // See the definition in the LWPFileKit.h file for details.
  std::string file_ext_;

  MediaVersion media_ver_; // Upload the version of mediaId;
  
  bool is_streaming_;
  bool fail_on_network_broken_;
  bool is_huge_file_;

  std::string conversation_id_;
  std::string identifier_;

  int32_t height_;
  int32_t width_;

  std::string biz_type_;
  std::map<std::string, std::string> biz_entity_;

  AuthType auth_type_;
  std::string auth_token_;

  std::chrono::time_point<std::chrono::steady_clock> begin_time_;
  int64_t size_;
  std::map<std::string, std::string> headers_;
  int32_t dtn_task_id_;
};
typedef std::shared_ptr<FileUploadTask> FileUploadTaskPtr;
typedef std::weak_ptr<FileUploadTask> FileUploadTaskWeakPtr;

}
}

#endif /* GAEA_INTERFACE_FILE_FILE_UPLOAD_TASK_H_ */
