//
//  http_callback.h
//  gaea_interface
//
//  Created by guodi.ggd on 2020/11/19.
//

#ifndef GAEA_INTERFACE_HTTP_CALLBACK_H_
#define GAEA_INTERFACE_HTTP_CALLBACK_H_

#include <stdio.h>
#include <functional>
#include "gaea/base/error_result.h"
#include "gaea/interface/http/http_request.h"
#include "gaea/interface/http/http_response.h"

namespace gaea {
namespace service {

typedef std::function<void(HttpRequestPtr, HttpResponsePtr)> HttpSuccessCallback;
typedef std::function<void(const gaea::base::ErrorResult&)> HttpFailedCallback;

class HttpCallback {
 public:
  HttpCallback();
  virtual ~HttpCallback();

  void SetCallback(HttpSuccessCallback on_success,
                   HttpFailedCallback on_failure);

  HttpSuccessCallback on_success() const { return on_success_; }
  HttpFailedCallback on_failure() const { return on_failure_; }

 private:
  HttpSuccessCallback on_success_;
  HttpFailedCallback on_failure_;
};
typedef std::shared_ptr<HttpCallback> HttpCallbackPtr;

}  // namespace service
}  // namespace gaea

#endif /* GAEA_INTERFACE_HTTP_CALLBACK_H_ */
